/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.completion;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.NavUtils;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTError;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

final class CompletionContextFinder {
    private static final String NAMESPACE_FALSE_TOKEN = "NAMESPACE_FALSE_TOKEN";
    private static final String GROUP_USE_STATEMENT_TOKENS = "GROUP_USE_STATEMENT_TOKENS";
    private static final String COMBINED_USE_STATEMENT_TOKENS = "COMBINED_USE_STATEMENT_TOKENS";
    private static final String TYPE_KEYWORD = "TYPE_KEYWORD";
    private static final PHPTokenId[] COMMENT_TOKENS = new PHPTokenId[]{PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_LINE_COMMENT, PHPTokenId.PHP_COMMENT_END};
    private static final PHPTokenId[] PHPDOC_TOKENS = new PHPTokenId[]{PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.PHPDOC_COMMENT_END};
    private static final List<Object[]> CLASS_NAME_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_NEW}, {PHPTokenId.PHP_NEW, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_NEW, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_NEW, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<Object[]> THROW_NEW_TOKEN_CHAINS = Arrays.asList({PHPTokenId.PHP_THROW}, {PHPTokenId.PHP_THROW, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_THROW, PHPTokenId.WHITESPACE, PHPTokenId.PHP_NEW}, {PHPTokenId.PHP_THROW, PHPTokenId.WHITESPACE, PHPTokenId.PHP_NEW, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_THROW, PHPTokenId.WHITESPACE, PHPTokenId.PHP_NEW, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_THROW, PHPTokenId.WHITESPACE, PHPTokenId.PHP_NEW, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<Object[]> FUNCTION_NAME_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_FUNCTION}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<Object[]> GROUP_USE_KEYWORD_TOKENS = Arrays.asList({PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN", "GROUP_USE_STATEMENT_TOKENS"}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN", PHPTokenId.WHITESPACE, "GROUP_USE_STATEMENT_TOKENS"});
    private static final List<Object[]> GROUP_USE_CONST_KEYWORD_TOKENS = Arrays.asList({PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_CONST, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN", "GROUP_USE_STATEMENT_TOKENS"}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_CONST, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN", PHPTokenId.WHITESPACE, "GROUP_USE_STATEMENT_TOKENS"});
    private static final List<Object[]> GROUP_USE_FUNCTION_KEYWORD_TOKENS = Arrays.asList({PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN", "GROUP_USE_STATEMENT_TOKENS"}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN", PHPTokenId.WHITESPACE, "GROUP_USE_STATEMENT_TOKENS"});
    private static final List<Object[]> USE_KEYWORD_TOKENS = Arrays.asList({PHPTokenId.PHP_USE}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_USE, "COMBINED_USE_STATEMENT_TOKENS"});
    private static final List<Object[]> USE_CONST_KEYWORD_TOKENS = Arrays.asList({PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_CONST}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_CONST, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_CONST, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_CONST, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_CONST, "COMBINED_USE_STATEMENT_TOKENS"});
    private static final List<Object[]> USE_FUNCTION_KEYWORD_TOKENS = Arrays.asList({PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_FUNCTION}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_USE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_FUNCTION, "COMBINED_USE_STATEMENT_TOKENS"});
    private static final List<Object[]> NAMESPACE_KEYWORD_TOKENS = Arrays.asList({PHPTokenId.PHP_NAMESPACE}, {PHPTokenId.PHP_NAMESPACE, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_NAMESPACE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_NAMESPACE, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"});
    private static final List<Object[]> INSTANCEOF_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_INSTANCEOF}, {PHPTokenId.PHP_INSTANCEOF, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_INSTANCEOF, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_INSTANCEOF, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<Object[]> CATCH_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_CATCH, PHPTokenId.PHP_TOKEN}, {PHPTokenId.PHP_CATCH, PHPTokenId.PHP_TOKEN, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_CATCH, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN}, {PHPTokenId.PHP_CATCH, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_CATCH, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_CATCH, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN, PHPTokenId.WHITESPACE, "NAMESPACE_FALSE_TOKEN"}, {PHPTokenId.PHP_CATCH, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN, PHPTokenId.PHP_STRING});
    private static final List<Object[]> CLASS_MEMBER_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_OBJECT_OPERATOR}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.PHP_VARIABLE}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.PHP_TOKEN}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.WHITESPACE, PHPTokenId.PHP_VARIABLE}, {PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN});
    private static final List<Object[]> STATIC_CLASS_MEMBER_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.PHP_VARIABLE}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.PHP_TOKEN}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.WHITESPACE, PHPTokenId.PHP_VARIABLE}, {PHPTokenId.PHP_PAAMAYIM_NEKUDOTAYIM, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN});
    private static final List<Object[]> CLASS_MEMBER_IN_STRING_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE, PHPTokenId.PHP_VARIABLE, PHPTokenId.PHP_OBJECT_OPERATOR}, {PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE, PHPTokenId.PHP_VARIABLE, PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE, PHPTokenId.PHP_VARIABLE, PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.PHP_TOKEN}, {PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE, PHPTokenId.PHP_VARIABLE, PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE, PHPTokenId.PHP_VARIABLE, PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE, PHPTokenId.PHP_VARIABLE, PHPTokenId.PHP_OBJECT_OPERATOR, PHPTokenId.WHITESPACE, PHPTokenId.PHP_TOKEN});
    private static final List<Object[]> METHOD_NAME_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_FUNCTION}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_FUNCTION, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<Object[]> CLASS_CONTEXT_KEYWORDS_TOKENCHAINS = Arrays.asList({PHPTokenId.PHP_PRIVATE}, {PHPTokenId.PHP_PRIVATE, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PRIVATE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PROTECTED}, {PHPTokenId.PHP_PROTECTED, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PROTECTED, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_PUBLIC}, {PHPTokenId.PHP_PUBLIC, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_PUBLIC, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_STATIC}, {PHPTokenId.PHP_STATIC, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_STATIC, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_ABSTRACT}, {PHPTokenId.PHP_ABSTRACT, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_ABSTRACT, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_FINAL}, {PHPTokenId.PHP_FINAL, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_FINAL, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_CURLY_OPEN}, {PHPTokenId.WHITESPACE}, {PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_CURLY_CLOSE}, {PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_CURLY_OPEN}, {PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING}, {PHPTokenId.PHP_SEMICOLON}, {PHPTokenId.PHP_SEMICOLON, PHPTokenId.WHITESPACE}, {PHPTokenId.PHP_SEMICOLON, PHPTokenId.WHITESPACE, PHPTokenId.PHP_STRING});
    private static final List<Object[]> SERVER_ARRAY_TOKENCHAINS = Collections.singletonList(new Object[]{PHPTokenId.PHP_VARIABLE, PHPTokenId.PHP_TOKEN});
    private static final List<String> SERVER_ARRAY_TOKENTEXTS = Arrays.asList("$_SERVER", "[");
    static final Collection<PHPTokenId> CTX_DELIMITERS = Arrays.asList(PHPTokenId.PHP_SEMICOLON, PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.PHP_RETURN, PHPTokenId.PHP_OPERATOR, PHPTokenId.PHP_ECHO, PHPTokenId.PHP_EVAL, PHPTokenId.PHP_NEW, PHPTokenId.PHP_NOT, PHPTokenId.PHP_CASE, PHPTokenId.PHP_IF, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_PRINT, PHPTokenId.PHP_FOR, PHPTokenId.PHP_FOREACH, PHPTokenId.PHP_WHILE, PHPTokenId.PHP_CONSTANT_ENCAPSED_STRING, PHPTokenId.PHP_ENCAPSED_AND_WHITESPACE, PHPTokenId.T_OPEN_TAG_WITH_ECHO, PHPTokenId.PHP_OPENTAG, PHPTokenId.PHP_CASTING);

    private CompletionContextFinder() {
    }

    @NonNull
    static CompletionContext findCompletionContext(ParserResult info, int caretOffset) {
        TokenHierarchy th = info.getSnapshot().getTokenHierarchy();
        if (th == null) {
            return CompletionContext.NONE;
        }
        TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence(th, caretOffset);
        if (tokenSequence == null) {
            return CompletionContext.NONE;
        }
        tokenSequence.move(caretOffset);
        boolean moveNextSucces = tokenSequence.moveNext();
        if (!moveNextSucces && !tokenSequence.movePrevious()) {
            return CompletionContext.NONE;
        }
        Token token = tokenSequence.token();
        PHPTokenId tokenId = (PHPTokenId)token.id();
        if (tokenId.equals((Object)PHPTokenId.PHP_CLOSETAG) && tokenSequence.offset() < caretOffset) {
            return CompletionContext.NONE;
        }
        int tokenIdOffset = tokenSequence.token().offset(th);
        CompletionContext clsIfaceDeclContext = CompletionContextFinder.getClsIfaceDeclContext((Token<PHPTokenId>)token, caretOffset - tokenIdOffset, tokenSequence);
        if (clsIfaceDeclContext != null) {
            return clsIfaceDeclContext;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, THROW_NEW_TOKEN_CHAINS, moveNextSucces)) {
            return CompletionContext.THROW;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, CLASS_NAME_TOKENCHAINS, moveNextSucces)) {
            return CompletionContext.NEW_CLASS;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, CLASS_MEMBER_IN_STRING_TOKENCHAINS, moveNextSucces)) {
            return CompletionContext.CLASS_MEMBER_IN_STRING;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, CLASS_MEMBER_TOKENCHAINS, moveNextSucces)) {
            return CompletionContext.CLASS_MEMBER;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, STATIC_CLASS_MEMBER_TOKENCHAINS, moveNextSucces)) {
            return CompletionContext.STATIC_CLASS_MEMBER;
        }
        if (tokenId == PHPTokenId.PHP_COMMENT) {
            return CompletionContextFinder.getCompletionContextInComment(tokenSequence, caretOffset, info);
        }
        if (CompletionContextFinder.isPhpDocToken(tokenSequence)) {
            return CompletionContext.PHPDOC;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, CATCH_TOKENCHAINS, moveNextSucces)) {
            return CompletionContext.CATCH;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, NAMESPACE_KEYWORD_TOKENS, moveNextSucces)) {
            return CompletionContext.NAMESPACE_KEYWORD;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, INSTANCEOF_TOKENCHAINS, moveNextSucces)) {
            return CompletionContext.TYPE_NAME;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, GROUP_USE_KEYWORD_TOKENS, moveNextSucces)) {
            while (tokenSequence.movePrevious()) {
                tokenId = (PHPTokenId)tokenSequence.token().id();
                if (tokenId == PHPTokenId.WHITESPACE) continue;
                if (tokenId == PHPTokenId.PHP_CONST) {
                    return CompletionContext.GROUP_USE_CONST_KEYWORD;
                }
                if (tokenId != PHPTokenId.PHP_FUNCTION) break;
                return CompletionContext.GROUP_USE_FUNCTION_KEYWORD;
            }
            return CompletionContext.GROUP_USE_KEYWORD;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, GROUP_USE_CONST_KEYWORD_TOKENS, moveNextSucces)) {
            return CompletionContext.GROUP_USE_CONST_KEYWORD;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, GROUP_USE_FUNCTION_KEYWORD_TOKENS, moveNextSucces)) {
            return CompletionContext.GROUP_USE_FUNCTION_KEYWORD;
        }
        if (CompletionContextFinder.isInsideInterfaceDeclarationBlock(info, caretOffset, tokenSequence)) {
            CompletionContext paramContext = CompletionContextFinder.getParamaterContext((Token<PHPTokenId>)token, caretOffset, tokenSequence);
            if (paramContext != null) {
                return paramContext;
            }
            return CompletionContext.INTERFACE_CONTEXT_KEYWORDS;
        }
        if (CompletionContextFinder.isInsideClassOrTraitDeclarationBlock(info, caretOffset, tokenSequence)) {
            if (CompletionContextFinder.acceptTokenChains(tokenSequence, USE_KEYWORD_TOKENS, moveNextSucces)) {
                return CompletionContext.USE_TRAITS;
            }
            if (CompletionContextFinder.acceptTokenChains(tokenSequence, METHOD_NAME_TOKENCHAINS, moveNextSucces)) {
                return CompletionContext.METHOD_NAME;
            }
            CompletionContext paramContext = CompletionContextFinder.getParamaterContext((Token<PHPTokenId>)token, caretOffset, tokenSequence);
            if (paramContext != null) {
                return paramContext;
            }
            if (CompletionContextFinder.acceptTokenChains(tokenSequence, CLASS_CONTEXT_KEYWORDS_TOKENCHAINS, moveNextSucces)) {
                return CompletionContext.CLASS_CONTEXT_KEYWORDS;
            }
            return CompletionContext.NONE;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, USE_KEYWORD_TOKENS, moveNextSucces)) {
            return CompletionContext.USE_KEYWORD;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, USE_CONST_KEYWORD_TOKENS, moveNextSucces)) {
            return CompletionContext.USE_CONST_KEYWORD;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, USE_FUNCTION_KEYWORD_TOKENS, moveNextSucces)) {
            return CompletionContext.USE_FUNCTION_KEYWORD;
        }
        if (CompletionContextFinder.acceptTokenChains(tokenSequence, FUNCTION_NAME_TOKENCHAINS, moveNextSucces)) {
            return CompletionContext.NONE;
        }
        if (CompletionContextFinder.isCommonCommentToken(tokenSequence)) {
            return CompletionContext.NONE;
        }
        switch (tokenId) {
            case T_INLINE_HTML: {
                return CompletionContext.HTML;
            }
            case PHP_CONSTANT_ENCAPSED_STRING: {
                char encChar = tokenSequence.token().text().charAt(0);
                if (encChar == '\"') {
                    if (CompletionContextFinder.acceptTokenChains(tokenSequence, SERVER_ARRAY_TOKENCHAINS, moveNextSucces) && CompletionContextFinder.acceptTokenChainTexts(tokenSequence, SERVER_ARRAY_TOKENTEXTS)) {
                        return CompletionContext.SERVER_ENTRY_CONSTANTS;
                    }
                    return CompletionContext.STRING;
                }
                if (encChar == '\'' && CompletionContextFinder.acceptTokenChains(tokenSequence, SERVER_ARRAY_TOKENCHAINS, moveNextSucces) && CompletionContextFinder.acceptTokenChainTexts(tokenSequence, SERVER_ARRAY_TOKENTEXTS)) {
                    return CompletionContext.SERVER_ENTRY_CONSTANTS;
                }
                return CompletionContext.NONE;
            }
        }
        if (CompletionContextFinder.isEachOfTokens(CompletionContextFinder.getLeftPreceedingTokens(tokenSequence), new PHPTokenId[]{PHPTokenId.PHP_GLOBAL, PHPTokenId.WHITESPACE}) || CompletionContextFinder.isWhiteSpace((Token<PHPTokenId>)token) && CompletionContextFinder.isEachOfTokens(CompletionContextFinder.getLeftPreceedingTokens(tokenSequence), new PHPTokenId[]{PHPTokenId.PHP_GLOBAL})) {
            return CompletionContext.GLOBAL;
        }
        CompletionContext paramContext = CompletionContextFinder.getParamaterContext((Token<PHPTokenId>)token, caretOffset, tokenSequence);
        if (paramContext != null) {
            return paramContext;
        }
        if (tokenSequence.movePrevious() && tokenSequence.token().id() == PHPTokenId.PHP_OPENTAG && TokenUtilities.textEquals((CharSequence)"<?", (CharSequence)tokenSequence.token().text()) && tokenSequence.offset() + 2 == caretOffset) {
            return CompletionContext.OPEN_TAG;
        }
        return CompletionContext.EXPRESSION;
    }

    private static boolean isPhpDocToken(TokenSequence tokenSequence) {
        return CompletionContextFinder.isOneOfTokens(tokenSequence, PHPDOC_TOKENS);
    }

    private static boolean isCommonCommentToken(TokenSequence tokenSequence) {
        return CompletionContextFinder.isOneOfTokens(tokenSequence, COMMENT_TOKENS);
    }

    private static boolean isCommentToken(TokenSequence tokenSequence) {
        return CompletionContextFinder.isCommonCommentToken(tokenSequence) || CompletionContextFinder.isPhpDocToken(tokenSequence);
    }

    private static boolean isOneOfTokens(TokenSequence tokenSequence, PHPTokenId[] tokenIds) {
        TokenId searchedId = tokenSequence.token().id();
        for (PHPTokenId tokenId : tokenIds) {
            if (!((Object)((Object)tokenId)).equals(searchedId)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEachOfTokens(Token[] tokens, PHPTokenId[] tokenIds) {
        EnumSet<PHPTokenId> set = EnumSet.noneOf(PHPTokenId.class);
        for (Token token : tokens) {
            TokenId searchedId = token.id();
            for (PHPTokenId tokenId : tokenIds) {
                if (!tokenId.equals(searchedId)) continue;
                set.add(tokenId);
            }
        }
        return set.size() == tokenIds.length;
    }

    private static boolean acceptTokenChainTexts(TokenSequence tokenSequence, List<String> tokenTexts) {
        int orgTokenSequencePos = tokenSequence.offset();
        boolean accept = true;
        boolean moreTokens = tokenSequence.movePrevious();
        for (int i = tokenTexts.size() - 1; i >= 0; --i) {
            String tokenTxt = tokenTexts.get(i);
            if (!moreTokens) {
                accept = false;
                break;
            }
            if (!TokenUtilities.textEquals((CharSequence)tokenTxt, (CharSequence)tokenSequence.token().text())) {
                accept = false;
                break;
            }
            moreTokens = tokenSequence.movePrevious();
        }
        tokenSequence.move(orgTokenSequencePos);
        tokenSequence.moveNext();
        return accept;
    }

    private static boolean acceptTokenChains(TokenSequence tokenSequence, List<Object[]> tokenIdChains, boolean movePrevious) {
        for (Object[] tokenIDChain : tokenIdChains) {
            if (!CompletionContextFinder.acceptTokenChain(tokenSequence, tokenIDChain, movePrevious)) continue;
            return true;
        }
        return false;
    }

    private static boolean acceptTokenChain(TokenSequence tokenSequence, Object[] tokenIdChain, boolean movePrevious) {
        int orgTokenSequencePos = tokenSequence.offset();
        boolean accept = true;
        boolean moreTokens = movePrevious ? tokenSequence.movePrevious() : true;
        boolean lastTokenWasComment = false;
        for (int i = tokenIdChain.length - 1; i >= 0; --i) {
            Object tokenID = tokenIdChain[i];
            if (!moreTokens) {
                accept = false;
                break;
            }
            if (tokenID instanceof PHPTokenId) {
                if (CompletionContextFinder.isCommentToken(tokenSequence)) {
                    ++i;
                    moreTokens = tokenSequence.movePrevious();
                    lastTokenWasComment = true;
                    continue;
                }
                if (tokenSequence.token().id() == PHPTokenId.WHITESPACE && lastTokenWasComment) {
                    ++i;
                    moreTokens = tokenSequence.movePrevious();
                    lastTokenWasComment = false;
                    continue;
                }
                lastTokenWasComment = false;
                if (tokenSequence.token().id() == tokenID) {
                    moreTokens = tokenSequence.movePrevious();
                    continue;
                }
                accept = false;
                break;
            }
            if (tokenID == NAMESPACE_FALSE_TOKEN) {
                if (CompletionContextFinder.consumeNameSpace(tokenSequence)) continue;
                accept = false;
                break;
            }
            if (tokenID == GROUP_USE_STATEMENT_TOKENS) {
                if (CompletionContextFinder.consumeClassesConstFunctionInGroupUse(tokenSequence)) continue;
                accept = false;
                break;
            }
            if (tokenID == COMBINED_USE_STATEMENT_TOKENS) {
                if (CompletionContextFinder.consumeClassesInCombinedUse(tokenSequence)) continue;
                accept = false;
                break;
            }
            if (tokenID == TYPE_KEYWORD) {
                if (CompletionContextFinder.consumeUntilTypeKeyword(tokenSequence)) continue;
                accept = false;
                break;
            }
            assert (false) : "Unsupported token type: " + tokenID.getClass().getName();
        }
        tokenSequence.move(orgTokenSequencePos);
        tokenSequence.moveNext();
        return accept;
    }

    private static boolean consumeNameSpace(TokenSequence tokenSequence) {
        boolean hadNSSeparator = false;
        if (tokenSequence.token().id() != PHPTokenId.PHP_NS_SEPARATOR && tokenSequence.token().id() != PHPTokenId.PHP_STRING) {
            return false;
        }
        do {
            if (tokenSequence.token().id() == PHPTokenId.PHP_NS_SEPARATOR || tokenSequence.token().id() == PHPTokenId.PHP_STRING) {
                hadNSSeparator = true;
            }
            if (tokenSequence.movePrevious()) continue;
            return false;
        } while (tokenSequence.token().id() == PHPTokenId.PHP_NS_SEPARATOR || tokenSequence.token().id() == PHPTokenId.PHP_STRING);
        return hadNSSeparator;
    }

    private static boolean consumeComment(TokenSequence tokenSequence) {
        while (tokenSequence.token().id() == PHPTokenId.PHP_COMMENT_START || tokenSequence.token().id() == PHPTokenId.PHP_COMMENT_END || tokenSequence.token().id() == PHPTokenId.PHP_COMMENT) {
            if (tokenSequence.movePrevious()) continue;
            return false;
        }
        return true;
    }

    private static boolean consumeClassesConstFunctionInGroupUse(TokenSequence tokenSequence) {
        if (tokenSequence.token().id() != PHPTokenId.PHP_CURLY_OPEN && tokenSequence.token().id() != PHPTokenId.PHP_TOKEN && tokenSequence.token().id() != PHPTokenId.PHP_CONST && tokenSequence.token().id() != PHPTokenId.PHP_FUNCTION && tokenSequence.token().id() != PHPTokenId.WHITESPACE && !CompletionContextFinder.consumeNameSpace(tokenSequence)) {
            return false;
        }
        boolean hasCurlyOpen = false;
        do {
            if (tokenSequence.token().id() == PHPTokenId.PHP_CURLY_OPEN) {
                hasCurlyOpen = true;
            }
            if (tokenSequence.movePrevious()) continue;
            return false;
        } while (!hasCurlyOpen && (tokenSequence.token().id() == PHPTokenId.PHP_CURLY_OPEN || tokenSequence.token().id() == PHPTokenId.PHP_TOKEN || tokenSequence.token().id() == PHPTokenId.PHP_CONST || tokenSequence.token().id() == PHPTokenId.PHP_FUNCTION || tokenSequence.token().id() == PHPTokenId.WHITESPACE || CompletionContextFinder.consumeNameSpace(tokenSequence) || CompletionContextFinder.consumeComment(tokenSequence)));
        return hasCurlyOpen;
    }

    private static boolean consumeClassesInCombinedUse(TokenSequence tokenSequence) {
        boolean hasCommaDelimiter = false;
        if (tokenSequence.token().id() != PHPTokenId.PHP_TOKEN && tokenSequence.token().id() != PHPTokenId.WHITESPACE && !CompletionContextFinder.consumeNameSpace(tokenSequence)) {
            return false;
        }
        do {
            if (tokenSequence.token().id() == PHPTokenId.PHP_TOKEN) {
                hasCommaDelimiter = true;
            }
            if (tokenSequence.movePrevious()) continue;
            return false;
        } while (tokenSequence.token().id() == PHPTokenId.PHP_TOKEN || tokenSequence.token().id() == PHPTokenId.WHITESPACE || CompletionContextFinder.consumeNameSpace(tokenSequence));
        return hasCommaDelimiter;
    }

    private static boolean consumeUntilTypeKeyword(TokenSequence tokenSequence) {
        boolean result = false;
        do {
            if (tokenSequence.token().id() == PHPTokenId.PHP_CLASS || tokenSequence.token().id() == PHPTokenId.PHP_INTERFACE || tokenSequence.token().id() == PHPTokenId.PHP_TRAIT || tokenSequence.token().id() == PHPTokenId.PHP_EXTENDS || tokenSequence.token().id() == PHPTokenId.PHP_IMPLEMENTS) {
                result = true;
                break;
            }
            if (tokenSequence.token().id() != PHPTokenId.PHP_NAMESPACE) continue;
            result = false;
            break;
        } while (tokenSequence.movePrevious());
        return result;
    }

    private static Token[] getLeftPreceedingTokens(TokenSequence tokenSequence) {
        Token[] preceedingTokens = CompletionContextFinder.getPreceedingTokens(tokenSequence);
        if (preceedingTokens.length == 0) {
            return preceedingTokens;
        }
        Token[] leftPreceedingTokens = new Token[preceedingTokens.length - 1];
        System.arraycopy(preceedingTokens, 1, leftPreceedingTokens, 0, leftPreceedingTokens.length);
        return leftPreceedingTokens;
    }

    private static Token[] getPreceedingTokens(TokenSequence tokenSequence) {
        int orgOffset = tokenSequence.offset();
        LinkedList<Token> tokens = new LinkedList<Token>();
        boolean success = true;
        if (tokenSequence.moveNext()) {
            boolean bl = success = tokenSequence.movePrevious() && tokenSequence.movePrevious();
        }
        if (success) {
            Token token = tokenSequence.token();
            while (token != null && !CTX_DELIMITERS.contains(token.id())) {
                tokens.addFirst(token);
                if (!tokenSequence.movePrevious()) break;
                token = tokenSequence.token();
            }
        }
        tokenSequence.move(orgOffset);
        tokenSequence.moveNext();
        return tokens.toArray(new Token[tokens.size()]);
    }

    @CheckForNull
    private static CompletionContext getClsIfaceDeclContext(Token<PHPTokenId> token, int tokenOffset, TokenSequence<PHPTokenId> tokenSequence) {
        boolean isNew = false;
        boolean isClass = false;
        int openParenthesis = 0;
        boolean isIface = false;
        boolean isExtends = false;
        boolean isImplements = false;
        boolean isNsSeparator = false;
        boolean isString = false;
        Token<PHPTokenId> stringToken = null;
        List<? extends Token<PHPTokenId>> preceedingLineTokens = CompletionContextFinder.getPreceedingLineTokens(token, tokenOffset, tokenSequence);
        for (int i = 0; i < preceedingLineTokens.size(); ++i) {
            boolean nokeywords;
            Token<PHPTokenId> cToken = preceedingLineTokens.get(i);
            TokenId tokenId = cToken.id();
            boolean bl = nokeywords = !isIface && !isClass && !isExtends && !isImplements && !isNsSeparator;
            if (tokenId.equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)cToken.text(), (CharSequence)")")) {
                --openParenthesis;
                continue;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)cToken.text(), (CharSequence)"(")) {
                ++openParenthesis;
                continue;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_CLASS)) {
                isClass = true;
                for (int j = i + 1; j < preceedingLineTokens.size(); ++j) {
                    Token<PHPTokenId> tkn = preceedingLineTokens.get(j);
                    if (tkn.id() == PHPTokenId.WHITESPACE) continue;
                    boolean bl2 = isNew = tkn.id() == PHPTokenId.PHP_NEW;
                    break;
                }
                if (!isNew || openParenthesis <= 0) break;
                return null;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_INTERFACE)) {
                isIface = true;
                break;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_EXTENDS)) {
                isExtends = true;
                continue;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_IMPLEMENTS)) {
                isImplements = true;
                continue;
            }
            if (tokenId.equals((Object)PHPTokenId.PHP_NS_SEPARATOR)) {
                isNsSeparator = true;
                continue;
            }
            if (nokeywords && tokenId.equals((Object)PHPTokenId.PHP_STRING)) {
                isString = true;
                stringToken = cToken;
                continue;
            }
            if (!nokeywords || !tokenId.equals((Object)PHPTokenId.PHP_CURLY_OPEN)) continue;
            return null;
        }
        if (isClass || isIface) {
            if (isImplements) {
                return CompletionContext.INTERFACE_NAME;
            }
            if (isExtends) {
                if (isString && isClass && stringToken != null && tokenOffset == 0 && preceedingLineTokens.size() > 0 && preceedingLineTokens.get(0).text().equals(stringToken.text())) {
                    return CompletionContext.CLASS_NAME;
                }
                if (isString && isClass) {
                    return CompletionContext.IMPLEMENTS;
                }
                if (!isString && isClass) {
                    return CompletionContext.CLASS_NAME;
                }
                if (isIface) {
                    return CompletionContext.INTERFACE_NAME;
                }
                return !isString ? (isClass ? CompletionContext.CLASS_NAME : CompletionContext.INTERFACE_NAME) : (isClass ? CompletionContext.IMPLEMENTS : CompletionContext.INTERFACE_NAME);
            }
            if (isIface) {
                return !isString ? CompletionContext.NONE : CompletionContext.EXTENDS;
            }
            if (isClass) {
                if (isString || isNew) {
                    return CompletionContext.INHERITANCE;
                }
                return CompletionContext.NONE;
            }
        } else if (isExtends || isImplements) {
            boolean firstString = false;
            for (Token<PHPTokenId> token2 : preceedingLineTokens) {
                TokenId id = token2.id();
                if (id == PHPTokenId.PHP_EXTENDS) {
                    return CompletionContext.CLASS_NAME;
                }
                if (id == PHPTokenId.PHP_IMPLEMENTS) {
                    return CompletionContext.INTERFACE_NAME;
                }
                if (id == PHPTokenId.PHP_STRING) {
                    if (firstString) break;
                    firstString = true;
                    continue;
                }
                if (id == PHPTokenId.WHITESPACE) continue;
                break;
            }
        }
        return null;
    }

    @CheckForNull
    private static CompletionContext getParamaterContext(Token<PHPTokenId> token, int carretOffset, TokenSequence<PHPTokenId> tokenSequence) {
        boolean isFunctionDeclaration = false;
        boolean isCompletionSeparator = false;
        CompletionContext contextForSeparator = null;
        boolean isNamespaceSeparator = false;
        boolean testCompletionSeparator = true;
        int orgOffset = tokenSequence.offset();
        tokenSequence.moveNext();
        boolean first = true;
        while (tokenSequence.movePrevious()) {
            Token cToken = tokenSequence.token();
            PHPTokenId id = (PHPTokenId)cToken.id();
            if (first) {
                first = false;
                if (PHPTokenId.PHP_SEMICOLON.equals((Object)id) || PHPTokenId.PHP_CURLY_OPEN.equals((Object)id)) continue;
            }
            if (CTX_DELIMITERS.contains((Object)id) && !CompletionContextFinder.isReference((Token<PHPTokenId>)cToken) && !CompletionContextFinder.isVariadic((Token<PHPTokenId>)cToken)) break;
            if (isFunctionDeclaration) continue;
            if (!isCompletionSeparator && testCompletionSeparator) {
                if (CompletionContextFinder.isEqualSign((Token<PHPTokenId>)cToken)) {
                    isCompletionSeparator = true;
                    contextForSeparator = CompletionContext.DEFAULT_PARAMETER_VALUE;
                    continue;
                }
                if (CompletionContextFinder.isParamSeparator((Token<PHPTokenId>)cToken) || CompletionContextFinder.isReturnTypeSeparator((Token<PHPTokenId>)cToken) || CompletionContextFinder.isArray(token)) {
                    isCompletionSeparator = true;
                    contextForSeparator = CompletionContext.TYPE_NAME;
                    continue;
                }
                if (CompletionContextFinder.isAcceptedPrefix((Token<PHPTokenId>)cToken)) {
                    int offset;
                    if (CompletionContextFinder.isNamespaceSeparator((Token<PHPTokenId>)cToken)) {
                        isNamespaceSeparator = true;
                        continue;
                    }
                    if (!isNamespaceSeparator && CompletionContextFinder.isString((Token<PHPTokenId>)cToken)) {
                        offset = cToken.offset(null) + cToken.text().length();
                        if (carretOffset > offset) {
                            testCompletionSeparator = false;
                        }
                    } else if ((CompletionContextFinder.isReference((Token<PHPTokenId>)cToken) || CompletionContextFinder.isRightBracket((Token<PHPTokenId>)cToken) || CompletionContextFinder.isVariable((Token<PHPTokenId>)cToken)) && carretOffset >= (offset = cToken.offset(null) + cToken.text().length())) {
                        testCompletionSeparator = false;
                    }
                    isNamespaceSeparator = false;
                    continue;
                }
                if (CompletionContextFinder.isCommentToken(tokenSequence)) continue;
                testCompletionSeparator = false;
                continue;
            }
            if (!CompletionContextFinder.isFunctionDeclaration((Token<PHPTokenId>)cToken)) continue;
            isFunctionDeclaration = true;
            break;
        }
        tokenSequence.move(orgOffset);
        tokenSequence.moveNext();
        return isFunctionDeclaration && isCompletionSeparator ? contextForSeparator : (isFunctionDeclaration ? CompletionContext.NONE : null);
    }

    private static boolean isNamespaceSeparator(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_NS_SEPARATOR);
    }

    private static boolean isFunctionDeclaration(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_FUNCTION);
    }

    private static boolean isVariable(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_VARIABLE);
    }

    private static boolean isReference(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_OPERATOR) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"&");
    }

    private static boolean isVariadic(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_OPERATOR) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"...");
    }

    private static boolean isLeftBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"(");
    }

    private static boolean isRightBracket(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)")");
    }

    private static boolean isEqualSign(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_OPERATOR) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"=");
    }

    private static boolean isParamSeparator(Token<PHPTokenId> token) {
        return CompletionContextFinder.isComma(token) || CompletionContextFinder.isLeftBracket(token);
    }

    private static boolean isReturnTypeSeparator(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)":");
    }

    private static boolean isArray(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_ARRAY);
    }

    private static boolean isAcceptedPrefix(Token<PHPTokenId> token) {
        return CompletionContextFinder.isVariable(token) || CompletionContextFinder.isReference(token) || CompletionContextFinder.isRightBracket(token) || CompletionContextFinder.isString(token) || CompletionContextFinder.isWhiteSpace(token) || CompletionContextFinder.isNamespaceSeparator(token) || CompletionContextFinder.isType(token);
    }

    private static boolean isType(Token<PHPTokenId> token) {
        PHPTokenId id = (PHPTokenId)token.id();
        return id.equals((Object)PHPTokenId.PHP_TYPE_BOOL) || id.equals((Object)PHPTokenId.PHP_TYPE_FLOAT) || id.equals((Object)PHPTokenId.PHP_TYPE_INT) || id.equals((Object)PHPTokenId.PHP_TYPE_STRING);
    }

    private static boolean isComma(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_TOKEN) && TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)",");
    }

    private static boolean isWhiteSpace(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.WHITESPACE);
    }

    private static boolean isString(Token<PHPTokenId> token) {
        return ((PHPTokenId)token.id()).equals((Object)PHPTokenId.PHP_STRING);
    }

    static boolean lineContainsAny(Token<PHPTokenId> token, int tokenOffset, TokenSequence<PHPTokenId> tokenSequence, List<PHPTokenId> ids) {
        List<? extends Token<PHPTokenId>> preceedingLineTokens = CompletionContextFinder.getPreceedingLineTokens(token, tokenOffset, tokenSequence);
        for (Token<PHPTokenId> token2 : preceedingLineTokens) {
            if (!ids.contains(token2.id())) continue;
            return true;
        }
        return false;
    }

    private static List<? extends Token<PHPTokenId>> getPreceedingLineTokens(Token<PHPTokenId> token, int tokenOffset, TokenSequence<PHPTokenId> tokenSequence) {
        int orgOffset = tokenSequence.offset();
        LinkedList<Token> tokens = new LinkedList<Token>();
        if (token.id() != PHPTokenId.WHITESPACE || TokenUtilities.indexOf((CharSequence)token.text().subSequence(0, Math.min(token.text().length(), tokenOffset)), (int)10) == -1) {
            Token cToken;
            while (tokenSequence.movePrevious() && ((cToken = tokenSequence.token()).id() != PHPTokenId.WHITESPACE || TokenUtilities.indexOf((CharSequence)cToken.text(), (int)10) == -1)) {
                tokens.addLast(cToken);
            }
        }
        tokenSequence.move(orgOffset);
        tokenSequence.moveNext();
        return tokens;
    }

    private static synchronized boolean isInsideInterfaceDeclarationBlock(ParserResult info, int caretOffset, TokenSequence tokenSequence) {
        boolean retval = false;
        List<ASTNode> nodePath = NavUtils.underCaret(info, CompletionContextFinder.lexerToASTOffset(info, caretOffset));
        int nodesCount = nodePath.size();
        if (nodesCount > 0) {
            ASTNode lastNode = nodePath.get(nodesCount - 1);
            if (lastNode instanceof Block) {
                if (nodesCount > 1) {
                    lastNode = nodePath.get(nodesCount - 2);
                    retval = lastNode instanceof InterfaceDeclaration ? true : CompletionContextFinder.isUnderInterfaceTokenId(tokenSequence);
                }
            } else {
                retval = CompletionContextFinder.isUnderInterfaceTokenId(tokenSequence);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean isUnderInterfaceTokenId(TokenSequence tokenSequence) {
        boolean retval = false;
        int curlyBalance = -1;
        int orgOffset = tokenSequence.offset();
        try {
            while (tokenSequence.movePrevious()) {
                Token token = tokenSequence.token();
                TokenId id = token.id();
                if (id.equals((Object)PHPTokenId.PHP_INTERFACE) && curlyBalance == 0) {
                    retval = true;
                } else {
                    if (id.equals((Object)PHPTokenId.PHP_CURLY_OPEN)) {
                        ++curlyBalance;
                        continue;
                    }
                    if (id.equals((Object)PHPTokenId.PHP_CURLY_CLOSE)) {
                        --curlyBalance;
                        continue;
                    }
                    if (!id.equals((Object)PHPTokenId.PHP_CLASS) && !id.equals((Object)PHPTokenId.PHP_WHILE) && !id.equals((Object)PHPTokenId.PHP_IF) && !id.equals((Object)PHPTokenId.PHP_FOR) && !id.equals((Object)PHPTokenId.PHP_FOREACH) && !id.equals((Object)PHPTokenId.PHP_TRY) && !id.equals((Object)PHPTokenId.PHP_CATCH) && !id.equals((Object)PHPTokenId.PHP_FUNCTION)) continue;
                    retval = false;
                }
                break;
            }
        }
        finally {
            tokenSequence.move(orgOffset);
            tokenSequence.moveNext();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean isInsideClassOrTraitDeclarationBlock(ParserResult info, int caretOffset, TokenSequence tokenSequence) {
        List<ASTNode> nodePath = NavUtils.underCaret(info, CompletionContextFinder.lexerToASTOffset(info, caretOffset));
        boolean methDecl = false;
        boolean funcDecl = false;
        boolean typeDecl = false;
        boolean isTypeInsideFunc = false;
        boolean isFuncInsideType = false;
        for (ASTNode aSTNode : nodePath) {
            if (aSTNode instanceof FunctionDeclaration) {
                funcDecl = true;
                if (!typeDecl) continue;
                isFuncInsideType = true;
                continue;
            }
            if (aSTNode instanceof MethodDeclaration) {
                methDecl = true;
                continue;
            }
            if (!(aSTNode instanceof ClassDeclaration) && !(aSTNode instanceof TraitDeclaration)) continue;
            if (aSTNode.getEndOffset() != caretOffset) {
                typeDecl = true;
                if (!funcDecl) continue;
                isTypeInsideFunc = true;
                continue;
            }
            return false;
        }
        if (funcDecl && !methDecl && !typeDecl) {
            final StringBuilder sb = new StringBuilder();
            new DefaultVisitor(){

                @Override
                public void visit(ASTError astError) {
                    super.visit(astError);
                    sb.append(astError.toString());
                }
            }.scan(Utils.getRoot(info));
            if (sb.length() == 0) {
                return false;
            }
        }
        if (isTypeInsideFunc && !isFuncInsideType) {
            return true;
        }
        int orgOffset = tokenSequence.offset();
        try {
            int curlyOpen = 0;
            int curlyClose = 0;
            while (tokenSequence.movePrevious()) {
                boolean isTypeScope;
                Token token = tokenSequence.token();
                TokenId id = token.id();
                if (id.equals((Object)PHPTokenId.PHP_CURLY_OPEN)) {
                    ++curlyOpen;
                    continue;
                }
                if (id.equals((Object)PHPTokenId.PHP_CURLY_CLOSE)) {
                    ++curlyClose;
                    continue;
                }
                if ((id.equals((Object)PHPTokenId.PHP_FUNCTION) || id.equals((Object)PHPTokenId.PHP_WHILE) || id.equals((Object)PHPTokenId.PHP_IF) || id.equals((Object)PHPTokenId.PHP_FOR) || id.equals((Object)PHPTokenId.PHP_FOREACH) || id.equals((Object)PHPTokenId.PHP_TRY) || id.equals((Object)PHPTokenId.PHP_CATCH)) && curlyOpen > curlyClose) {
                    boolean bl = false;
                    return bl;
                }
                if (!id.equals((Object)PHPTokenId.PHP_CLASS) && !id.equals((Object)PHPTokenId.PHP_TRAIT)) continue;
                boolean bl = isTypeScope = curlyOpen > 0 && curlyOpen > curlyClose;
                return bl;
            }
        }
        finally {
            tokenSequence.move(orgOffset);
            tokenSequence.moveNext();
        }
        return false;
    }

    static CompletionContext getCompletionContextInComment(TokenSequence<PHPTokenId> tokenSeq, int caretOffset, ParserResult info) {
        Token token = tokenSeq.token();
        CharSequence text = token.text();
        if (text == null || text.length() == 0) {
            return CompletionContext.NONE;
        }
        int offset = caretOffset - tokenSeq.offset() - 1;
        char charAt = '\u0000';
        if (offset > -1) {
            charAt = text.charAt(offset--);
            while (-1 < offset && !Character.isWhitespace(charAt) && charAt != '$') {
                charAt = text.charAt(offset);
                --offset;
            }
        }
        if (offset < text.length() && charAt == '$') {
            return CompletionContext.STRING;
        }
        return CompletionContext.TYPE_NAME;
    }

    static int lexerToASTOffset(PHPParseResult result, int lexerOffset) {
        return lexerOffset;
    }

    static int lexerToASTOffset(ParserResult info, int lexerOffset) {
        int value = 0;
        if (info instanceof PHPParseResult) {
            PHPParseResult result = (PHPParseResult)info;
            value = CompletionContextFinder.lexerToASTOffset(result, lexerOffset);
        }
        return value;
    }

    static enum KeywordCompletionType {
        SIMPLE,
        CURSOR_INSIDE_BRACKETS,
        ENDS_WITH_CURLY_BRACKETS,
        ENDS_WITH_SPACE,
        ENDS_WITH_SEMICOLON,
        ENDS_WITH_COLON,
        ENDS_WITH_BRACKETS_AND_CURLY_BRACKETS,
        CURSOR_BEFORE_ENDING_SEMICOLON;

    }

    public static enum CompletionContext {
        EXPRESSION,
        HTML,
        CLASS_NAME,
        INTERFACE_NAME,
        TYPE_NAME,
        STRING,
        CLASS_MEMBER,
        STATIC_CLASS_MEMBER,
        PHPDOC,
        INHERITANCE,
        EXTENDS,
        IMPLEMENTS,
        METHOD_NAME,
        CLASS_CONTEXT_KEYWORDS,
        SERVER_ENTRY_CONSTANTS,
        NONE,
        NEW_CLASS,
        GLOBAL,
        NAMESPACE_KEYWORD,
        GROUP_USE_KEYWORD,
        GROUP_USE_CONST_KEYWORD,
        GROUP_USE_FUNCTION_KEYWORD,
        USE_KEYWORD,
        USE_CONST_KEYWORD,
        USE_FUNCTION_KEYWORD,
        DEFAULT_PARAMETER_VALUE,
        OPEN_TAG,
        THROW,
        CATCH,
        CLASS_MEMBER_IN_STRING,
        INTERFACE_CONTEXT_KEYWORDS,
        USE_TRAITS;

    }
}

