/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.xml;

import java.io.BufferedWriter;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.cnd.api.xml.AttrValuePair;
import org.openide.xml.XMLUtil;

public final class XMLEncoderStream {
    private String indentElement = "  ";
    private int indent;
    private PrintWriter writer;
    private OutputStream os;

    @SuppressWarnings(value={"Dm"})
    XMLEncoderStream(OutputStream os, int indentChars, String encoding, String lineSeparator) {
        this.os = os;
        try {
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(os, encoding));
            this.writer = new MyPrintWriter((Writer)w, lineSeparator);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace(System.err);
            this.writer = new PrintWriter(os);
        }
        this.makeIndentElement(indentChars);
    }

    private void makeIndentElement(int indentChars) {
        this.indentElement = "";
        if (indentChars > 20) {
            indentChars = 20;
        }
        for (int i = 0; i < indentChars; ++i) {
            this.indentElement = this.indentElement + " ";
        }
    }

    public void elementOpen(String tagName, int version, AttrValuePair[] attrs) {
        this.writeIndent();
        this.writer.print("<" + tagName);
        this.writeAttrs(tagName, version, attrs, true);
        this.writer.println(">");
        ++this.indent;
    }

    public void elementOpen(String tagName, AttrValuePair[] attrs) {
        this.elementOpen(tagName, -1, attrs);
    }

    public void elementOpen(String tagName, int version) {
        this.elementOpen(tagName, version, null);
    }

    public void elementOpen(String tagName) {
        this.elementOpen(tagName, -1, null);
    }

    public void elementClose(String tagName) {
        --this.indent;
        if (this.indent < 0) {
            this.indent = 0;
        }
        this.writeIndent();
        this.writer.println("</" + tagName + ">");
    }

    public void element(String tagName, AttrValuePair[] attrs) {
        this.element(tagName, -1, attrs, null);
    }

    public void element(String tagName, String content) {
        this.element(tagName, -1, null, content);
    }

    public void element(String tagName, int version, AttrValuePair[] attrs, String content) {
        this.writeIndent();
        this.writer.print("<" + tagName);
        this.writeAttrs(tagName, version, attrs, true);
        if (content == null) {
            this.writer.print("/>");
        } else {
            this.writer.print(">");
        }
        if (content != null) {
            this.writer.print(XMLEncoderStream.escapeContent(content));
            this.writer.print("</" + tagName + ">");
        }
        this.writer.println();
    }

    void close() throws IOException {
        this.writer.flush();
        this.writer.close();
        this.writer = null;
        this.os.close();
    }

    void println(String s) {
        this.writer.println(s);
    }

    private void writeIndent(int additionalIndent) {
        int i;
        for (i = 0; i < this.indent; ++i) {
            this.writer.print(this.indentElement);
        }
        for (i = 0; i < additionalIndent; ++i) {
            this.writer.print(' ');
        }
    }

    private void writeIndent() {
        this.writeIndent(0);
    }

    private boolean needFormat(String tagName, int version, AttrValuePair[] attrs, boolean format) {
        if (!format) {
            return false;
        }
        int additionalIndent = 1 + tagName.length() + 1;
        int max = 80;
        int width = additionalIndent;
        if (version >= 0) {
            width += " version=\"\"".length();
            width += ("" + version).length();
        }
        if (width > 80) {
            return true;
        }
        if (attrs != null) {
            for (int ax = 0; ax < attrs.length; ++ax) {
                AttrValuePair avp = attrs[ax];
                width += " ".length();
                width += avp.getAttr().length();
                width += "=\"".length();
                width += avp.getValue().length();
                if ((width += "\"".length()) <= 80) continue;
                return true;
            }
        }
        return false;
    }

    private void writeAttrs(String tagName, int version, AttrValuePair[] attrs, boolean format) {
        int awritten = 0;
        format = this.needFormat(tagName, version, attrs, format);
        if (version != -1) {
            this.writer.print(" version=\"");
            this.writer.print(version);
            this.writer.print("\"");
            ++awritten;
        }
        if (attrs != null) {
            int additionalIndent = 1 + tagName.length() + 1;
            for (int ax = 0; ax < attrs.length; ++ax) {
                AttrValuePair avp = attrs[ax];
                if (awritten >= 1 && format) {
                    this.writer.println();
                    this.writeIndent(additionalIndent);
                } else {
                    this.writer.print(" ");
                }
                this.writer.print(avp.getAttr());
                this.writer.print("=\"");
                this.writer.print(XMLEncoderStream.escapeAttributeValue(avp.getValue()));
                this.writer.print("\"");
                ++awritten;
            }
        }
    }

    public static String escapeAttributeValue(String value) {
        if (value == null) {
            return "";
        }
        String escapedValue = value;
        try {
            escapedValue = XMLUtil.toAttributeValue((String)value);
        }
        catch (CharConversionException charConversionException) {
            // empty catch block
        }
        return escapedValue;
    }

    public static String escapeContent(String content) {
        if (content == null) {
            return "";
        }
        String escapedContent = content;
        try {
            escapedContent = XMLUtil.toElementContent((String)content);
        }
        catch (CharConversionException charConversionException) {
            // empty catch block
        }
        return escapedContent;
    }

    private static final class MyPrintWriter
    extends PrintWriter {
        private final String lineSeparator;

        public MyPrintWriter(Writer w, String lineSeparator) {
            super(w);
            this.lineSeparator = lineSeparator;
        }

        @Override
        public void println() {
            this.newLine();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void newLine() {
            try {
                Object object = this.lock;
                synchronized (object) {
                    if (this.out == null) {
                        throw new IOException("Stream closed");
                    }
                    this.out.write(this.lineSeparator);
                }
            }
            catch (InterruptedIOException x) {
                Thread.currentThread().interrupt();
            }
            catch (IOException x) {
                this.setError();
            }
        }
    }
}

