/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.macros.storage.ui;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class MacrosNamePanel
extends JPanel {
    private transient ChangeListener parent;
    private final Color regularColor;
    private final Color errColor;
    private JLabel errorLabel;
    private JLabel label;
    private JTextField nameField;

    public MacrosNamePanel() {
        this.initComponents();
        this.regularColor = this.nameField.getForeground();
        this.errColor = UIManager.getDefaults().getColor("nb.errorForeground");
        this.setErrorMessage(null);
    }

    private void initComponents() {
        this.label = new JLabel();
        this.nameField = new JTextField();
        this.errorLabel = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setMinimumSize(new Dimension(100, 50));
        this.setPreferredSize(new Dimension(340, 82));
        this.label.setHorizontalAlignment(2);
        this.label.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)NbBundle.getMessage(MacrosNamePanel.class, (String)"CTL_Enter_macro_name"));
        this.nameField.setMinimumSize(new Dimension(44, 24));
        this.nameField.setPreferredSize(new Dimension(120, 24));
        this.nameField.selectAll();
        this.errorLabel.setForeground(new Color(255, 0, 0));
        this.errorLabel.setHorizontalTextPosition(2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameField, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.errorLabel, -2, 307, -2).addContainerGap(5, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label).addComponent(this.nameField, -2, 24, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.errorLabel, -2, 16, -2).addContainerGap()));
        this.nameField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MacrosNamePanel.class, (String)"AN_Enter_macro_name"));
        this.nameField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MacrosNamePanel.class, (String)"AD_Enter_macro_name"));
    }

    public String getNameValue() {
        return this.nameField.getText();
    }

    public void setChangeListener(ChangeListener textListener) {
        this.parent = textListener;
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
                MacrosNamePanel.this.parent.stateChanged(null);
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                MacrosNamePanel.this.parent.stateChanged(null);
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                MacrosNamePanel.this.parent.stateChanged(null);
            }
        });
        this.parent.stateChanged(null);
    }

    private void setTextColor(Color color) {
        this.nameField.setForeground(color);
    }

    public void setErrorMessage(String text) {
        if (text != null && text.length() > 0) {
            this.errorLabel.setText(text);
            this.errorLabel.setFocusable(true);
            this.setTextColor(this.errColor);
        } else {
            this.errorLabel.setText(" ");
            this.errorLabel.setFocusable(false);
            this.setTextColor(this.regularColor);
        }
    }
}

