/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.File;

class VerifyExp {
    static int verbose = 1;
    static boolean printTrace = false;

    VerifyExp() {
    }

    public static void main(String[] stringArray) {
        String string;
        int n;
        boolean bl = true;
        for (n = 0; n < stringArray.length && stringArray[n].length() > 0 && stringArray[n].charAt(0) == '-'; ++n) {
            string = stringArray[n];
            if (string.equals("-verbose")) {
                ++verbose;
                continue;
            }
            if (string.equals("-nobanner")) {
                bl = false;
                continue;
            }
            if (string.equals("-nowarn")) {
                VerifierError.noWarn = true;
                continue;
            }
            if (string.equals("-help")) {
                VerifyExp.printUsageAndExit();
                continue;
            }
            if (string.equals("-version")) {
                Messages.println("MainExp.3");
                Messages.exactPrintLn(ToolsVersion.getCopyrightBanner());
                Messages.exactPrintLn(ToolsVersion.getCopyrightBanner());
                System.exit(2);
                continue;
            }
            VerifyExp.printUsageAndExit();
        }
        if (n + 1 != stringArray.length) {
            VerifyExp.printUsageAndExit();
        }
        if (verbose >= 1 && bl) {
            Messages.println("MainExp.3", ToolsVersion.getVersion(2));
        }
        Messages.exactPrintLn(ToolsVersion.getCopyrightBanner());
        string = stringArray[n];
        if (!string.endsWith(".exp")) {
            VerifyExp.printUsageAndExit();
        }
        File file = new File(string);
        if (verbose >= 1) {
            Messages.println("MainExp.4", string);
        }
        try {
            ExportFile exportFile = ExportFile.readFromFile(file);
            exportFile.verify();
        }
        catch (VerifierError verifierError) {
            Messages.printSevere("MainExp.2", Messages.numWarning, verifierError.getMessage(), Messages.format("MainExp.6"));
            System.exit(2);
        }
        Messages.println("MainExp.5", Messages.numWarning);
    }

    private static void printUsageAndExit() {
        Messages.printTo(System.err);
        Messages.println("MainExp.1");
        System.exit(2);
    }
}

