/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter;

import com.sun.javacard.basicstructure.PackageDefinition;
import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JPackage;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.PrecheckException;
import com.sun.javacard.converter.checkers.ReferenceChecker;
import com.sun.javacard.converter.checkers.SubsetChecker;
import com.sun.javacard.converter.converters.PackageConverter;
import com.sun.javacard.converter.efbuilder.ExportFileBuilder;
import com.sun.javacard.converter.jcawriter.JcaWriter;
import com.sun.javacard.converter.optimizers.Optimizer;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.converter.util.Strings;
import com.sun.javacard.debugcomponent.DebugComponent;
import com.sun.javacard.exportfile.EfExportFile;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class Converter {
    protected static ResourceBundle messages = ResourceBundle.getBundle("com/sun/javacard/converter/MessagesBundle");
    public static final byte CAP_MAJOR_VERSION = 2;
    public static final byte CAP_MINOR_VERSION = 1;
    public static final byte EXP_MAJOR_VERSION = 2;
    public static final byte MIN_EXP_MINOR_VERSION = 1;
    public static final byte MAX_EXP_MINOR_VERSION = 2;
    public static final byte JCA_MAJOR_VERSION = 2;
    public static final byte JCA_MINOR_VERSION = 1;
    public static final int MIN_CLASSFILE_MAJOR_VERSION = 45;
    public static final int MAX_CLASSFILE_MAJOR_VERSION = 50;
    public static final int MIN_CLASSFILE_MINOR_VERSION = 0;
    public static final int MAX_CLASSFILE_MINOR_VERSION = 65535;
    private ConversionProfile conversion_profile;
    private JPackage java_package;
    private JcPackage jc_package;
    private ExportFileManager export_file_manager;

    public JcPackage getJcPakcage() {
        return this.jc_package;
    }

    public ExportFileManager getExportFileManager() {
        return this.export_file_manager;
    }

    public Converter(ConversionProfile conversionProfile, Hashtable<String, File> hashtable) {
        this.conversion_profile = conversionProfile;
        for (int i = 0; i < conversionProfile.applets_profile.length; ++i) {
            String string = conversionProfile.applets_profile[i].install_class;
            if (string.indexOf(46) >= 0 || string.indexOf(47) >= 0) continue;
            this.conversion_profile.applets_profile[i].install_class = string = (conversionProfile.package_profile.package_name + '.' + string).replace('.', '/');
        }
        this.export_file_manager = new ExportFileManager(conversionProfile, hashtable);
    }

    public void convert() throws Exception {
        Object object;
        if (this.conversion_profile.this_exp_provided) {
            object = this.export_file_manager.load(this.conversion_profile.package_profile.package_name);
            this.checkBinaryCompatibility((EfExportFile)object);
        } else if (this.conversion_profile.package_profile.minor_version > 0) {
            Notifier.warning("warning.9");
        }
        this.java_package = new JPackage(this.conversion_profile.package_profile.package_name);
        this.java_package.parse(this.conversion_profile.classes);
        try {
            this.java_package.resolve();
        }
        catch (PrecheckException precheckException) {
            // empty catch block
        }
        this.checkError();
        if (this.java_package.getClasses().length == 0) {
            Notifier.error("conversion.0", this.java_package.getPackageName().replace('/', '.'));
        }
        this.checkClassFileVersion();
        this.checkError();
        object = new SubsetChecker(this.conversion_profile);
        ((SubsetChecker)object).check(this.java_package);
        this.checkError();
        PackageConverter packageConverter = new PackageConverter(this.java_package, this.conversion_profile, this.export_file_manager);
        this.jc_package = packageConverter.convert();
        this.checkError();
        this.checkAidConsistency();
        this.checkError();
        boolean bl = false;
        if (this.conversion_profile.output == 2) {
            bl = true;
        }
        ReferenceChecker referenceChecker = new ReferenceChecker(this.jc_package, this.export_file_manager, bl);
        referenceChecker.check();
        this.checkError();
        ((SubsetChecker)object).check(this.jc_package);
        this.checkError();
        Optimizer optimizer = new Optimizer(this.jc_package);
        this.jc_package = optimizer.optimize();
        this.checkError();
        File file = this.determineOutputPath();
        if ((this.conversion_profile.output & 2) != 0) {
            ExportFileBuilder exportFileBuilder = new ExportFileBuilder(this.jc_package, this.conversion_profile);
            EfExportFile efExportFile = exportFileBuilder.build();
            this.outputExportFile(efExportFile, file);
        }
        this.checkError();
        if ((this.conversion_profile.output & 4) != 0) {
            this.outputJCAFile(file);
            if (this.conversion_profile.debug) {
                this.outputDebugComponent(file);
            }
        }
        this.checkError();
    }

    private void checkBinaryCompatibility(EfExportFile efExportFile) throws Exception {
        if (efExportFile.getPackageMajorVersion() != this.conversion_profile.package_profile.major_version) {
            Object[] objectArray = new Object[]{Names.getExportFileName(efExportFile.getPackageName()), messages.getString("major"), messages.getString("major")};
            Notifier.error("binary.2", objectArray);
            throw new ConverterException();
        }
        if (efExportFile.getPackageMinorVersion() > this.conversion_profile.package_profile.minor_version) {
            Object[] objectArray = new Object[]{Names.getExportFileName(efExportFile.getPackageName()), messages.getString("minor"), messages.getString("minor")};
            Notifier.error("binary.2", objectArray);
            throw new ConverterException();
        }
        if (efExportFile.getPackageMinorVersion() == this.conversion_profile.package_profile.minor_version) {
            this.conversion_profile.packageUpgrade = false;
            Notifier.progress("progress.4");
        } else {
            this.conversion_profile.packageUpgrade = true;
            Notifier.progress("progress.5");
        }
    }

    private void checkClassFileVersion() {
        JClassFile[] jClassFileArray;
        for (JClassFile jClassFile : jClassFileArray = this.java_package.getClasses()) {
            boolean bl = true;
            int n = jClassFile.getMajorVersion();
            int n2 = jClassFile.getMinorVersion();
            String string = String.valueOf(n) + "." + String.valueOf(n2);
            if (n < 45 || n > 50) {
                bl = false;
            } else if (n2 < 0 || n2 > 65535) {
                bl = false;
            } else if (n == 50 && n2 != 0) {
                bl = false;
            }
            if (bl) continue;
            Object[] objectArray = new String[]{jClassFile.getClassName().replace('/', '.'), string};
            Notifier.error("conversion.3", objectArray);
        }
    }

    private File determineOutputPath() throws Exception {
        String string = this.conversion_profile.output_dir;
        String string2 = this.conversion_profile.package_profile.package_name;
        char c = File.separatorChar;
        String string3 = string2.replace('/', c) + c + "javacard";
        File file = new File(string, string3);
        if (file.isFile()) {
            Notifier.error("converter.2");
            throw new ConverterException();
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    private void outputExportFile(EfExportFile efExportFile, File file) throws Exception {
        String string = Names.getExportFileName(efExportFile.getPackageName());
        File file2 = new File(file, string);
        if (file2.isFile() && !file2.canWrite()) {
            Notifier.error("converter.3", string);
            throw new ConverterException();
        }
        try {
            Notifier.progress("progress.3", file2.getCanonicalPath());
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
            efExportFile.toBinary(dataOutputStream);
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            Notifier.error("converter.4", string);
            throw new ConverterException();
        }
    }

    private void outputJCAFile(File file) throws Exception {
        JcaWriter jcaWriter = new JcaWriter(this.jc_package, this.conversion_profile, this.export_file_manager);
        String string = Names.getJcaFileName(this.jc_package.getPackageName());
        File file2 = new File(file, string);
        if (file2.isFile() && !file2.canWrite()) {
            Notifier.error("converter.3", string);
            throw new ConverterException();
        }
        PrintWriter printWriter = null;
        try {
            Notifier.progress("progress.3", file2.getCanonicalPath());
            printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file2)));
            jcaWriter.write(printWriter);
        }
        catch (IOException iOException) {
            Notifier.error("converter.4", string);
            throw new ConverterException();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private void outputDebugComponent(File file) throws Exception {
        JcClass[] jcClassArray;
        for (JcClass jcClass : jcClassArray = this.jc_package.getClasses()) {
            JcMethod[] jcMethodArray;
            for (JcMethod jcMethod : jcMethodArray = jcClass.getMethods()) {
                int n = 0;
                for (JcInstruction jcInstruction = jcMethod.getCode(); jcInstruction != null; jcInstruction = jcInstruction.getNextInstr()) {
                    jcInstruction.setPC(n);
                    n += jcInstruction.getSizeInBytes();
                }
            }
        }
        Globals.debugComp = new DebugComponent(this.jc_package);
        String string = "debug.cap";
        try {
            Globals.outputDebugData = Globals.debugComp.toByteArray();
            if (this.conversion_profile.mask) {
                File iOException = new File(file, "debug.msk");
                FileOutputStream fileOutputStream = new FileOutputStream(iOException);
                DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
                dataOutputStream.write(Globals.outputDebugData, 0, Globals.outputDebugData.length);
                dataOutputStream.flush();
                dataOutputStream.close();
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            Notifier.error("converter.4", string);
            throw new ConverterException();
        }
    }

    private void checkError() throws Exception {
        if (Notifier.getErrorCount() != 0) {
            throw new ConverterException();
        }
    }

    private void checkAidConsistency() throws Exception {
        byte[] byArray;
        int n;
        byte[] byArray2 = this.conversion_profile.package_profile.aid;
        byte[] byArray3 = new byte[]{byArray2[0], byArray2[1], byArray2[2], byArray2[3], byArray2[4]};
        Object object = this.export_file_manager.getExportFiles();
        for (n = 0; n < ((EfExportFile[])object).length; ++n) {
            byArray = object[n].getAID();
            if (!Arrays.equals(byArray, byArray2) || object[n].getPackageName().equals(this.conversion_profile.package_profile.package_name)) continue;
            Notifier.error("binary.65");
            throw new ConverterException();
        }
        object = new HashSet();
        for (n = 0; n < this.conversion_profile.applets_profile.length; ++n) {
            Object[] objectArray;
            Object object2;
            byArray = this.conversion_profile.applets_profile[n].aid;
            byte[] byArray4 = new byte[]{byArray[0], byArray[1], byArray[2], byArray[3], byArray[4]};
            if (Arrays.equals(byArray2, byArray)) {
                Notifier.error("binary.53");
                throw new ConverterException();
            }
            if (!Arrays.equals(byArray3, byArray4)) {
                Notifier.error("binary.52");
                throw new ConverterException();
            }
            String string = this.conversion_profile.applets_profile[n].install_class;
            JcClass jcClass = this.jc_package.getClass(string);
            if (jcClass == null) {
                object2 = new Object[]{string, this.jc_package.getPackageName().replace('/', '.')};
                Notifier.error("binary.54", object2);
                throw new ConverterException();
            }
            if (!jcClass.isApplet()) {
                object2 = new Object[]{string};
                Notifier.error("binary.55", object2);
                throw new ConverterException();
            }
            if (jcClass.isAbstract()) {
                object2 = new Object[]{string};
                Notifier.error("binary.67", object2);
                throw new ConverterException();
            }
            object2 = Strings.toHexString(byArray, ":");
            if (((HashSet)object).contains(object2)) {
                objectArray = new Object[]{object2};
                Notifier.error("binary.56", objectArray);
                throw new ConverterException();
            }
            ((HashSet)object).add(object2);
            for (Object object3 : objectArray = this.export_file_manager.getExportFiles()) {
                byte[] byArray5 = ((PackageDefinition)object3).getAID();
                if (!Arrays.equals(byArray5, byArray)) continue;
                Notifier.error("binary.61");
                throw new ConverterException();
            }
        }
    }
}

