/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.coordinator;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.tx.common.ActivityIdentifier;
import com.sun.xml.ws.tx.common.Identifier;
import com.sun.xml.ws.tx.common.TxLogger;
import com.sun.xml.ws.tx.coordinator.CoordinationContextInterface;
import com.sun.xml.ws.tx.coordinator.CoordinationManager;
import com.sun.xml.ws.tx.coordinator.Registrant;
import com.sun.xml.ws.tx.webservice.member.coord.CreateCoordinationContextType;
import com.sun.xml.ws.tx.webservice.member.coord.RegistrationCoordinatorPortTypeImpl;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Coordinator {
    private final CoordinationContextInterface context;
    private final CreateCoordinationContextType request;
    private final ActivityIdentifier id;
    private static final Timer expirationTimer = new Timer("WS-TX Expiration Timer");
    private ExpirationTask expirationTask = null;
    private boolean expired = false;
    private static TxLogger logger = TxLogger.getCoordLogger(Coordinator.class);

    public Coordinator(@NotNull CoordinationContextInterface context, @Nullable CreateCoordinationContextType request) {
        this.context = context;
        this.request = request;
        this.id = new ActivityIdentifier(context.getIdentifier());
        if (logger.isLogging(Level.FINER)) {
            logger.finer("Coordinator constructor", "New Coordinator created for activity: " + context.getIdentifier());
        }
        if (context.getExpires() != 0L) {
            if (logger.isLogging(Level.FINER)) {
                logger.finer("Coordinator constructor", "Starting expiration task for activity: " + context.getIdentifier() + " will expire in " + context.getExpires() + "ms");
            }
            this.expirationTask = new ExpirationTask(this);
            expirationTimer.schedule((TimerTask)this.expirationTask, context.getExpires());
        }
    }

    public Coordinator(@NotNull CoordinationContextInterface context) {
        this(context, null);
    }

    @NotNull
    public CoordinationContextInterface getContext() {
        return this.context;
    }

    @Nullable
    public CreateCoordinationContextType getRequest() {
        return this.request;
    }

    @NotNull
    public String getIdValue() {
        return this.id.getValue();
    }

    @NotNull
    public Identifier getId() {
        return this.id;
    }

    public long getExpires() {
        return this.context.getExpires();
    }

    public void setExpires(long i) {
        if (this.context != null) {
            this.context.setExpires(i);
        }
    }

    @NotNull
    public abstract List<Registrant> getRegistrants();

    public abstract void addRegistrant(Registrant var1, WebServiceContext var2);

    @Nullable
    public abstract Registrant getRegistrant(String var1);

    public abstract void removeRegistrant(String var1);

    public boolean isSubordinate() {
        return this.context.getRootRegistrationService() != null;
    }

    @NotNull
    public abstract EndpointReference getCoordinatorProtocolServiceForRegistrant(@NotNull Registrant var1);

    public boolean registerWithRootRegistrationService(@NotNull Registrant r) {
        return false;
    }

    public abstract boolean expirationGuard();

    public void expire() {
        this.expired = true;
        if (logger.isLogging(Level.FINEST)) {
            logger.finest("Coordinator.expire", "attempting to expire coordinator: " + this.id.getValue());
        }
        if (!this.expirationGuard()) {
            if (logger.isLogging(Level.FINEST)) {
                logger.finest("Coordinator.expire", "forgetting resources for: " + this.id.getValue());
            }
            this.forget();
        } else if (logger.isLogging(Level.FINEST)) {
            logger.finest("Coordinator.expire", "expiration was guarded, returning without expiration");
        }
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public void forget() {
        RegistrationCoordinatorPortTypeImpl rpti;
        if (this.expirationTask != null) {
            this.expirationTask.cancel();
            this.expirationTask = null;
        }
        if ((rpti = RegistrationCoordinatorPortTypeImpl.getManager().resolve(this.context.getRegistrationService())) != null) {
            RegistrationCoordinatorPortTypeImpl.getManager().unexport(rpti);
        }
        CoordinationManager.getInstance().removeCoordinator(this.id.getValue());
    }

    static class ExpirationTask
    extends TimerTask {
        Coordinator c;

        ExpirationTask(Coordinator c) {
            this.c = c;
        }

        public void run() {
            this.c.expire();
            this.cancel();
        }
    }
}

