/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.nodes;

import java.awt.Image;
import javax.swing.Action;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.AbstractItemNode;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.UnregisterAction;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.UnregisterCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;

class ResourceNode
extends AbstractItemNode {
    private static final String RESOURCES_ICON = "org/netbeans/modules/j2ee/weblogic9/resources/resources.gif";
    private static final String JDBC_RESOURCE_ICON = "org/netbeans/modules/j2ee/weblogic9/resources/jdbc.gif";
    private static final String CONNECTOR_ICON = "org/netbeans/modules/j2ee/weblogic9/resources/connector.gif";
    private static final String JAVAMAIL_ICON = "org/netbeans/modules/j2ee/weblogic9/resources/javamail.gif";
    private static final String LIBRARY_ICON = "org/netbeans/modules/j2ee/weblogic9/resources/libraries.gif";
    private ResourceNodeType resourceType;

    ResourceNode(Children children, ResourceNodeType type, String name, Node.Cookie cookie) {
        this(children, type, name, cookie, null);
    }

    ResourceNode(Children children, ResourceNodeType type, String name, Node.Cookie cookie, String tooltip) {
        super(children);
        this.setDisplayName(name);
        if (tooltip != null) {
            this.setShortDescription(tooltip);
        }
        this.resourceType = type;
        if (cookie != null) {
            this.getCookieSet().add(cookie);
        }
    }

    ResourceNode(Children children, ResourceNodeType type, String name, String tooltip) {
        this(children, type, name, null, tooltip);
    }

    ResourceNode(Children children, ResourceNodeType type, String name) {
        this(children, type, name, null, null);
    }

    ResourceNode(ChildFactory<? extends AbstractNode> childFactory, ResourceNodeType type, String name) {
        super(childFactory, name);
        this.setDisplayName(name);
        this.resourceType = type;
    }

    public Image getIcon(int type) {
        switch (this.resourceType) {
            case RESOURCE: {
                return ImageUtilities.loadImage((String)RESOURCES_ICON);
            }
            case JDBC: {
                return ImageUtilities.loadImage((String)JDBC_RESOURCE_ICON);
            }
            case CONNECTORS: {
                return ImageUtilities.loadImage((String)CONNECTOR_ICON);
            }
            case JAVA_MAIL: {
                return ImageUtilities.loadImage((String)JAVAMAIL_ICON);
            }
            case LIBRARY: {
                return ImageUtilities.loadImage((String)LIBRARY_ICON);
            }
        }
        return this.getIconDelegate().getIcon(type);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    @Override
    public Action[] getActions(boolean context) {
        Action[] actions = super.getActions(context);
        UnregisterCookie cookie = (UnregisterCookie)this.getCookieSet().getCookie(UnregisterCookie.class);
        if (cookie != null) {
            Action[] result = new Action[actions.length + 1];
            System.arraycopy(actions, 0, result, 0, actions.length);
            result[actions.length] = SystemAction.get(UnregisterAction.class);
            return result;
        }
        return actions;
    }

    private Node getIconDelegate() {
        return DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
    }

    static enum ResourceNodeType {
        RESOURCE,
        JDBC,
        JDBC_RESOURCES,
        JDBC_POOL,
        CONNECTORS,
        CONNECTOR_RESOURCES,
        CONNECTION_POOLS,
        ADMIN_OBJ_RESOURCE,
        JAVA_MAIL,
        LIBRARY,
        TUXEDO,
        WTC_SERVER,
        JOLT_CONNECTION_POOL;

    }
}

