/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.WebSocketHandlerDecorator;

public class LoggingWebSocketHandlerDecorator
extends WebSocketHandlerDecorator {
    private final Log logger = LogFactory.getLog(LoggingWebSocketHandlerDecorator.class);

    public LoggingWebSocketHandlerDecorator(WebSocketHandler delegate) {
        super(delegate);
    }

    @Override
    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Connection established, " + session + ", uri=" + session.getUri()));
        }
        super.afterConnectionEstablished(session);
    }

    @Override
    public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) throws Exception {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(message + ", " + session));
        }
        super.handleMessage(session, message);
    }

    @Override
    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Transport error for " + session + ": " + exception));
        } else if (this.logger.isTraceEnabled()) {
            this.logger.debug((Object)("Transport error for " + session), exception);
        }
        super.handleTransportError(session, exception);
    }

    @Override
    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Connection closed for " + session + ", " + closeStatus));
        }
        super.afterConnectionClosed(session, closeStatus);
    }
}

