/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend.impl;

import java.util.Comparator;
import org.clang.basic.BasicClangGlobals;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.SourceLocation;
import org.clang.frontend.impl.PrintPPOutputHelper;
import org.clang.frontend.impl.PrintPPOutputPPCallbacks;
import org.clang.lex.MacroDirective;
import org.clang.lex.MacroInfo;
import org.clang.lex.Preprocessor;
import org.clang.lex.Token;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringMapEntryBase;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public final class PrintPreprocessedOutputStatics {
    private static final Comparator<std_pair.pair<IdentifierInfo, MacroInfo>> MacroIDCompareCallback = new Comparator<std_pair.pair<IdentifierInfo, MacroInfo>>(){

        @Override
        public int compare(std_pair.pair<IdentifierInfo, MacroInfo> o1, std_pair.pair<IdentifierInfo, MacroInfo> o2) {
            return PrintPreprocessedOutputStatics.MacroIDCompare(o1, o2);
        }
    };

    public static void PrintMacroDefinition(IdentifierInfo II, MacroInfo MI, Preprocessor PP, raw_ostream OS) {
        OS.$out("#define ").$out(II.getName());
        if (MI.isFunctionLike()) {
            OS.$out_char((byte)40);
            if (!MI.arg_empty()) {
                IdentifierInfo[] ArgumentList = MI.$args();
                int AI = 0;
                int E = MI.getNumArgs();
                while (AI + 1 != E) {
                    OS.$out(ArgumentList[AI].getName());
                    OS.$out_char((byte)44);
                    ++AI;
                }
                if (llvm.$eq_StringRef((StringRef)ArgumentList[AI].getName(), (String)"__VA_ARGS__")) {
                    OS.$out(NativePointer.$ELLIPSIS);
                } else {
                    OS.$out(ArgumentList[AI].getName());
                }
            }
            if (MI.isGNUVarargs()) {
                OS.$out(NativePointer.$ELLIPSIS);
            }
            OS.$out_char((byte)41);
        }
        if (MI.tokens_empty() || !MI.tokens_begin().$star().hasLeadingSpace()) {
            OS.$out_char((byte)32);
        }
        SmallString SpellingBuffer = new SmallString(128);
        for (Token T : MI.tokens()) {
            if (T.hasLeadingSpace()) {
                OS.$out_char((byte)32);
            }
            OS.$out(PP.getSpelling(T, SpellingBuffer));
        }
    }

    public static void outputPrintable(raw_ostream OS, std.string Str) {
        int e = Str.size();
        for (int i = 0; i != e; ++i) {
            byte Char = Str.$at(i);
            if (BasicClangGlobals.isPrintable((byte)Char) && Char != 92 && Char != 34) {
                OS.$out_char(Char);
                continue;
            }
            OS.$out_char((byte)92).$out_char((byte)(48 + (Char >>> 6 & 7))).$out_char((byte)(48 + (Char >>> 3 & 7))).$out_char((byte)(48 + (Char >>> 0 & 7)));
        }
    }

    public static void PrintPreprocessedTokens(Preprocessor PP, Token Tok, PrintPPOutputPPCallbacks Callbacks, raw_ostream OS) {
        boolean DropComments = PP.getLangOpts().TraditionalCPP && !PP.getCommentRetentionState();
        PrintPPOutputHelper $Helper = Callbacks.$getPrintPPOutputHelper();
        Token PrevPrevTok = $Helper.$PrevPrevTok();
        Token PrevTok = $Helper.$PrevTok();
        PrevPrevTok.startToken();
        PrevTok.startToken();
        while (true) {
            if (Callbacks.hasEmittedDirectiveOnThisLine()) {
                Callbacks.startNewLineIfNeeded();
                Callbacks.MoveToLine(Tok.$getLocation());
            }
            if ((!Tok.isAtStartOfLine() || !Callbacks.HandleFirstTokOnLine(Tok)) && (Tok.hasLeadingSpace() || Callbacks.hasEmittedTokensOnThisLine() && Callbacks.AvoidConcat(PrevPrevTok, PrevTok, Tok))) {
                OS.$out_char((byte)32);
            }
            if (DropComments && Tok.is('\u0004')) {
                int StartLoc = Tok.$getLocation();
                Callbacks.MoveToLine(SourceLocation.$getLocWithOffset((int)StartLoc, (int)Tok.getLength()));
            } else {
                if (Tok.is('\u015d') || Tok.is('\u015e') || Tok.is('\u015f')) {
                    PP.Lex(Tok);
                    continue;
                }
                IdentifierInfo II = Tok.getIdentifierInfo();
                if (II != null) {
                    StringMapEntryBase entry = II.getEntry();
                    assert (entry != null);
                    OS.write(entry.getKeyArray(), entry.getKeyArrayIndex(), entry.getKeyLength());
                } else if (Tok.isLiteral() && !Tok.needsCleaning() && Tok.$CharPtrData() != null) {
                    OS.write(Tok.$CharPtrData(), Tok.$CharPtrDataIndex(), Tok.getLength());
                } else if (Tok.isLiteral() && !Tok.needsCleaning() && Tok.getLiteralData() != null) {
                    OS.write(Tok.getLiteralData(), Tok.getLength());
                } else if (Tok.getLength() < 256) {
                    char.ptr TokPtr = $Helper.$CharBufPtr();
                    int Len = PP.getSpelling(Tok, TokPtr);
                    OS.write(TokPtr, Len);
                    if (Tok.getKind() == '\u0004' || Tok.getKind() == '\u0000') {
                        Callbacks.HandleNewlinesInToken(TokPtr, Len);
                    }
                    $Helper.$reset$CharBufPtr();
                } else {
                    std.string S = PP.getSpelling(Tok);
                    OS.write(S.data(), S.size());
                    if (Tok.getKind() == '\u0004' || Tok.getKind() == '\u0000') {
                        Callbacks.HandleNewlinesInToken(S.data(), S.size());
                    }
                }
            }
            Callbacks.setEmittedTokensOnThisLine();
            if (Tok.is('\u0001')) break;
            PrevPrevTok.$assign(PrevTok);
            PrevTok.$assign(Tok);
            PP.Lex(Tok);
        }
        Callbacks.$releasePrintPPOutputHelper($Helper);
    }

    public static int MacroIDCompare(std_pair.pair<IdentifierInfo, MacroInfo> LHS, std_pair.pair<IdentifierInfo, MacroInfo> RHS) {
        return ((IdentifierInfo)LHS.first).getName().compare(((IdentifierInfo)RHS.first).getName());
    }

    public static void DoPrintMacros(Preprocessor PP, raw_ostream OS) {
        PP.IgnorePragmas();
        PP.EnterMainSourceFile();
        Token Tok = new Token();
        do {
            PP.Lex(Tok);
        } while (Tok.isNot('\u0001'));
        SmallVector MacrosByID = new SmallVector(128, (Object)new std_pair.pair());
        DenseMapIterator I = PP.macro_begin();
        DenseMapIterator E = PP.macro_end();
        while (I.$noteq(E)) {
            MacroDirective MD = ((Preprocessor.MacroState)I.$arrow().second).getLatest();
            if (MD != null && MD.isDefined()) {
                MacrosByID.push_back((Object)new std_pair.pair(I.$arrow().first, (Object)MD.getMacroInfo()));
            }
            I.$preInc();
        }
        llvm.array_pod_sort((type.ptr)MacrosByID.begin().toPointer(), (type.ptr)MacrosByID.end().toPointer(), MacroIDCompareCallback);
        int e = MacrosByID.size();
        for (int i = 0; i != e; ++i) {
            MacroInfo MI = (MacroInfo)((std_pair.pair)MacrosByID.$at((int)i)).second;
            if (MI.isBuiltinMacro()) continue;
            PrintPreprocessedOutputStatics.PrintMacroDefinition((IdentifierInfo)((std_pair.pair)MacrosByID.$at((int)i)).first, MI, PP, OS);
            OS.$out_char((byte)10);
        }
    }
}

