/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.ui.support;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class RemoteLogger {
    private static final Logger instance = Logger.getLogger("remote.support.logger");
    private static boolean assertionsEnabled = false;
    private static volatile Exception lastAssertion;

    public static Exception getLastAssertion() {
        return lastAssertion;
    }

    public static boolean isDebugMode() {
        return assertionsEnabled;
    }

    private RemoteLogger() {
    }

    public static Logger getInstance() {
        return instance;
    }

    public static void assertTrueInConsole(boolean value, String message) {
        if (assertionsEnabled && !value) {
            instance.log(Level.INFO, message);
        }
    }

    public static void assertTrue(boolean value) {
        if (assertionsEnabled && !value) {
            String message = "Assertion error";
            lastAssertion = new Exception(message);
            instance.log(Level.SEVERE, message, lastAssertion);
        }
    }

    public static void assertTrue(boolean value, String message) {
        if (assertionsEnabled && !value) {
            lastAssertion = new Exception(message);
            instance.log(Level.SEVERE, message, lastAssertion);
        }
    }

    public static void assertFalse(boolean value) {
        if (assertionsEnabled && value) {
            String message = "Assertion error";
            lastAssertion = new Exception(message);
            instance.log(Level.SEVERE, message, lastAssertion);
        }
    }

    public static void assertFalse(boolean value, String message) {
        if (assertionsEnabled && value) {
            lastAssertion = new Exception(message);
            instance.log(Level.SEVERE, message, lastAssertion);
        }
    }

    public static void assertNonUiThread(String message) {
        if (assertionsEnabled && SwingUtilities.isEventDispatchThread()) {
            lastAssertion = new Exception(message);
            instance.log(Level.SEVERE, message, lastAssertion);
        }
    }

    public static void assertNonUiThread() {
        RemoteLogger.assertNonUiThread("Should not be called from UI thread");
    }

    public static void finest(Exception exception) {
        instance.log(Level.FINEST, "FYI:", exception);
    }

    static {
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
    }
}

