/*
 * Decompiled with CFR 0.152.
 */
package lucee.loader.osgi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import lucee.commons.io.log.Log;
import lucee.commons.io.res.Resource;
import lucee.loader.engine.CFMLEngineFactory;
import lucee.loader.engine.CFMLEngineFactorySupport;
import lucee.loader.util.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class BundleUtil {
    public static Bundle addBundle(CFMLEngineFactory factory, BundleContext context, File bundle, Log log) throws IOException, BundleException {
        return BundleUtil.addBundle(factory, context, bundle.getAbsolutePath(), new FileInputStream(bundle), true, log);
    }

    public static Bundle addBundle(CFMLEngineFactory factory, BundleContext context, Resource bundle, Log log) throws IOException, BundleException {
        return BundleUtil.addBundle(factory, context, bundle.getAbsolutePath(), bundle.getInputStream(), true, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bundle addBundle(CFMLEngineFactory factory, BundleContext context, String path, InputStream is, boolean closeIS, Log log) throws IOException, BundleException {
        if (log != null) {
            log.info("OSGI", "add bundle:" + path);
        }
        try {
            Bundle bundle = BundleUtil.installBundle(context, path, is);
            return bundle;
        }
        finally {
            if (closeIS) {
                CFMLEngineFactorySupport.closeEL(is);
            }
        }
    }

    public static Bundle installBundle(BundleContext context, String path, InputStream is) throws BundleException {
        return context.installBundle(path, is);
    }

    public static void start(CFMLEngineFactory factory, List<Bundle> bundles) throws BundleException {
        if (bundles == null || bundles.isEmpty()) {
            return;
        }
        Iterator<Bundle> it = bundles.iterator();
        while (it.hasNext()) {
            BundleUtil.start(factory, it.next());
        }
    }

    public static void start(CFMLEngineFactory factory, Bundle bundle) throws BundleException {
        String fh = bundle.getHeaders().get("Fragment-Host");
        if (!Util.isEmpty(fh)) {
            factory.log(3, "do not start [" + bundle.getSymbolicName() + "], because this is a fragment bundle for [" + fh + "]");
            return;
        }
        factory.log(3, "start bundle:" + bundle.getSymbolicName() + ":" + bundle.getVersion().toString());
        BundleUtil.start(bundle, false);
    }

    @Deprecated
    public static void start(Bundle bundle) throws BundleException {
        BundleUtil.start(bundle, false);
    }

    public static void start(Bundle bundle, boolean async) throws BundleException {
        bundle.start();
        if (!async) {
            BundleUtil.waitFor(bundle, 8, 4, 2, 60000L);
        }
    }

    public static void stop(Bundle bundle, boolean async) throws BundleException {
        bundle.stop();
        if (!async) {
            BundleUtil.waitFor(bundle, 16, 32, 32, 60000L);
        }
    }

    private static void waitFor(Bundle bundle, int action1, int action2, int action3, long timeout) throws BundleException {
        long start = System.currentTimeMillis();
        while (bundle.getState() == action1 || bundle.getState() == action2 || bundle.getState() == action3) {
            if (start + timeout < System.currentTimeMillis()) {
                throw new BundleException("timeout [" + timeout + "] reached for action [" + (action1 == 8 ? "starting" : "stopping") + "], bundle is still in [" + bundle.getState() + "]");
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void startIfNecessary(CFMLEngineFactory factory, Bundle bundle) throws BundleException {
        if (bundle.getState() == 32) {
            return;
        }
        BundleUtil.start(factory, bundle);
    }

    public static String bundleState(int state, String defaultValue) {
        switch (state) {
            case 1: {
                return "UNINSTALLED";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 32: {
                return "ACTIVE";
            }
        }
        return defaultValue;
    }

    public static String toFrameworkBundleParent(String str) throws BundleException {
        if (str != null) {
            if ("framework".equalsIgnoreCase(str = str.trim())) {
                return "framework";
            }
            if ("app".equalsIgnoreCase(str)) {
                return "app";
            }
            if ("boot".equalsIgnoreCase(str)) {
                return "boot";
            }
            if ("ext".equalsIgnoreCase(str)) {
                return "ext";
            }
        }
        throw new BundleException("value [" + str + "] for [" + "org.osgi.framework.bundle.parent" + "] defintion is invalid, valid values are [" + "app" + ", " + "boot" + ", " + "ext" + ", " + "framework" + "]");
    }

    public static boolean isSystemBundle(Bundle bundle) {
        return bundle.getSymbolicName().equals("org.apache.felix.framework");
    }
}

