"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var vega_util_1 = require("vega-util");
var util_1 = require("./util");
function isVgSignalRef(o) {
    return !!o['signal'];
}
exports.isVgSignalRef = isVgSignalRef;
function isVgRangeStep(range) {
    return !!range['step'];
}
exports.isVgRangeStep = isVgRangeStep;
function isDataRefUnionedDomain(domain) {
    if (!vega_util_1.isArray(domain)) {
        return 'fields' in domain && !('data' in domain);
    }
    return false;
}
exports.isDataRefUnionedDomain = isDataRefUnionedDomain;
function isFieldRefUnionDomain(domain) {
    if (!vega_util_1.isArray(domain)) {
        return 'fields' in domain && 'data' in domain;
    }
    return false;
}
exports.isFieldRefUnionDomain = isFieldRefUnionDomain;
function isDataRefDomain(domain) {
    if (!vega_util_1.isArray(domain)) {
        return 'field' in domain && 'data' in domain;
    }
    return false;
}
exports.isDataRefDomain = isDataRefDomain;
function isSignalRefDomain(domain) {
    if (!vega_util_1.isArray(domain)) {
        return 'signal' in domain;
    }
    return false;
}
exports.isSignalRefDomain = isSignalRefDomain;
var VG_MARK_CONFIG_INDEX = {
    opacity: 1,
    fill: 1,
    fillOpacity: 1,
    stroke: 1,
    strokeCap: 1,
    strokeWidth: 1,
    strokeOpacity: 1,
    strokeDash: 1,
    strokeDashOffset: 1,
    size: 1,
    shape: 1,
    interpolate: 1,
    tension: 1,
    orient: 1,
    align: 1,
    baseline: 1,
    text: 1,
    limit: 1,
    dx: 1,
    dy: 1,
    radius: 1,
    theta: 1,
    angle: 1,
    font: 1,
    fontSize: 1,
    fontWeight: 1,
    fontStyle: 1,
    cursor: 1,
    href: 1,
};
exports.VG_MARK_CONFIGS = util_1.flagKeys(VG_MARK_CONFIG_INDEX);
//# sourceMappingURL=data:application/json;base64,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