"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var logical_1 = require("./logical");
var predicate_1 = require("./predicate");
function isFilter(t) {
    return t['filter'] !== undefined;
}
exports.isFilter = isFilter;
function isLookup(t) {
    return t['lookup'] !== undefined;
}
exports.isLookup = isLookup;
function isWindow(t) {
    return t['window'] !== undefined;
}
exports.isWindow = isWindow;
function isCalculate(t) {
    return t['calculate'] !== undefined;
}
exports.isCalculate = isCalculate;
function isBin(t) {
    return !!t['bin'];
}
exports.isBin = isBin;
function isTimeUnit(t) {
    return t['timeUnit'] !== undefined;
}
exports.isTimeUnit = isTimeUnit;
function isAggregate(t) {
    return t['aggregate'] !== undefined;
}
exports.isAggregate = isAggregate;
function normalizeTransform(transform) {
    return transform.map(function (t) {
        if (isFilter(t)) {
            return {
                filter: logical_1.normalizeLogicalOperand(t.filter, predicate_1.normalizePredicate)
            };
        }
        return t;
    });
}
exports.normalizeTransform = normalizeTransform;
//# sourceMappingURL=data:application/json;base64,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