'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KuiListingTableToolBarFooter = KuiListingTableToolBarFooter;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _ = require('../../');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function KuiListingTableToolBarFooter(_ref) {
  var pager = _ref.pager,
      itemsSelectedCount = _ref.itemsSelectedCount;

  var renderText = function renderText() {
    if (itemsSelectedCount === 1) {
      return '1 item selected';
    }

    return itemsSelectedCount + ' items selected';
  };

  var pagerSection = void 0;

  if (pager) {
    pagerSection = _react2.default.createElement(
      _.KuiToolBarFooterSection,
      null,
      pager
    );
  }

  return _react2.default.createElement(
    _.KuiToolBarFooter,
    null,
    _react2.default.createElement(
      _.KuiToolBarFooterSection,
      null,
      _react2.default.createElement(
        _.KuiToolBarText,
        null,
        renderText()
      )
    ),
    pagerSection
  );
} /*
   * Licensed to Elasticsearch B.V. under one or more contributor
   * license agreements. See the NOTICE file distributed with
   * this work for additional information regarding copyright
   * ownership. Elasticsearch B.V. licenses this file to you under
   * the Apache License, Version 2.0 (the "License"); you may
   * not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *    http://www.apache.org/licenses/LICENSE-2.0
   *
   * Unless required by applicable law or agreed to in writing,
   * software distributed under the License is distributed on an
   * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
   * KIND, either express or implied.  See the License for the
   * specific language governing permissions and limitations
   * under the License.
   */

KuiListingTableToolBarFooter.propTypes = {
  pager: _propTypes2.default.node,
  itemsSelectedCount: _propTypes2.default.number
};
