'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KuiExpressionButton = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; } /*
                                                                                                                                                                                                                              * Licensed to Elasticsearch B.V. under one or more contributor
                                                                                                                                                                                                                              * license agreements. See the NOTICE file distributed with
                                                                                                                                                                                                                              * this work for additional information regarding copyright
                                                                                                                                                                                                                              * ownership. Elasticsearch B.V. licenses this file to you under
                                                                                                                                                                                                                              * the Apache License, Version 2.0 (the "License"); you may
                                                                                                                                                                                                                              * not use this file except in compliance with the License.
                                                                                                                                                                                                                              * You may obtain a copy of the License at
                                                                                                                                                                                                                              *
                                                                                                                                                                                                                              *    http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                              *
                                                                                                                                                                                                                              * Unless required by applicable law or agreed to in writing,
                                                                                                                                                                                                                              * software distributed under the License is distributed on an
                                                                                                                                                                                                                              * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                                                                                                                                                                                              * KIND, either express or implied.  See the License for the
                                                                                                                                                                                                                              * specific language governing permissions and limitations
                                                                                                                                                                                                                              * under the License.
                                                                                                                                                                                                                              */

var KuiExpressionButton = function KuiExpressionButton(_ref) {
  var className = _ref.className,
      description = _ref.description,
      buttonValue = _ref.buttonValue,
      isActive = _ref.isActive,
      onClick = _ref.onClick,
      rest = _objectWithoutProperties(_ref, ['className', 'description', 'buttonValue', 'isActive', 'onClick']);

  var classes = (0, _classnames2.default)('kuiExpressionButton', className, {
    'kuiExpressionButton-isActive': isActive
  });

  return _react2.default.createElement(
    'button',
    _extends({
      className: classes,
      onClick: onClick
    }, rest),
    _react2.default.createElement(
      'span',
      { className: 'kuiExpressionButton__description' },
      description
    ),
    ' ',
    _react2.default.createElement(
      'span',
      { className: 'kuiExpressionButton__value' },
      buttonValue
    )
  );
};

exports.KuiExpressionButton = KuiExpressionButton;
KuiExpressionButton.propTypes = {
  className: _propTypes2.default.string,
  description: _propTypes2.default.string.isRequired,
  buttonValue: _propTypes2.default.string.isRequired,
  isActive: _propTypes2.default.bool.isRequired,
  onClick: _propTypes2.default.func.isRequired
};

KuiExpressionButton.defaultProps = {
  isActive: false
};
