'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTabbedContent = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _services = require('../../../services');

var _tabs = require('../tabs');

var _tab = require('../tab');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var makeId = (0, _services.htmlIdGenerator)();

var EuiTabbedContent = exports.EuiTabbedContent = function (_Component) {
  _inherits(EuiTabbedContent, _Component);

  function EuiTabbedContent(props) {
    _classCallCheck(this, EuiTabbedContent);

    var _this = _possibleConstructorReturn(this, (EuiTabbedContent.__proto__ || Object.getPrototypeOf(EuiTabbedContent)).call(this, props));

    _initialiseProps.call(_this);

    var initialSelectedTab = props.initialSelectedTab,
        selectedTab = props.selectedTab,
        tabs = props.tabs;


    _this.rootId = makeId();

    // Only track selection state if it's not controlled externally.
    if (!selectedTab) {
      _this.state = {
        selectedTabId: initialSelectedTab && initialSelectedTab.id || tabs[0].id
      };
    }
    return _this;
  }

  _createClass(EuiTabbedContent, [{
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          className = _props.className,
          tabs = _props.tabs,
          onTabClick = _props.onTabClick,
          initialSelectedTab = _props.initialSelectedTab,
          externalSelectedTab = _props.selectedTab,
          size = _props.size,
          rest = _objectWithoutProperties(_props, ['className', 'tabs', 'onTabClick', 'initialSelectedTab', 'selectedTab', 'size']);

      // Allow the consumer to control tab selection.


      var selectedTab = externalSelectedTab || tabs.find(function (tab) {
        return tab.id === _this2.state.selectedTabId;
      });

      var selectedTabContent = selectedTab.content,
          selectedTabId = selectedTab.id;


      return _react2.default.createElement(
        'div',
        _extends({ className: className }, rest),
        _react2.default.createElement(
          _tabs.EuiTabs,
          { size: size },
          tabs.map(function (tab) {
            var id = tab.id,
                name = tab.name,
                content = tab.content,
                tabProps = _objectWithoutProperties(tab, ['id', 'name', 'content']);

            var props = _extends({
              key: id,
              id: id
            }, tabProps, {
              onClick: function onClick() {
                return _this2.onTabClick(tab);
              },
              isSelected: tab === selectedTab,
              'aria-controls': _this2.rootId + '-' + id
            });

            return _react2.default.createElement(
              _tab.EuiTab,
              props,
              name
            );
          })
        ),
        _react2.default.createElement(
          'div',
          {
            role: 'tabpanel',
            id: this.rootId + '-' + selectedTabId,
            'aria-labelledby': selectedTabId
          },
          selectedTabContent
        )
      );
    }
  }]);

  return EuiTabbedContent;
}(_react.Component);

EuiTabbedContent.propTypes = {
  className: _propTypes2.default.string,

  /**
   * Each tab needs id and content properties, so we can associate it with its panel for accessibility.
   * The name property is also required to display to the user.
   */
  tabs: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    id: _propTypes2.default.string.isRequired,
    name: _propTypes2.default.string.isRequired,
    content: _propTypes2.default.node.isRequired
  })).isRequired,
  onTabClick: _propTypes2.default.func,

  /**
   * Use this prop if you want to control selection state within the owner component
   */
  selectedTab: _propTypes2.default.object,

  /**
   * Use this prop to set the initially selected tab while letting the tabbed content component
   * control selection state internally
   */
  initialSelectedTab: _propTypes2.default.object,
  size: _propTypes2.default.oneOf(_tabs.SIZES)
};

var _initialiseProps = function _initialiseProps() {
  var _this3 = this;

  this.onTabClick = function (selectedTab) {
    var _props2 = _this3.props,
        onTabClick = _props2.onTabClick,
        externalSelectedTab = _props2.selectedTab;


    if (onTabClick) {
      onTabClick(selectedTab);
    }

    // Only track selection state if it's not controlled externally.
    if (!externalSelectedTab) {
      _this3.setState({ selectedTabId: selectedTab.id });
    }
  };
};

EuiTabbedContent.__docgenInfo = [{
  'description': '',
  'displayName': 'EuiTabbedContent',
  'methods': [{
    'name': 'onTabClick',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'selectedTab',
      'type': null
    }],
    'returns': null
  }],
  'props': {
    'className': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': ''
    },
    'tabs': {
      'type': {
        'name': 'arrayOf',
        'value': {
          'name': 'shape',
          'value': {
            'id': {
              'name': 'string',
              'required': true
            },
            'name': {
              'name': 'string',
              'required': true
            },
            'content': {
              'name': 'node',
              'required': true
            }
          }
        }
      },
      'required': true,
      'description': 'Each tab needs id and content properties, so we can associate it with its panel for accessibility.\nThe name property is also required to display to the user.'
    },
    'onTabClick': {
      'type': {
        'name': 'func'
      },
      'required': false,
      'description': ''
    },
    'selectedTab': {
      'type': {
        'name': 'object'
      },
      'required': false,
      'description': 'Use this prop if you want to control selection state within the owner component'
    },
    'initialSelectedTab': {
      'type': {
        'name': 'object'
      },
      'required': false,
      'description': 'Use this prop to set the initially selected tab while letting the tabbed content component\ncontrol selection state internally'
    },
    'size': {
      'type': {
        'name': 'enum',
        'computed': true,
        'value': 'SIZES'
      },
      'required': false,
      'description': ''
    }
  }
}];