'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiErrorBoundary = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _text = require('../text');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EuiErrorBoundary = exports.EuiErrorBoundary = function (_Component) {
  _inherits(EuiErrorBoundary, _Component);

  function EuiErrorBoundary(props) {
    _classCallCheck(this, EuiErrorBoundary);

    var _this = _possibleConstructorReturn(this, (EuiErrorBoundary.__proto__ || Object.getPrototypeOf(EuiErrorBoundary)).call(this, props));

    _this.state = {
      hasError: false,
      error: undefined
    };
    return _this;
  }

  _createClass(EuiErrorBoundary, [{
    key: 'componentDidCatch',
    value: function componentDidCatch(error) {
      // Display fallback UI
      this.setState({
        hasError: true,
        error: error
      });
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          children = _props.children,
          rest = _objectWithoutProperties(_props, ['children']);

      if (this.state.hasError) {
        // You can render any custom fallback UI
        return _react2.default.createElement(
          'div',
          _extends({ className: 'euiErrorBoundary' }, rest),
          _react2.default.createElement(
            'div',
            { className: 'euiErrorBoundary__text' },
            _react2.default.createElement(
              _text.EuiText,
              { size: 'xs' },
              _react2.default.createElement(
                'h1',
                null,
                'Error'
              ),
              _react2.default.createElement(
                'pre',
                { className: 'euiErrorBoundary__stack' },
                _react2.default.createElement(
                  'p',
                  null,
                  this.state.error && this.state.error.stack
                )
              )
            )
          )
        );
      }

      return children;
    }
  }]);

  return EuiErrorBoundary;
}(_react.Component);

EuiErrorBoundary.propTypes = {
  children: _propTypes2.default.node
};
EuiErrorBoundary.__docgenInfo = [{
  'description': '',
  'displayName': 'EuiErrorBoundary',
  'methods': [{
    'name': 'componentDidCatch',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'error',
      'type': null
    }],
    'returns': null
  }],
  'props': {
    'children': {
      'type': {
        'name': 'node'
      },
      'required': false,
      'description': ''
    }
  }
}];