/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Collections {
    private static final int BINARYSEARCH_THRESHOLD = 5000;
    private static final int REVERSE_THRESHOLD = 18;
    private static final int SHUFFLE_THRESHOLD = 5;
    private static final int FILL_THRESHOLD = 25;
    private static final int ROTATE_THRESHOLD = 100;
    private static final int COPY_THRESHOLD = 10;
    private static final int REPLACEALL_THRESHOLD = 11;
    private static final int INDEXOFSUBLIST_THRESHOLD = 35;
    private static Random r;
    public static final Set EMPTY_SET;
    public static final List EMPTY_LIST;
    public static final Map EMPTY_MAP;

    private Collections() {
    }

    public static <T extends Comparable<? super T>> void sort(List<T> list) {
        list.sort(null);
    }

    public static <T> void sort(List<T> list, Comparator<? super T> comparator) {
        list.sort(comparator);
    }

    public static <T> int binarySearch(List<? extends Comparable<? super T>> list, T t) {
        if (list instanceof RandomAccess || list.size() < 5000) {
            return Collections.indexedBinarySearch(list, t);
        }
        return Collections.iteratorBinarySearch(list, t);
    }

    private static <T> int indexedBinarySearch(List<? extends Comparable<? super T>> list, T t) {
        int n = 0;
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            Comparable<T> comparable = list.get(n3);
            int n4 = comparable.compareTo(t);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    private static <T> int iteratorBinarySearch(List<? extends Comparable<? super T>> list, T t) {
        int n = 0;
        int n2 = list.size() - 1;
        ListIterator<? extends Comparable<? super T>> listIterator = list.listIterator();
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            Comparable<T> comparable = Collections.get(listIterator, n3);
            int n4 = comparable.compareTo(t);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    private static <T> T get(ListIterator<? extends T> listIterator, int n) {
        T t = null;
        int n2 = listIterator.nextIndex();
        if (n2 <= n) {
            do {
                t = listIterator.next();
            } while (n2++ < n);
        } else {
            do {
                t = listIterator.previous();
            } while (--n2 > n);
        }
        return t;
    }

    public static <T> int binarySearch(List<? extends T> list, T t, Comparator<? super T> comparator) {
        if (comparator == null) {
            return Collections.binarySearch(list, t);
        }
        if (list instanceof RandomAccess || list.size() < 5000) {
            return Collections.indexedBinarySearch(list, t, comparator);
        }
        return Collections.iteratorBinarySearch(list, t, comparator);
    }

    private static <T> int indexedBinarySearch(List<? extends T> list, T t, Comparator<? super T> comparator) {
        int n = 0;
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            T t2 = list.get(n3);
            int n4 = comparator.compare(t2, t);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    private static <T> int iteratorBinarySearch(List<? extends T> list, T t, Comparator<? super T> comparator) {
        int n = 0;
        int n2 = list.size() - 1;
        ListIterator<? extends T> listIterator = list.listIterator();
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            T t2 = Collections.get(listIterator, n3);
            int n4 = comparator.compare(t2, t);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static void reverse(List<?> list) {
        int n = list.size();
        if (n < 18 || list instanceof RandomAccess) {
            int n2 = 0;
            int n3 = n >> 1;
            int n4 = n - 1;
            while (n2 < n3) {
                Collections.swap(list, n2, n4);
                ++n2;
                --n4;
            }
        } else {
            ListIterator<?> listIterator = list.listIterator();
            ListIterator<?> listIterator2 = list.listIterator(n);
            int n5 = list.size() >> 1;
            for (int i = 0; i < n5; ++i) {
                Object obj = listIterator.next();
                listIterator.set(listIterator2.previous());
                listIterator2.set(obj);
            }
        }
    }

    public static void shuffle(List<?> list) {
        Random random = r;
        if (random == null) {
            r = random = new Random();
        }
        Collections.shuffle(list, random);
    }

    public static void shuffle(List<?> list, Random random) {
        int n = list.size();
        if (n < 5 || list instanceof RandomAccess) {
            for (int i = n; i > 1; --i) {
                Collections.swap(list, i - 1, random.nextInt(i));
            }
        } else {
            Object[] objectArray = list.toArray();
            for (int i = n; i > 1; --i) {
                Collections.swap(objectArray, i - 1, random.nextInt(i));
            }
            ListIterator<?> listIterator = list.listIterator();
            for (int i = 0; i < objectArray.length; ++i) {
                listIterator.next();
                listIterator.set(objectArray[i]);
            }
        }
    }

    public static void swap(List<?> list, int n, int n2) {
        List<?> list2 = list;
        list2.set(n, list2.set(n2, list2.get(n)));
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    public static <T> void fill(List<? super T> list, T t) {
        int n = list.size();
        if (n < 25 || list instanceof RandomAccess) {
            for (int i = 0; i < n; ++i) {
                list.set(i, t);
            }
        } else {
            ListIterator<T> listIterator = list.listIterator();
            for (int i = 0; i < n; ++i) {
                listIterator.next();
                listIterator.set(t);
            }
        }
    }

    public static <T> void copy(List<? super T> list, List<? extends T> list2) {
        int n = list2.size();
        if (n > list.size()) {
            throw new IndexOutOfBoundsException("Source does not fit in dest");
        }
        if (n < 10 || list2 instanceof RandomAccess && list instanceof RandomAccess) {
            for (int i = 0; i < n; ++i) {
                list.set(i, list2.get(i));
            }
        } else {
            ListIterator<T> listIterator = list.listIterator();
            ListIterator<T> listIterator2 = list2.listIterator();
            for (int i = 0; i < n; ++i) {
                listIterator.next();
                listIterator.set(listIterator2.next());
            }
        }
    }

    public static <T> T min(Collection<? extends T> collection) {
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (((Comparable)t2).compareTo(t) >= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T> T min(Collection<? extends T> collection, Comparator<? super T> comparator) {
        if (comparator == null) {
            return Collections.min(collection);
        }
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (comparator.compare(t2, t) >= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T> T max(Collection<? extends T> collection) {
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (((Comparable)t2).compareTo(t) <= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T> T max(Collection<? extends T> collection, Comparator<? super T> comparator) {
        if (comparator == null) {
            return Collections.max(collection);
        }
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (comparator.compare(t2, t) <= 0) continue;
            t = t2;
        }
        return t;
    }

    public static void rotate(List<?> list, int n) {
        if (list instanceof RandomAccess || list.size() < 100) {
            Collections.rotate1(list, n);
        } else {
            Collections.rotate2(list, n);
        }
    }

    private static <T> void rotate1(List<T> list, int n) {
        int n2 = list.size();
        if (n2 == 0) {
            return;
        }
        if ((n %= n2) < 0) {
            n += n2;
        }
        if (n == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 != n2) {
            T t = list.get(n3);
            int n5 = n3;
            do {
                if ((n5 += n) >= n2) {
                    n5 -= n2;
                }
                t = list.set(n5, t);
                ++n4;
            } while (n5 != n3);
            ++n3;
        }
    }

    private static void rotate2(List<?> list, int n) {
        int n2 = list.size();
        if (n2 == 0) {
            return;
        }
        int n3 = -n % n2;
        if (n3 < 0) {
            n3 += n2;
        }
        if (n3 == 0) {
            return;
        }
        Collections.reverse(list.subList(0, n3));
        Collections.reverse(list.subList(n3, n2));
        Collections.reverse(list);
    }

    public static <T> boolean replaceAll(List<T> list, T t, T t2) {
        boolean bl = false;
        int n = list.size();
        if (n < 11 || list instanceof RandomAccess) {
            if (t == null) {
                for (int i = 0; i < n; ++i) {
                    if (list.get(i) != null) continue;
                    list.set(i, t2);
                    bl = true;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (!t.equals(list.get(i))) continue;
                    list.set(i, t2);
                    bl = true;
                }
            }
        } else {
            ListIterator<T> listIterator = list.listIterator();
            if (t == null) {
                for (int i = 0; i < n; ++i) {
                    if (listIterator.next() != null) continue;
                    listIterator.set(t2);
                    bl = true;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (!t.equals(listIterator.next())) continue;
                    listIterator.set(t2);
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static int indexOfSubList(List<?> list, List<?> list2) {
        int n = list.size();
        int n2 = list2.size();
        int n3 = n - n2;
        if (n < 35 || list instanceof RandomAccess && list2 instanceof RandomAccess) {
            block0: for (int i = 0; i <= n3; ++i) {
                int n4 = 0;
                int n5 = i;
                while (n4 < n2) {
                    if (!Collections.eq(list2.get(n4), list.get(n5))) continue block0;
                    ++n4;
                    ++n5;
                }
                return i;
            }
        } else {
            ListIterator<?> listIterator = list.listIterator();
            block2: for (int i = 0; i <= n3; ++i) {
                ListIterator<?> listIterator2 = list2.listIterator();
                for (int j = 0; j < n2; ++j) {
                    if (Collections.eq(listIterator2.next(), listIterator.next())) continue;
                    for (int k = 0; k < j; ++k) {
                        listIterator.previous();
                    }
                    continue block2;
                }
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOfSubList(List<?> list, List<?> list2) {
        int n = list.size();
        int n2 = list2.size();
        int n3 = n - n2;
        if (n < 35 || list instanceof RandomAccess) {
            block0: for (int i = n3; i >= 0; --i) {
                int n4 = 0;
                int n5 = i;
                while (n4 < n2) {
                    if (!Collections.eq(list2.get(n4), list.get(n5))) continue block0;
                    ++n4;
                    ++n5;
                }
                return i;
            }
        } else {
            if (n3 < 0) {
                return -1;
            }
            ListIterator<?> listIterator = list.listIterator(n3);
            block2: for (int i = n3; i >= 0; --i) {
                ListIterator<?> listIterator2 = list2.listIterator();
                for (int j = 0; j < n2; ++j) {
                    if (Collections.eq(listIterator2.next(), listIterator.next())) continue;
                    if (i == 0) continue block2;
                    for (int k = 0; k <= j + 1; ++k) {
                        listIterator.previous();
                    }
                    continue block2;
                }
                return i;
            }
        }
        return -1;
    }

    public static <T> Collection<T> unmodifiableCollection(Collection<? extends T> collection) {
        return new UnmodifiableCollection<T>(collection);
    }

    public static <T> Set<T> unmodifiableSet(Set<? extends T> set) {
        return new UnmodifiableSet<T>(set);
    }

    public static <T> SortedSet<T> unmodifiableSortedSet(SortedSet<T> sortedSet) {
        return new UnmodifiableSortedSet<T>(sortedSet);
    }

    public static <T> NavigableSet<T> unmodifiableNavigableSet(NavigableSet<T> navigableSet) {
        return new UnmodifiableNavigableSet<T>(navigableSet);
    }

    public static <T> List<T> unmodifiableList(List<? extends T> list) {
        return list instanceof RandomAccess ? new UnmodifiableRandomAccessList<T>(list) : new UnmodifiableList<T>(list);
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> map) {
        return new UnmodifiableMap<K, V>(map);
    }

    public static <K, V> SortedMap<K, V> unmodifiableSortedMap(SortedMap<K, ? extends V> sortedMap) {
        return new UnmodifiableSortedMap<K, V>(sortedMap);
    }

    public static <K, V> NavigableMap<K, V> unmodifiableNavigableMap(NavigableMap<K, ? extends V> navigableMap) {
        return new UnmodifiableNavigableMap<K, V>(navigableMap);
    }

    public static <T> Collection<T> synchronizedCollection(Collection<T> collection) {
        return new SynchronizedCollection<T>(collection);
    }

    static <T> Collection<T> synchronizedCollection(Collection<T> collection, Object object) {
        return new SynchronizedCollection<T>(collection, object);
    }

    public static <T> Set<T> synchronizedSet(Set<T> set) {
        return new SynchronizedSet<T>(set);
    }

    static <T> Set<T> synchronizedSet(Set<T> set, Object object) {
        return new SynchronizedSet<T>(set, object);
    }

    public static <T> SortedSet<T> synchronizedSortedSet(SortedSet<T> sortedSet) {
        return new SynchronizedSortedSet<T>(sortedSet);
    }

    public static <T> NavigableSet<T> synchronizedNavigableSet(NavigableSet<T> navigableSet) {
        return new SynchronizedNavigableSet<T>(navigableSet);
    }

    public static <T> List<T> synchronizedList(List<T> list) {
        return list instanceof RandomAccess ? new SynchronizedRandomAccessList<T>(list) : new SynchronizedList<T>(list);
    }

    static <T> List<T> synchronizedList(List<T> list, Object object) {
        return list instanceof RandomAccess ? new SynchronizedRandomAccessList<T>(list, object) : new SynchronizedList<T>(list, object);
    }

    public static <K, V> Map<K, V> synchronizedMap(Map<K, V> map) {
        return new SynchronizedMap<K, V>(map);
    }

    public static <K, V> SortedMap<K, V> synchronizedSortedMap(SortedMap<K, V> sortedMap) {
        return new SynchronizedSortedMap<K, V>(sortedMap);
    }

    public static <K, V> NavigableMap<K, V> synchronizedNavigableMap(NavigableMap<K, V> navigableMap) {
        return new SynchronizedNavigableMap<K, V>(navigableMap);
    }

    public static <E> Collection<E> checkedCollection(Collection<E> collection, Class<E> clazz) {
        return new CheckedCollection<E>(collection, clazz);
    }

    static <T> T[] zeroLengthArray(Class<T> clazz) {
        return (Object[])Array.newInstance(clazz, 0);
    }

    public static <E> Queue<E> checkedQueue(Queue<E> queue, Class<E> clazz) {
        return new CheckedQueue<E>(queue, clazz);
    }

    public static <E> Set<E> checkedSet(Set<E> set, Class<E> clazz) {
        return new CheckedSet<E>(set, clazz);
    }

    public static <E> SortedSet<E> checkedSortedSet(SortedSet<E> sortedSet, Class<E> clazz) {
        return new CheckedSortedSet<E>(sortedSet, clazz);
    }

    public static <E> NavigableSet<E> checkedNavigableSet(NavigableSet<E> navigableSet, Class<E> clazz) {
        return new CheckedNavigableSet<E>(navigableSet, clazz);
    }

    public static <E> List<E> checkedList(List<E> list, Class<E> clazz) {
        return list instanceof RandomAccess ? new CheckedRandomAccessList<E>(list, clazz) : new CheckedList<E>(list, clazz);
    }

    public static <K, V> Map<K, V> checkedMap(Map<K, V> map, Class<K> clazz, Class<V> clazz2) {
        return new CheckedMap<K, V>(map, clazz, clazz2);
    }

    public static <K, V> SortedMap<K, V> checkedSortedMap(SortedMap<K, V> sortedMap, Class<K> clazz, Class<V> clazz2) {
        return new CheckedSortedMap<K, V>(sortedMap, clazz, clazz2);
    }

    public static <K, V> NavigableMap<K, V> checkedNavigableMap(NavigableMap<K, V> navigableMap, Class<K> clazz, Class<V> clazz2) {
        return new CheckedNavigableMap<K, V>(navigableMap, clazz, clazz2);
    }

    public static <T> Iterator<T> emptyIterator() {
        return EmptyIterator.EMPTY_ITERATOR;
    }

    public static <T> ListIterator<T> emptyListIterator() {
        return EmptyListIterator.EMPTY_ITERATOR;
    }

    public static <T> Enumeration<T> emptyEnumeration() {
        return EmptyEnumeration.EMPTY_ENUMERATION;
    }

    public static final <T> Set<T> emptySet() {
        return EMPTY_SET;
    }

    public static <E> SortedSet<E> emptySortedSet() {
        return UnmodifiableNavigableSet.EMPTY_NAVIGABLE_SET;
    }

    public static <E> NavigableSet<E> emptyNavigableSet() {
        return UnmodifiableNavigableSet.EMPTY_NAVIGABLE_SET;
    }

    public static final <T> List<T> emptyList() {
        return EMPTY_LIST;
    }

    public static final <K, V> Map<K, V> emptyMap() {
        return EMPTY_MAP;
    }

    public static final <K, V> SortedMap<K, V> emptySortedMap() {
        return UnmodifiableNavigableMap.EMPTY_NAVIGABLE_MAP;
    }

    public static final <K, V> NavigableMap<K, V> emptyNavigableMap() {
        return UnmodifiableNavigableMap.EMPTY_NAVIGABLE_MAP;
    }

    public static <T> Set<T> singleton(T t) {
        return new SingletonSet<T>(t);
    }

    static <E> Iterator<E> singletonIterator(final E e) {
        return new Iterator<E>(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public E next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return e;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void forEachRemaining(Consumer<? super E> consumer) {
                Objects.requireNonNull(consumer);
                if (this.hasNext) {
                    consumer.accept(e);
                    this.hasNext = false;
                }
            }
        };
    }

    static <T> Spliterator<T> singletonSpliterator(final T t) {
        return new Spliterator<T>(){
            long est = 1L;

            @Override
            public Spliterator<T> trySplit() {
                return null;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                Objects.requireNonNull(consumer);
                if (this.est > 0L) {
                    --this.est;
                    consumer.accept(t);
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> consumer) {
                this.tryAdvance(consumer);
            }

            @Override
            public long estimateSize() {
                return this.est;
            }

            @Override
            public int characteristics() {
                int n = t != null ? 256 : 0;
                return n | 0x40 | 0x4000 | 0x400 | 1 | 0x10;
            }
        };
    }

    public static <T> List<T> singletonList(T t) {
        return new SingletonList<T>(t);
    }

    public static <K, V> Map<K, V> singletonMap(K k, V v) {
        return new SingletonMap<K, V>(k, v);
    }

    public static <T> List<T> nCopies(int n, T t) {
        if (n < 0) {
            throw new IllegalArgumentException("List length = " + n);
        }
        return new CopiesList<T>(n, t);
    }

    public static <T> Comparator<T> reverseOrder() {
        return ReverseComparator.REVERSE_ORDER;
    }

    public static <T> Comparator<T> reverseOrder(Comparator<T> comparator) {
        if (comparator == null) {
            return Collections.reverseOrder();
        }
        if (comparator instanceof ReverseComparator2) {
            return ((ReverseComparator2)comparator).cmp;
        }
        return new ReverseComparator2<T>(comparator);
    }

    public static <T> Enumeration<T> enumeration(final Collection<T> collection) {
        return new Enumeration<T>(){
            private final Iterator<T> i;
            {
                this.i = collection.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.i.hasNext();
            }

            @Override
            public T nextElement() {
                return this.i.next();
            }
        };
    }

    public static <T> ArrayList<T> list(Enumeration<T> enumeration) {
        ArrayList<T> arrayList = new ArrayList<T>();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    static boolean eq(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static int frequency(Collection<?> collection, Object object) {
        int n = 0;
        if (object == null) {
            for (Object obj : collection) {
                if (obj != null) continue;
                ++n;
            }
        } else {
            for (Object obj : collection) {
                if (!object.equals(obj)) continue;
                ++n;
            }
        }
        return n;
    }

    public static boolean disjoint(Collection<?> collection, Collection<?> collection2) {
        Collection<?> collection3 = collection2;
        Collection<?> collection4 = collection;
        if (collection instanceof Set) {
            collection4 = collection2;
            collection3 = collection;
        } else if (!(collection2 instanceof Set)) {
            int n = collection.size();
            int n2 = collection2.size();
            if (n == 0 || n2 == 0) {
                return true;
            }
            if (n > n2) {
                collection4 = collection2;
                collection3 = collection;
            }
        }
        for (Object obj : collection4) {
            if (!collection3.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> boolean addAll(Collection<? super T> collection, T ... TArray) {
        boolean bl = false;
        for (T t : TArray) {
            bl |= collection.add(t);
        }
        return bl;
    }

    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        return new SetFromMap<E>(map);
    }

    public static <T> Queue<T> asLifoQueue(Deque<T> deque) {
        return new AsLIFOQueue<T>(deque);
    }

    static {
        EMPTY_SET = new EmptySet();
        EMPTY_LIST = new EmptyList();
        EMPTY_MAP = new EmptyMap();
    }

    static class AsLIFOQueue<E>
    extends AbstractQueue<E>
    implements Queue<E>,
    Serializable {
        private static final long serialVersionUID = 1802017725587941708L;
        private final Deque<E> q;

        AsLIFOQueue(Deque<E> deque) {
            this.q = deque;
        }

        @Override
        public boolean add(E e) {
            this.q.addFirst(e);
            return true;
        }

        @Override
        public boolean offer(E e) {
            return this.q.offerFirst(e);
        }

        @Override
        public E poll() {
            return this.q.pollFirst();
        }

        @Override
        public E remove() {
            return this.q.removeFirst();
        }

        @Override
        public E peek() {
            return this.q.peekFirst();
        }

        @Override
        public E element() {
            return this.q.getFirst();
        }

        @Override
        public void clear() {
            this.q.clear();
        }

        @Override
        public int size() {
            return this.q.size();
        }

        @Override
        public boolean isEmpty() {
            return this.q.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.q.contains(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.q.remove(object);
        }

        @Override
        public Iterator<E> iterator() {
            return this.q.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.q.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.q.toArray(TArray);
        }

        @Override
        public String toString() {
            return this.q.toString();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.q.containsAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.q.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.q.retainAll(collection);
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            this.q.forEach(consumer);
        }

        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            return this.q.removeIf(predicate);
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.q.spliterator();
        }

        @Override
        public Stream<E> stream() {
            return this.q.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.q.parallelStream();
        }
    }

    private static class SetFromMap<E>
    extends AbstractSet<E>
    implements Set<E>,
    Serializable {
        private final Map<E, Boolean> m;
        private transient Set<E> s;
        private static final long serialVersionUID = 2454657854757543876L;

        SetFromMap(Map<E, Boolean> map) {
            if (!map.isEmpty()) {
                throw new IllegalArgumentException("Map is non-empty");
            }
            this.m = map;
            this.s = map.keySet();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.m.remove(object) != null;
        }

        @Override
        public boolean add(E e) {
            return this.m.put(e, Boolean.TRUE) == null;
        }

        @Override
        public Iterator<E> iterator() {
            return this.s.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.s.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.s.toArray(TArray);
        }

        @Override
        public String toString() {
            return this.s.toString();
        }

        @Override
        public int hashCode() {
            return this.s.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return object == this || this.s.equals(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.s.containsAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.s.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.s.retainAll(collection);
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            this.s.forEach(consumer);
        }

        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            return this.s.removeIf(predicate);
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.s.spliterator();
        }

        @Override
        public Stream<E> stream() {
            return this.s.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.s.parallelStream();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.s = this.m.keySet();
        }
    }

    private static class ReverseComparator2<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 4374092139857L;
        final Comparator<T> cmp;

        ReverseComparator2(Comparator<T> comparator) {
            assert (comparator != null);
            this.cmp = comparator;
        }

        @Override
        public int compare(T t, T t2) {
            return this.cmp.compare(t2, t);
        }

        @Override
        public boolean equals(Object object) {
            return object == this || object instanceof ReverseComparator2 && this.cmp.equals(((ReverseComparator2)object).cmp);
        }

        public int hashCode() {
            return this.cmp.hashCode() ^ Integer.MIN_VALUE;
        }

        @Override
        public Comparator<T> reversed() {
            return this.cmp;
        }
    }

    private static class ReverseComparator
    implements Comparator<Comparable<Object>>,
    Serializable {
        private static final long serialVersionUID = 7207038068494060240L;
        static final ReverseComparator REVERSE_ORDER = new ReverseComparator();

        private ReverseComparator() {
        }

        @Override
        public int compare(Comparable<Object> comparable, Comparable<Object> comparable2) {
            return comparable2.compareTo(comparable);
        }

        private Object readResolve() {
            return Collections.reverseOrder();
        }

        @Override
        public Comparator<Comparable<Object>> reversed() {
            return Comparator.naturalOrder();
        }
    }

    private static class CopiesList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 2739099268398711800L;
        final int n;
        final E element;

        CopiesList(int n, E e) {
            assert (n >= 0);
            this.n = n;
            this.element = e;
        }

        @Override
        public int size() {
            return this.n;
        }

        @Override
        public boolean contains(Object object) {
            return this.n != 0 && Collections.eq(object, this.element);
        }

        @Override
        public int indexOf(Object object) {
            return this.contains(object) ? 0 : -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.contains(object) ? this.n - 1 : -1;
        }

        @Override
        public E get(int n) {
            if (n < 0 || n >= this.n) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.n);
            }
            return this.element;
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.n];
            if (this.element != null) {
                Arrays.fill(objectArray, 0, this.n, this.element);
            }
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            int n = this.n;
            if (objectArray.length < n) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
                if (this.element != null) {
                    Arrays.fill(objectArray, 0, n, this.element);
                }
            } else {
                Arrays.fill(objectArray, 0, n, this.element);
                if (objectArray.length > n) {
                    objectArray[n] = null;
                }
            }
            return objectArray;
        }

        @Override
        public List<E> subList(int n, int n2) {
            if (n < 0) {
                throw new IndexOutOfBoundsException("fromIndex = " + n);
            }
            if (n2 > this.n) {
                throw new IndexOutOfBoundsException("toIndex = " + n2);
            }
            if (n > n2) {
                throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
            }
            return new CopiesList<E>(n2 - n, this.element);
        }

        @Override
        public Stream<E> stream() {
            return IntStream.range(0, this.n).mapToObj(n -> this.element);
        }

        @Override
        public Stream<E> parallelStream() {
            return IntStream.range(0, this.n).parallel().mapToObj(n -> this.element);
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.stream().spliterator();
        }
    }

    private static class SingletonMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = -6979724477215052911L;
        private final K k;
        private final V v;
        private transient Set<K> keySet;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient Collection<V> values;

        SingletonMap(K k, V v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object object) {
            return Collections.eq(object, this.k);
        }

        @Override
        public boolean containsValue(Object object) {
            return Collections.eq(object, this.v);
        }

        @Override
        public V get(Object object) {
            return Collections.eq(object, this.k) ? (V)this.v : null;
        }

        @Override
        public Set<K> keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.singleton(this.k);
            }
            return this.keySet;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = Collections.singleton(new AbstractMap.SimpleImmutableEntry<K, V>(this.k, this.v));
            }
            return this.entrySet;
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = Collections.singleton(this.v);
            }
            return this.values;
        }

        @Override
        public V getOrDefault(Object object, V v) {
            return Collections.eq(object, this.k) ? this.v : v;
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
            biConsumer.accept(this.k, this.v);
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V putIfAbsent(K k, V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean replace(K k, V v, V v2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V replace(K k, V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
            throw new UnsupportedOperationException();
        }
    }

    private static class SingletonList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 3093736618740652951L;
        private final E element;

        SingletonList(E e) {
            this.element = e;
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.singletonIterator(this.element);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object object) {
            return Collections.eq(object, this.element);
        }

        @Override
        public E get(int n) {
            if (n != 0) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size: 1");
            }
            return this.element;
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            consumer.accept(this.element);
        }

        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<E> unaryOperator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super E> comparator) {
        }

        @Override
        public Spliterator<E> spliterator() {
            return Collections.singletonSpliterator(this.element);
        }
    }

    private static class SingletonSet<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = 3193687207550431679L;
        private final E element;

        SingletonSet(E e) {
            this.element = e;
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.singletonIterator(this.element);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object object) {
            return Collections.eq(object, this.element);
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            consumer.accept(this.element);
        }

        @Override
        public Spliterator<E> spliterator() {
            return Collections.singletonSpliterator(this.element);
        }

        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            throw new UnsupportedOperationException();
        }
    }

    private static class EmptyMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 6428348081105594320L;

        private EmptyMap() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object object) {
            return false;
        }

        @Override
        public boolean containsValue(Object object) {
            return false;
        }

        @Override
        public V get(Object object) {
            return null;
        }

        @Override
        public Set<K> keySet() {
            return Collections.emptySet();
        }

        @Override
        public Collection<V> values() {
            return Collections.emptySet();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Map && ((Map)object).isEmpty();
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public V getOrDefault(Object object, V v) {
            return v;
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
            Objects.requireNonNull(biConsumer);
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
            Objects.requireNonNull(biFunction);
        }

        @Override
        public V putIfAbsent(K k, V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean replace(K k, V v, V v2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V replace(K k, V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
            throw new UnsupportedOperationException();
        }

        private Object readResolve() {
            return EMPTY_MAP;
        }
    }

    private static class EmptyList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 8842843931221139166L;

        private EmptyList() {
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public ListIterator<E> listIterator() {
            return Collections.emptyListIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return collection.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            if (TArray.length > 0) {
                TArray[0] = null;
            }
            return TArray;
        }

        @Override
        public E get(int n) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof List && ((List)object).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            Objects.requireNonNull(predicate);
            return false;
        }

        @Override
        public void replaceAll(UnaryOperator<E> unaryOperator) {
            Objects.requireNonNull(unaryOperator);
        }

        @Override
        public void sort(Comparator<? super E> comparator) {
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            Objects.requireNonNull(consumer);
        }

        @Override
        public Spliterator<E> spliterator() {
            return Spliterators.emptySpliterator();
        }

        private Object readResolve() {
            return EMPTY_LIST;
        }
    }

    private static class EmptySet<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = 1582296315990362920L;

        private EmptySet() {
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return collection.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            if (TArray.length > 0) {
                TArray[0] = null;
            }
            return TArray;
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            Objects.requireNonNull(consumer);
        }

        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            Objects.requireNonNull(predicate);
            return false;
        }

        @Override
        public Spliterator<E> spliterator() {
            return Spliterators.emptySpliterator();
        }

        private Object readResolve() {
            return EMPTY_SET;
        }
    }

    private static class EmptyEnumeration<E>
    implements Enumeration<E> {
        static final EmptyEnumeration<Object> EMPTY_ENUMERATION = new EmptyEnumeration();

        private EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public E nextElement() {
            throw new NoSuchElementException();
        }
    }

    private static class EmptyListIterator<E>
    extends EmptyIterator<E>
    implements ListIterator<E> {
        static final EmptyListIterator<Object> EMPTY_ITERATOR = new EmptyListIterator();

        private EmptyListIterator() {
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public E previous() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public void set(E e) {
            throw new IllegalStateException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }

    private static class EmptyIterator<E>
    implements Iterator<E> {
        static final EmptyIterator<Object> EMPTY_ITERATOR = new EmptyIterator();

        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            Objects.requireNonNull(consumer);
        }
    }

    static class CheckedNavigableMap<K, V>
    extends CheckedSortedMap<K, V>
    implements NavigableMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -4852462692372534096L;
        private final NavigableMap<K, V> nm;

        CheckedNavigableMap(NavigableMap<K, V> navigableMap, Class<K> clazz, Class<V> clazz2) {
            super(navigableMap, clazz, clazz2);
            this.nm = navigableMap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.nm.comparator();
        }

        @Override
        public K firstKey() {
            return this.nm.firstKey();
        }

        @Override
        public K lastKey() {
            return this.nm.lastKey();
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K k) {
            Map.Entry<K, V> entry = this.nm.lowerEntry(k);
            return null != entry ? new CheckedMap.CheckedEntrySet.CheckedEntry(entry, this.valueType) : null;
        }

        @Override
        public K lowerKey(K k) {
            return this.nm.lowerKey(k);
        }

        @Override
        public Map.Entry<K, V> floorEntry(K k) {
            Map.Entry<K, V> entry = this.nm.floorEntry(k);
            return null != entry ? new CheckedMap.CheckedEntrySet.CheckedEntry(entry, this.valueType) : null;
        }

        @Override
        public K floorKey(K k) {
            return this.nm.floorKey(k);
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K k) {
            Map.Entry<K, V> entry = this.nm.ceilingEntry(k);
            return null != entry ? new CheckedMap.CheckedEntrySet.CheckedEntry(entry, this.valueType) : null;
        }

        @Override
        public K ceilingKey(K k) {
            return this.nm.ceilingKey(k);
        }

        @Override
        public Map.Entry<K, V> higherEntry(K k) {
            Map.Entry<K, V> entry = this.nm.higherEntry(k);
            return null != entry ? new CheckedMap.CheckedEntrySet.CheckedEntry(entry, this.valueType) : null;
        }

        @Override
        public K higherKey(K k) {
            return this.nm.higherKey(k);
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            Map.Entry<K, V> entry = this.nm.firstEntry();
            return null != entry ? new CheckedMap.CheckedEntrySet.CheckedEntry(entry, this.valueType) : null;
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            Map.Entry<K, V> entry = this.nm.lastEntry();
            return null != entry ? new CheckedMap.CheckedEntrySet.CheckedEntry(entry, this.valueType) : null;
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Map.Entry<K, V> entry = this.nm.pollFirstEntry();
            return null == entry ? null : new CheckedMap.CheckedEntrySet.CheckedEntry(entry, this.valueType);
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Map.Entry<K, V> entry = this.nm.pollLastEntry();
            return null == entry ? null : new CheckedMap.CheckedEntrySet.CheckedEntry(entry, this.valueType);
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            return Collections.checkedNavigableMap(this.nm.descendingMap(), this.keyType, this.valueType);
        }

        @Override
        public NavigableSet<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return Collections.checkedNavigableSet(this.nm.navigableKeySet(), this.keyType);
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return Collections.checkedNavigableSet(this.nm.descendingKeySet(), this.keyType);
        }

        @Override
        public NavigableMap<K, V> subMap(K k, K k2) {
            return Collections.checkedNavigableMap(this.nm.subMap(k, true, k2, false), this.keyType, this.valueType);
        }

        @Override
        public NavigableMap<K, V> headMap(K k) {
            return Collections.checkedNavigableMap(this.nm.headMap(k, false), this.keyType, this.valueType);
        }

        @Override
        public NavigableMap<K, V> tailMap(K k) {
            return Collections.checkedNavigableMap(this.nm.tailMap(k, true), this.keyType, this.valueType);
        }

        @Override
        public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            return Collections.checkedNavigableMap(this.nm.subMap(k, bl, k2, bl2), this.keyType, this.valueType);
        }

        @Override
        public NavigableMap<K, V> headMap(K k, boolean bl) {
            return Collections.checkedNavigableMap(this.nm.headMap(k, bl), this.keyType, this.valueType);
        }

        @Override
        public NavigableMap<K, V> tailMap(K k, boolean bl) {
            return Collections.checkedNavigableMap(this.nm.tailMap(k, bl), this.keyType, this.valueType);
        }
    }

    static class CheckedSortedMap<K, V>
    extends CheckedMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 1599671320688067438L;
        private final SortedMap<K, V> sm;

        CheckedSortedMap(SortedMap<K, V> sortedMap, Class<K> clazz, Class<V> clazz2) {
            super(sortedMap, clazz, clazz2);
            this.sm = sortedMap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sm.comparator();
        }

        @Override
        public K firstKey() {
            return this.sm.firstKey();
        }

        @Override
        public K lastKey() {
            return this.sm.lastKey();
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            return Collections.checkedSortedMap(this.sm.subMap(k, k2), this.keyType, this.valueType);
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            return Collections.checkedSortedMap(this.sm.headMap(k), this.keyType, this.valueType);
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            return Collections.checkedSortedMap(this.sm.tailMap(k), this.keyType, this.valueType);
        }
    }

    private static class CheckedMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = 5742860141034234728L;
        private final Map<K, V> m;
        final Class<K> keyType;
        final Class<V> valueType;
        private transient Set<Map.Entry<K, V>> entrySet;

        private void typeCheck(Object object, Object object2) {
            if (object != null && !this.keyType.isInstance(object)) {
                throw new ClassCastException(this.badKeyMsg(object));
            }
            if (object2 != null && !this.valueType.isInstance(object2)) {
                throw new ClassCastException(this.badValueMsg(object2));
            }
        }

        private BiFunction<? super K, ? super V, ? extends V> typeCheck(BiFunction<? super K, ? super V, ? extends V> biFunction) {
            Objects.requireNonNull(biFunction);
            return (object, object2) -> {
                Object r = biFunction.apply((K)object, (V)object2);
                this.typeCheck(object, r);
                return r;
            };
        }

        private String badKeyMsg(Object object) {
            return "Attempt to insert " + object.getClass() + " key into map with key type " + this.keyType;
        }

        private String badValueMsg(Object object) {
            return "Attempt to insert " + object.getClass() + " value into map with value type " + this.valueType;
        }

        CheckedMap(Map<K, V> map, Class<K> clazz, Class<V> clazz2) {
            this.m = Objects.requireNonNull(map);
            this.keyType = Objects.requireNonNull(clazz);
            this.valueType = Objects.requireNonNull(clazz2);
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.m.containsValue(object);
        }

        @Override
        public V get(Object object) {
            return this.m.get(object);
        }

        @Override
        public V remove(Object object) {
            return this.m.remove(object);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.m.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.m.values();
        }

        @Override
        public boolean equals(Object object) {
            return object == this || this.m.equals(object);
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        public String toString() {
            return this.m.toString();
        }

        @Override
        public V put(K k, V v) {
            this.typeCheck(k, v);
            return this.m.put(k, v);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Object[] objectArray = map.entrySet().toArray();
            ArrayList arrayList = new ArrayList(objectArray.length);
            for (Object object : objectArray) {
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                Object v = entry.getValue();
                this.typeCheck(k, v);
                arrayList.add(new AbstractMap.SimpleImmutableEntry(k, v));
            }
            for (Map.Entry entry : arrayList) {
                this.m.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new CheckedEntrySet<K, V>(this.m.entrySet(), this.valueType);
            }
            return this.entrySet;
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
            this.m.forEach(biConsumer);
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
            this.m.replaceAll(this.typeCheck(biFunction));
        }

        @Override
        public V putIfAbsent(K k, V v) {
            this.typeCheck(k, v);
            return this.m.putIfAbsent(k, v);
        }

        @Override
        public boolean remove(Object object, Object object2) {
            return this.m.remove(object, object2);
        }

        @Override
        public boolean replace(K k, V v, V v2) {
            this.typeCheck(k, v2);
            return this.m.replace(k, v, v2);
        }

        @Override
        public V replace(K k, V v) {
            this.typeCheck(k, v);
            return this.m.replace(k, v);
        }

        @Override
        public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
            Objects.requireNonNull(function);
            return (V)this.m.computeIfAbsent(k, object -> {
                Object r = function.apply((K)object);
                this.typeCheck(object, r);
                return r;
            });
        }

        @Override
        public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            return this.m.computeIfPresent((K)k, this.typeCheck(biFunction));
        }

        @Override
        public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            return this.m.compute((K)k, this.typeCheck(biFunction));
        }

        @Override
        public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
            Objects.requireNonNull(biFunction);
            return (V)this.m.merge(k, v, (object, object2) -> {
                Object r = biFunction.apply((V)object, (V)object2);
                this.typeCheck(null, r);
                return r;
            });
        }

        static class CheckedEntrySet<K, V>
        implements Set<Map.Entry<K, V>> {
            private final Set<Map.Entry<K, V>> s;
            private final Class<V> valueType;

            CheckedEntrySet(Set<Map.Entry<K, V>> set, Class<V> clazz) {
                this.s = set;
                this.valueType = clazz;
            }

            @Override
            public int size() {
                return this.s.size();
            }

            @Override
            public boolean isEmpty() {
                return this.s.isEmpty();
            }

            public String toString() {
                return this.s.toString();
            }

            @Override
            public int hashCode() {
                return this.s.hashCode();
            }

            @Override
            public void clear() {
                this.s.clear();
            }

            @Override
            public boolean add(Map.Entry<K, V> entry) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator<Map.Entry<K, V>> iterator = this.s.iterator();
                final Class<V> clazz = this.valueType;
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return CheckedEntrySet.checkedEntry((Map.Entry)iterator.next(), clazz);
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] objectArray = this.s.toArray();
                Object[] objectArray2 = CheckedEntry.class.isInstance(objectArray.getClass().getComponentType()) ? objectArray : new Object[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = CheckedEntrySet.checkedEntry((Map.Entry)objectArray[i], this.valueType);
                }
                return objectArray2;
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                T[] TArray2 = this.s.toArray(TArray.length == 0 ? TArray : Arrays.copyOf(TArray, 0));
                for (int i = 0; i < TArray2.length; ++i) {
                    TArray2[i] = CheckedEntrySet.checkedEntry((Map.Entry)TArray2[i], this.valueType);
                }
                if (TArray2.length > TArray.length) {
                    return TArray2;
                }
                System.arraycopy(TArray2, 0, TArray, 0, TArray2.length);
                if (TArray.length > TArray2.length) {
                    TArray[TArray2.length] = null;
                }
                return TArray;
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                CheckedEntry<K, V, V> checkedEntry = (CheckedEntry<K, V, V>)object;
                return this.s.contains(checkedEntry instanceof CheckedEntry ? checkedEntry : CheckedEntrySet.checkedEntry(checkedEntry, this.valueType));
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                for (Object obj : collection) {
                    if (this.contains(obj)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                return this.s.remove(new AbstractMap.SimpleImmutableEntry((Map.Entry)object));
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                return this.batchRemove(collection, false);
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                return this.batchRemove(collection, true);
            }

            private boolean batchRemove(Collection<?> collection, boolean bl) {
                Objects.requireNonNull(collection);
                boolean bl2 = false;
                Iterator<Map.Entry<K, V>> iterator = this.iterator();
                while (iterator.hasNext()) {
                    if (collection.contains(iterator.next()) == bl) continue;
                    iterator.remove();
                    bl2 = true;
                }
                return bl2;
            }

            @Override
            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof Set)) {
                    return false;
                }
                Set set = (Set)object;
                return set.size() == this.s.size() && this.containsAll(set);
            }

            static <K, V, T> CheckedEntry<K, V, T> checkedEntry(Map.Entry<K, V> entry, Class<T> clazz) {
                return new CheckedEntry<K, V, T>(entry, clazz);
            }

            private static class CheckedEntry<K, V, T>
            implements Map.Entry<K, V> {
                private final Map.Entry<K, V> e;
                private final Class<T> valueType;

                CheckedEntry(Map.Entry<K, V> entry, Class<T> clazz) {
                    this.e = Objects.requireNonNull(entry);
                    this.valueType = Objects.requireNonNull(clazz);
                }

                @Override
                public K getKey() {
                    return this.e.getKey();
                }

                @Override
                public V getValue() {
                    return this.e.getValue();
                }

                @Override
                public int hashCode() {
                    return this.e.hashCode();
                }

                public String toString() {
                    return this.e.toString();
                }

                @Override
                public V setValue(V v) {
                    if (v != null && !this.valueType.isInstance(v)) {
                        throw new ClassCastException(this.badValueMsg(v));
                    }
                    return this.e.setValue(v);
                }

                private String badValueMsg(Object object) {
                    return "Attempt to insert " + object.getClass() + " value into map with value type " + this.valueType;
                }

                @Override
                public boolean equals(Object object) {
                    if (object == this) {
                        return true;
                    }
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    return this.e.equals(new AbstractMap.SimpleImmutableEntry((Map.Entry)object));
                }
            }
        }
    }

    static class CheckedRandomAccessList<E>
    extends CheckedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 1638200125423088369L;

        CheckedRandomAccessList(List<E> list, Class<E> clazz) {
            super(list, clazz);
        }

        @Override
        public List<E> subList(int n, int n2) {
            return new CheckedRandomAccessList(this.list.subList(n, n2), this.type);
        }
    }

    static class CheckedList<E>
    extends CheckedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = 65247728283967356L;
        final List<E> list;

        CheckedList(List<E> list, Class<E> clazz) {
            super(list, clazz);
            this.list = list;
        }

        @Override
        public boolean equals(Object object) {
            return object == this || this.list.equals(object);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public E get(int n) {
            return this.list.get(n);
        }

        @Override
        public E remove(int n) {
            return this.list.remove(n);
        }

        @Override
        public int indexOf(Object object) {
            return this.list.indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.list.lastIndexOf(object);
        }

        @Override
        public E set(int n, E e) {
            return this.list.set(n, this.typeCheck(e));
        }

        @Override
        public void add(int n, E e) {
            this.list.add(n, this.typeCheck(e));
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            return this.list.addAll(n, this.checkedCopyOf(collection));
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int n) {
            final ListIterator<E> listIterator = this.list.listIterator(n);
            return new ListIterator<E>(){

                @Override
                public boolean hasNext() {
                    return listIterator.hasNext();
                }

                @Override
                public E next() {
                    return listIterator.next();
                }

                @Override
                public boolean hasPrevious() {
                    return listIterator.hasPrevious();
                }

                @Override
                public E previous() {
                    return listIterator.previous();
                }

                @Override
                public int nextIndex() {
                    return listIterator.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return listIterator.previousIndex();
                }

                @Override
                public void remove() {
                    listIterator.remove();
                }

                @Override
                public void set(E e) {
                    listIterator.set(this.typeCheck(e));
                }

                @Override
                public void add(E e) {
                    listIterator.add(this.typeCheck(e));
                }

                @Override
                public void forEachRemaining(Consumer<? super E> consumer) {
                    listIterator.forEachRemaining(consumer);
                }
            };
        }

        @Override
        public List<E> subList(int n, int n2) {
            return new CheckedList<E>(this.list.subList(n, n2), this.type);
        }

        @Override
        public void replaceAll(UnaryOperator<E> unaryOperator) {
            Objects.requireNonNull(unaryOperator);
            this.list.replaceAll(object -> this.typeCheck(unaryOperator.apply(object)));
        }

        @Override
        public void sort(Comparator<? super E> comparator) {
            this.list.sort(comparator);
        }
    }

    static class CheckedNavigableSet<E>
    extends CheckedSortedSet<E>
    implements NavigableSet<E>,
    Serializable {
        private static final long serialVersionUID = -5429120189805438922L;
        private final NavigableSet<E> ns;

        CheckedNavigableSet(NavigableSet<E> navigableSet, Class<E> clazz) {
            super(navigableSet, clazz);
            this.ns = navigableSet;
        }

        @Override
        public E lower(E e) {
            return this.ns.lower(e);
        }

        @Override
        public E floor(E e) {
            return this.ns.floor(e);
        }

        @Override
        public E ceiling(E e) {
            return this.ns.ceiling(e);
        }

        @Override
        public E higher(E e) {
            return this.ns.higher(e);
        }

        @Override
        public E pollFirst() {
            return this.ns.pollFirst();
        }

        @Override
        public E pollLast() {
            return this.ns.pollLast();
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return Collections.checkedNavigableSet(this.ns.descendingSet(), this.type);
        }

        @Override
        public Iterator<E> descendingIterator() {
            return Collections.checkedNavigableSet(this.ns.descendingSet(), this.type).iterator();
        }

        @Override
        public NavigableSet<E> subSet(E e, E e2) {
            return Collections.checkedNavigableSet(this.ns.subSet(e, true, e2, false), this.type);
        }

        @Override
        public NavigableSet<E> headSet(E e) {
            return Collections.checkedNavigableSet(this.ns.headSet(e, false), this.type);
        }

        @Override
        public NavigableSet<E> tailSet(E e) {
            return Collections.checkedNavigableSet(this.ns.tailSet(e, true), this.type);
        }

        @Override
        public NavigableSet<E> subSet(E e, boolean bl, E e2, boolean bl2) {
            return Collections.checkedNavigableSet(this.ns.subSet(e, bl, e2, bl2), this.type);
        }

        @Override
        public NavigableSet<E> headSet(E e, boolean bl) {
            return Collections.checkedNavigableSet(this.ns.headSet(e, bl), this.type);
        }

        @Override
        public NavigableSet<E> tailSet(E e, boolean bl) {
            return Collections.checkedNavigableSet(this.ns.tailSet(e, bl), this.type);
        }
    }

    static class CheckedSortedSet<E>
    extends CheckedSet<E>
    implements SortedSet<E>,
    Serializable {
        private static final long serialVersionUID = 1599911165492914959L;
        private final SortedSet<E> ss;

        CheckedSortedSet(SortedSet<E> sortedSet, Class<E> clazz) {
            super(sortedSet, clazz);
            this.ss = sortedSet;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.ss.comparator();
        }

        @Override
        public E first() {
            return this.ss.first();
        }

        @Override
        public E last() {
            return this.ss.last();
        }

        @Override
        public SortedSet<E> subSet(E e, E e2) {
            return Collections.checkedSortedSet(this.ss.subSet(e, e2), this.type);
        }

        @Override
        public SortedSet<E> headSet(E e) {
            return Collections.checkedSortedSet(this.ss.headSet(e), this.type);
        }

        @Override
        public SortedSet<E> tailSet(E e) {
            return Collections.checkedSortedSet(this.ss.tailSet(e), this.type);
        }
    }

    static class CheckedSet<E>
    extends CheckedCollection<E>
    implements Set<E>,
    Serializable {
        private static final long serialVersionUID = 4694047833775013803L;

        CheckedSet(Set<E> set, Class<E> clazz) {
            super(set, clazz);
        }

        @Override
        public boolean equals(Object object) {
            return object == this || this.c.equals(object);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }
    }

    static class CheckedQueue<E>
    extends CheckedCollection<E>
    implements Queue<E>,
    Serializable {
        private static final long serialVersionUID = 1433151992604707767L;
        final Queue<E> queue;

        CheckedQueue(Queue<E> queue, Class<E> clazz) {
            super(queue, clazz);
            this.queue = queue;
        }

        @Override
        public E element() {
            return this.queue.element();
        }

        @Override
        public boolean equals(Object object) {
            return object == this || this.c.equals(object);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }

        @Override
        public E peek() {
            return this.queue.peek();
        }

        @Override
        public E poll() {
            return this.queue.poll();
        }

        @Override
        public E remove() {
            return this.queue.remove();
        }

        @Override
        public boolean offer(E e) {
            return this.queue.offer(this.typeCheck(e));
        }
    }

    static class CheckedCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 1578914078182001775L;
        final Collection<E> c;
        final Class<E> type;
        private E[] zeroLengthElementArray;

        E typeCheck(Object object) {
            if (object != null && !this.type.isInstance(object)) {
                throw new ClassCastException(this.badElementMsg(object));
            }
            return (E)object;
        }

        private String badElementMsg(Object object) {
            return "Attempt to insert " + object.getClass() + " element into collection with element type " + this.type;
        }

        CheckedCollection(Collection<E> collection, Class<E> clazz) {
            this.c = Objects.requireNonNull(collection, "c");
            this.type = Objects.requireNonNull(clazz, "type");
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.c.contains(object);
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.c.toArray(TArray);
        }

        public String toString() {
            return this.c.toString();
        }

        @Override
        public boolean remove(Object object) {
            return this.c.remove(object);
        }

        @Override
        public void clear() {
            this.c.clear();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.c.containsAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.c.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.c.retainAll(collection);
        }

        @Override
        public Iterator<E> iterator() {
            final Iterator<E> iterator = this.c.iterator();
            return new Iterator<E>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public E next() {
                    return iterator.next();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }

        @Override
        public boolean add(E e) {
            return this.c.add(this.typeCheck(e));
        }

        private E[] zeroLengthElementArray() {
            return this.zeroLengthElementArray != null ? this.zeroLengthElementArray : (this.zeroLengthElementArray = Collections.zeroLengthArray(this.type));
        }

        Collection<E> checkedCopyOf(Collection<? extends E> collection) {
            Object[] objectArray;
            block3: {
                try {
                    E[] EArray = this.zeroLengthElementArray();
                    objectArray = collection.toArray(EArray);
                    if (objectArray.getClass() == EArray.getClass()) break block3;
                    objectArray = Arrays.copyOf(objectArray, objectArray.length, EArray.getClass());
                }
                catch (ArrayStoreException arrayStoreException) {
                    objectArray = (Object[])collection.toArray().clone();
                    for (E e : objectArray) {
                        this.typeCheck(e);
                    }
                }
            }
            return Arrays.asList(objectArray);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            return this.c.addAll(this.checkedCopyOf(collection));
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            this.c.forEach(consumer);
        }

        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            return this.c.removeIf(predicate);
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.c.spliterator();
        }

        @Override
        public Stream<E> stream() {
            return this.c.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.c.parallelStream();
        }
    }

    static class SynchronizedNavigableMap<K, V>
    extends SynchronizedSortedMap<K, V>
    implements NavigableMap<K, V> {
        private static final long serialVersionUID = 699392247599746807L;
        private final NavigableMap<K, V> nm;

        SynchronizedNavigableMap(NavigableMap<K, V> navigableMap) {
            super(navigableMap);
            this.nm = navigableMap;
        }

        SynchronizedNavigableMap(NavigableMap<K, V> navigableMap, Object object) {
            super(navigableMap, object);
            this.nm = navigableMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> lowerEntry(K k) {
            Object object = this.mutex;
            synchronized (object) {
                return this.nm.lowerEntry(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K lowerKey(K k) {
            Object object = this.mutex;
            synchronized (object) {
                return this.nm.lowerKey(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> floorEntry(K k) {
            Object object = this.mutex;
            synchronized (object) {
                return this.nm.floorEntry(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K floorKey(K k) {
            Object object = this.mutex;
            synchronized (object) {
                return this.nm.floorKey(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> ceilingEntry(K k) {
            Object object = this.mutex;
            synchronized (object) {
                return this.nm.ceilingEntry(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K ceilingKey(K k) {
            Object object = this.mutex;
            synchronized (object) {
                return this.nm.ceilingKey(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> higherEntry(K k) {
            Object object = this.mutex;
            synchronized (object) {
                return this.nm.higherEntry(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K higherKey(K k) {
            Object object = this.mutex;
            synchronized (object) {
                return this.nm.higherKey(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> firstEntry() {
            Object object = this.mutex;
            synchronized (object) {
                return this.nm.firstEntry();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> lastEntry() {
            Object object = this.mutex;
            synchronized (object) {
                return this.nm.lastEntry();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Object object = this.mutex;
            synchronized (object) {
                return this.nm.pollFirstEntry();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Object object = this.mutex;
            synchronized (object) {
                return this.nm.pollLastEntry();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableMap<K, V> descendingMap() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedNavigableMap<K, V>(this.nm.descendingMap(), this.mutex);
            }
        }

        @Override
        public NavigableSet<K> keySet() {
            return this.navigableKeySet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableSet<K> navigableKeySet() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedNavigableSet<K>(this.nm.navigableKeySet(), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableSet<K> descendingKeySet() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedNavigableSet<K>(this.nm.descendingKeySet(), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedNavigableMap<K, V>(this.nm.subMap(k, true, k2, false), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> headMap(K k) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedNavigableMap<K, V>(this.nm.headMap(k, false), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> tailMap(K k) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedNavigableMap<K, V>(this.nm.tailMap(k, true), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedNavigableMap<K, V>(this.nm.subMap(k, bl, k2, bl2), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableMap<K, V> headMap(K k, boolean bl) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedNavigableMap<K, V>(this.nm.headMap(k, bl), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableMap<K, V> tailMap(K k, boolean bl) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedNavigableMap<K, V>(this.nm.tailMap(k, bl), this.mutex);
            }
        }
    }

    static class SynchronizedSortedMap<K, V>
    extends SynchronizedMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = -8798146769416483793L;
        private final SortedMap<K, V> sm;

        SynchronizedSortedMap(SortedMap<K, V> sortedMap) {
            super(sortedMap);
            this.sm = sortedMap;
        }

        SynchronizedSortedMap(SortedMap<K, V> sortedMap, Object object) {
            super(sortedMap, object);
            this.sm = sortedMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super K> comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.sm.subMap(k, k2), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> headMap(K k) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.sm.headMap(k), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> tailMap(K k) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.sm.tailMap(k), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K firstKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K lastKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.lastKey();
            }
        }
    }

    private static class SynchronizedMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = 1978198479659022715L;
        private final Map<K, V> m;
        final Object mutex;
        private transient Set<K> keySet;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient Collection<V> values;

        SynchronizedMap(Map<K, V> map) {
            this.m = Objects.requireNonNull(map);
            this.mutex = this;
        }

        SynchronizedMap(Map<K, V> map, Object object) {
            this.m = map;
            this.mutex = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.containsKey(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.containsValue(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.get(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K k, V v) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.m.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.keySet == null) {
                    this.keySet = new SynchronizedSet<K>(this.m.keySet(), this.mutex);
                }
                return this.keySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.entrySet == null) {
                    this.entrySet = new SynchronizedSet<Map.Entry<K, V>>(this.m.entrySet(), this.mutex);
                }
                return this.entrySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.values == null) {
                    this.values = new SynchronizedCollection<V>(this.m.values(), this.mutex);
                }
                return this.values;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V getOrDefault(Object object, V v) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.getOrDefault(object, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.forEach(biConsumer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.replaceAll(biFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V putIfAbsent(K k, V v) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.putIfAbsent(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object, Object object2) {
            Object object3 = this.mutex;
            synchronized (object3) {
                return this.m.remove(object, object2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean replace(K k, V v, V v2) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.replace(k, v, v2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V replace(K k, V v) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.replace(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.computeIfAbsent((K)k, function);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.computeIfPresent((K)k, (BiFunction<? super K, ? extends V, ? extends V>)biFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.compute((K)k, (BiFunction<? super K, ? extends V, ? extends V>)biFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.merge(k, (V)v, (BiFunction<? extends V, ? extends V, ? extends V>)biFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                objectOutputStream.defaultWriteObject();
            }
        }
    }

    static class SynchronizedRandomAccessList<E>
    extends SynchronizedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 1530674583602358482L;

        SynchronizedRandomAccessList(List<E> list) {
            super(list);
        }

        SynchronizedRandomAccessList(List<E> list, Object object) {
            super(list, object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int n, int n2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedRandomAccessList(this.list.subList(n, n2), this.mutex);
            }
        }

        private Object writeReplace() {
            return new SynchronizedList(this.list);
        }
    }

    static class SynchronizedList<E>
    extends SynchronizedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = -7754090372962971524L;
        final List<E> list;

        SynchronizedList(List<E> list) {
            super(list);
            this.list = list;
        }

        SynchronizedList(List<E> list, Object object) {
            super(list, object);
            this.list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.list.equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int n) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.get(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int n, E e) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.set(n, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int n, E e) {
            Object object = this.mutex;
            synchronized (object) {
                this.list.add(n, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int n) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.remove(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.list.indexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.list.lastIndexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.addAll(n, collection);
            }
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.list.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int n) {
            return this.list.listIterator(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int n, int n2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedList<E>(this.list.subList(n, n2), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replaceAll(UnaryOperator<E> unaryOperator) {
            Object object = this.mutex;
            synchronized (object) {
                this.list.replaceAll(unaryOperator);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator<? super E> comparator) {
            Object object = this.mutex;
            synchronized (object) {
                this.list.sort(comparator);
            }
        }

        private Object readResolve() {
            return this.list instanceof RandomAccess ? new SynchronizedRandomAccessList<E>(this.list) : this;
        }
    }

    static class SynchronizedNavigableSet<E>
    extends SynchronizedSortedSet<E>
    implements NavigableSet<E> {
        private static final long serialVersionUID = -5505529816273629798L;
        private final NavigableSet<E> ns;

        SynchronizedNavigableSet(NavigableSet<E> navigableSet) {
            super(navigableSet);
            this.ns = navigableSet;
        }

        SynchronizedNavigableSet(NavigableSet<E> navigableSet, Object object) {
            super(navigableSet, object);
            this.ns = navigableSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E lower(E e) {
            Object object = this.mutex;
            synchronized (object) {
                return this.ns.lower(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E floor(E e) {
            Object object = this.mutex;
            synchronized (object) {
                return this.ns.floor(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E ceiling(E e) {
            Object object = this.mutex;
            synchronized (object) {
                return this.ns.ceiling(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E higher(E e) {
            Object object = this.mutex;
            synchronized (object) {
                return this.ns.higher(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E pollFirst() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ns.pollFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E pollLast() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ns.pollLast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableSet<E> descendingSet() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedNavigableSet<E>(this.ns.descendingSet(), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<E> descendingIterator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.descendingSet().iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableSet<E> subSet(E e, E e2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedNavigableSet<E>(this.ns.subSet(e, true, e2, false), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableSet<E> headSet(E e) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedNavigableSet<E>(this.ns.headSet(e, false), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableSet<E> tailSet(E e) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedNavigableSet<E>(this.ns.tailSet(e, true), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableSet<E> subSet(E e, boolean bl, E e2, boolean bl2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedNavigableSet<E>(this.ns.subSet(e, bl, e2, bl2), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableSet<E> headSet(E e, boolean bl) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedNavigableSet<E>(this.ns.headSet(e, bl), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NavigableSet<E> tailSet(E e, boolean bl) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedNavigableSet<E>(this.ns.tailSet(e, bl), this.mutex);
            }
        }
    }

    static class SynchronizedSortedSet<E>
    extends SynchronizedSet<E>
    implements SortedSet<E> {
        private static final long serialVersionUID = 8695801310862127406L;
        private final SortedSet<E> ss;

        SynchronizedSortedSet(SortedSet<E> sortedSet) {
            super(sortedSet);
            this.ss = sortedSet;
        }

        SynchronizedSortedSet(SortedSet<E> sortedSet, Object object) {
            super(sortedSet, object);
            this.ss = sortedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super E> comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> subSet(E e, E e2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<E>(this.ss.subSet(e, e2), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> headSet(E e) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<E>(this.ss.headSet(e), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> tailSet(E e) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<E>(this.ss.tailSet(e), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E first() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E last() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.last();
            }
        }
    }

    static class SynchronizedSet<E>
    extends SynchronizedCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = 487447009682186044L;

        SynchronizedSet(Set<E> set) {
            super(set);
        }

        SynchronizedSet(Set<E> set, Object object) {
            super(set, object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.hashCode();
            }
        }
    }

    static class SynchronizedCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        final Collection<E> c;
        final Object mutex;

        SynchronizedCollection(Collection<E> collection) {
            this.c = Objects.requireNonNull(collection);
            this.mutex = this;
        }

        SynchronizedCollection(Collection<E> collection, Object object) {
            this.c = Objects.requireNonNull(collection);
            this.mutex = Objects.requireNonNull(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.contains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] TArray) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray(TArray);
            }
        }

        @Override
        public Iterator<E> iterator() {
            return this.c.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E e) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.add(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.c.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEach(Consumer<? super E> consumer) {
            Object object = this.mutex;
            synchronized (object) {
                this.c.forEach(consumer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeIf(predicate);
            }
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.c.spliterator();
        }

        @Override
        public Stream<E> stream() {
            return this.c.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.c.parallelStream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                objectOutputStream.defaultWriteObject();
            }
        }
    }

    static class UnmodifiableNavigableMap<K, V>
    extends UnmodifiableSortedMap<K, V>
    implements NavigableMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -4858195264774772197L;
        private static final EmptyNavigableMap<?, ?> EMPTY_NAVIGABLE_MAP = new EmptyNavigableMap();
        private final NavigableMap<K, ? extends V> nm;

        UnmodifiableNavigableMap(NavigableMap<K, ? extends V> navigableMap) {
            super(navigableMap);
            this.nm = navigableMap;
        }

        @Override
        public K lowerKey(K k) {
            return this.nm.lowerKey(k);
        }

        @Override
        public K floorKey(K k) {
            return this.nm.floorKey(k);
        }

        @Override
        public K ceilingKey(K k) {
            return this.nm.ceilingKey(k);
        }

        @Override
        public K higherKey(K k) {
            return this.nm.higherKey(k);
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K k) {
            Map.Entry<K, ? extends V> entry = this.nm.lowerEntry(k);
            return null != entry ? new UnmodifiableMap.UnmodifiableEntrySet.UnmodifiableEntry<K, V>(entry) : null;
        }

        @Override
        public Map.Entry<K, V> floorEntry(K k) {
            Map.Entry<K, ? extends V> entry = this.nm.floorEntry(k);
            return null != entry ? new UnmodifiableMap.UnmodifiableEntrySet.UnmodifiableEntry<K, V>(entry) : null;
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K k) {
            Map.Entry<K, ? extends V> entry = this.nm.ceilingEntry(k);
            return null != entry ? new UnmodifiableMap.UnmodifiableEntrySet.UnmodifiableEntry<K, V>(entry) : null;
        }

        @Override
        public Map.Entry<K, V> higherEntry(K k) {
            Map.Entry<K, ? extends V> entry = this.nm.higherEntry(k);
            return null != entry ? new UnmodifiableMap.UnmodifiableEntrySet.UnmodifiableEntry<K, V>(entry) : null;
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            Map.Entry<K, ? extends V> entry = this.nm.firstEntry();
            return null != entry ? new UnmodifiableMap.UnmodifiableEntrySet.UnmodifiableEntry<K, V>(entry) : null;
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            Map.Entry<K, ? extends V> entry = this.nm.lastEntry();
            return null != entry ? new UnmodifiableMap.UnmodifiableEntrySet.UnmodifiableEntry<K, V>(entry) : null;
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            return Collections.unmodifiableNavigableMap(this.nm.descendingMap());
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return Collections.unmodifiableNavigableSet(this.nm.navigableKeySet());
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return Collections.unmodifiableNavigableSet(this.nm.descendingKeySet());
        }

        @Override
        public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            return Collections.unmodifiableNavigableMap(this.nm.subMap(k, bl, k2, bl2));
        }

        @Override
        public NavigableMap<K, V> headMap(K k, boolean bl) {
            return Collections.unmodifiableNavigableMap(this.nm.headMap(k, bl));
        }

        @Override
        public NavigableMap<K, V> tailMap(K k, boolean bl) {
            return Collections.unmodifiableNavigableMap(this.nm.tailMap(k, bl));
        }

        private static class EmptyNavigableMap<K, V>
        extends UnmodifiableNavigableMap<K, V>
        implements Serializable {
            private static final long serialVersionUID = -2239321462712562324L;

            EmptyNavigableMap() {
                super(new TreeMap());
            }

            @Override
            public NavigableSet<K> navigableKeySet() {
                return Collections.emptyNavigableSet();
            }

            private Object readResolve() {
                return EMPTY_NAVIGABLE_MAP;
            }
        }
    }

    static class UnmodifiableSortedMap<K, V>
    extends UnmodifiableMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -8806743815996713206L;
        private final SortedMap<K, ? extends V> sm;

        UnmodifiableSortedMap(SortedMap<K, ? extends V> sortedMap) {
            super(sortedMap);
            this.sm = sortedMap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sm.comparator();
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            return new UnmodifiableSortedMap<K, V>(this.sm.subMap(k, k2));
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            return new UnmodifiableSortedMap<K, V>(this.sm.headMap(k));
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            return new UnmodifiableSortedMap<K, V>(this.sm.tailMap(k));
        }

        @Override
        public K firstKey() {
            return this.sm.firstKey();
        }

        @Override
        public K lastKey() {
            return this.sm.lastKey();
        }
    }

    private static class UnmodifiableMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        private final Map<? extends K, ? extends V> m;
        private transient Set<K> keySet;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient Collection<V> values;

        UnmodifiableMap(Map<? extends K, ? extends V> map) {
            if (map == null) {
                throw new NullPointerException();
            }
            this.m = map;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.m.containsValue(object);
        }

        @Override
        public V get(Object object) {
            return this.m.get(object);
        }

        @Override
        public V put(K k, V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<K> keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.unmodifiableSet(this.m.keySet());
            }
            return this.keySet;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new UnmodifiableEntrySet<K, V>(this.m.entrySet());
            }
            return this.entrySet;
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = Collections.unmodifiableCollection(this.m.values());
            }
            return this.values;
        }

        @Override
        public boolean equals(Object object) {
            return object == this || this.m.equals(object);
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        public String toString() {
            return this.m.toString();
        }

        @Override
        public V getOrDefault(Object object, V v) {
            return this.m.getOrDefault(object, v);
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
            this.m.forEach(biConsumer);
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V putIfAbsent(K k, V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean replace(K k, V v, V v2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V replace(K k, V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
            throw new UnsupportedOperationException();
        }

        static class UnmodifiableEntrySet<K, V>
        extends UnmodifiableSet<Map.Entry<K, V>> {
            private static final long serialVersionUID = 7854390611657943733L;

            UnmodifiableEntrySet(Set<? extends Map.Entry<? extends K, ? extends V>> set) {
                super(set);
            }

            static <K, V> Consumer<Map.Entry<K, V>> entryConsumer(Consumer<? super Map.Entry<K, V>> consumer) {
                return entry -> consumer.accept(new UnmodifiableEntry(entry));
            }

            @Override
            public void forEach(Consumer<? super Map.Entry<K, V>> consumer) {
                Objects.requireNonNull(consumer);
                this.c.forEach(UnmodifiableEntrySet.entryConsumer(consumer));
            }

            @Override
            public Spliterator<Map.Entry<K, V>> spliterator() {
                return new UnmodifiableEntrySetSpliterator(this.c.spliterator());
            }

            @Override
            public Stream<Map.Entry<K, V>> stream() {
                return StreamSupport.stream(this.spliterator(), false);
            }

            @Override
            public Stream<Map.Entry<K, V>> parallelStream() {
                return StreamSupport.stream(this.spliterator(), true);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<? extends Map.Entry<? extends K, ? extends V>> i;
                    {
                        this.i = c.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return new UnmodifiableEntry(this.i.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] objectArray = this.c.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = new UnmodifiableEntry((Map.Entry)objectArray[i]);
                }
                return objectArray;
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                T[] TArray2 = this.c.toArray(TArray.length == 0 ? TArray : Arrays.copyOf(TArray, 0));
                for (int i = 0; i < TArray2.length; ++i) {
                    TArray2[i] = new UnmodifiableEntry((Map.Entry)TArray2[i]);
                }
                if (TArray2.length > TArray.length) {
                    return TArray2;
                }
                System.arraycopy(TArray2, 0, TArray, 0, TArray2.length);
                if (TArray.length > TArray2.length) {
                    TArray[TArray2.length] = null;
                }
                return TArray;
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                return this.c.contains(new UnmodifiableEntry((Map.Entry)object));
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                for (Object obj : collection) {
                    if (this.contains(obj)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof Set)) {
                    return false;
                }
                Set set = (Set)object;
                if (set.size() != this.c.size()) {
                    return false;
                }
                return this.containsAll(set);
            }

            private static class UnmodifiableEntry<K, V>
            implements Map.Entry<K, V> {
                private Map.Entry<? extends K, ? extends V> e;

                UnmodifiableEntry(Map.Entry<? extends K, ? extends V> entry) {
                    this.e = Objects.requireNonNull(entry);
                }

                @Override
                public K getKey() {
                    return this.e.getKey();
                }

                @Override
                public V getValue() {
                    return this.e.getValue();
                }

                @Override
                public V setValue(V v) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int hashCode() {
                    return this.e.hashCode();
                }

                @Override
                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    return Collections.eq(this.e.getKey(), entry.getKey()) && Collections.eq(this.e.getValue(), entry.getValue());
                }

                public String toString() {
                    return this.e.toString();
                }
            }

            static final class UnmodifiableEntrySetSpliterator<K, V>
            implements Spliterator<Map.Entry<K, V>> {
                final Spliterator<Map.Entry<K, V>> s;

                UnmodifiableEntrySetSpliterator(Spliterator<Map.Entry<K, V>> spliterator) {
                    this.s = spliterator;
                }

                @Override
                public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> consumer) {
                    Objects.requireNonNull(consumer);
                    return this.s.tryAdvance(UnmodifiableEntrySet.entryConsumer(consumer));
                }

                @Override
                public void forEachRemaining(Consumer<? super Map.Entry<K, V>> consumer) {
                    Objects.requireNonNull(consumer);
                    this.s.forEachRemaining(UnmodifiableEntrySet.entryConsumer(consumer));
                }

                @Override
                public Spliterator<Map.Entry<K, V>> trySplit() {
                    Spliterator<Map.Entry<K, V>> spliterator = this.s.trySplit();
                    return spliterator == null ? null : new UnmodifiableEntrySetSpliterator<K, V>(spliterator);
                }

                @Override
                public long estimateSize() {
                    return this.s.estimateSize();
                }

                @Override
                public long getExactSizeIfKnown() {
                    return this.s.getExactSizeIfKnown();
                }

                @Override
                public int characteristics() {
                    return this.s.characteristics();
                }

                @Override
                public boolean hasCharacteristics(int n) {
                    return this.s.hasCharacteristics(n);
                }

                @Override
                public Comparator<? super Map.Entry<K, V>> getComparator() {
                    return this.s.getComparator();
                }
            }
        }
    }

    static class UnmodifiableRandomAccessList<E>
    extends UnmodifiableList<E>
    implements RandomAccess {
        private static final long serialVersionUID = -2542308836966382001L;

        UnmodifiableRandomAccessList(List<? extends E> list) {
            super(list);
        }

        @Override
        public List<E> subList(int n, int n2) {
            return new UnmodifiableRandomAccessList(this.list.subList(n, n2));
        }

        private Object writeReplace() {
            return new UnmodifiableList(this.list);
        }
    }

    static class UnmodifiableList<E>
    extends UnmodifiableCollection<E>
    implements List<E> {
        private static final long serialVersionUID = -283967356065247728L;
        final List<? extends E> list;

        UnmodifiableList(List<? extends E> list) {
            super(list);
            this.list = list;
        }

        @Override
        public boolean equals(Object object) {
            return object == this || this.list.equals(object);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public E get(int n) {
            return this.list.get(n);
        }

        @Override
        public E set(int n, E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int n, E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E remove(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object object) {
            return this.list.indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.list.lastIndexOf(object);
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<E> unaryOperator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super E> comparator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(final int n) {
            return new ListIterator<E>(){
                private final ListIterator<? extends E> i;
                {
                    this.i = list.listIterator(n);
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public boolean hasPrevious() {
                    return this.i.hasPrevious();
                }

                @Override
                public E previous() {
                    return this.i.previous();
                }

                @Override
                public int nextIndex() {
                    return this.i.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.i.previousIndex();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(E e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(E e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> consumer) {
                    this.i.forEachRemaining(consumer);
                }
            };
        }

        @Override
        public List<E> subList(int n, int n2) {
            return new UnmodifiableList<E>(this.list.subList(n, n2));
        }

        private Object readResolve() {
            return this.list instanceof RandomAccess ? new UnmodifiableRandomAccessList<E>(this.list) : this;
        }
    }

    static class UnmodifiableNavigableSet<E>
    extends UnmodifiableSortedSet<E>
    implements NavigableSet<E>,
    Serializable {
        private static final long serialVersionUID = -6027448201786391929L;
        private static final NavigableSet<?> EMPTY_NAVIGABLE_SET = new EmptyNavigableSet();
        private final NavigableSet<E> ns;

        UnmodifiableNavigableSet(NavigableSet<E> navigableSet) {
            super(navigableSet);
            this.ns = navigableSet;
        }

        @Override
        public E lower(E e) {
            return this.ns.lower(e);
        }

        @Override
        public E floor(E e) {
            return this.ns.floor(e);
        }

        @Override
        public E ceiling(E e) {
            return this.ns.ceiling(e);
        }

        @Override
        public E higher(E e) {
            return this.ns.higher(e);
        }

        @Override
        public E pollFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E pollLast() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new UnmodifiableNavigableSet<E>(this.ns.descendingSet());
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<E> subSet(E e, boolean bl, E e2, boolean bl2) {
            return new UnmodifiableNavigableSet<E>(this.ns.subSet(e, bl, e2, bl2));
        }

        @Override
        public NavigableSet<E> headSet(E e, boolean bl) {
            return new UnmodifiableNavigableSet<E>(this.ns.headSet(e, bl));
        }

        @Override
        public NavigableSet<E> tailSet(E e, boolean bl) {
            return new UnmodifiableNavigableSet<E>(this.ns.tailSet(e, bl));
        }

        private static class EmptyNavigableSet<E>
        extends UnmodifiableNavigableSet<E>
        implements Serializable {
            private static final long serialVersionUID = -6291252904449939134L;

            public EmptyNavigableSet() {
                super(new TreeSet());
            }

            private Object readResolve() {
                return EMPTY_NAVIGABLE_SET;
            }
        }
    }

    static class UnmodifiableSortedSet<E>
    extends UnmodifiableSet<E>
    implements SortedSet<E>,
    Serializable {
        private static final long serialVersionUID = -4929149591599911165L;
        private final SortedSet<E> ss;

        UnmodifiableSortedSet(SortedSet<E> sortedSet) {
            super(sortedSet);
            this.ss = sortedSet;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.ss.comparator();
        }

        @Override
        public SortedSet<E> subSet(E e, E e2) {
            return new UnmodifiableSortedSet<E>(this.ss.subSet(e, e2));
        }

        @Override
        public SortedSet<E> headSet(E e) {
            return new UnmodifiableSortedSet<E>(this.ss.headSet(e));
        }

        @Override
        public SortedSet<E> tailSet(E e) {
            return new UnmodifiableSortedSet<E>(this.ss.tailSet(e));
        }

        @Override
        public E first() {
            return this.ss.first();
        }

        @Override
        public E last() {
            return this.ss.last();
        }
    }

    static class UnmodifiableSet<E>
    extends UnmodifiableCollection<E>
    implements Set<E>,
    Serializable {
        private static final long serialVersionUID = -9215047833775013803L;

        UnmodifiableSet(Set<? extends E> set) {
            super(set);
        }

        @Override
        public boolean equals(Object object) {
            return object == this || this.c.equals(object);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }
    }

    static class UnmodifiableCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 1820017752578914078L;
        final Collection<? extends E> c;

        UnmodifiableCollection(Collection<? extends E> collection) {
            if (collection == null) {
                throw new NullPointerException();
            }
            this.c = collection;
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.c.contains(object);
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.c.toArray(TArray);
        }

        public String toString() {
            return this.c.toString();
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private final Iterator<? extends E> i;
                {
                    this.i = c.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> consumer) {
                    this.i.forEachRemaining(consumer);
                }
            };
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.c.containsAll(collection);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            this.c.forEach(consumer);
        }

        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.c.spliterator();
        }

        @Override
        public Stream<E> stream() {
            return this.c.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.c.parallelStream();
        }
    }
}

