/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.AESCrypt;
import com.sun.crypto.provider.CipherCore;
import com.sun.crypto.provider.PBKDF2Core;
import com.sun.crypto.provider.SunJCE;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

abstract class PBES2Core
extends CipherSpi {
    private static final int DEFAULT_SALT_LENGTH = 20;
    private static final int DEFAULT_COUNT = 4096;
    private final CipherCore cipher;
    private final int keyLength;
    private final int blkSize;
    private final PBKDF2Core kdf;
    private final String pbeAlgo;
    private final String cipherAlgo;
    private int iCount = 4096;
    private byte[] salt = null;
    private IvParameterSpec ivSpec = null;

    PBES2Core(String string, String string2, int n) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.cipherAlgo = string2;
        this.keyLength = n * 8;
        this.pbeAlgo = "PBEWith" + string + "And" + string2 + "_" + this.keyLength;
        if (string2.equals("AES")) {
            this.blkSize = 16;
            this.cipher = new CipherCore(new AESCrypt(), this.blkSize);
            switch (string) {
                case "HmacSHA1": {
                    this.kdf = new PBKDF2Core.HmacSHA1();
                    break;
                }
                case "HmacSHA224": {
                    this.kdf = new PBKDF2Core.HmacSHA224();
                    break;
                }
                case "HmacSHA256": {
                    this.kdf = new PBKDF2Core.HmacSHA256();
                    break;
                }
                case "HmacSHA384": {
                    this.kdf = new PBKDF2Core.HmacSHA384();
                    break;
                }
                case "HmacSHA512": {
                    this.kdf = new PBKDF2Core.HmacSHA512();
                    break;
                }
                default: {
                    throw new NoSuchAlgorithmException("No Cipher implementation for " + string);
                }
            }
        } else {
            throw new NoSuchAlgorithmException("No Cipher implementation for " + this.pbeAlgo);
        }
        this.cipher.setMode("CBC");
        this.cipher.setPadding("PKCS5Padding");
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (string != null && !string.equalsIgnoreCase("CBC")) {
            throw new NoSuchAlgorithmException("Invalid cipher mode: " + string);
        }
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (string != null && !string.equalsIgnoreCase("PKCS5Padding")) {
            throw new NoSuchPaddingException("Invalid padding scheme: " + string);
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return this.blkSize;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        return this.cipher.getOutputSize(n);
    }

    @Override
    protected byte[] engineGetIV() {
        return this.cipher.getIV();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        Object object;
        AlgorithmParameters algorithmParameters = null;
        if (this.salt == null) {
            this.salt = new byte[20];
            SunJCE.getRandom().nextBytes(this.salt);
            this.iCount = 4096;
        }
        if (this.ivSpec == null) {
            object = new byte[this.blkSize];
            SunJCE.getRandom().nextBytes((byte[])object);
            this.ivSpec = new IvParameterSpec((byte[])object);
        }
        object = new PBEParameterSpec(this.salt, this.iCount, this.ivSpec);
        try {
            algorithmParameters = AlgorithmParameters.getInstance(this.pbeAlgo, SunJCE.getInstance());
            algorithmParameters.init((AlgorithmParameterSpec)object);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("SunJCE called, but not configured");
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException("PBEParameterSpec not supported");
        }
        return algorithmParameters;
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            InvalidKeyException invalidKeyException = new InvalidKeyException("requires PBE parameters");
            invalidKeyException.initCause(invalidAlgorithmParameterException);
            throw invalidKeyException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null || key.getEncoded() == null || !key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3)) {
            throw new InvalidKeyException("Missing password");
        }
        if (key instanceof PBEKey) {
            this.salt = ((PBEKey)key).getSalt();
            if (this.salt != null && this.salt.length < 8) {
                throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
            }
            this.iCount = ((PBEKey)key).getIterationCount();
            if (this.iCount == 0) {
                this.iCount = 4096;
            } else if (this.iCount < 0) {
                throw new InvalidAlgorithmParameterException("Iteration count must be a positive number");
            }
        }
        if (algorithmParameterSpec == null) {
            if (this.salt == null) {
                this.salt = new byte[20];
                secureRandom.nextBytes(this.salt);
                this.iCount = 4096;
            }
            if (n == 1 || n == 3) {
                byte[] byArray = new byte[this.blkSize];
                secureRandom.nextBytes(byArray);
                this.ivSpec = new IvParameterSpec(byArray);
            }
        } else {
            if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: PBE expected");
            }
            byte[] byArray = ((PBEParameterSpec)algorithmParameterSpec).getSalt();
            if (byArray != null && byArray.length < 8) {
                throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
            }
            this.salt = byArray;
            int n2 = ((PBEParameterSpec)algorithmParameterSpec).getIterationCount();
            if (n2 == 0) {
                n2 = 4096;
            } else if (n2 < 0) {
                throw new InvalidAlgorithmParameterException("Iteration count must be a positive number");
            }
            this.iCount = n2;
            AlgorithmParameterSpec algorithmParameterSpec2 = ((PBEParameterSpec)algorithmParameterSpec).getParameterSpec();
            if (algorithmParameterSpec2 != null) {
                if (!(algorithmParameterSpec2 instanceof IvParameterSpec)) throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
                this.ivSpec = (IvParameterSpec)algorithmParameterSpec2;
            } else {
                if (n != 1 && n != 3) throw new InvalidAlgorithmParameterException("Missing parameter type: IV expected");
                byte[] byArray2 = new byte[this.blkSize];
                secureRandom.nextBytes(byArray2);
                this.ivSpec = new IvParameterSpec(byArray2);
            }
        }
        Object var5_8 = null;
        byte[] byArray = null;
        byte[] byArray3 = key.getEncoded();
        char[] cArray = new char[byArray3.length];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)(byArray3[i] & 0x7F);
        }
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray, this.salt, this.iCount, this.keyLength);
        Arrays.fill(cArray, ' ');
        Arrays.fill(byArray3, (byte)0);
        SecretKey secretKey = null;
        try {
            secretKey = this.kdf.engineGenerateSecret(pBEKeySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            InvalidKeyException invalidKeyException = new InvalidKeyException("Cannot construct PBE key");
            invalidKeyException.initCause(invalidKeySpecException);
            throw invalidKeyException;
        }
        byArray = secretKey.getEncoded();
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, this.cipherAlgo);
        this.cipher.init(n, (Key)secretKeySpec, this.ivSpec, secureRandom);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBEParameterSpec pBEParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                pBEParameterSpec = algorithmParameters.getParameterSpec(PBEParameterSpec.class);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: PBE expected");
            }
        }
        this.engineInit(n, key, pBEParameterSpec, secureRandom);
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        return this.cipher.update(byArray, n, n2);
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        return this.cipher.update(byArray, n, n2, byArray2, n3);
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(byArray, n, n2);
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(byArray, n, n2, byArray2, n3);
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return this.keyLength;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.cipher.wrap(key);
    }

    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.cipher.unwrap(byArray, string, n);
    }

    public static final class HmacSHA512AndAES_256
    extends PBES2Core {
        public HmacSHA512AndAES_256() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA512", "AES", 32);
        }
    }

    public static final class HmacSHA384AndAES_256
    extends PBES2Core {
        public HmacSHA384AndAES_256() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA384", "AES", 32);
        }
    }

    public static final class HmacSHA256AndAES_256
    extends PBES2Core {
        public HmacSHA256AndAES_256() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA256", "AES", 32);
        }
    }

    public static final class HmacSHA224AndAES_256
    extends PBES2Core {
        public HmacSHA224AndAES_256() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA224", "AES", 32);
        }
    }

    public static final class HmacSHA1AndAES_256
    extends PBES2Core {
        public HmacSHA1AndAES_256() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA1", "AES", 32);
        }
    }

    public static final class HmacSHA512AndAES_128
    extends PBES2Core {
        public HmacSHA512AndAES_128() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA512", "AES", 16);
        }
    }

    public static final class HmacSHA384AndAES_128
    extends PBES2Core {
        public HmacSHA384AndAES_128() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA384", "AES", 16);
        }
    }

    public static final class HmacSHA256AndAES_128
    extends PBES2Core {
        public HmacSHA256AndAES_128() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA256", "AES", 16);
        }
    }

    public static final class HmacSHA224AndAES_128
    extends PBES2Core {
        public HmacSHA224AndAES_128() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA224", "AES", 16);
        }
    }

    public static final class HmacSHA1AndAES_128
    extends PBES2Core {
        public HmacSHA1AndAES_128() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSHA1", "AES", 16);
        }
    }
}

