/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.sort;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationNodeMap;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.Utils;

public class RelationSorter {
    private static final Collection<AdditionalSorter> ADDITIONAL_SORTERS = Arrays.asList(new AssociatedStreetRoleStreetSorter(), new AssociatedStreetRoleAddressHouseSorter(), new PublicTransportRoleStopPlatformSorter());

    public List<RelationMember> sortMembers(List<RelationMember> relationMembers) {
        ArrayList<RelationMember> newMembers = new ArrayList<RelationMember>();
        ArrayList<RelationMember> defaultMembers = new ArrayList<RelationMember>(relationMembers.size());
        LinkedHashMap<AdditionalSorter, List> customMap = new LinkedHashMap<AdditionalSorter, List>();
        for (RelationMember relationMember : relationMembers) {
            boolean wasAdded = false;
            for (AdditionalSorter sorter : ADDITIONAL_SORTERS) {
                if (!sorter.acceptsMember(relationMember)) continue;
                wasAdded = customMap.computeIfAbsent(sorter, k -> new LinkedList()).add(relationMember);
                break;
            }
            if (wasAdded) continue;
            defaultMembers.add(relationMember);
        }
        for (Map.Entry entry : customMap.entrySet()) {
            newMembers.addAll(((AdditionalSorter)entry.getKey()).sortMembers((List)entry.getValue()));
        }
        newMembers.addAll(RelationSorter.sortMembersByConnectivity(defaultMembers));
        return newMembers;
    }

    public static List<RelationMember> sortMembersByConnectivity(List<RelationMember> defaultMembers) {
        Integer first;
        ArrayList<RelationMember> newMembers = new ArrayList<RelationMember>();
        RelationNodeMap map = new RelationNodeMap(defaultMembers);
        ArrayList allGroups = new ArrayList();
        while ((first = map.pop()) != null) {
            LinkedList<Integer> group = new LinkedList<Integer>();
            group.add(first);
            allGroups.add(group);
            Integer next = first;
            while ((next = map.popAdjacent(next)) != null) {
                group.addLast(next);
            }
            next = first;
            while ((next = map.popAdjacent(next)) != null) {
                group.addFirst(next);
            }
        }
        for (List list : allGroups) {
            for (Integer p : list) {
                newMembers.add(defaultMembers.get(p));
            }
        }
        for (Integer n : map.getNotSortableMembers()) {
            newMembers.add(defaultMembers.get(n));
        }
        return newMembers;
    }

    private static class PublicTransportRoleStopPlatformSorter
    implements AdditionalSorter {
        private PublicTransportRoleStopPlatformSorter() {
        }

        @Override
        public boolean acceptsMember(RelationMember m) {
            return m.getRole() != null && (m.getRole().startsWith("platform") || m.getRole().startsWith("stop"));
        }

        private static String getStopName(OsmPrimitive p) {
            for (Relation ref : Utils.filteredCollection(p.getReferrers(), Relation.class)) {
                if (!ref.hasTag("type", "public_transport") || !ref.hasTag("public_transport", "stop_area") || ref.getName() == null) continue;
                return ref.getName();
            }
            return p.getName();
        }

        @Override
        public List<RelationMember> sortMembers(List<RelationMember> list) {
            HashMap<String, RelationMember> platformByName = new HashMap<String, RelationMember>();
            for (RelationMember i : list) {
                RelationMember old;
                if (!i.getRole().startsWith("platform") || (old = platformByName.put(PublicTransportRoleStopPlatformSorter.getStopName(i.getMember()), i)) == null) continue;
                return list;
            }
            ArrayList<RelationMember> sorted = new ArrayList<RelationMember>(list.size());
            for (RelationMember i : list) {
                if (!i.getRole().startsWith("stop")) continue;
                sorted.add(i);
                RelationMember platform = (RelationMember)platformByName.remove(PublicTransportRoleStopPlatformSorter.getStopName(i.getMember()));
                if (platform == null) continue;
                sorted.add(platform);
            }
            sorted.addAll(platformByName.values());
            return sorted;
        }
    }

    private static class AssociatedStreetRoleAddressHouseSorter
    implements AdditionalSorter {
        private AssociatedStreetRoleAddressHouseSorter() {
        }

        @Override
        public boolean acceptsMember(RelationMember m) {
            return "address".equals(m.getRole()) || "house".equals(m.getRole());
        }

        @Override
        public List<RelationMember> sortMembers(List<RelationMember> list) {
            list.sort((a, b) -> {
                int houseNumber = AlphanumComparator.getInstance().compare(a.getMember().get("addr:housenumber"), b.getMember().get("addr:housenumber"));
                if (houseNumber != 0) {
                    return houseNumber;
                }
                String aDisplayName = a.getMember().getDisplayName(DefaultNameFormatter.getInstance());
                String bDisplayName = b.getMember().getDisplayName(DefaultNameFormatter.getInstance());
                return AlphanumComparator.getInstance().compare(aDisplayName, bDisplayName);
            });
            return list;
        }
    }

    private static class AssociatedStreetRoleStreetSorter
    implements AdditionalSorter {
        private AssociatedStreetRoleStreetSorter() {
        }

        @Override
        public boolean acceptsMember(RelationMember m) {
            return "street".equals(m.getRole());
        }

        @Override
        public List<RelationMember> sortMembers(List<RelationMember> list) {
            return RelationSorter.sortMembersByConnectivity(list);
        }
    }

    private static interface AdditionalSorter {
        public boolean acceptsMember(RelationMember var1);

        public List<RelationMember> sortMembers(List<RelationMember> var1);
    }
}

