/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor.conversion;

import java.text.DecimalFormat;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.conversion.AbstractCoordinateFormat;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public class DMSCoordinateFormat
extends AbstractCoordinateFormat {
    private static final DecimalFormat DMS_MINUTE_FORMATTER = DMSCoordinateFormat.newUnlocalizedDecimalFormat("00");
    private static final DecimalFormat DMS_SECOND_FORMATTER = DMSCoordinateFormat.newUnlocalizedDecimalFormat(Config.getPref() == null ? "00.0" : Config.getPref().get("latlon.dms.decimal-format", "00.0"));
    private static final String DMS60 = DMS_SECOND_FORMATTER.format(60.0);
    private static final String DMS00 = DMS_SECOND_FORMATTER.format(0.0);
    public static final DMSCoordinateFormat INSTANCE = new DMSCoordinateFormat();

    protected DMSCoordinateFormat() {
        super("DEGREES_MINUTES_SECONDS", I18n.tr("deg\u00b0 min'' sec\"", new Object[0]));
    }

    @Override
    public String latToString(ILatLon ll) {
        return DMSCoordinateFormat.degreesMinutesSeconds(ll.lat()) + (ll.lat() < 0.0 ? SOUTH : NORTH);
    }

    @Override
    public String lonToString(ILatLon ll) {
        return DMSCoordinateFormat.degreesMinutesSeconds(ll.lon()) + (ll.lon() < 0.0 ? WEST : EAST);
    }

    public static String degreesMinutesSeconds(double pCoordinate) {
        double tAbsCoord = Math.abs(pCoordinate);
        int tDegree = (int)tAbsCoord;
        double tTmpMinutes = (tAbsCoord - (double)tDegree) * 60.0;
        int tMinutes = (int)tTmpMinutes;
        double tSeconds = (tTmpMinutes - (double)tMinutes) * 60.0;
        String sDegrees = Integer.toString(tDegree);
        String sMinutes = DMS_MINUTE_FORMATTER.format(tMinutes);
        String sSeconds = DMS_SECOND_FORMATTER.format(tSeconds);
        if (DMS60.equals(sSeconds)) {
            sSeconds = DMS00;
            sMinutes = DMS_MINUTE_FORMATTER.format((long)tMinutes + 1L);
        }
        if ("60".equals(sMinutes)) {
            sMinutes = "00";
            sDegrees = Integer.toString(tDegree + 1);
        }
        return sDegrees + '\u00b0' + sMinutes + '\'' + sSeconds + '\"';
    }
}

