/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.List;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.constant.ConstantClass;
import jd.core.model.classfile.constant.ConstantFieldref;
import jd.core.model.classfile.constant.ConstantMethodref;
import jd.core.model.classfile.constant.ConstantNameAndType;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.LoadInstruction;
import jd.core.model.instruction.bytecode.instruction.LookupSwitch;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TableSwitch;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;
import jd.core.util.SignatureUtil;

public class AddCheckCastVisitor {
    private ConstantPool constants;
    private LocalVariables localVariables;
    private LocalVariable localVariable;

    public AddCheckCastVisitor(ConstantPool constants, LocalVariables localVariables, LocalVariable localVariable) {
        this.constants = constants;
        this.localVariables = localVariables;
        this.localVariable = localVariable;
    }

    public void visit(Instruction instruction) {
        switch (instruction.opcode) {
            case 190: {
                ArrayLength al = (ArrayLength)instruction;
                this.visit(al.arrayref);
                break;
            }
            case 83: 
            case 272: {
                ArrayStoreInstruction asi = (ArrayStoreInstruction)instruction;
                this.visit(asi.arrayref);
                this.visit(asi.valueref);
                break;
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                this.visit(ai.test);
                if (ai.msg == null) break;
                this.visit(ai.msg);
                break;
            }
            case 191: {
                AThrow aThrow = (AThrow)instruction;
                if (this.match(aThrow.value)) {
                    LoadInstruction li = (LoadInstruction)aThrow.value;
                    LocalVariable lv = this.localVariables.getLocalVariableWithIndexAndOffset(li.index, li.offset);
                    if (lv.signature_index != this.constants.objectSignatureIndex) break;
                    int nameIndex = this.constants.addConstantUtf8("java/lang/Throwable");
                    int classIndex = this.constants.addConstantClass(nameIndex);
                    Instruction i = aThrow.value;
                    aThrow.value = new CheckCast(192, i.offset, i.lineNumber, classIndex, i);
                    break;
                }
                this.visit(aThrow.value);
                break;
            }
            case 266: {
                this.visit(((UnaryOperatorInstruction)instruction).value);
                break;
            }
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                this.visit(boi.value1);
                this.visit(boi.value2);
                break;
            }
            case 192: {
                this.visit(((CheckCast)instruction).objectref);
                break;
            }
            case 54: 
            case 269: {
                this.visit(((StoreInstruction)instruction).valueref);
                break;
            }
            case 58: {
                StoreInstruction storeInstruction = (StoreInstruction)instruction;
                if (this.match(storeInstruction.valueref)) {
                    LocalVariable lv = this.localVariables.getLocalVariableWithIndexAndOffset(storeInstruction.index, storeInstruction.offset);
                    if (lv.signature_index <= 0 || lv.signature_index == this.constants.objectSignatureIndex) break;
                    String signature = this.constants.getConstantUtf8(lv.signature_index);
                    storeInstruction.valueref = this.newInstruction(signature, storeInstruction.valueref);
                    break;
                }
                this.visit(storeInstruction.valueref);
                break;
            }
            case 264: {
                this.visit(((DupStore)instruction).objectref);
                break;
            }
            case 275: 
            case 276: {
                this.visit(((ConvertInstruction)instruction).value);
                break;
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                this.visit(ifCmp.value1);
                this.visit(ifCmp.value2);
                break;
            }
            case 260: 
            case 262: {
                this.visit(((IfInstruction)instruction).value);
                break;
            }
            case 284: {
                List<Instruction> branchList = ((ComplexConditionalBranchInstruction)instruction).instructions;
                int i = branchList.size() - 1;
                while (i >= 0) {
                    this.visit(branchList.get(i));
                    --i;
                }
                break;
            }
            case 193: {
                this.visit(((InstanceOf)instruction).objectref);
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                InvokeNoStaticInstruction insi = (InvokeNoStaticInstruction)instruction;
                if (this.match(insi.objectref)) {
                    ConstantMethodref cmr = this.constants.getConstantMethodref(insi.index);
                    ConstantClass cc = this.constants.getConstantClass(cmr.class_index);
                    if (this.constants.objectClassNameIndex != cc.name_index) {
                        Instruction i = insi.objectref;
                        insi.objectref = new CheckCast(192, i.offset, i.lineNumber, cmr.class_index, i);
                    }
                } else {
                    this.visit(insi.objectref);
                }
            }
            case 184: {
                List<Instruction> list = ((InvokeInstruction)instruction).args;
                List<String> types = ((InvokeInstruction)instruction).getListOfParameterSignatures(this.constants);
                int i = list.size() - 1;
                while (i >= 0) {
                    Instruction arg = list.get(i);
                    if (this.match(arg)) {
                        String signature = types.get(i);
                        if (!signature.equals("Ljava/lang/Object;")) {
                            list.set(i, this.newInstruction(signature, arg));
                        }
                    } else {
                        this.visit(arg);
                    }
                    --i;
                }
                break;
            }
            case 171: {
                this.visit(((LookupSwitch)instruction).key);
                break;
            }
            case 194: {
                this.visit(((MonitorEnter)instruction).objectref);
                break;
            }
            case 195: {
                this.visit(((MonitorExit)instruction).objectref);
                break;
            }
            case 197: {
                Instruction[] dimensions = ((MultiANewArray)instruction).dimensions;
                int i = dimensions.length - 1;
                while (i >= 0) {
                    this.visit(dimensions[i]);
                    --i;
                }
                break;
            }
            case 188: {
                this.visit(((NewArray)instruction).dimension);
                break;
            }
            case 189: {
                this.visit(((ANewArray)instruction).dimension);
                break;
            }
            case 87: {
                this.visit(((Pop)instruction).objectref);
                break;
            }
            case 180: {
                GetField getField = (GetField)instruction;
                if (this.match(getField.objectref)) {
                    ConstantFieldref cfr = this.constants.getConstantFieldref(getField.index);
                    ConstantClass cc = this.constants.getConstantClass(cfr.class_index);
                    if (this.constants.objectClassNameIndex == cc.name_index) break;
                    Instruction i = getField.objectref;
                    getField.objectref = new CheckCast(192, i.offset, i.lineNumber, cfr.class_index, i);
                    break;
                }
                this.visit(getField.objectref);
                break;
            }
            case 181: {
                ConstantFieldref cfr;
                PutField putField = (PutField)instruction;
                if (this.match(putField.objectref)) {
                    cfr = this.constants.getConstantFieldref(putField.index);
                    ConstantClass cc = this.constants.getConstantClass(cfr.class_index);
                    if (this.constants.objectClassNameIndex != cc.name_index) {
                        Instruction i = putField.objectref;
                        putField.objectref = new CheckCast(192, i.offset, i.lineNumber, cfr.class_index, i);
                    }
                } else {
                    this.visit(putField.objectref);
                }
                if (this.match(putField.valueref)) {
                    cfr = this.constants.getConstantFieldref(putField.index);
                    ConstantNameAndType cnat = this.constants.getConstantNameAndType(cfr.name_and_type_index);
                    if (cnat.descriptor_index == this.constants.objectSignatureIndex) break;
                    String signature = this.constants.getConstantUtf8(cnat.descriptor_index);
                    putField.valueref = this.newInstruction(signature, putField.valueref);
                    break;
                }
                this.visit(putField.valueref);
                break;
            }
            case 179: {
                PutStatic putStatic = (PutStatic)instruction;
                if (this.match(putStatic.valueref)) {
                    ConstantFieldref cfr = this.constants.getConstantFieldref(putStatic.index);
                    ConstantNameAndType cnat = this.constants.getConstantNameAndType(cfr.name_and_type_index);
                    if (cnat.descriptor_index == this.constants.objectSignatureIndex) break;
                    String signature = this.constants.getConstantUtf8(cnat.descriptor_index);
                    putStatic.valueref = this.newInstruction(signature, putStatic.valueref);
                    break;
                }
                this.visit(putStatic.valueref);
                break;
            }
            case 273: {
                this.visit(((ReturnInstruction)instruction).valueref);
                break;
            }
            case 170: {
                this.visit(((TableSwitch)instruction).key);
                break;
            }
            case 280: {
                this.visit(((TernaryOpStore)instruction).objectref);
                break;
            }
            case 281: {
                TernaryOperator to = (TernaryOperator)instruction;
                this.visit(to.value1);
                this.visit(to.value2);
                break;
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 178: 
            case 187: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 268: 
            case 270: 
            case 271: 
            case 274: 
            case 277: 
            case 278: 
            case 279: 
            case 285: {
                break;
            }
            default: {
                System.err.println("Can not add cast in " + instruction.getClass().getName() + ", opcode=" + instruction.opcode);
            }
        }
    }

    private boolean match(Instruction i) {
        if (i.opcode == 25) {
            LoadInstruction li = (LoadInstruction)i;
            if (li.index == this.localVariable.index) {
                LocalVariable lv = this.localVariables.getLocalVariableWithIndexAndOffset(li.index, li.offset);
                return lv == this.localVariable;
            }
        }
        return false;
    }

    private Instruction newInstruction(String signature, Instruction i) {
        int nameIndex;
        if (SignatureUtil.IsPrimitiveSignature(signature)) {
            return new ConvertInstruction(275, i.offset, i.lineNumber, i, signature);
        }
        if (signature.charAt(0) == 'L') {
            String name = SignatureUtil.GetInnerName(signature);
            nameIndex = this.constants.addConstantUtf8(name);
        } else {
            nameIndex = this.constants.addConstantUtf8(signature);
        }
        int classIndex = this.constants.addConstantClass(nameIndex);
        return new CheckCast(192, i.offset, i.lineNumber, classIndex, i);
    }
}

