/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.jobs;

import jadx.gui.JadxWrapper;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BackgroundJob {
    private static final Logger LOG = LoggerFactory.getLogger(BackgroundJob.class);
    protected final JadxWrapper wrapper;
    private final ThreadPoolExecutor executor;
    private Future<Boolean> future;

    public BackgroundJob(JadxWrapper wrapper, int threadsCount) {
        this.wrapper = wrapper;
        this.executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(threadsCount);
    }

    public synchronized Future<Boolean> process() {
        if (this.future != null) {
            return this.future;
        }
        ExecutorService shutdownExecutor = Executors.newSingleThreadExecutor();
        ShutdownTask task = new ShutdownTask();
        shutdownExecutor.execute(task);
        shutdownExecutor.shutdown();
        this.future = task;
        return this.future;
    }

    protected abstract void runJob();

    public abstract String getInfoString();

    protected void addTask(Runnable runnable) {
        this.executor.execute(runnable);
    }

    public void processAndWait() {
        try {
            this.process().get();
        }
        catch (Exception e) {
            LOG.error("BackgroundJob.processAndWait failed", (Throwable)e);
        }
    }

    public synchronized boolean isComplete() {
        try {
            return this.future != null && this.future.isDone();
        }
        catch (Exception e) {
            LOG.error("BackgroundJob.isComplete failed", (Throwable)e);
            return false;
        }
    }

    public int getProgress() {
        return (int)((double)(this.executor.getCompletedTaskCount() * 100L) / (double)this.executor.getTaskCount());
    }

    private class ShutdownTask
    extends FutureTask<Boolean> {
        public ShutdownTask() {
            super(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    BackgroundJob.this.runJob();
                    BackgroundJob.this.executor.shutdown();
                    return BackgroundJob.this.executor.awaitTermination(5L, TimeUnit.MINUTES);
                }
            });
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            BackgroundJob.this.executor.shutdownNow();
            return super.cancel(mayInterruptIfRunning);
        }
    }
}

