/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.javax.crypto.keyring.BaseKeyring;
import gnu.javax.crypto.keyring.CertificateEntry;
import gnu.javax.crypto.keyring.CompressedEntry;
import gnu.javax.crypto.keyring.Entry;
import gnu.javax.crypto.keyring.IPublicKeyring;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.PasswordAuthenticatedEntry;
import gnu.javax.crypto.keyring.Properties;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Logger;

public class GnuPublicKeyring
extends BaseKeyring
implements IPublicKeyring {
    private static final Logger log = null;
    public static final int USAGE = 4;

    public GnuPublicKeyring(String mac, int macLen) {
        this.keyring = new PasswordAuthenticatedEntry(mac, macLen, new Properties());
        this.keyring2 = new CompressedEntry(new Properties());
        this.keyring.add(this.keyring2);
    }

    public GnuPublicKeyring() {
    }

    public boolean containsCertificate(String alias) {
        boolean result = false;
        if (this.containsAlias(alias)) {
            Iterator it = this.get(alias).iterator();
            while (it.hasNext()) {
                if (!(it.next() instanceof CertificateEntry)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public Certificate getCertificate(String alias) {
        Certificate result = null;
        if (this.containsAlias(alias)) {
            for (Entry e : this.get(alias)) {
                if (!(e instanceof CertificateEntry)) continue;
                result = ((CertificateEntry)e).getCertificate();
                break;
            }
        }
        return result;
    }

    public void putCertificate(String alias, Certificate cert) {
        if (!this.containsCertificate(alias)) {
            Properties p = new Properties();
            p.put("alias", this.fixAlias(alias));
            this.add(new CertificateEntry(cert, new Date(), p));
        }
    }

    protected void load(InputStream in, char[] password) throws IOException {
        if (in.read() != 4) {
            throw new MalformedKeyringException("incompatible keyring usage");
        }
        if (in.read() != 3) {
            throw new MalformedKeyringException("expecting password-authenticated entry tag");
        }
        DataInputStream dis = new DataInputStream(in);
        this.keyring = PasswordAuthenticatedEntry.decode(dis, password);
    }

    protected void store(OutputStream out, char[] password) throws IOException {
        out.write(4);
        this.keyring.encode(new DataOutputStream(out), password);
    }
}

