/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.lookup;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.elasticsearch.painless.lookup.PainlessClassBuilder;
import org.elasticsearch.painless.lookup.PainlessField;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.spi.Whitelist;
import org.elasticsearch.painless.spi.WhitelistClass;
import org.elasticsearch.painless.spi.WhitelistConstructor;
import org.elasticsearch.painless.spi.WhitelistField;
import org.elasticsearch.painless.spi.WhitelistMethod;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class PainlessLookupBuilder {
    private static final Map<PainlessMethodCacheKey, PainlessMethod> painlessMethodCache = new HashMap<PainlessMethodCacheKey, PainlessMethod>();
    private static final Map<PainlessFieldCacheKey, PainlessField> painlessFieldCache = new HashMap<PainlessFieldCacheKey, PainlessField>();
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("^[_a-zA-Z][._a-zA-Z0-9]*$");
    private static final Pattern METHOD_NAME_PATTERN = Pattern.compile("^[_a-zA-Z][_a-zA-Z0-9]*$");
    private static final Pattern FIELD_NAME_PATTERN = Pattern.compile("^[_a-zA-Z][_a-zA-Z0-9]*$");
    private final List<Whitelist> whitelists;
    private final Map<String, Class<?>> canonicalClassNamesToClasses;
    private final Map<Class<?>, PainlessClassBuilder> classesToPainlessClassBuilders;

    public PainlessLookupBuilder(List<Whitelist> whitelists) {
        this.whitelists = whitelists;
        this.canonicalClassNamesToClasses = new HashMap();
        this.classesToPainlessClassBuilders = new HashMap();
        this.canonicalClassNamesToClasses.put("def", def.class);
        this.classesToPainlessClassBuilders.put(def.class, new PainlessClassBuilder("def", Object.class, Type.getType(Object.class)));
    }

    private Class<?> canonicalTypeNameToType(String canonicalTypeName) {
        return PainlessLookupUtility.canonicalTypeNameToType(canonicalTypeName, this.canonicalClassNamesToClasses);
    }

    private void validateType(Class<?> type) {
        PainlessLookupUtility.validateType(type, this.classesToPainlessClassBuilders.keySet());
    }

    public void addPainlessClass(ClassLoader classLoader, String javaClassName, boolean importClassName) {
        Class<Object> clazz;
        Objects.requireNonNull(classLoader);
        Objects.requireNonNull(javaClassName);
        if ("void".equals(javaClassName)) {
            clazz = Void.TYPE;
        } else if ("boolean".equals(javaClassName)) {
            clazz = Boolean.TYPE;
        } else if ("byte".equals(javaClassName)) {
            clazz = Byte.TYPE;
        } else if ("short".equals(javaClassName)) {
            clazz = Short.TYPE;
        } else if ("char".equals(javaClassName)) {
            clazz = Character.TYPE;
        } else if ("int".equals(javaClassName)) {
            clazz = Integer.TYPE;
        } else if ("long".equals(javaClassName)) {
            clazz = Long.TYPE;
        } else if ("float".equals(javaClassName)) {
            clazz = Float.TYPE;
        } else if ("double".equals(javaClassName)) {
            clazz = Double.TYPE;
        } else {
            try {
                clazz = Class.forName(javaClassName, true, classLoader);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("class [" + javaClassName + "] not found", cnfe);
            }
        }
        this.addPainlessClass(clazz, importClassName);
    }

    public void addPainlessClass(Class<?> clazz, boolean importClassName) {
        Objects.requireNonNull(clazz);
        if (clazz == def.class) {
            throw new IllegalArgumentException("cannot add reserved class [def]");
        }
        String canonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(clazz);
        if (clazz.isArray()) {
            throw new IllegalArgumentException("cannot add array type [" + canonicalClassName + "] as a class");
        }
        if (!CLASS_NAME_PATTERN.matcher(canonicalClassName).matches()) {
            throw new IllegalArgumentException("invalid class name [" + canonicalClassName + "]");
        }
        PainlessClassBuilder existingPainlessClassBuilder = this.classesToPainlessClassBuilders.get(clazz);
        if (existingPainlessClassBuilder == null) {
            PainlessClassBuilder painlessClassBuilder = new PainlessClassBuilder(canonicalClassName, clazz, Type.getType(clazz));
            this.canonicalClassNamesToClasses.put(canonicalClassName, clazz);
            this.classesToPainlessClassBuilders.put(clazz, painlessClassBuilder);
        } else if (!existingPainlessClassBuilder.clazz.equals(clazz)) {
            throw new IllegalArgumentException("class [" + canonicalClassName + "] cannot represent multiple java classes with the same name from different class loaders");
        }
        String javaClassName = clazz.getName();
        String importedCanonicalClassName = javaClassName.substring(javaClassName.lastIndexOf(46) + 1).replace('$', '.');
        if (canonicalClassName.equals(importedCanonicalClassName)) {
            if (importClassName) {
                throw new IllegalArgumentException("must use only_fqn parameter on class [" + canonicalClassName + "] with no package");
            }
        } else {
            Class<?> importedPainlessClass = this.canonicalClassNamesToClasses.get(importedCanonicalClassName);
            if (importedPainlessClass == null) {
                if (importClassName) {
                    if (existingPainlessClassBuilder != null) {
                        throw new IllegalArgumentException("inconsistent only_fqn parameters found for class [" + canonicalClassName + "]");
                    }
                    this.canonicalClassNamesToClasses.put(importedCanonicalClassName, clazz);
                }
            } else {
                if (!importedPainlessClass.equals(clazz)) {
                    throw new IllegalArgumentException("imported class [" + importedCanonicalClassName + "] cannot represent multiple classes [" + canonicalClassName + "] and [" + PainlessLookupUtility.typeToCanonicalTypeName(importedPainlessClass) + "]");
                }
                if (!importClassName) {
                    throw new IllegalArgumentException("inconsistent only_fqn parameters found for class [" + canonicalClassName + "]");
                }
            }
        }
    }

    public void addPainlessConstructor(String targetCanonicalClassName, List<String> typeNameParameters) {
        Objects.requireNonNull(targetCanonicalClassName);
        Objects.requireNonNull(typeNameParameters);
        Class<?> targetClass = this.canonicalClassNamesToClasses.get(targetCanonicalClassName);
        if (targetClass == null) {
            throw new IllegalArgumentException("target class [" + targetCanonicalClassName + "] not foundfor constructor [[" + targetCanonicalClassName + "], " + typeNameParameters + "]");
        }
        ArrayList typeParameters = new ArrayList(typeNameParameters.size());
        for (String typeNameParameter : typeNameParameters) {
            try {
                Class<?> typeParameter = this.canonicalTypeNameToType(typeNameParameter);
                typeParameters.add(typeParameter);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("type parameter [" + typeNameParameter + "] not found for constructor [[" + targetCanonicalClassName + "], " + typeNameParameters + "]", iae);
            }
        }
        this.addPainlessConstructor(targetClass, typeParameters);
    }

    public void addPainlessConstructor(Class<?> targetClass, List<Class<?>> typeParameters) {
        Constructor<?> javaConstructor;
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(typeParameters);
        if (targetClass == def.class) {
            throw new IllegalArgumentException("cannot add constructor to reserved class [def]");
        }
        String targetCanonicalClassName = targetClass.getCanonicalName();
        PainlessClassBuilder painlessClassBuilder = this.classesToPainlessClassBuilders.get(targetClass);
        if (painlessClassBuilder == null) {
            throw new IllegalArgumentException("target class [" + targetCanonicalClassName + "] not foundfor constructor [[" + targetCanonicalClassName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]");
        }
        int typeParametersSize = typeParameters.size();
        ArrayList javaTypeParameters = new ArrayList(typeParametersSize);
        for (Class<?> typeParameter : typeParameters) {
            try {
                this.validateType(typeParameter);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("type parameter [" + PainlessLookupUtility.typeToCanonicalTypeName(typeParameter) + "] not found for constructor [[" + targetCanonicalClassName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]", iae);
            }
            javaTypeParameters.add(PainlessLookupUtility.typeToJavaType(typeParameter));
        }
        try {
            javaConstructor = targetClass.getConstructor(javaTypeParameters.toArray(new Class[typeParametersSize]));
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("constructor reflection object [[" + targetCanonicalClassName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "] not found", nsme);
        }
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey("<init>", typeParametersSize);
        PainlessMethod painlessConstructor = painlessClassBuilder.constructors.get(painlessMethodKey);
        if (painlessConstructor == null) {
            MethodHandle methodHandle;
            Method asmConstructor = Method.getMethod(javaConstructor);
            try {
                methodHandle = MethodHandles.publicLookup().in(targetClass).unreflectConstructor(javaConstructor);
            }
            catch (IllegalAccessException iae) {
                throw new IllegalArgumentException("constructor method handle [[" + targetCanonicalClassName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "] not found", iae);
            }
            painlessConstructor = painlessMethodCache.computeIfAbsent(new PainlessMethodCacheKey(targetClass, "<init>", typeParameters), key -> new PainlessMethod("<init>", targetClass, null, Void.TYPE, typeParameters, asmConstructor, javaConstructor.getModifiers(), methodHandle));
            painlessClassBuilder.constructors.put(painlessMethodKey, painlessConstructor);
        } else if (!painlessConstructor.arguments.equals(typeParameters)) {
            throw new IllegalArgumentException("cannot have constructors [[" + targetCanonicalClassName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "] and [[" + targetCanonicalClassName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(painlessConstructor.arguments) + "] with the same arity and different type parameters");
        }
    }

    public void addPainlessMethod(ClassLoader classLoader, String targetCanonicalClassName, String augmentedCanonicalClassName, String methodName, String returnCanonicalTypeName, List<String> typeNameParameters) {
        Class<?> returnType;
        Objects.requireNonNull(classLoader);
        Objects.requireNonNull(targetCanonicalClassName);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(returnCanonicalTypeName);
        Objects.requireNonNull(typeNameParameters);
        Class<?> targetClass = this.canonicalClassNamesToClasses.get(targetCanonicalClassName);
        if (targetClass == null) {
            throw new IllegalArgumentException("target class [" + targetCanonicalClassName + "] not found for method [[" + targetCanonicalClassName + "], [" + methodName + "], " + typeNameParameters + "]");
        }
        Class<?> augmentedClass = null;
        if (augmentedCanonicalClassName != null) {
            try {
                augmentedClass = Class.forName(augmentedCanonicalClassName, true, classLoader);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("augmented class [" + augmentedCanonicalClassName + "] not found for method [[" + targetCanonicalClassName + "], [" + methodName + "], " + typeNameParameters + "]", cnfe);
            }
        }
        ArrayList typeParameters = new ArrayList(typeNameParameters.size());
        for (String typeNameParameter : typeNameParameters) {
            try {
                Class<?> typeParameter = this.canonicalTypeNameToType(typeNameParameter);
                typeParameters.add(typeParameter);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("parameter type [" + typeNameParameter + "] not found for method [[" + targetCanonicalClassName + "], [" + methodName + "], " + typeNameParameters + "]", iae);
            }
        }
        try {
            returnType = this.canonicalTypeNameToType(returnCanonicalTypeName);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("parameter type [" + returnCanonicalTypeName + "] not found for method [[" + targetCanonicalClassName + "], [" + methodName + "], " + typeNameParameters + "]", iae);
        }
        this.addPainlessMethod(targetClass, augmentedClass, methodName, returnType, typeParameters);
    }

    public void addPainlessMethod(Class<?> targetClass, Class<?> augmentedClass, String methodName, Class<?> returnType, List<Class<?>> typeParameters) {
        java.lang.reflect.Method javaMethod;
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(returnType);
        Objects.requireNonNull(typeParameters);
        if (targetClass == def.class) {
            throw new IllegalArgumentException("cannot add method to reserved class [def]");
        }
        String targetCanonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(targetClass);
        if (!METHOD_NAME_PATTERN.matcher(methodName).matches()) {
            throw new IllegalArgumentException("invalid method name [" + methodName + "] for target class [" + targetCanonicalClassName + "].");
        }
        PainlessClassBuilder painlessClassBuilder = this.classesToPainlessClassBuilders.get(targetClass);
        if (painlessClassBuilder == null) {
            throw new IllegalArgumentException("target class [" + targetCanonicalClassName + "] not found for method [[" + targetCanonicalClassName + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]");
        }
        int typeParametersSize = typeParameters.size();
        int augmentedParameterOffset = augmentedClass == null ? 0 : 1;
        ArrayList javaTypeParameters = new ArrayList(typeParametersSize + augmentedParameterOffset);
        if (augmentedClass != null) {
            javaTypeParameters.add(targetClass);
        }
        for (Class<?> typeParameter : typeParameters) {
            try {
                this.validateType(typeParameter);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("type parameter [" + PainlessLookupUtility.typeToCanonicalTypeName(typeParameter) + "] not found for method [[" + targetCanonicalClassName + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]", iae);
            }
            javaTypeParameters.add(PainlessLookupUtility.typeToJavaType(typeParameter));
        }
        try {
            this.validateType(returnType);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("return type [" + PainlessLookupUtility.typeToCanonicalTypeName(returnType) + "] not found for method [[" + targetCanonicalClassName + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]", iae);
        }
        if (augmentedClass == null) {
            try {
                javaMethod = targetClass.getMethod(methodName, javaTypeParameters.toArray(new Class[typeParametersSize]));
            }
            catch (NoSuchMethodException nsme) {
                throw new IllegalArgumentException("method reflection object [[" + targetCanonicalClassName + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "] not found", nsme);
            }
        }
        try {
            javaMethod = augmentedClass.getMethod(methodName, javaTypeParameters.toArray(new Class[typeParametersSize]));
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("method reflection object [[" + targetCanonicalClassName + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "] not found with augmented target class [" + PainlessLookupUtility.typeToCanonicalTypeName(augmentedClass) + "]", nsme);
        }
        if (javaMethod.getReturnType() != PainlessLookupUtility.typeToJavaType(returnType)) {
            throw new IllegalArgumentException("return type [" + PainlessLookupUtility.typeToCanonicalTypeName(javaMethod.getReturnType()) + "] does not match the specified returned type [" + PainlessLookupUtility.typeToCanonicalTypeName(returnType) + "] for method [[" + targetClass.getCanonicalName() + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "]");
        }
        String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(methodName, typeParametersSize);
        if (augmentedClass == null && Modifier.isStatic(javaMethod.getModifiers())) {
            PainlessMethod painlessMethod = painlessClassBuilder.staticMethods.get(painlessMethodKey);
            if (painlessMethod == null) {
                MethodHandle javaMethodHandle;
                Method asmMethod = Method.getMethod((java.lang.reflect.Method)javaMethod);
                try {
                    javaMethodHandle = MethodHandles.publicLookup().in(targetClass).unreflect(javaMethod);
                }
                catch (IllegalAccessException iae) {
                    throw new IllegalArgumentException("static method handle [[" + targetClass.getCanonicalName() + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "] not found", iae);
                }
                painlessMethod = painlessMethodCache.computeIfAbsent(new PainlessMethodCacheKey(targetClass, methodName, typeParameters), key -> new PainlessMethod(methodName, targetClass, null, returnType, typeParameters, asmMethod, javaMethod.getModifiers(), javaMethodHandle));
                painlessClassBuilder.staticMethods.put(painlessMethodKey, painlessMethod);
            } else if (!(painlessMethod.name.equals(methodName) && painlessMethod.rtn == returnType && painlessMethod.arguments.equals(typeParameters))) {
                throw new IllegalArgumentException("cannot have static methods [[" + targetCanonicalClassName + "], [" + methodName + "], [" + PainlessLookupUtility.typeToCanonicalTypeName(returnType) + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "] and [[" + targetCanonicalClassName + "], [" + methodName + "], [" + PainlessLookupUtility.typeToCanonicalTypeName(painlessMethod.rtn) + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(painlessMethod.arguments) + "] with the same arity and different return type or type parameters");
            }
        } else {
            PainlessMethod painlessMethod = painlessClassBuilder.staticMethods.get(painlessMethodKey);
            if (painlessMethod == null) {
                MethodHandle javaMethodHandle;
                Method asmMethod = Method.getMethod((java.lang.reflect.Method)javaMethod);
                if (augmentedClass == null) {
                    try {
                        javaMethodHandle = MethodHandles.publicLookup().in(targetClass).unreflect(javaMethod);
                    }
                    catch (IllegalAccessException iae) {
                        throw new IllegalArgumentException("method handle [[" + targetClass.getCanonicalName() + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "] not found", iae);
                    }
                }
                try {
                    javaMethodHandle = MethodHandles.publicLookup().in(augmentedClass).unreflect(javaMethod);
                }
                catch (IllegalAccessException iae) {
                    throw new IllegalArgumentException("method handle [[" + targetClass.getCanonicalName() + "], [" + methodName + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "] not found with augmented target class [" + PainlessLookupUtility.typeToCanonicalTypeName(augmentedClass) + "]", iae);
                }
                painlessMethod = painlessMethodCache.computeIfAbsent(new PainlessMethodCacheKey(targetClass, methodName, typeParameters), key -> new PainlessMethod(methodName, targetClass, augmentedClass, returnType, typeParameters, asmMethod, javaMethod.getModifiers(), javaMethodHandle));
                painlessClassBuilder.methods.put(painlessMethodKey, painlessMethod);
            } else if (!(painlessMethod.name.equals(methodName) && painlessMethod.rtn == returnType && painlessMethod.arguments.equals(typeParameters))) {
                throw new IllegalArgumentException("cannot have methods [[" + targetCanonicalClassName + "], [" + methodName + "], [" + PainlessLookupUtility.typeToCanonicalTypeName(returnType) + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(typeParameters) + "] and [[" + targetCanonicalClassName + "], [" + methodName + "], [" + PainlessLookupUtility.typeToCanonicalTypeName(painlessMethod.rtn) + "], " + PainlessLookupUtility.typesToCanonicalTypeNames(painlessMethod.arguments) + "] with the same arity and different return type or type parameters");
            }
        }
    }

    public void addPainlessField(String targetCanonicalClassName, String fieldName, String typeNameParameter) {
        Class<?> typeParameter;
        Objects.requireNonNull(targetCanonicalClassName);
        Objects.requireNonNull(fieldName);
        Objects.requireNonNull(typeNameParameter);
        Class<?> targetClass = this.canonicalClassNamesToClasses.get(targetCanonicalClassName);
        if (targetClass == null) {
            throw new IllegalArgumentException("class [" + targetCanonicalClassName + "] not found");
        }
        try {
            typeParameter = this.canonicalTypeNameToType(typeNameParameter);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("type parameter [" + typeNameParameter + "] not found for field [[" + targetCanonicalClassName + "], [" + fieldName + "]");
        }
        this.addPainlessField(targetClass, fieldName, typeParameter);
    }

    public void addPainlessField(Class<?> targetClass, String fieldName, Class<?> typeParameter) {
        Field javaField;
        Objects.requireNonNull(targetClass);
        Objects.requireNonNull(fieldName);
        Objects.requireNonNull(typeParameter);
        if (targetClass == def.class) {
            throw new IllegalArgumentException("cannot add field to reserved class [def]");
        }
        String targetCanonicalClassName = PainlessLookupUtility.typeToCanonicalTypeName(targetClass);
        if (!FIELD_NAME_PATTERN.matcher(fieldName).matches()) {
            throw new IllegalArgumentException("invalid field name [" + fieldName + "] for target class [" + targetCanonicalClassName + "].");
        }
        PainlessClassBuilder painlessClassBuilder = this.classesToPainlessClassBuilders.get(targetClass);
        if (painlessClassBuilder == null) {
            throw new IllegalArgumentException("class [" + targetCanonicalClassName + "] not found");
        }
        try {
            this.validateType(typeParameter);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("type parameter [" + PainlessLookupUtility.typeToCanonicalTypeName(typeParameter) + "] not found for field [[" + targetCanonicalClassName + "], [" + fieldName + "]", iae);
        }
        try {
            javaField = targetClass.getField(fieldName);
        }
        catch (NoSuchFieldException nsme) {
            throw new IllegalArgumentException("field reflection object [[" + targetCanonicalClassName + "], [" + fieldName + "] not found", nsme);
        }
        if (javaField.getType() != PainlessLookupUtility.typeToJavaType(typeParameter)) {
            throw new IllegalArgumentException("type parameter [" + PainlessLookupUtility.typeToCanonicalTypeName(javaField.getType()) + "] does not match the specified type parameter [" + PainlessLookupUtility.typeToCanonicalTypeName(typeParameter) + "] for field [[" + targetCanonicalClassName + "], [" + fieldName + "]");
        }
        String painlessFieldKey = PainlessLookupUtility.buildPainlessFieldKey(fieldName);
        if (Modifier.isStatic(javaField.getModifiers())) {
            if (!Modifier.isFinal(javaField.getModifiers())) {
                throw new IllegalArgumentException("static field [[" + targetCanonicalClassName + "]. [" + fieldName + "]] must be final");
            }
            PainlessField painlessField = painlessClassBuilder.staticMembers.get(painlessFieldKey);
            if (painlessField == null) {
                painlessField = painlessFieldCache.computeIfAbsent(new PainlessFieldCacheKey(targetClass, fieldName, typeParameter), key -> new PainlessField(fieldName, javaField.getName(), targetClass, typeParameter, javaField.getModifiers(), null, null));
                painlessClassBuilder.staticMembers.put(painlessFieldKey, painlessField);
            } else if (painlessField.clazz != typeParameter) {
                throw new IllegalArgumentException("cannot have static fields [[" + targetCanonicalClassName + "], [" + fieldName + "], [" + PainlessLookupUtility.typeToCanonicalTypeName(typeParameter) + "] and [[" + targetCanonicalClassName + "], [" + painlessField.name + "], " + PainlessLookupUtility.typeToCanonicalTypeName(painlessField.clazz) + "] with the same and different type parameters");
            }
        } else {
            MethodHandle methodHandleSetter;
            MethodHandle methodHandleGetter;
            try {
                methodHandleGetter = MethodHandles.publicLookup().unreflectGetter(javaField);
            }
            catch (IllegalAccessException iae) {
                throw new IllegalArgumentException("method handle getter not found for field [[" + targetCanonicalClassName + "], [" + fieldName + "]]");
            }
            try {
                methodHandleSetter = MethodHandles.publicLookup().unreflectSetter(javaField);
            }
            catch (IllegalAccessException iae) {
                throw new IllegalArgumentException("method handle setter not found for field [[" + targetCanonicalClassName + "], [" + fieldName + "]]");
            }
            PainlessField painlessField = painlessClassBuilder.members.get(painlessFieldKey);
            if (painlessField == null) {
                painlessField = painlessFieldCache.computeIfAbsent(new PainlessFieldCacheKey(targetClass, painlessFieldKey, typeParameter), key -> new PainlessField(fieldName, javaField.getName(), targetClass, typeParameter, javaField.getModifiers(), methodHandleGetter, methodHandleSetter));
                painlessClassBuilder.members.put(fieldName, painlessField);
            } else if (painlessField.clazz != typeParameter) {
                throw new IllegalArgumentException("cannot have fields [[" + targetCanonicalClassName + "], [" + fieldName + "], [" + PainlessLookupUtility.typeToCanonicalTypeName(typeParameter) + "] and [[" + targetCanonicalClassName + "], [" + painlessField.name + "], " + PainlessLookupUtility.typeToCanonicalTypeName(painlessField.clazz) + "] with the same and different type parameters");
            }
        }
    }

    public PainlessLookup build() {
        String origin = "internal error";
        try {
            String painlessTypeName;
            for (Whitelist whitelist : this.whitelists) {
                for (WhitelistClass whitelistStruct : whitelist.whitelistStructs) {
                    painlessTypeName = whitelistStruct.javaClassName.replace('$', '.');
                    PainlessClassBuilder painlessStruct = this.classesToPainlessClassBuilders.get(this.canonicalClassNamesToClasses.get(painlessTypeName));
                    if (painlessStruct != null && !painlessStruct.clazz.getName().equals(whitelistStruct.javaClassName)) {
                        throw new IllegalArgumentException("struct [" + painlessStruct.name + "] cannot represent multiple classes [" + painlessStruct.clazz.getName() + "] and [" + whitelistStruct.javaClassName + "]");
                    }
                    origin = whitelistStruct.origin;
                    this.addPainlessClass(whitelist.javaClassLoader, whitelistStruct.javaClassName, !whitelistStruct.onlyFQNJavaClassName);
                    painlessStruct = this.classesToPainlessClassBuilders.get(this.canonicalClassNamesToClasses.get(painlessTypeName));
                    this.classesToPainlessClassBuilders.put(painlessStruct.clazz, painlessStruct);
                }
            }
            for (Whitelist whitelist : this.whitelists) {
                for (WhitelistClass whitelistStruct : whitelist.whitelistStructs) {
                    painlessTypeName = whitelistStruct.javaClassName.replace('$', '.');
                    for (WhitelistConstructor whitelistConstructor : whitelistStruct.whitelistConstructors) {
                        origin = whitelistConstructor.origin;
                        this.addPainlessConstructor(painlessTypeName, whitelistConstructor.painlessParameterTypeNames);
                    }
                    for (WhitelistMethod whitelistMethod : whitelistStruct.whitelistMethods) {
                        origin = whitelistMethod.origin;
                        this.addPainlessMethod(whitelist.javaClassLoader, painlessTypeName, whitelistMethod.javaAugmentedClassName, whitelistMethod.javaMethodName, whitelistMethod.painlessReturnTypeName, whitelistMethod.painlessParameterTypeNames);
                    }
                    for (WhitelistField whitelistField : whitelistStruct.whitelistFields) {
                        origin = whitelistField.origin;
                        this.addPainlessField(painlessTypeName, whitelistField.javaFieldName, whitelistField.painlessFieldTypeName);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("error loading whitelist(s) " + origin, exception);
        }
        this.copyPainlessClassMembers();
        this.cacheRuntimeHandles();
        this.setFunctionalInterfaceMethods();
        HashMap classesToPainlessClasses = new HashMap(this.classesToPainlessClassBuilders.size());
        for (Map.Entry<Class<?>, PainlessClassBuilder> painlessClassBuilderEntry : this.classesToPainlessClassBuilders.entrySet()) {
            classesToPainlessClasses.put(painlessClassBuilderEntry.getKey(), painlessClassBuilderEntry.getValue().build());
        }
        return new PainlessLookup(this.canonicalClassNamesToClasses, classesToPainlessClasses);
    }

    private void copyPainlessClassMembers() {
        for (Class<?> parentClass : this.classesToPainlessClassBuilders.keySet()) {
            this.copyPainlessInterfaceMembers(parentClass, parentClass);
            for (Class<?> childClass = parentClass.getSuperclass(); childClass != null; childClass = childClass.getSuperclass()) {
                if (this.classesToPainlessClassBuilders.containsKey(childClass)) {
                    this.copyPainlessClassMembers(childClass, parentClass);
                }
                this.copyPainlessInterfaceMembers(childClass, parentClass);
            }
        }
        for (Class<?> javaClass : this.classesToPainlessClassBuilders.keySet()) {
            if (!javaClass.isInterface()) continue;
            this.copyPainlessClassMembers(Object.class, javaClass);
        }
    }

    private void copyPainlessInterfaceMembers(Class<?> parentClass, Class<?> targetClass) {
        for (Class<?> childClass : parentClass.getInterfaces()) {
            if (this.classesToPainlessClassBuilders.containsKey(childClass)) {
                this.copyPainlessClassMembers(childClass, targetClass);
            }
            this.copyPainlessInterfaceMembers(childClass, targetClass);
        }
    }

    private void copyPainlessClassMembers(Class<?> originalClass, Class<?> targetClass) {
        PainlessClassBuilder originalPainlessClassBuilder = this.classesToPainlessClassBuilders.get(originalClass);
        PainlessClassBuilder targetPainlessClassBuilder = this.classesToPainlessClassBuilders.get(targetClass);
        Objects.requireNonNull(originalPainlessClassBuilder);
        Objects.requireNonNull(targetPainlessClassBuilder);
        for (Map.Entry<String, PainlessMethod> entry : originalPainlessClassBuilder.methods.entrySet()) {
            String painlessMethodKey = entry.getKey();
            PainlessMethod newPainlessMethod = entry.getValue();
            PainlessMethod existingPainlessMethod = targetPainlessClassBuilder.methods.get(painlessMethodKey);
            if (existingPainlessMethod != null && (existingPainlessMethod.target == newPainlessMethod.target || !existingPainlessMethod.target.isAssignableFrom(newPainlessMethod.target))) continue;
            targetPainlessClassBuilder.methods.put(painlessMethodKey, newPainlessMethod);
        }
        for (Map.Entry<String, Object> entry : originalPainlessClassBuilder.members.entrySet()) {
            String painlessFieldKey = entry.getKey();
            PainlessField newPainlessField = (PainlessField)entry.getValue();
            PainlessField existingPainlessField = targetPainlessClassBuilder.members.get(painlessFieldKey);
            if (existingPainlessField != null && (existingPainlessField.target == newPainlessField.target || !existingPainlessField.target.isAssignableFrom(newPainlessField.target))) continue;
            targetPainlessClassBuilder.members.put(painlessFieldKey, newPainlessField);
        }
    }

    private void cacheRuntimeHandles() {
        for (PainlessClassBuilder painlessClassBuilder : this.classesToPainlessClassBuilders.values()) {
            this.cacheRuntimeHandles(painlessClassBuilder);
        }
    }

    private void cacheRuntimeHandles(PainlessClassBuilder painlessClassBuilder) {
        for (PainlessMethod painlessMethod : painlessClassBuilder.methods.values()) {
            String methodName = painlessMethod.name;
            int typeParametersSize = painlessMethod.arguments.size();
            if (typeParametersSize == 0 && methodName.startsWith("get") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3))) {
                painlessClassBuilder.getters.putIfAbsent(Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4), painlessMethod.handle);
                continue;
            }
            if (typeParametersSize == 0 && methodName.startsWith("is") && methodName.length() > 2 && Character.isUpperCase(methodName.charAt(2))) {
                painlessClassBuilder.getters.putIfAbsent(Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3), painlessMethod.handle);
                continue;
            }
            if (typeParametersSize != 1 || !methodName.startsWith("set") || methodName.length() <= 3 || !Character.isUpperCase(methodName.charAt(3))) continue;
            painlessClassBuilder.setters.putIfAbsent(Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4), painlessMethod.handle);
        }
        for (PainlessField painlessField : painlessClassBuilder.members.values()) {
            painlessClassBuilder.getters.put(painlessField.name, painlessField.getter);
            painlessClassBuilder.setters.put(painlessField.name, painlessField.setter);
        }
    }

    private void setFunctionalInterfaceMethods() {
        for (Map.Entry<Class<?>, PainlessClassBuilder> painlessClassBuilderEntry : this.classesToPainlessClassBuilders.entrySet()) {
            this.setFunctionalInterfaceMethod(painlessClassBuilderEntry.getValue());
        }
    }

    private void setFunctionalInterfaceMethod(PainlessClassBuilder painlessClassBuilder) {
        Class<?> targetClass = painlessClassBuilder.clazz;
        if (targetClass.isInterface()) {
            ArrayList<java.lang.reflect.Method> javaMethods = new ArrayList<java.lang.reflect.Method>();
            for (java.lang.reflect.Method javaMethod : targetClass.getMethods()) {
                if (javaMethod.isDefault() || Modifier.isStatic(javaMethod.getModifiers())) continue;
                try {
                    Object.class.getMethod(javaMethod.getName(), javaMethod.getParameterTypes());
                }
                catch (ReflectiveOperationException roe) {
                    javaMethods.add(javaMethod);
                }
            }
            if (javaMethods.size() != 1 && targetClass.isAnnotationPresent(FunctionalInterface.class)) {
                throw new IllegalArgumentException("class [" + PainlessLookupUtility.typeToCanonicalTypeName(targetClass) + "] is illegally marked as a FunctionalInterface with java methods " + javaMethods);
            }
            if (javaMethods.size() == 1) {
                java.lang.reflect.Method javaMethod = (java.lang.reflect.Method)javaMethods.get(0);
                String painlessMethodKey = PainlessLookupUtility.buildPainlessMethodKey(javaMethod.getName(), javaMethod.getParameterCount());
                painlessClassBuilder.functionalMethod = painlessClassBuilder.methods.get(painlessMethodKey);
            }
        }
    }

    private static class PainlessFieldCacheKey {
        private final Class<?> targetType;
        private final String fieldName;
        private final Class<?> typeParameter;

        private PainlessFieldCacheKey(Class<?> targetType, String fieldName, Class<?> typeParameter) {
            this.targetType = targetType;
            this.fieldName = fieldName;
            this.typeParameter = typeParameter;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            PainlessFieldCacheKey that = (PainlessFieldCacheKey)object;
            return Objects.equals(this.targetType, that.targetType) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.typeParameter, that.typeParameter);
        }

        public int hashCode() {
            return Objects.hash(this.targetType, this.fieldName, this.typeParameter);
        }
    }

    private static class PainlessMethodCacheKey {
        private final Class<?> targetType;
        private final String methodName;
        private final List<Class<?>> typeParameters;

        private PainlessMethodCacheKey(Class<?> targetType, String methodName, List<Class<?>> typeParameters) {
            this.targetType = targetType;
            this.methodName = methodName;
            this.typeParameters = Collections.unmodifiableList(typeParameters);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            PainlessMethodCacheKey that = (PainlessMethodCacheKey)object;
            return Objects.equals(this.targetType, that.targetType) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.typeParameters, that.typeParameters);
        }

        public int hashCode() {
            return Objects.hash(this.targetType, this.methodName, this.typeParameters);
        }
    }
}

