/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ComponentConfiguration;
import org.apache.camel.Endpoint;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Route;
import org.apache.camel.TimerListener;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.management.mbean.LoadTriplet;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.management.mbean.RouteCoverageXmlParser;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.JsonSchemaHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.XmlLineNumberParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@ManagedResource(description="Managed CamelContext")
public class ManagedCamelContext
extends ManagedPerformanceCounter
implements TimerListener,
ManagedCamelContextMBean {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedCamelContext.class);
    private final ModelCamelContext context;
    private final LoadTriplet load = new LoadTriplet();

    public ManagedCamelContext(ModelCamelContext context) {
        this.context = context;
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        boolean enabled = this.context.getManagementStrategy().getManagementAgent() != null && this.context.getManagementStrategy().getManagementAgent().getStatisticsLevel() != ManagementStatisticsLevel.Off;
        this.setStatisticsEnabled(enabled);
    }

    public CamelContext getContext() {
        return this.context;
    }

    @Override
    public String getCamelId() {
        return this.context.getName();
    }

    @Override
    public String getManagementName() {
        return this.context.getManagementName();
    }

    @Override
    public String getCamelVersion() {
        return this.context.getVersion();
    }

    @Override
    public String getState() {
        return this.context.getStatus().name();
    }

    @Override
    public String getUptime() {
        return this.context.getUptime();
    }

    @Override
    public String getManagementStatisticsLevel() {
        if (this.context.getManagementStrategy().getManagementAgent() != null) {
            return this.context.getManagementStrategy().getManagementAgent().getStatisticsLevel().name();
        }
        return null;
    }

    @Override
    public String getClassResolver() {
        return this.context.getClassResolver().getClass().getName();
    }

    @Override
    public String getPackageScanClassResolver() {
        return this.context.getPackageScanClassResolver().getClass().getName();
    }

    @Override
    public String getApplicationContextClassName() {
        if (this.context.getApplicationContextClassLoader() != null) {
            return this.context.getApplicationContextClassLoader().toString();
        }
        return null;
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.context.getProperties().isEmpty()) {
            return null;
        }
        return this.context.getProperties();
    }

    @Override
    public String getProperty(String name) throws Exception {
        return this.context.getProperty(name);
    }

    @Override
    public void setProperty(String name, String value) throws Exception {
        this.context.getProperties().put(name, value);
    }

    @Override
    public Boolean getTracing() {
        return this.context.isTracing();
    }

    @Override
    public void setTracing(Boolean tracing) {
        this.context.setTracing(tracing);
    }

    @Override
    public Integer getInflightExchanges() {
        return (int)super.getExchangesInflight();
    }

    @Override
    public Integer getTotalRoutes() {
        return this.context.getRoutes().size();
    }

    @Override
    public Integer getStartedRoutes() {
        int started = 0;
        for (Route route : this.context.getRoutes()) {
            if (!this.context.getRouteStatus(route.getId()).isStarted()) continue;
            ++started;
        }
        return started;
    }

    @Override
    public void setTimeout(long timeout) {
        this.context.getShutdownStrategy().setTimeout(timeout);
    }

    @Override
    public long getTimeout() {
        return this.context.getShutdownStrategy().getTimeout();
    }

    @Override
    public void setTimeUnit(TimeUnit timeUnit) {
        this.context.getShutdownStrategy().setTimeUnit(timeUnit);
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.context.getShutdownStrategy().getTimeUnit();
    }

    @Override
    public void setShutdownNowOnTimeout(boolean shutdownNowOnTimeout) {
        this.context.getShutdownStrategy().setShutdownNowOnTimeout(shutdownNowOnTimeout);
    }

    @Override
    public boolean isShutdownNowOnTimeout() {
        return this.context.getShutdownStrategy().isShutdownNowOnTimeout();
    }

    @Override
    public String getLoad01() {
        double load1 = this.load.getLoad1();
        if (Double.isNaN(load1)) {
            return "";
        }
        return String.format("%.2f", load1);
    }

    @Override
    public String getLoad05() {
        double load5 = this.load.getLoad5();
        if (Double.isNaN(load5)) {
            return "";
        }
        return String.format("%.2f", load5);
    }

    @Override
    public String getLoad15() {
        double load15 = this.load.getLoad15();
        if (Double.isNaN(load15)) {
            return "";
        }
        return String.format("%.2f", load15);
    }

    @Override
    public boolean isUseBreadcrumb() {
        return this.context.isUseBreadcrumb();
    }

    @Override
    public boolean isAllowUseOriginalMessage() {
        return this.context.isAllowUseOriginalMessage();
    }

    @Override
    public boolean isMessageHistory() {
        return this.context.isMessageHistory() != null ? this.context.isMessageHistory() : false;
    }

    @Override
    public boolean isUseMDCLogging() {
        return this.context.isUseMDCLogging();
    }

    @Override
    public void onTimer() {
        this.load.update(this.getInflightExchanges());
    }

    @Override
    public void start() throws Exception {
        if (this.context.isSuspended()) {
            this.context.resume();
        } else {
            this.context.start();
        }
    }

    @Override
    public void stop() throws Exception {
        this.context.stop();
    }

    @Override
    public void restart() throws Exception {
        this.context.stop();
        this.context.start();
    }

    @Override
    public void suspend() throws Exception {
        this.context.suspend();
    }

    @Override
    public void resume() throws Exception {
        if (!this.context.isSuspended()) {
            throw new IllegalStateException("CamelContext is not suspended");
        }
        this.context.resume();
    }

    @Override
    public void startAllRoutes() throws Exception {
        this.context.startAllRoutes();
    }

    @Override
    public boolean canSendToEndpoint(String endpointUri) {
        try {
            Endpoint endpoint = this.context.getEndpoint(endpointUri);
            if (endpoint != null) {
                Producer producer = endpoint.createProducer();
                return producer != null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBody(String endpointUri, Object body) throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate();
        try {
            template.sendBody(endpointUri, body);
        }
        finally {
            template.stop();
        }
    }

    @Override
    public void sendStringBody(String endpointUri, String body) throws Exception {
        this.sendBody(endpointUri, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers) throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate();
        try {
            template.sendBodyAndHeaders(endpointUri, body, headers);
        }
        finally {
            template.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object requestBody(String endpointUri, Object body) throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate();
        Object answer = null;
        try {
            answer = template.requestBody(endpointUri, body);
        }
        finally {
            template.stop();
        }
        return answer;
    }

    @Override
    public Object requestStringBody(String endpointUri, String body) throws Exception {
        return this.requestBody(endpointUri, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object requestBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers) throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate();
        Object answer = null;
        try {
            answer = template.requestBodyAndHeaders(endpointUri, body, headers);
        }
        finally {
            template.stop();
        }
        return answer;
    }

    @Override
    public String dumpRestsAsXml() throws Exception {
        return this.dumpRestsAsXml(false);
    }

    @Override
    public String dumpRestsAsXml(boolean resolvePlaceholders) throws Exception {
        List<RestDefinition> rests = this.context.getRestDefinitions();
        if (rests.isEmpty()) {
            return null;
        }
        RestsDefinition def = new RestsDefinition();
        def.setRests(rests);
        String xml = ModelHelper.dumpModelAsXml(this.context, def);
        if (resolvePlaceholders) {
            final AtomicBoolean changed = new AtomicBoolean();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
            Document dom = XmlLineNumberParser.parseXml(is, new XmlLineNumberParser.XmlTextTransformer(){

                @Override
                public String transform(String text) {
                    try {
                        String after = ManagedCamelContext.this.getContext().resolvePropertyPlaceholders(text);
                        if (!changed.get()) {
                            changed.set(!text.equals(after));
                        }
                        return after;
                    }
                    catch (Exception e) {
                        return text;
                    }
                }
            });
            if (changed.get()) {
                xml = this.context.getTypeConverter().mandatoryConvertTo(String.class, dom);
                RestsDefinition copy = ModelHelper.createModelFromXml((CamelContext)this.context, xml, RestsDefinition.class);
                xml = ModelHelper.dumpModelAsXml(this.context, copy);
            }
        }
        return xml;
    }

    @Override
    public String dumpRoutesAsXml() throws Exception {
        return this.dumpRoutesAsXml(false);
    }

    @Override
    public String dumpRoutesAsXml(boolean resolvePlaceholders) throws Exception {
        List<RouteDefinition> routes = this.context.getRouteDefinitions();
        if (routes.isEmpty()) {
            return null;
        }
        RoutesDefinition def = new RoutesDefinition();
        def.setRoutes(routes);
        String xml = ModelHelper.dumpModelAsXml(this.context, def);
        if (resolvePlaceholders) {
            final AtomicBoolean changed = new AtomicBoolean();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
            Document dom = XmlLineNumberParser.parseXml(is, new XmlLineNumberParser.XmlTextTransformer(){

                @Override
                public String transform(String text) {
                    try {
                        String after = ManagedCamelContext.this.getContext().resolvePropertyPlaceholders(text);
                        if (!changed.get()) {
                            changed.set(!text.equals(after));
                        }
                        return after;
                    }
                    catch (Exception e) {
                        return text;
                    }
                }
            });
            if (changed.get()) {
                xml = this.context.getTypeConverter().mandatoryConvertTo(String.class, dom);
                RoutesDefinition copy = ModelHelper.createModelFromXml((CamelContext)this.context, xml, RoutesDefinition.class);
                xml = ModelHelper.dumpModelAsXml(this.context, copy);
            }
        }
        return xml;
    }

    @Override
    public void addOrUpdateRoutesFromXml(String xml) throws Exception {
        this.addOrUpdateRoutesFromXml(xml, false);
    }

    @Override
    public void addOrUpdateRoutesFromXml(String xml, boolean urlDecode) throws Exception {
        InputStream is;
        RoutesDefinition def;
        if (urlDecode) {
            xml = URLDecoder.decode(xml, "UTF-8");
        }
        if ((def = this.context.loadRoutesDefinition(is = this.context.getTypeConverter().mandatoryConvertTo(InputStream.class, xml))) == null) {
            return;
        }
        try {
            this.context.addRouteDefinitions(def.getRoutes());
        }
        catch (Exception e) {
            String msg = "Error updating routes from xml: " + xml + " due: " + e.getMessage();
            LOG.warn(msg, (Throwable)e);
            throw e;
        }
    }

    @Override
    public String dumpRoutesStatsAsXml(boolean fullStats, boolean includeProcessors) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<camelContextStat").append(String.format(" id=\"%s\" state=\"%s\"", this.getCamelId(), this.getState()));
        String stat = this.dumpStatsAsXml(fullStats);
        sb.append(" exchangesInflight=\"").append(this.getInflightExchanges()).append("\"");
        sb.append(" ").append(stat.substring(7, stat.length() - 2)).append(">\n");
        MBeanServer server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer();
        if (server != null) {
            String prefix = this.getContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
            ObjectName query = ObjectName.getInstance("org.apache.camel:context=" + prefix + this.getContext().getManagementName() + ",type=routes,*");
            Set<ObjectName> routes = server.queryNames(query, null);
            ArrayList<ManagedProcessorMBean> processors = new ArrayList<ManagedProcessorMBean>();
            if (includeProcessors) {
                query = ObjectName.getInstance("org.apache.camel:context=" + prefix + this.getContext().getManagementName() + ",type=processors,*");
                Set<ObjectName> names = server.queryNames(query, null);
                for (ObjectName on : names) {
                    ManagedProcessorMBean processor = this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedProcessorMBean.class);
                    processors.add(processor);
                }
            }
            Collections.sort(processors, new OrderProcessorMBeans());
            sb.append("  <routeStats>\n");
            for (ObjectName on : routes) {
                ManagedRouteMBean route = this.context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedRouteMBean.class);
                sb.append("    <routeStat").append(String.format(" id=\"%s\" state=\"%s\"", route.getRouteId(), route.getState()));
                stat = route.dumpStatsAsXml(fullStats);
                sb.append(" exchangesInflight=\"").append(route.getExchangesInflight()).append("\"");
                sb.append(" ").append(stat.substring(7, stat.length() - 2)).append(">\n");
                if (includeProcessors) {
                    sb.append("      <processorStats>\n");
                    for (ManagedProcessorMBean processor : processors) {
                        if (!route.getRouteId().equals(processor.getRouteId())) continue;
                        sb.append("        <processorStat").append(String.format(" id=\"%s\" index=\"%s\" state=\"%s\"", processor.getProcessorId(), processor.getIndex(), processor.getState()));
                        stat = processor.dumpStatsAsXml(fullStats);
                        sb.append(" exchangesInflight=\"").append(processor.getExchangesInflight()).append("\"");
                        sb.append(" ").append(stat.substring(7)).append("\n");
                    }
                    sb.append("      </processorStats>\n");
                }
                sb.append("    </routeStat>\n");
            }
            sb.append("  </routeStats>\n");
        }
        sb.append("</camelContextStat>");
        return sb.toString();
    }

    @Override
    public String dumpRoutesCoverageAsXml() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<camelContextRouteCoverage").append(String.format(" id=\"%s\" exchangesTotal=\"%s\" totalProcessingTime=\"%s\"", this.getCamelId(), this.getExchangesTotal(), this.getTotalProcessingTime())).append(">\n");
        String xml = this.dumpRoutesAsXml();
        if (xml != null) {
            Document dom = RouteCoverageXmlParser.parseXml(this.context, new ByteArrayInputStream(xml.getBytes()));
            String converted = this.context.getTypeConverter().convertTo(String.class, dom);
            sb.append(converted);
        }
        sb.append("\n</camelContextRouteCoverage>");
        return sb.toString();
    }

    @Override
    public boolean createEndpoint(String uri) throws Exception {
        if (this.context.hasEndpoint(uri) != null) {
            return false;
        }
        Endpoint endpoint = this.context.getEndpoint(uri);
        if (endpoint != null) {
            ObjectName on = this.context.getManagementStrategy().getManagementNamingStrategy().getObjectNameForEndpoint(endpoint);
            if (on != null && !this.context.getManagementStrategy().getManagementAgent().isRegistered(on)) {
                Object me = this.context.getManagementStrategy().getManagementObjectStrategy().getManagedObjectForEndpoint(this.context, endpoint);
                this.context.getManagementStrategy().getManagementAgent().register(me, on);
            }
            return true;
        }
        return false;
    }

    @Override
    public int removeEndpoints(String pattern) throws Exception {
        Collection<Endpoint> removed = this.context.removeEndpoints(pattern);
        return removed.size();
    }

    @Override
    public Map<String, Properties> findEips() throws Exception {
        return this.context.findEips();
    }

    @Override
    public List<String> findEipNames() throws Exception {
        Map<String, Properties> map = this.findEips();
        return new ArrayList<String>(map.keySet());
    }

    @Override
    public TabularData listEips() throws Exception {
        try {
            Map<String, Properties> eips = this.context.findEips();
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.listEipsTabularType());
            for (Map.Entry<String, Properties> entry : eips.entrySet()) {
                String name = entry.getKey();
                String title = (String)entry.getValue().get("title");
                String description = (String)entry.getValue().get("description");
                String label = (String)entry.getValue().get("label");
                String type = (String)entry.getValue().get("class");
                String status = CamelContextHelper.isEipInUse(this.context, name) ? "in use" : "on classpath";
                CompositeType ct = CamelOpenMBeanTypes.listEipsCompositeType();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"name", "title", "description", "label", "status", "type"}, new Object[]{name, title, description, label, status, type});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public Map<String, Properties> findComponents() throws Exception {
        Map<String, Properties> answer = this.context.findComponents();
        for (Map.Entry<String, Properties> entry : answer.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().remove("component");
            entry.getValue().remove("components");
        }
        return answer;
    }

    @Override
    public String getComponentDocumentation(String componentName) throws IOException {
        return this.context.getComponentDocumentation(componentName);
    }

    @Override
    public String createRouteStaticEndpointJson() {
        return this.createRouteStaticEndpointJson(true);
    }

    @Override
    public String createRouteStaticEndpointJson(boolean includeDynamic) {
        return this.context.createRouteStaticEndpointJson(null, includeDynamic);
    }

    @Override
    public List<String> findComponentNames() throws Exception {
        Map<String, Properties> map = this.findComponents();
        return new ArrayList<String>(map.keySet());
    }

    @Override
    public TabularData listComponents() throws Exception {
        try {
            Map<String, Properties> components = this.context.findComponents();
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.listComponentsTabularType());
            for (Map.Entry<String, Properties> entry : components.entrySet()) {
                String name = entry.getKey();
                String title = null;
                String description = null;
                String label = null;
                String status = this.context.hasComponent(name) != null ? "in use" : "on classpath";
                String type = (String)entry.getValue().get("class");
                String groupId = null;
                String artifactId = null;
                String version = null;
                String defaultName = this.context.resolveComponentDefaultName(type);
                String target = defaultName != null ? defaultName : name;
                String json = this.context.getComponentParameterJsonSchema(target);
                List<Map<String, String>> rows = JsonSchemaHelper.parseJsonSchema("component", json, false);
                for (Map<String, String> row : rows) {
                    if (row.containsKey("title")) {
                        title = row.get("title");
                        continue;
                    }
                    if (row.containsKey("description")) {
                        description = row.get("description");
                        continue;
                    }
                    if (row.containsKey("label")) {
                        label = row.get("label");
                        continue;
                    }
                    if (row.containsKey("javaType")) {
                        type = row.get("javaType");
                        continue;
                    }
                    if (row.containsKey("groupId")) {
                        groupId = row.get("groupId");
                        continue;
                    }
                    if (row.containsKey("artifactId")) {
                        artifactId = row.get("artifactId");
                        continue;
                    }
                    if (!row.containsKey("version")) continue;
                    version = row.get("version");
                }
                CompositeType ct = CamelOpenMBeanTypes.listComponentsCompositeType();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"name", "title", "description", "label", "status", "type", "groupId", "artifactId", "version"}, new Object[]{name, title, description, label, status, type, groupId, artifactId, version});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public List<String> completeEndpointPath(String componentName, Map<String, Object> endpointParameters, String completionText) throws Exception {
        Component component;
        if (completionText == null) {
            completionText = "";
        }
        if ((component = this.context.getComponent(componentName, false)) != null) {
            ComponentConfiguration configuration = component.createComponentConfiguration();
            configuration.setParameters(endpointParameters);
            return configuration.completeEndpointPath(completionText);
        }
        return new ArrayList<String>();
    }

    @Override
    public String componentParameterJsonSchema(String componentName) throws Exception {
        Component component;
        String json = this.context.getComponentParameterJsonSchema(componentName);
        if (json == null && (component = this.context.getComponent(componentName)) != null) {
            ComponentConfiguration configuration = component.createComponentConfiguration();
            json = configuration.createParameterJsonSchema();
        }
        return json;
    }

    @Override
    public String dataFormatParameterJsonSchema(String dataFormatName) throws Exception {
        return this.context.getDataFormatParameterJsonSchema(dataFormatName);
    }

    @Override
    public String languageParameterJsonSchema(String languageName) throws Exception {
        return this.context.getLanguageParameterJsonSchema(languageName);
    }

    @Override
    public String eipParameterJsonSchema(String eipName) throws Exception {
        return this.context.getEipParameterJsonSchema(eipName);
    }

    @Override
    public String explainEipJson(String nameOrId, boolean includeAllOptions) {
        return this.context.explainEipJson(nameOrId, includeAllOptions);
    }

    @Override
    public String explainComponentJson(String componentName, boolean includeAllOptions) throws Exception {
        return this.context.explainComponentJson(componentName, includeAllOptions);
    }

    @Override
    public String explainEndpointJson(String uri, boolean includeAllOptions) throws Exception {
        return this.context.explainEndpointJson(uri, includeAllOptions);
    }

    @Override
    public void reset(boolean includeRoutes) throws Exception {
        MBeanServer server;
        this.reset();
        if (includeRoutes && (server = this.getContext().getManagementStrategy().getManagementAgent().getMBeanServer()) != null) {
            String prefix = this.getContext().getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
            ObjectName query = ObjectName.getInstance("org.apache.camel:context=" + prefix + this.getContext().getManagementName() + ",type=routes,*");
            Set<ObjectName> names = server.queryNames(query, null);
            for (ObjectName name : names) {
                server.invoke(name, "reset", new Object[]{true}, new String[]{"boolean"});
            }
        }
    }

    private static final class OrderProcessorMBeans
    implements Comparator<ManagedProcessorMBean> {
        private OrderProcessorMBeans() {
        }

        @Override
        public int compare(ManagedProcessorMBean o1, ManagedProcessorMBean o2) {
            return o1.getIndex().compareTo(o2.getIndex());
        }
    }
}

