/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.maven.commons;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.ops4j.lang.NullArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenRepositoryURL {
    private static final Logger LOG = LoggerFactory.getLogger(MavenRepositoryURL.class);
    private final String m_id;
    private final URL m_repositoryURL;
    private final File m_file;
    private final boolean m_snapshotsEnabled;
    private final boolean m_releasesEnabled;
    private final boolean m_multi;

    public MavenRepositoryURL(String repositorySpec) throws MalformedURLException {
        NullArgumentException.validateNotEmpty(repositorySpec, true, "Repository spec");
        String[] segments = repositorySpec.split("@");
        StringBuilder urlBuilder = new StringBuilder();
        boolean snapshotEnabled = false;
        boolean releasesEnabled = true;
        boolean multi = false;
        String name = null;
        for (int i = 0; i < segments.length; ++i) {
            String segment = segments[i].trim();
            if (segment.equalsIgnoreCase("snapshots")) {
                snapshotEnabled = true;
                continue;
            }
            if (segment.equalsIgnoreCase("noreleases")) {
                releasesEnabled = false;
                continue;
            }
            if (segment.equalsIgnoreCase("multi")) {
                multi = true;
                continue;
            }
            if (segment.startsWith("id")) {
                try {
                    name = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (i > 0) {
                urlBuilder.append("@");
            }
            urlBuilder.append(segments[i]);
        }
        String spec = this.buildSpec(urlBuilder);
        this.m_repositoryURL = new URL(spec);
        this.m_snapshotsEnabled = snapshotEnabled;
        this.m_releasesEnabled = releasesEnabled;
        this.m_multi = multi;
        if (name == null) {
            String warn = "Repository spec " + spec + " does not contain an identifier. This is deprecated & discouraged & just evil.";
            LOG.warn(warn);
            name = "repo_" + spec.hashCode();
        }
        this.m_id = name;
        if (this.m_repositoryURL.getProtocol().equals("file")) {
            try {
                spec = spec.replaceAll("\\\\", "/");
                spec = spec.replaceAll(" ", "%20");
                URI uri = new URI(spec);
                String path = uri.getPath();
                if (path == null) {
                    path = uri.getSchemeSpecificPart();
                }
                this.m_file = new File(path);
            }
            catch (URISyntaxException e) {
                throw new MalformedURLException(e.getMessage());
            }
        } else {
            this.m_file = null;
        }
    }

    private String buildSpec(StringBuilder urlBuilder) {
        String spec = urlBuilder.toString().trim();
        if (!spec.endsWith("\\") && !spec.endsWith("/")) {
            spec = spec + "/";
        }
        return spec;
    }

    public String getId() {
        return this.m_id;
    }

    public URL getURL() {
        return this.m_repositoryURL;
    }

    public File getFile() {
        return this.m_file;
    }

    public boolean isReleasesEnabled() {
        return this.m_releasesEnabled;
    }

    public boolean isSnapshotsEnabled() {
        return this.m_snapshotsEnabled;
    }

    public boolean isMulti() {
        return this.m_multi;
    }

    public boolean isFileRepository() {
        return this.m_file != null;
    }

    public String toString() {
        return this.m_repositoryURL.toString() + ",releases=" + this.m_releasesEnabled + ",snapshots=" + this.m_snapshotsEnabled;
    }
}

