#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2017 Google
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)
# ----------------------------------------------------------------------------
#
#     ***     AUTO GENERATED CODE    ***    AUTO GENERATED CODE     ***
#
# ----------------------------------------------------------------------------
#
#     This file is automatically generated by Magic Modules and manual
#     changes will be clobbered when the file is regenerated.
#
#     Please read more about how to change this file at
#     https://www.github.com/GoogleCloudPlatform/magic-modules
#
# ----------------------------------------------------------------------------

from __future__ import absolute_import, division, print_function
__metaclass__ = type

################################################################################
# Documentation
################################################################################

ANSIBLE_METADATA = {'metadata_version': '1.1',
                    'status': ["preview"],
                    'supported_by': 'community'}

DOCUMENTATION = '''
---
module: gcp_compute_instance_template
description:
    - Defines an Instance Template resource that provides configuration settings for your
      virtual machine instances. Instance templates are not tied to the lifetime of an
      instance and can be used and reused as to deploy virtual machines. You can also
      use different templates to create different virtual machine configurations. Instance
      templates are required when you create a managed instance group.
    - 'Tip: Disks should be set to autoDelete=true so that leftover disks are not left
      behind on machine deletion.'
short_description: Creates a GCP InstanceTemplate
version_added: 2.6
author: Google Inc. (@googlecloudplatform)
requirements:
    - python >= 2.6
    - requests >= 2.18.4
    - google-auth >= 1.3.0
options:
    state:
        description:
            - Whether the given object should exist in GCP
        choices: ['present', 'absent']
        default: 'present'
    description:
        description:
            - An optional description of this resource. Provide this property when you create
              the resource.
        required: false
    name:
        description:
            - Name of the resource. The name is 1-63 characters long and complies with RFC1035.
        required: true
    properties:
        description:
            - The instance properties for this instance template.
        required: false
        suboptions:
            can_ip_forward:
                description:
                    - Enables instances created based on this template to send packets with source IP
                      addresses other than their own and receive packets with destination IP addresses
                      other than their own. If these instances will be used as an IP gateway or it will
                      be set as the next-hop in a Route resource, specify true. If unsure, leave this
                      set to false.
                required: false
                type: bool
            description:
                description:
                    - An optional text description for the instances that are created from this instance
                      template.
                required: false
            disks:
                description:
                    - An array of disks that are associated with the instances that are created from this
                      template.
                required: false
                suboptions:
                    auto_delete:
                        description:
                            - Specifies whether the disk will be auto-deleted when the instance is deleted (but
                              not when the disk is detached from the instance).
                            - 'Tip: Disks should be set to autoDelete=true so that leftover disks are not left
                              behind on machine deletion.'
                        required: false
                        type: bool
                    boot:
                        description:
                            - Indicates that this is a boot disk. The virtual machine will use the first partition
                              of the disk for its root filesystem.
                        required: false
                        type: bool
                    device_name:
                        description:
                            - Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-*
                              tree of a Linux operating system running within the instance. This name can be used
                              to reference the device for mounting, resizing, and so on, from within the instance.
                        required: false
                    disk_encryption_key:
                        description:
                            - Encrypts or decrypts a disk using a customer-supplied encryption key.
                        required: false
                        suboptions:
                            raw_key:
                                description:
                                    - Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64
                                      to either encrypt or decrypt this resource.
                                required: false
                            rsa_encrypted_key:
                                description:
                                    - Specifies an RFC 4648 base64 encoded, RSA-wrapped 2048-bit customer-supplied encryption
                                      key to either encrypt or decrypt this resource.
                                required: false
                            sha256:
                                description:
                                    - The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key
                                      that protects this resource.
                                required: false
                    index:
                        description:
                            - Assigns a zero-based index to this disk, where 0 is reserved for the boot disk.
                              For example, if you have many disks attached to an instance, each disk would have
                              a unique index number. If not specified, the server will choose an appropriate value.
                        required: false
                    initialize_params:
                        description:
                            - Specifies the parameters for a new disk that will be created alongside the new instance.
                              Use initialization parameters to create boot disks or local SSDs attached to the
                              new instance.
                        required: false
                        suboptions:
                            disk_name:
                                description:
                                    - Specifies the disk name. If not specified, the default is to use the name of the
                                      instance.
                                required: false
                            disk_size_gb:
                                description:
                                    - Specifies the size of the disk in base-2 GB.
                                required: false
                            disk_type:
                                description:
                                    - A reference to DiskType resource.
                                required: false
                            source_image:
                                description:
                                    - The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage
                                      or disks.source is required.  To create a disk with one of the public operating
                                      system images, specify the image by its family name.
                                required: false
                            source_image_encryption_key:
                                description:
                                    - The customer-supplied encryption key of the source image. Required if the source
                                      image is protected by a customer-supplied encryption key.
                                    - Instance templates do not store customer-supplied encryption keys, so you cannot
                                      create disks for instances in a managed instance group if the source images are
                                      encrypted with your own keys.
                                required: false
                                suboptions:
                                    raw_key:
                                        description:
                                            - Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64
                                              to either encrypt or decrypt this resource.
                                        required: false
                                    sha256:
                                        description:
                                            - The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key
                                              that protects this resource.
                                        required: false
                    interface:
                        description:
                            - Specifies the disk interface to use for attaching this disk, which is either SCSI
                              or NVME. The default is SCSI.
                            - Persistent disks must always use SCSI and the request will fail if you attempt to
                              attach a persistent disk in any other format than SCSI.
                        required: false
                        choices: ['SCSI', 'NVME']
                    mode:
                        description:
                            - The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified,
                              the default is to attach the disk in READ_WRITE mode.
                        required: false
                        choices: ['READ_WRITE', 'READ_ONLY']
                    source:
                        description:
                            - A reference to Disk resource.
                        required: false
                    type:
                        description:
                            - Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified,
                              the default is PERSISTENT.
                        required: false
                        choices: ['SCRATCH', 'PERSISTENT']
            machine_type:
                description:
                    - A reference to MachineType resource.
                required: true
            metadata:
                description:
                    - The metadata key/value pairs to assign to instances that are created from this template.
                      These pairs can consist of custom metadata or predefined keys.
                required: false
            guest_accelerators:
                description:
                    - List of the type and count of accelerator cards attached to the instance .
                required: false
                suboptions:
                    accelerator_count:
                        description:
                            - The number of the guest accelerator cards exposed to this instance.
                        required: false
                    accelerator_type:
                        description:
                            - Full or partial URL of the accelerator type resource to expose to this instance.
                        required: false
            network_interfaces:
                description:
                    - An array of configurations for this interface. This specifies how this interface
                      is configured to interact with other network services, such as connecting to the
                      internet. Only one network interface is supported per instance.
                required: false
                suboptions:
                    access_configs:
                        description:
                            - An array of configurations for this interface. Currently, only one access config,
                              ONE_TO_ONE_NAT, is supported. If there are no accessConfigs specified, then this
                              instance will have no external internet access.
                        required: false
                        suboptions:
                            name:
                                description:
                                    - The name of this access configuration. The default and recommended name is External
                                      NAT but you can use any arbitrary string you would like. For example, My external
                                      IP or Network Access.
                                required: true
                            nat_ip:
                                description:
                                    - A reference to Address resource.
                                required: true
                            type:
                                description:
                                    - The type of configuration. The default and only option is ONE_TO_ONE_NAT.
                                required: true
                                choices: ['ONE_TO_ONE_NAT']
                    alias_ip_ranges:
                        description:
                            - An array of alias IP ranges for this network interface. Can only be specified for
                              network interfaces on subnet-mode networks.
                        required: false
                        suboptions:
                            ip_cidr_range:
                                description:
                                    - The IP CIDR range represented by this alias IP range.
                                    - This IP CIDR range must belong to the specified subnetwork and cannot contain IP
                                      addresses reserved by system or used by other network interfaces. This range may
                                      be a single IP address (e.g. 10.2.3.4), a netmask (e.g. /24) or a CIDR format string
                                      (e.g. 10.1.2.0/24).
                                required: false
                            subnetwork_range_name:
                                description:
                                    - Optional subnetwork secondary range name specifying the secondary range from which
                                      to allocate the IP CIDR range for this alias IP range. If left unspecified, the
                                      primary range of the subnetwork will be used.
                                required: false
                    name:
                        description:
                            - The name of the network interface, generated by the server. For network devices,
                              these are eth0, eth1, etc .
                        required: false
                    network:
                        description:
                            - A reference to Network resource.
                        required: false
                    network_ip:
                        description:
                            - An IPv4 internal network address to assign to the instance for this network interface.
                              If not specified by the user, an unused internal IP is assigned by the system.
                        required: false
                    subnetwork:
                        description:
                            - A reference to Subnetwork resource.
                        required: false
            scheduling:
                description:
                    - Sets the scheduling options for this instance.
                required: false
                suboptions:
                    automatic_restart:
                        description:
                            - Specifies whether the instance should be automatically restarted if it is terminated
                              by Compute Engine (not terminated by a user).
                            - You can only set the automatic restart option for standard instances. Preemptible
                              instances cannot be automatically restarted.
                        required: false
                        type: bool
                    on_host_maintenance:
                        description:
                            - Defines the maintenance behavior for this instance. For standard instances, the
                              default behavior is MIGRATE. For preemptible instances, the default and only possible
                              behavior is TERMINATE.
                            - For more information, see Setting Instance Scheduling Options.
                        required: false
                    preemptible:
                        description:
                            - Defines whether the instance is preemptible. This can only be set during instance
                              creation, it cannot be set or changed after the instance has been created.
                        required: false
                        type: bool
            service_accounts:
                description:
                    - A list of service accounts, with their specified scopes, authorized for this instance.
                      Only one service account per VM instance is supported.
                required: false
                suboptions:
                    email:
                        description:
                            - Email address of the service account.
                        required: false
                        type: bool
                    scopes:
                        description:
                            - The list of scopes to be made available for this service account.
                        required: false
            tags:
                description:
                    - A list of tags to apply to this instance. Tags are used to identify valid sources
                      or targets for network firewalls and are specified by the client during instance
                      creation. The tags can be later modified by the setTags method. Each tag within
                      the list must comply with RFC1035.
                required: false
                suboptions:
                    fingerprint:
                        description:
                            - Specifies a fingerprint for this request, which is essentially a hash of the metadata's
                              contents and used for optimistic locking.
                            - The fingerprint is initially generated by Compute Engine and changes after every
                              request to modify or update metadata. You must always provide an up-to-date fingerprint
                              hash in order to update or change metadata.
                        required: false
                    items:
                        description:
                            - An array of tags. Each tag must be 1-63 characters long, and comply with RFC1035.
                        required: false
extends_documentation_fragment: gcp
'''

EXAMPLES = '''
- name: create a network
  gcp_compute_network:
      name: 'network-instancetemplate'
      project: "{{ gcp_project }}"
      auth_kind: "{{ gcp_cred_kind }}"
      service_account_file: "{{ gcp_cred_file }}"
      scopes:
        - https://www.googleapis.com/auth/compute
      state: present
  register: network
- name: create a address
  gcp_compute_address:
      name: 'address-instancetemplate'
      region: 'us-west1'
      project: "{{ gcp_project }}"
      auth_kind: "{{ gcp_cred_kind }}"
      service_account_file: "{{ gcp_cred_file }}"
      scopes:
        - https://www.googleapis.com/auth/compute
      state: present
  register: address
- name: create a instance template
  gcp_compute_instance_template:
      name: testObject
      properties:
        disks:
          - auto_delete: true
            boot: true
            initialize_params:
              source_image: 'projects/ubuntu-os-cloud/global/images/family/ubuntu-1604-lts'
        machine_type: n1-standard-1
        network_interfaces:
          - network: "{{ network }}"
            access_configs:
              - name: 'test-config'
                type: 'ONE_TO_ONE_NAT'
                nat_ip: "{{ address }}"
      project: testProject
      auth_kind: service_account
      service_account_file: /tmp/auth.pem
      scopes:
        - https://www.googleapis.com/auth/compute
      state: present
'''

RETURN = '''
    creation_timestamp:
        description:
            - Creation timestamp in RFC3339 text format.
        returned: success
        type: str
    description:
        description:
            - An optional description of this resource. Provide this property when you create
              the resource.
        returned: success
        type: str
    id:
        description:
            - The unique identifier for the resource. This identifier is defined by the server.
        returned: success
        type: int
    name:
        description:
            - Name of the resource. The name is 1-63 characters long and complies with RFC1035.
        returned: success
        type: str
    properties:
        description:
            - The instance properties for this instance template.
        returned: success
        type: complex
        contains:
            can_ip_forward:
                description:
                    - Enables instances created based on this template to send packets with source IP
                      addresses other than their own and receive packets with destination IP addresses
                      other than their own. If these instances will be used as an IP gateway or it will
                      be set as the next-hop in a Route resource, specify true. If unsure, leave this
                      set to false.
                returned: success
                type: bool
            description:
                description:
                    - An optional text description for the instances that are created from this instance
                      template.
                returned: success
                type: str
            disks:
                description:
                    - An array of disks that are associated with the instances that are created from this
                      template.
                returned: success
                type: complex
                contains:
                    auto_delete:
                        description:
                            - Specifies whether the disk will be auto-deleted when the instance is deleted (but
                              not when the disk is detached from the instance).
                            - 'Tip: Disks should be set to autoDelete=true so that leftover disks are not left
                              behind on machine deletion.'
                        returned: success
                        type: bool
                    boot:
                        description:
                            - Indicates that this is a boot disk. The virtual machine will use the first partition
                              of the disk for its root filesystem.
                        returned: success
                        type: bool
                    device_name:
                        description:
                            - Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-*
                              tree of a Linux operating system running within the instance. This name can be used
                              to reference the device for mounting, resizing, and so on, from within the instance.
                        returned: success
                        type: str
                    disk_encryption_key:
                        description:
                            - Encrypts or decrypts a disk using a customer-supplied encryption key.
                        returned: success
                        type: complex
                        contains:
                            raw_key:
                                description:
                                    - Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64
                                      to either encrypt or decrypt this resource.
                                returned: success
                                type: str
                            rsa_encrypted_key:
                                description:
                                    - Specifies an RFC 4648 base64 encoded, RSA-wrapped 2048-bit customer-supplied encryption
                                      key to either encrypt or decrypt this resource.
                                returned: success
                                type: str
                            sha256:
                                description:
                                    - The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key
                                      that protects this resource.
                                returned: success
                                type: str
                    index:
                        description:
                            - Assigns a zero-based index to this disk, where 0 is reserved for the boot disk.
                              For example, if you have many disks attached to an instance, each disk would have
                              a unique index number. If not specified, the server will choose an appropriate value.
                        returned: success
                        type: int
                    initialize_params:
                        description:
                            - Specifies the parameters for a new disk that will be created alongside the new instance.
                              Use initialization parameters to create boot disks or local SSDs attached to the
                              new instance.
                        returned: success
                        type: complex
                        contains:
                            disk_name:
                                description:
                                    - Specifies the disk name. If not specified, the default is to use the name of the
                                      instance.
                                returned: success
                                type: str
                            disk_size_gb:
                                description:
                                    - Specifies the size of the disk in base-2 GB.
                                returned: success
                                type: int
                            disk_type:
                                description:
                                    - A reference to DiskType resource.
                                returned: success
                                type: str
                            source_image:
                                description:
                                    - The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage
                                      or disks.source is required.  To create a disk with one of the public operating
                                      system images, specify the image by its family name.
                                returned: success
                                type: str
                            source_image_encryption_key:
                                description:
                                    - The customer-supplied encryption key of the source image. Required if the source
                                      image is protected by a customer-supplied encryption key.
                                    - Instance templates do not store customer-supplied encryption keys, so you cannot
                                      create disks for instances in a managed instance group if the source images are
                                      encrypted with your own keys.
                                returned: success
                                type: complex
                                contains:
                                    raw_key:
                                        description:
                                            - Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64
                                              to either encrypt or decrypt this resource.
                                        returned: success
                                        type: str
                                    sha256:
                                        description:
                                            - The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key
                                              that protects this resource.
                                        returned: success
                                        type: str
                    interface:
                        description:
                            - Specifies the disk interface to use for attaching this disk, which is either SCSI
                              or NVME. The default is SCSI.
                            - Persistent disks must always use SCSI and the request will fail if you attempt to
                              attach a persistent disk in any other format than SCSI.
                        returned: success
                        type: str
                    mode:
                        description:
                            - The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified,
                              the default is to attach the disk in READ_WRITE mode.
                        returned: success
                        type: str
                    source:
                        description:
                            - A reference to Disk resource.
                        returned: success
                        type: dict
                    type:
                        description:
                            - Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified,
                              the default is PERSISTENT.
                        returned: success
                        type: str
            machine_type:
                description:
                    - A reference to MachineType resource.
                returned: success
                type: str
            metadata:
                description:
                    - The metadata key/value pairs to assign to instances that are created from this template.
                      These pairs can consist of custom metadata or predefined keys.
                returned: success
                type: dict
            guest_accelerators:
                description:
                    - List of the type and count of accelerator cards attached to the instance .
                returned: success
                type: complex
                contains:
                    accelerator_count:
                        description:
                            - The number of the guest accelerator cards exposed to this instance.
                        returned: success
                        type: int
                    accelerator_type:
                        description:
                            - Full or partial URL of the accelerator type resource to expose to this instance.
                        returned: success
                        type: str
            network_interfaces:
                description:
                    - An array of configurations for this interface. This specifies how this interface
                      is configured to interact with other network services, such as connecting to the
                      internet. Only one network interface is supported per instance.
                returned: success
                type: complex
                contains:
                    access_configs:
                        description:
                            - An array of configurations for this interface. Currently, only one access config,
                              ONE_TO_ONE_NAT, is supported. If there are no accessConfigs specified, then this
                              instance will have no external internet access.
                        returned: success
                        type: complex
                        contains:
                            name:
                                description:
                                    - The name of this access configuration. The default and recommended name is External
                                      NAT but you can use any arbitrary string you would like. For example, My external
                                      IP or Network Access.
                                returned: success
                                type: str
                            nat_ip:
                                description:
                                    - A reference to Address resource.
                                returned: success
                                type: dict
                            type:
                                description:
                                    - The type of configuration. The default and only option is ONE_TO_ONE_NAT.
                                returned: success
                                type: str
                    alias_ip_ranges:
                        description:
                            - An array of alias IP ranges for this network interface. Can only be specified for
                              network interfaces on subnet-mode networks.
                        returned: success
                        type: complex
                        contains:
                            ip_cidr_range:
                                description:
                                    - The IP CIDR range represented by this alias IP range.
                                    - This IP CIDR range must belong to the specified subnetwork and cannot contain IP
                                      addresses reserved by system or used by other network interfaces. This range may
                                      be a single IP address (e.g. 10.2.3.4), a netmask (e.g. /24) or a CIDR format string
                                      (e.g. 10.1.2.0/24).
                                returned: success
                                type: str
                            subnetwork_range_name:
                                description:
                                    - Optional subnetwork secondary range name specifying the secondary range from which
                                      to allocate the IP CIDR range for this alias IP range. If left unspecified, the
                                      primary range of the subnetwork will be used.
                                returned: success
                                type: str
                    name:
                        description:
                            - The name of the network interface, generated by the server. For network devices,
                              these are eth0, eth1, etc .
                        returned: success
                        type: str
                    network:
                        description:
                            - A reference to Network resource.
                        returned: success
                        type: dict
                    network_ip:
                        description:
                            - An IPv4 internal network address to assign to the instance for this network interface.
                              If not specified by the user, an unused internal IP is assigned by the system.
                        returned: success
                        type: str
                    subnetwork:
                        description:
                            - A reference to Subnetwork resource.
                        returned: success
                        type: dict
            scheduling:
                description:
                    - Sets the scheduling options for this instance.
                returned: success
                type: complex
                contains:
                    automatic_restart:
                        description:
                            - Specifies whether the instance should be automatically restarted if it is terminated
                              by Compute Engine (not terminated by a user).
                            - You can only set the automatic restart option for standard instances. Preemptible
                              instances cannot be automatically restarted.
                        returned: success
                        type: bool
                    on_host_maintenance:
                        description:
                            - Defines the maintenance behavior for this instance. For standard instances, the
                              default behavior is MIGRATE. For preemptible instances, the default and only possible
                              behavior is TERMINATE.
                            - For more information, see Setting Instance Scheduling Options.
                        returned: success
                        type: str
                    preemptible:
                        description:
                            - Defines whether the instance is preemptible. This can only be set during instance
                              creation, it cannot be set or changed after the instance has been created.
                        returned: success
                        type: bool
            service_accounts:
                description:
                    - A list of service accounts, with their specified scopes, authorized for this instance.
                      Only one service account per VM instance is supported.
                returned: success
                type: complex
                contains:
                    email:
                        description:
                            - Email address of the service account.
                        returned: success
                        type: bool
                    scopes:
                        description:
                            - The list of scopes to be made available for this service account.
                        returned: success
                        type: list
            tags:
                description:
                    - A list of tags to apply to this instance. Tags are used to identify valid sources
                      or targets for network firewalls and are specified by the client during instance
                      creation. The tags can be later modified by the setTags method. Each tag within
                      the list must comply with RFC1035.
                returned: success
                type: complex
                contains:
                    fingerprint:
                        description:
                            - Specifies a fingerprint for this request, which is essentially a hash of the metadata's
                              contents and used for optimistic locking.
                            - The fingerprint is initially generated by Compute Engine and changes after every
                              request to modify or update metadata. You must always provide an up-to-date fingerprint
                              hash in order to update or change metadata.
                        returned: success
                        type: str
                    items:
                        description:
                            - An array of tags. Each tag must be 1-63 characters long, and comply with RFC1035.
                        returned: success
                        type: list
'''

################################################################################
# Imports
################################################################################

from ansible.module_utils.gcp_utils import navigate_hash, GcpSession, GcpModule, GcpRequest, remove_nones_from_dict, replace_resource_dict
import json
import re
import time

################################################################################
# Main
################################################################################


def main():
    """Main function"""

    module = GcpModule(
        argument_spec=dict(
            state=dict(default='present', choices=['present', 'absent'], type='str'),
            description=dict(type='str'),
            name=dict(required=True, type='str'),
            properties=dict(type='dict', options=dict(
                can_ip_forward=dict(type='bool'),
                description=dict(type='str'),
                disks=dict(type='list', elements='dict', options=dict(
                    auto_delete=dict(type='bool'),
                    boot=dict(type='bool'),
                    device_name=dict(type='str'),
                    disk_encryption_key=dict(type='dict', options=dict(
                        raw_key=dict(type='str'),
                        rsa_encrypted_key=dict(type='str'),
                        sha256=dict(type='str')
                    )),
                    index=dict(type='int'),
                    initialize_params=dict(type='dict', options=dict(
                        disk_name=dict(type='str'),
                        disk_size_gb=dict(type='int'),
                        disk_type=dict(type='str'),
                        source_image=dict(type='str'),
                        source_image_encryption_key=dict(type='dict', options=dict(
                            raw_key=dict(type='str'),
                            sha256=dict(type='str')
                        ))
                    )),
                    interface=dict(type='str', choices=['SCSI', 'NVME']),
                    mode=dict(type='str', choices=['READ_WRITE', 'READ_ONLY']),
                    source=dict(type='dict'),
                    type=dict(type='str', choices=['SCRATCH', 'PERSISTENT'])
                )),
                machine_type=dict(required=True, type='str'),
                metadata=dict(type='dict'),
                guest_accelerators=dict(type='list', elements='dict', options=dict(
                    accelerator_count=dict(type='int'),
                    accelerator_type=dict(type='str')
                )),
                network_interfaces=dict(type='list', elements='dict', options=dict(
                    access_configs=dict(type='list', elements='dict', options=dict(
                        name=dict(required=True, type='str'),
                        nat_ip=dict(required=True, type='dict'),
                        type=dict(required=True, type='str', choices=['ONE_TO_ONE_NAT'])
                    )),
                    alias_ip_ranges=dict(type='list', elements='dict', options=dict(
                        ip_cidr_range=dict(type='str'),
                        subnetwork_range_name=dict(type='str')
                    )),
                    name=dict(type='str'),
                    network=dict(type='dict'),
                    network_ip=dict(type='str'),
                    subnetwork=dict(type='dict')
                )),
                scheduling=dict(type='dict', options=dict(
                    automatic_restart=dict(type='bool'),
                    on_host_maintenance=dict(type='str'),
                    preemptible=dict(type='bool')
                )),
                service_accounts=dict(type='list', elements='dict', options=dict(
                    email=dict(type='bool'),
                    scopes=dict(type='list', elements='str')
                )),
                tags=dict(type='dict', options=dict(
                    fingerprint=dict(type='str'),
                    items=dict(type='list', elements='str')
                ))
            ))
        )
    )

    state = module.params['state']
    kind = 'compute#instanceTemplate'

    fetch = fetch_resource(module, self_link(module), kind)
    changed = False

    if fetch:
        if state == 'present':
            if is_different(module, fetch):
                fetch = update(module, self_link(module), kind, fetch)
                changed = True
        else:
            delete(module, self_link(module), kind, fetch)
            fetch = {}
            changed = True
    else:
        if state == 'present':
            fetch = create(module, collection(module), kind)
            changed = True
        else:
            fetch = {}

    fetch.update({'changed': changed})

    module.exit_json(**fetch)


def create(module, link, kind):
    auth = GcpSession(module, 'compute')
    return wait_for_operation(module, auth.post(link, resource_to_request(module)))


def update(module, link, kind, fetch):
    auth = GcpSession(module, 'compute')
    return wait_for_operation(module, auth.put(link, resource_to_request(module)))


def delete(module, link, kind, fetch):
    auth = GcpSession(module, 'compute')
    return wait_for_operation(module, auth.delete(link))


def resource_to_request(module):
    request = {
        u'kind': 'compute#instanceTemplate',
        u'description': module.params.get('description'),
        u'name': module.params.get('name'),
        u'properties': InstancTemplatPropert(module.params.get('properties', {}), module).to_request()
    }
    request = encode_request(request, module)
    return_vals = {}
    for k, v in request.items():
        if v:
            return_vals[k] = v

    return return_vals


def fetch_resource(module, link, kind):
    auth = GcpSession(module, 'compute')
    return return_if_object(module, auth.get(link), kind)


def self_link(module):
    return "https://www.googleapis.com/compute/v1/projects/{project}/global/instanceTemplates/{name}".format(**module.params)


def collection(module):
    return "https://www.googleapis.com/compute/v1/projects/{project}/global/instanceTemplates".format(**module.params)


def return_if_object(module, response, kind):
    # If not found, return nothing.
    if response.status_code == 404:
        return None

    # If no content, return nothing.
    if response.status_code == 204:
        return None

    try:
        module.raise_for_status(response)
        result = response.json()
    except getattr(json.decoder, 'JSONDecodeError', ValueError) as inst:
        module.fail_json(msg="Invalid JSON response with error: %s" % inst)

    result = decode_response(result, module)

    if navigate_hash(result, ['error', 'errors']):
        module.fail_json(msg=navigate_hash(result, ['error', 'errors']))
    if result['kind'] != kind:
        module.fail_json(msg="Incorrect result: {kind}".format(**result))

    return result


def is_different(module, response):
    request = resource_to_request(module)
    response = response_to_hash(module, response)
    request = decode_response(request, module)

    # Remove all output-only from response.
    response_vals = {}
    for k, v in response.items():
        if k in request:
            response_vals[k] = v

    request_vals = {}
    for k, v in request.items():
        if k in response:
            request_vals[k] = v

    return GcpRequest(request_vals) != GcpRequest(response_vals)


# Remove unnecessary properties from the response.
# This is for doing comparisons with Ansible's current parameters.
def response_to_hash(module, response):
    return {
        u'creationTimestamp': response.get(u'creationTimestamp'),
        u'description': response.get(u'description'),
        u'id': response.get(u'id'),
        u'name': response.get(u'name'),
        u'properties': InstancTemplatPropert(response.get(u'properties', {}), module).from_response()
    }


def disk_type_selflink(name, params):
    if name is None:
        return
    url = r"https://www.googleapis.com/compute/v1/projects/.*/zones/{zone}/diskTypes/[a-z1-9\-]*"
    if not re.match(url, name):
        name = "https://www.googleapis.com/compute/v1/projects/{project}/zones/{zone}/diskTypes/%s".format(**params) % name
    return name


def async_op_url(module, extra_data=None):
    if extra_data is None:
        extra_data = {}
    url = "https://www.googleapis.com/compute/v1/projects/{project}/global/operations/{op_id}"
    combined = extra_data.copy()
    combined.update(module.params)
    return url.format(**combined)


def wait_for_operation(module, response):
    op_result = return_if_object(module, response, 'compute#operation')
    if op_result is None:
        return None
    status = navigate_hash(op_result, ['status'])
    wait_done = wait_for_completion(status, op_result, module)
    return fetch_resource(module, navigate_hash(wait_done, ['targetLink']), 'compute#instanceTemplate')


def wait_for_completion(status, op_result, module):
    op_id = navigate_hash(op_result, ['name'])
    op_uri = async_op_url(module, {'op_id': op_id})
    while status != 'DONE':
        raise_if_errors(op_result, ['error', 'errors'], 'message')
        time.sleep(1.0)
        if status not in ['PENDING', 'RUNNING', 'DONE']:
            module.fail_json(msg="Invalid result %s" % status)
        op_result = fetch_resource(module, op_uri, 'compute#operation')
        status = navigate_hash(op_result, ['status'])
    return op_result


def raise_if_errors(response, err_path, module):
    errors = navigate_hash(response, err_path)
    if errors is not None:
        module.fail_json(msg=errors)


def encode_request(request, module):
    if 'metadata' in request:
        request['metadata'] = metadata_encoder(request['metadata'])
    return request


def decode_response(response, module):
    if 'metadata' in response:
        response['metadata'] = metadata_decoder(response['metadata'])
    return response


# TODO(alexstephen): Implement updating metadata on exsiting resources.

# Expose instance 'metadata' as a simple name/value pair hash. However the API
# defines metadata as a NestedObject with the following layout:
#
# metadata {
#   fingerprint: 'hash-of-last-metadata'
#   items: [
#     {
#       key: 'metadata1-key'
#       value: 'metadata1-value'
#     },
#     ...
#   ]
# }
#
def metadata_encoder(metadata):
    metadata_new = []
    for key in metadata:
        value = metadata[key]
        metadata_new.append({key: value})
    return {
        'items': metadata_new
    }


# Map metadata.items[]{key:,value:} => metadata[key]=value
def metadata_decoder(metadata):
    items = {}
    if 'items' in metadata:
        metadata_items = metadata['items']
        for item in metadata_items:
            items[item.keys()[0]] = item[item.keys()[0]]
    return items


class InstancTemplatPropert(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = {}

    def to_request(self):
        return remove_nones_from_dict({
            u'canIpForward': self.request.get('can_ip_forward'),
            u'description': self.request.get('description'),
            u'disks': InstancTemplatDisksArray(self.request.get('disks', []), self.module).to_request(),
            u'machineType': self.request.get('machine_type'),
            u'metadata': self.request.get('metadata'),
            u'guestAccelerators': InstaTemplGuestAccelArray(self.request.get('guest_accelerators', []), self.module).to_request(),
            u'networkInterfaces': InstaTemplNetwoInterArray(self.request.get('network_interfaces', []), self.module).to_request(),
            u'scheduling': InstancTemplatSchedul(self.request.get('scheduling', {}), self.module).to_request(),
            u'serviceAccounts': InstaTemplServiAccouArray(self.request.get('service_accounts', []), self.module).to_request(),
            u'tags': InstancTemplatTags(self.request.get('tags', {}), self.module).to_request()
        })

    def from_response(self):
        return remove_nones_from_dict({
            u'canIpForward': self.request.get(u'canIpForward'),
            u'description': self.request.get(u'description'),
            u'disks': InstancTemplatDisksArray(self.request.get(u'disks', []), self.module).from_response(),
            u'machineType': self.request.get(u'machineType'),
            u'metadata': self.request.get(u'metadata'),
            u'guestAccelerators': InstaTemplGuestAccelArray(self.request.get(u'guestAccelerators', []), self.module).from_response(),
            u'networkInterfaces': InstaTemplNetwoInterArray(self.request.get(u'networkInterfaces', []), self.module).from_response(),
            u'scheduling': InstancTemplatSchedul(self.request.get(u'scheduling', {}), self.module).from_response(),
            u'serviceAccounts': InstaTemplServiAccouArray(self.request.get(u'serviceAccounts', []), self.module).from_response(),
            u'tags': InstancTemplatTags(self.request.get(u'tags', {}), self.module).from_response()
        })


class InstancTemplatDisksArray(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = []

    def to_request(self):
        items = []
        for item in self.request:
            items.append(self._request_for_item(item))
        return items

    def from_response(self):
        items = []
        for item in self.request:
            items.append(self._response_from_item(item))
        return items

    def _request_for_item(self, item):
        return remove_nones_from_dict({
            u'autoDelete': item.get('auto_delete'),
            u'boot': item.get('boot'),
            u'deviceName': item.get('device_name'),
            u'diskEncryptionKey': InstTempDiskEncrKey(item.get('disk_encryption_key', {}), self.module).to_request(),
            u'index': item.get('index'),
            u'initializeParams': InstaTemplInitiParam(item.get('initialize_params', {}), self.module).to_request(),
            u'interface': item.get('interface'),
            u'mode': item.get('mode'),
            u'source': replace_resource_dict(item.get(u'source', {}), 'name'),
            u'type': item.get('type')
        })

    def _response_from_item(self, item):
        return remove_nones_from_dict({
            u'autoDelete': item.get(u'autoDelete'),
            u'boot': item.get(u'boot'),
            u'deviceName': item.get(u'deviceName'),
            u'diskEncryptionKey': InstTempDiskEncrKey(item.get(u'diskEncryptionKey', {}), self.module).from_response(),
            u'index': item.get(u'index'),
            u'initializeParams': InstaTemplInitiParam(self.module.params.get('initialize_params', {}), self.module).to_request(),
            u'interface': item.get(u'interface'),
            u'mode': item.get(u'mode'),
            u'source': item.get(u'source'),
            u'type': item.get(u'type')
        })


class InstTempDiskEncrKey(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = {}

    def to_request(self):
        return remove_nones_from_dict({
            u'rawKey': self.request.get('raw_key'),
            u'rsaEncryptedKey': self.request.get('rsa_encrypted_key'),
            u'sha256': self.request.get('sha256')
        })

    def from_response(self):
        return remove_nones_from_dict({
            u'rawKey': self.request.get(u'rawKey'),
            u'rsaEncryptedKey': self.request.get(u'rsaEncryptedKey'),
            u'sha256': self.request.get(u'sha256')
        })


class InstaTemplInitiParam(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = {}

    def to_request(self):
        return remove_nones_from_dict({
            u'diskName': self.request.get('disk_name'),
            u'diskSizeGb': self.request.get('disk_size_gb'),
            u'diskType': disk_type_selflink(self.request.get('disk_type'), self.module.params),
            u'sourceImage': self.request.get('source_image'),
            u'sourceImageEncryptionKey': InsTemSouImaEncKey(self.request.get('source_image_encryption_key', {}), self.module).to_request()
        })

    def from_response(self):
        return remove_nones_from_dict({
            u'diskName': self.request.get(u'diskName'),
            u'diskSizeGb': self.request.get(u'diskSizeGb'),
            u'diskType': self.request.get(u'diskType'),
            u'sourceImage': self.request.get(u'sourceImage'),
            u'sourceImageEncryptionKey': InsTemSouImaEncKey(self.request.get(u'sourceImageEncryptionKey', {}), self.module).from_response()
        })


class InsTemSouImaEncKey(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = {}

    def to_request(self):
        return remove_nones_from_dict({
            u'rawKey': self.request.get('raw_key'),
            u'sha256': self.request.get('sha256')
        })

    def from_response(self):
        return remove_nones_from_dict({
            u'rawKey': self.request.get(u'rawKey'),
            u'sha256': self.request.get(u'sha256')
        })


class InstaTemplGuestAccelArray(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = []

    def to_request(self):
        items = []
        for item in self.request:
            items.append(self._request_for_item(item))
        return items

    def from_response(self):
        items = []
        for item in self.request:
            items.append(self._response_from_item(item))
        return items

    def _request_for_item(self, item):
        return remove_nones_from_dict({
            u'acceleratorCount': item.get('accelerator_count'),
            u'acceleratorType': item.get('accelerator_type')
        })

    def _response_from_item(self, item):
        return remove_nones_from_dict({
            u'acceleratorCount': item.get(u'acceleratorCount'),
            u'acceleratorType': item.get(u'acceleratorType')
        })


class InstaTemplNetwoInterArray(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = []

    def to_request(self):
        items = []
        for item in self.request:
            items.append(self._request_for_item(item))
        return items

    def from_response(self):
        items = []
        for item in self.request:
            items.append(self._response_from_item(item))
        return items

    def _request_for_item(self, item):
        return remove_nones_from_dict({
            u'accessConfigs': InstaTemplAccesConfiArray(item.get('access_configs', []), self.module).to_request(),
            u'aliasIpRanges': InstTempAliaIpRangArray(item.get('alias_ip_ranges', []), self.module).to_request(),
            u'name': item.get('name'),
            u'network': replace_resource_dict(item.get(u'network', {}), 'selfLink'),
            u'networkIP': item.get('network_ip'),
            u'subnetwork': replace_resource_dict(item.get(u'subnetwork', {}), 'selfLink')
        })

    def _response_from_item(self, item):
        return remove_nones_from_dict({
            u'accessConfigs': InstaTemplAccesConfiArray(item.get(u'accessConfigs', []), self.module).from_response(),
            u'aliasIpRanges': InstTempAliaIpRangArray(item.get(u'aliasIpRanges', []), self.module).from_response(),
            u'name': item.get(u'name'),
            u'network': item.get(u'network'),
            u'networkIP': item.get(u'networkIP'),
            u'subnetwork': item.get(u'subnetwork')
        })


class InstaTemplAccesConfiArray(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = []

    def to_request(self):
        items = []
        for item in self.request:
            items.append(self._request_for_item(item))
        return items

    def from_response(self):
        items = []
        for item in self.request:
            items.append(self._response_from_item(item))
        return items

    def _request_for_item(self, item):
        return remove_nones_from_dict({
            u'name': item.get('name'),
            u'natIP': replace_resource_dict(item.get(u'nat_ip', {}), 'address'),
            u'type': item.get('type')
        })

    def _response_from_item(self, item):
        return remove_nones_from_dict({
            u'name': item.get(u'name'),
            u'natIP': item.get(u'natIP'),
            u'type': item.get(u'type')
        })


class InstTempAliaIpRangArray(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = []

    def to_request(self):
        items = []
        for item in self.request:
            items.append(self._request_for_item(item))
        return items

    def from_response(self):
        items = []
        for item in self.request:
            items.append(self._response_from_item(item))
        return items

    def _request_for_item(self, item):
        return remove_nones_from_dict({
            u'ipCidrRange': item.get('ip_cidr_range'),
            u'subnetworkRangeName': item.get('subnetwork_range_name')
        })

    def _response_from_item(self, item):
        return remove_nones_from_dict({
            u'ipCidrRange': item.get(u'ipCidrRange'),
            u'subnetworkRangeName': item.get(u'subnetworkRangeName')
        })


class InstancTemplatSchedul(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = {}

    def to_request(self):
        return remove_nones_from_dict({
            u'automaticRestart': self.request.get('automatic_restart'),
            u'onHostMaintenance': self.request.get('on_host_maintenance'),
            u'preemptible': self.request.get('preemptible')
        })

    def from_response(self):
        return remove_nones_from_dict({
            u'automaticRestart': self.request.get(u'automaticRestart'),
            u'onHostMaintenance': self.request.get(u'onHostMaintenance'),
            u'preemptible': self.request.get(u'preemptible')
        })


class InstaTemplServiAccouArray(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = []

    def to_request(self):
        items = []
        for item in self.request:
            items.append(self._request_for_item(item))
        return items

    def from_response(self):
        items = []
        for item in self.request:
            items.append(self._response_from_item(item))
        return items

    def _request_for_item(self, item):
        return remove_nones_from_dict({
            u'email': item.get('email'),
            u'scopes': item.get('scopes')
        })

    def _response_from_item(self, item):
        return remove_nones_from_dict({
            u'email': item.get(u'email'),
            u'scopes': item.get(u'scopes')
        })


class InstancTemplatTags(object):
    def __init__(self, request, module):
        self.module = module
        if request:
            self.request = request
        else:
            self.request = {}

    def to_request(self):
        return remove_nones_from_dict({
            u'fingerprint': self.request.get('fingerprint'),
            u'items': self.request.get('items')
        })

    def from_response(self):
        return remove_nones_from_dict({
            u'fingerprint': self.request.get(u'fingerprint'),
            u'items': self.request.get(u'items')
        })

if __name__ == '__main__':
    main()
