<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_cache_disk - Serveur HTTP Apache Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur HTTP Apache Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_cache_disk</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_cache_disk.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_cache_disk.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_cache_disk.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_cache_disk.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Module de stockage sur disque pour le filtre de mise en
cache HTTP.</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>cache_disk_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_cache_disk.c</td></tr></table>
<h3>Sommaire</h3>

    <p><code class="module"><a href="../mod/mod_cache_disk.html">mod_cache_disk</a></code> implmente un gestionnaire de
    stockage sur disque pour le module <code class="module"><a href="../mod/mod_cache.html">mod_cache</a></code>.</p>

    <p>Les en-ttes et corps des rponses mises en cache sont stocks
    sparment sur le disque, dans une structure de rpertoires base
    sur le condens md5 de l'URL mise en cache.</p>

    <p>Plusieurs rponses au contenu ngoci peuvent tre stockes en
    mme temps, mais la mise en cache de contenus partiels n'est pas
    supporte actuellement par ce module.</p>

    <p>Les mises  jour atomiques du cache pour les fichiers d'en-tte
    et de corps peuvent tre effectues sans verrouillage en
    enregistrant les numros d'inode et de priphrique du fichier de
    corps dans le fichier d'en-tte. Ceci implique que les entres du
    cache dplaces manuellement dans le cache seront ignores.</p>

    <p>L'utilitaire <code class="program"><a href="../programs/htcacheclean.html">htcacheclean</a></code> permet de lister et
    de supprimer les URLs du cache, ou de maintenir le cache en de de
    certaines limites de taille et/ou de nombre d'inodes. L'utilitaire
    peut tre excut  la demande, ou automatiquement pour assurer un
    contrle continu des tailles des rpertoires.</p>

    <div class="note"><h3>Note :</h3>
      <p><code class="module"><a href="../mod/mod_cache.html">mod_cache</a></code> doit tre charg avant
      <code class="module"><a href="../mod/mod_cache_disk.html">mod_cache_disk</a></code> pour que ce dernier puisse
      fonctionner.</p>
    </div>
    <div class="note"><h3>Note :</h3>
    <p>Lorsque la plate-forme la supporte, et si elle est active via la
    directive <code class="directive"><a href="../mod/core.html#enablesendfile">EnableSendfile</a></code>,
    <code class="module"><a href="../mod/mod_cache_disk.html">mod_cache_disk</a></code> utilise la fonctionnalit sendfile
    pour servir les fichiers  partir du cache. Cependant,
    <code class="module"><a href="../mod/mod_cache_disk.html">mod_cache_disk</a></code> ignore la configuration de la
    directive <code class="directive"><a href="../mod/core.html#enablesendfile">EnableSendfile</a></code> dans
    un contexte de rpertoire ou de fichier .htaccess, car le module ne
    dispose pas des dfinitions correspondantes lorsque la requte est
    servie depuis le cache.</p>
    </div>
</div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#cachedirlength">CacheDirLength</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cachedirlevels">CacheDirLevels</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cachemaxfilesize">CacheMaxFileSize</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cacheminfilesize">CacheMinFileSize</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cachereadsize">CacheReadSize</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cachereadtime">CacheReadTime</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cacheroot">CacheRoot</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mod_cache_disk">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mod_cache_disk">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="module"><a href="../mod/mod_cache.html">mod_cache</a></code></li>
<li><code class="module"><a href="../mod/mod_cache_socache.html">mod_cache_socache</a></code></li>
<li><a href="../caching.html">Guide de la mise en cache</a></li>
<li><a href="#comments_section">Commentaires</a></li></ul></div>

<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="cachedirlength" id="cachedirlength">Directive</a> <a name="CacheDirLength" id="CacheDirLength">CacheDirLength</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Le nombre de caractres des noms des
sous-rpertoires</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheDirLength <var>longueur</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheDirLength 2</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache_disk</td></tr>
</table>
    <p>la directive <code class="directive">CacheDirLength</code> permet de
    dfinir le nombre de caractres que comportera chaque nom de
    sous-rpertoire de la hirarchie du cache. On peut l'utiliser en
    conjonction avec <code class="directive">CacheDirLevels</code> pour
    dterminer une structure approximative de la hirarchie de
    cache.</p>
    <p>Une valeur haute pour <code class="directive">CacheDirLength</code>
    combine avec une valeur basse pour
    <code class="directive">CacheDirLevels</code> gnrera une hirarchie
    relativement peu profonde, avec un grand nombre de sous-rpertoires
     chaque niveau.</p>

    <div class="note">
      <p>La valeur du produit <code class="directive">CacheDirLevels</code> *
      <code class="directive"><a href="#cachedirlength">CacheDirLength</a></code> ne
      doit pas dpasser 20.</p>
    </div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="cachedirlevels" id="cachedirlevels">Directive</a> <a name="CacheDirLevels" id="CacheDirLevels">CacheDirLevels</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Le nombre de niveaux de sous-rpertoires que comportera le
cache.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheDirLevels <var>niveaux</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheDirLevels 2</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache_disk</td></tr>
</table>
    <p>La directive <code class="directive">CacheDirLevels</code> permet de
    dfinir le nombre de niveaux de sous-rpertoires que comportera le
    cache. Les donnes du cache seront stokes au niveau correspondant
    par rapport au rpertoire <code class="directive"><a href="#cacheroot">CacheRoot</a></code>.</p>
    <p>Une valeur haute pour <code class="directive">CacheDirLevels</code>
    combine avec une valeur basse pour
    <code class="directive">CacheDirLength</code> gnrera une arborescence
    trs dveloppe, avec un petit nombre de sous-rpertoires  chaque
    niveau.</p>

    <div class="note">
      <p>La valeur du produit <code class="directive">CacheDirLevels</code> *
      <code class="directive"><a href="#cachedirlength">CacheDirLength</a></code> ne
      doit pas dpasser 20.</p>
    </div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="cachemaxfilesize" id="cachemaxfilesize">Directive</a> <a name="CacheMaxFileSize" id="CacheMaxFileSize">CacheMaxFileSize</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>&gt;La taille maximale (en octets) d'un document pour pouvoir
tre stock dans le cache</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheMaxFileSize <var>octets</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheMaxFileSize 1000000</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache_disk</td></tr>
</table>
    <p>La directive <code class="directive">CacheMaxFileSize</code> permet de
    dfinir la taille maximale d'un document, en octets, pour que
    celui-ci puisse faire l'objet d'un stockage dans le cache.</p>

    <pre class="prettyprint lang-config">CacheMaxFileSize 64000</pre>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="cacheminfilesize" id="cacheminfilesize">Directive</a> <a name="CacheMinFileSize" id="CacheMinFileSize">CacheMinFileSize</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>La taille minimale (en octets) d'un document pour pouvoir
tre stock dans le cache</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheMinFileSize <var>octets</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheMinFileSize 1</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache_disk</td></tr>
</table>
    <p>La directive <code class="directive">CacheMinFileSize</code> permet de
    dfinir la taille minimale d'un document, en octets, pour que
    celui-ci puisse faire l'objet d'un stockage dans le cache.</p>

    <pre class="prettyprint lang-config">CacheMinFileSize 64</pre>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="cachereadsize" id="cachereadsize">Directive</a> <a name="CacheReadSize" id="CacheReadSize">CacheReadSize</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>La quantit minimale (en octets) de donnes  lire et 
mettre en cache avant de les envoyer au client</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheReadSize <var>octets</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheReadSize 0</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache_disk</td></tr>
</table>
    <p>La directive <code class="directive">CacheReadSize</code> permet de
    dfinir la quantit minimale de donnes, en octets,  lire depuis le
    serveur d'arrire-plan avant de les envoyer au client. Avec la
    valeur par dfaut zro, toute donne de toutes tailles est envoye
    au client ds qu'elle est disponible. Avec une valeur non nulle, le
    cache disque met en tampon au moins la quantit de donnes
    correspondante avant d'envoyer la rponse au client. Les
    performances peuvent s'en trouver amliores lorsqu'on met en cache
    du contenu en provenance d'un mandataire inverse.</p>

    <p>Cette directive ne prend effet que lorsque les donnes sont
    enregistres dans le cache, et non lorsque les donnes sont servies 
    partir du cache.</p>
  
    <pre class="prettyprint lang-config">CacheReadSize 102400</pre>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="cachereadtime" id="cachereadtime">Directive</a> <a name="CacheReadTime" id="CacheReadTime">CacheReadTime</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Le temps minimum (en millisecondes) qui doit s'couler
avant d'envoyer les donnes au client</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheReadTime <var>millisecondes</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheReadTime 0</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache_disk</td></tr>
</table>
    <p>La directive <code class="directive">CacheReadTime</code> permet de
    dfinir le temps minimum qui doit s'couler avant d'essayer
    d'envoyer des donnes au client. Pendant ce temps, les donnes sont
    mises en tampon avant de pouvoir tre envoyes au client. Les
    performances peuvent s'en trouver amliores lorsqu'on met en cache
    du contenu en provenance d'un mandataire inverse.</p>

    <p>La valeur par dfaut zro dsactive cette option.</p>

    <p>Cette directive ne prend effet que lorsque les donnes sont
    enregistres dans le cache, et non lorsque les donnes sont servies 
    partir du cache. Il est recommand d'harmoniser l'utilisation de cette
    directive avec celle de la directive <code class="directive"><a href="#cachereadsize">CacheReadSize</a></code>, afin de s'assurer
    que le serveur n'effectue pas une mise en tampon excessive au cas
    o les donnes arriveraient plus vite que prvu.</p>

    <pre class="prettyprint lang-config">CacheReadTime 1000</pre>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="cacheroot" id="cacheroot">Directive</a> <a name="CacheRoot" id="CacheRoot">CacheRoot</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>La racine du rpertoire dans lequel les fichiers du cache
seront stocks</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheRoot <var>rpertoire</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache_disk</td></tr>
</table>
    <p>La directive <code class="directive">CacheRoot</code> permet de dfinir
    le nom du rpertoire sur disque qui contiendra les fichiers du
    cache. Si le module <code class="module"><a href="../mod/mod_cache_disk.html">mod_cache_disk</a></code> a t charg ou
    compil dans le serveur Apache, cette directive <em>doit</em> tre
    dfinie. L'absence de dfinition de la directive
    <code class="directive">CacheRoot</code> provoquera une erreur de traitement
    du fichier de configuration. Les directives <code class="directive"><a href="#cachedirlevels">CacheDirLevels</a></code> et <code class="directive"><a href="#cachedirlength">CacheDirLength</a></code> permettent de
    dfinir la structure des sous-rpertoires du rpertoire racine
    spcifi.</p>

    <pre class="prettyprint lang-config">CacheRoot c:/cacheroot</pre>


</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_cache_disk.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_cache_disk.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_cache_disk.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_cache_disk.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_cache_disk.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2018 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>