/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.NoneSuggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.PolicyHelper;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.UnsupportedSuggester;
import org.apache.solr.cloud.autoscaling.ActionContext;
import org.apache.solr.cloud.autoscaling.TriggerActionBase;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.cloud.autoscaling.TriggerUtils;
import org.apache.solr.cloud.autoscaling.TriggerValidationException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputePlanAction
extends TriggerActionBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Set<String> collections = new HashSet<String>();
    private static final String START = "__start__";

    public ComputePlanAction() {
        TriggerUtils.validProperties(this.validProperties, "collections");
    }

    @Override
    public void configure(SolrResourceLoader loader, SolrCloudManager cloudManager, Map<String, Object> properties) throws TriggerValidationException {
        super.configure(loader, cloudManager, properties);
        String colString = (String)properties.get("collections");
        if (colString != null && !colString.isEmpty()) {
            this.collections.addAll(StrUtils.splitSmart((String)colString, (char)','));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(TriggerEvent event, ActionContext context) throws Exception {
        log.debug("-- processing event: {} with context properties: {}", (Object)event, context.getProperties());
        SolrCloudManager cloudManager = context.getCloudManager();
        try {
            AutoScalingConfig autoScalingConf = cloudManager.getDistribStateManager().getAutoScalingConfig();
            if (autoScalingConf.isEmpty()) {
                throw new Exception("Action: " + this.getName() + " executed but no policy is configured");
            }
            PolicyHelper.SessionWrapper sessionWrapper = PolicyHelper.getSession((SolrCloudManager)cloudManager);
            Policy.Session session = sessionWrapper.get();
            ClusterState clusterState = cloudManager.getClusterStateProvider().getClusterState();
            if (log.isTraceEnabled()) {
                log.trace("-- session: {}", (Object)session);
                log.trace("-- state: {}", (Object)clusterState);
            }
            try {
                Suggester suggester = this.getSuggester(session, event, context, cloudManager);
                int maxOperations = this.getMaxNumOps(event, autoScalingConf, clusterState);
                int requestedOperations = this.getRequestedNumOps(event);
                if (requestedOperations > maxOperations) {
                    log.warn("Requested number of operations {} higher than maximum {}, adjusting...", (Object)requestedOperations, (Object)maxOperations);
                }
                int opCount = 0;
                int opLimit = maxOperations;
                if (requestedOperations > 0) {
                    opLimit = requestedOperations;
                }
                do {
                    String coll;
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException("stopping - thread was interrupted");
                    }
                    SolrRequest operation = suggester.getSuggestion();
                    ++opCount;
                    if (suggester.getSession() != null) {
                        session = suggester.getSession();
                    }
                    suggester = this.getSuggester(session, event, context, cloudManager);
                    if (operation == null) {
                        if (requestedOperations < 0) {
                            break;
                        }
                        log.info("Computed plan empty, remained " + (opCount - opLimit) + " requested ops to try.");
                        continue;
                    }
                    log.info("Computed Plan: {}", (Object)operation.getParams());
                    if (!this.collections.isEmpty() && (coll = operation.getParams().get("collection")) != null && !this.collections.contains(coll)) {
                        log.debug("-- discarding due to collection={} not in {}", (Object)coll, this.collections);
                        continue;
                    }
                    Map<String, Object> props = context.getProperties();
                    props.compute("operations", (k, v) -> {
                        ArrayList<SolrRequest> operations = (ArrayList<SolrRequest>)v;
                        if (operations == null) {
                            operations = new ArrayList<SolrRequest>();
                        }
                        operations.add(operation);
                        return operations;
                    });
                } while (opCount < opLimit);
            }
            finally {
                this.releasePolicySession(sessionWrapper, session);
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected exception while processing event: " + event, (Throwable)e);
        }
    }

    private void releasePolicySession(PolicyHelper.SessionWrapper sessionWrapper, Policy.Session session) {
        sessionWrapper.returnSession(session);
        sessionWrapper.release();
    }

    protected int getMaxNumOps(TriggerEvent event, AutoScalingConfig autoScalingConfig, ClusterState clusterState) {
        AtomicInteger totalRF = new AtomicInteger();
        clusterState.forEachCollection(coll -> {
            Integer rf = coll.getReplicationFactor();
            if (rf == null) {
                rf = coll.getReplicas().size() / coll.getSlices().size();
            }
            totalRF.addAndGet(rf * coll.getSlices().size());
        });
        int totalMax = clusterState.getLiveNodes().size() * totalRF.get() * 3;
        int maxOp = autoScalingConfig.getProperties().getOrDefault("maxComputeOperations", totalMax);
        Object o = event.getProperty("maxComputeOperations", maxOp);
        try {
            return Integer.parseInt(String.valueOf(o));
        }
        catch (Exception e) {
            log.warn("Invalid 'maxComputeOperations' event property: " + o + ", using default " + maxOp);
            return maxOp;
        }
    }

    protected int getRequestedNumOps(TriggerEvent event) {
        Collection ops = (Collection)event.getProperty("requestedOps", Collections.emptyList());
        if (ops.isEmpty()) {
            return -1;
        }
        return ops.size();
    }

    protected Suggester getSuggester(Policy.Session session, TriggerEvent event, ActionContext context, SolrCloudManager cloudManager) throws IOException {
        Suggester suggester;
        block0 : switch (event.getEventType()) {
            case NODEADDED: {
                suggester = this.getNodeAddedSuggester(cloudManager, session, event);
                break;
            }
            case NODELOST: {
                String preferredOp = (String)event.getProperty("preferredOperation", CollectionParams.CollectionAction.MOVEREPLICA.toLower());
                CollectionParams.CollectionAction action = CollectionParams.CollectionAction.get((String)preferredOp);
                switch (action) {
                    case MOVEREPLICA: {
                        suggester = session.getSuggester(action).hint(Suggester.Hint.SRC_NODE, event.getProperty("nodeNames"));
                        break block0;
                    }
                    case DELETENODE: {
                        int start = (Integer)event.getProperty(START, 0);
                        List srcNodes = (List)event.getProperty("nodeNames");
                        if (srcNodes.isEmpty() || start >= srcNodes.size()) {
                            return NoneSuggester.get((Policy.Session)session);
                        }
                        String sourceNode = (String)srcNodes.get(start);
                        suggester = session.getSuggester(action).hint(Suggester.Hint.SRC_NODE, Collections.singletonList(sourceNode));
                        event.getProperties().put(START, ++start);
                        break block0;
                    }
                    case NONE: {
                        return NoneSuggester.get((Policy.Session)session);
                    }
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unsupported preferredOperation: " + action.toLower() + " specified for node lost trigger");
            }
            case SEARCHRATE: 
            case METRIC: 
            case INDEXSIZE: {
                List ops = (List)event.getProperty("requestedOps", Collections.emptyList());
                int start = (Integer)event.getProperty(START, 0);
                if (ops.isEmpty() || start >= ops.size()) {
                    return NoneSuggester.get((Policy.Session)session);
                }
                TriggerEvent.Op op = (TriggerEvent.Op)ops.get(start);
                suggester = session.getSuggester(op.getAction());
                if (suggester instanceof UnsupportedSuggester) {
                    List unsupportedOps = (List)context.getProperties().computeIfAbsent("unsupportedOps", k -> new ArrayList());
                    unsupportedOps.add(op);
                }
                for (Map.Entry<Suggester.Hint, Object> e : op.getHints().entrySet()) {
                    suggester = suggester.hint(e.getKey(), e.getValue());
                }
                suggester = suggester.forceOperation(true);
                event.getProperties().put(START, ++start);
                break;
            }
            case SCHEDULED: {
                String preferredOp = (String)event.getProperty("preferredOperation", CollectionParams.CollectionAction.MOVEREPLICA.toLower());
                CollectionParams.CollectionAction action = CollectionParams.CollectionAction.get((String)preferredOp);
                suggester = session.getSuggester(action);
                break;
            }
            default: {
                throw new UnsupportedOperationException("No support for events other than nodeAdded, nodeLost, searchRate, metric, scheduled and indexSize. Received: " + event.getEventType());
            }
        }
        return suggester;
    }

    private Suggester getNodeAddedSuggester(SolrCloudManager cloudManager, Policy.Session session, TriggerEvent event) throws IOException {
        String preferredOp = (String)event.getProperty("preferredOperation", CollectionParams.CollectionAction.MOVEREPLICA.toLower());
        CollectionParams.CollectionAction action = CollectionParams.CollectionAction.get((String)preferredOp);
        Suggester suggester = session.getSuggester(action).hint(Suggester.Hint.TARGET_NODE, event.getProperty("nodeNames"));
        switch (action) {
            case ADDREPLICA: {
                ClusterState clusterState = cloudManager.getClusterStateProvider().getClusterState();
                HashSet collShards = new HashSet();
                clusterState.getCollectionStates().forEach((collectionName, collectionRef) -> {
                    DocCollection docCollection = collectionRef.get();
                    if (docCollection != null) {
                        docCollection.getActiveSlices().stream().map(slice -> new Pair(collectionName, (Object)slice.getName())).forEach(collShards::add);
                    }
                });
                suggester.hint(Suggester.Hint.COLL_SHARD, collShards);
                break;
            }
            case MOVEREPLICA: 
            case NONE: {
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unsupported preferredOperation=" + preferredOp + " for node added event");
            }
        }
        return suggester;
    }
}

