/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryUtils;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.LuceneTestCase;
import org.junit.Assert;

public class CheckHits {
    public static float EXPLAIN_SCORE_TOLERANCE_DELTA = 0.001f;
    public static float EXPLAIN_SCORE_TOLERANCE_MINIMUM = 1.0E-6f;

    public static void checkNoMatchExplanations(Query q, String defaultFieldName, IndexSearcher searcher, int[] results) throws IOException {
        String d = q.toString(defaultFieldName);
        TreeSet<Integer> ignore = new TreeSet<Integer>();
        for (int i = 0; i < results.length; ++i) {
            ignore.add(results[i]);
        }
        int maxDoc = searcher.getIndexReader().maxDoc();
        for (int doc = 0; doc < maxDoc; ++doc) {
            if (ignore.contains(doc)) continue;
            Explanation exp = searcher.explain(q, doc);
            junit.framework.Assert.assertNotNull((String)("Explanation of [[" + d + "]] for #" + doc + " is null"), (Object)exp);
            junit.framework.Assert.assertFalse((String)("Explanation of [[" + d + "]] for #" + doc + " doesn't indicate non-match: " + exp.toString()), (boolean)exp.isMatch());
        }
    }

    public static void checkHitCollector(Random random, Query query, String defaultFieldName, IndexSearcher searcher, int[] results) throws IOException {
        QueryUtils.check(random, query, searcher);
        TreeSet<Integer> correct = new TreeSet<Integer>();
        for (int i = 0; i < results.length; ++i) {
            correct.add(results[i]);
        }
        TreeSet<Integer> actual = new TreeSet<Integer>();
        SetCollector c = new SetCollector(actual);
        searcher.search(query, (Collector)c);
        junit.framework.Assert.assertEquals((String)("Simple: " + query.toString(defaultFieldName)), correct, actual);
        for (int i = -1; i < 2; ++i) {
            actual.clear();
            IndexSearcher s = QueryUtils.wrapUnderlyingReader(random, searcher, i);
            s.search(query, (Collector)c);
            junit.framework.Assert.assertEquals((String)("Wrap Reader " + i + ": " + query.toString(defaultFieldName)), correct, actual);
        }
    }

    public static void checkHits(Random random, Query query, String defaultFieldName, IndexSearcher searcher, int[] results) throws IOException {
        ScoreDoc[] hits = searcher.search((Query)query, (int)1000).scoreDocs;
        TreeSet<Integer> correct = new TreeSet<Integer>();
        for (int i = 0; i < results.length; ++i) {
            correct.add(results[i]);
        }
        TreeSet<Integer> actual = new TreeSet<Integer>();
        for (int i = 0; i < hits.length; ++i) {
            actual.add(hits[i].doc);
        }
        junit.framework.Assert.assertEquals((String)query.toString(defaultFieldName), correct, actual);
        QueryUtils.check(random, query, searcher, LuceneTestCase.rarely(random));
    }

    public static void checkDocIds(String mes, int[] results, ScoreDoc[] hits) {
        junit.framework.Assert.assertEquals((String)(mes + " nr of hits"), (int)hits.length, (int)results.length);
        for (int i = 0; i < results.length; ++i) {
            junit.framework.Assert.assertEquals((String)(mes + " doc nrs for hit " + i), (int)results[i], (int)hits[i].doc);
        }
    }

    public static void checkHitsQuery(Query query, ScoreDoc[] hits1, ScoreDoc[] hits2, int[] results) {
        CheckHits.checkDocIds("hits1", results, hits1);
        CheckHits.checkDocIds("hits2", results, hits2);
        CheckHits.checkEqual(query, hits1, hits2);
    }

    public static void checkEqual(Query query, ScoreDoc[] hits1, ScoreDoc[] hits2) {
        float scoreTolerance = 1.0E-6f;
        if (hits1.length != hits2.length) {
            junit.framework.Assert.fail((String)("Unequal lengths: hits1=" + hits1.length + ",hits2=" + hits2.length));
        }
        for (int i = 0; i < hits1.length; ++i) {
            if (hits1[i].doc != hits2[i].doc) {
                junit.framework.Assert.fail((String)("Hit " + i + " docnumbers don't match\n" + CheckHits.hits2str(hits1, hits2, 0, 0) + "for query:" + query.toString()));
            }
            if (hits1[i].doc == hits2[i].doc && !(Math.abs(hits1[i].score - hits2[i].score) > 1.0E-6f)) continue;
            junit.framework.Assert.fail((String)("Hit " + i + ", doc nrs " + hits1[i].doc + " and " + hits2[i].doc + "\nunequal       : " + hits1[i].score + "\n           and: " + hits2[i].score + "\nfor query:" + query.toString()));
        }
    }

    public static String hits2str(ScoreDoc[] hits1, ScoreDoc[] hits2, int start, int end) {
        int len2;
        StringBuilder sb = new StringBuilder();
        int len1 = hits1 == null ? 0 : hits1.length;
        int n = len2 = hits2 == null ? 0 : hits2.length;
        if (end <= 0) {
            end = Math.max(len1, len2);
        }
        sb.append("Hits length1=").append(len1).append("\tlength2=").append(len2);
        sb.append('\n');
        for (int i = start; i < end; ++i) {
            sb.append("hit=").append(i).append(':');
            if (i < len1) {
                sb.append(" doc").append(hits1[i].doc).append('=').append(hits1[i].score);
            } else {
                sb.append("               ");
            }
            sb.append(",\t");
            if (i < len2) {
                sb.append(" doc").append(hits2[i].doc).append('=').append(hits2[i].score);
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String topdocsString(TopDocs docs, int start, int end) {
        StringBuilder sb = new StringBuilder();
        sb.append("TopDocs totalHits=").append(docs.totalHits).append(" top=").append(docs.scoreDocs.length).append('\n');
        end = end <= 0 ? docs.scoreDocs.length : Math.min(end, docs.scoreDocs.length);
        for (int i = start; i < end; ++i) {
            sb.append('\t');
            sb.append(i);
            sb.append(") doc=");
            sb.append(docs.scoreDocs[i].doc);
            sb.append("\tscore=");
            sb.append(docs.scoreDocs[i].score);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static void checkExplanations(Query query, String defaultFieldName, IndexSearcher searcher) throws IOException {
        CheckHits.checkExplanations(query, defaultFieldName, searcher, false);
    }

    public static void checkExplanations(Query query, String defaultFieldName, IndexSearcher searcher, boolean deep) throws IOException {
        searcher.search(query, (Collector)new ExplanationAsserter(query, defaultFieldName, searcher, deep));
    }

    public static float explainToleranceDelta(float f1, float f2) {
        return Math.max(EXPLAIN_SCORE_TOLERANCE_MINIMUM, Math.max(Math.abs(f1), Math.abs(f2)) * EXPLAIN_SCORE_TOLERANCE_DELTA);
    }

    public static void checkMatches(Query query, IndexSearcher searcher) throws IOException {
        searcher.search(query, (Collector)new MatchesAsserter(query, searcher));
    }

    public static void verifyExplanation(String q, int doc, float score, boolean deep, Explanation expl) {
        float value = expl.getValue();
        junit.framework.Assert.assertEquals((String)(q + ": score(doc=" + doc + ")=" + score + " != explanationScore=" + value + " Explanation: " + expl), (float)score, (float)value, (float)CheckHits.explainToleranceDelta(score, value));
        if (!deep) {
            return;
        }
        Explanation[] detail = expl.getDetails();
        if (expl.getDescription().endsWith("computed from:")) {
            return;
        }
        String descr = expl.getDescription().toLowerCase(Locale.ROOT);
        if (descr.startsWith("score based on ") && descr.contains("child docs in range")) {
            junit.framework.Assert.assertTrue((String)"Child doc explanations are missing", (detail.length > 0 ? 1 : 0) != 0);
        }
        if (detail.length > 0) {
            if (detail.length == 1) {
                if (!(expl.getDescription().endsWith("with freq of:") || !(score >= 0.0f) && expl.getDescription().endsWith("times others of:"))) {
                    CheckHits.verifyExplanation(q, doc, score, deep, detail[0]);
                }
            } else {
                int k1;
                float x = 0.0f;
                boolean productOf = descr.endsWith("product of:");
                boolean sumOf = descr.endsWith("sum of:");
                boolean maxOf = descr.endsWith("max of:");
                boolean computedOf = descr.matches(".*, computed as .* from:");
                boolean maxTimesOthers = false;
                if (!(productOf || sumOf || maxOf || computedOf || (k1 = descr.indexOf("max plus ")) < 0)) {
                    int k2 = descr.indexOf(" ", k1 += "max plus ".length());
                    try {
                        x = Float.parseFloat(descr.substring(k1, k2).trim());
                        if (descr.substring(k2).trim().equals("times others of:")) {
                            maxTimesOthers = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                junit.framework.Assert.assertTrue((String)(q + ": multi valued explanation description=\"" + descr + "\" must be 'max of plus x times others', 'computed as x from:' or end with 'product of' or 'sum of:' or 'max of:' - " + expl), (productOf || sumOf || maxOf || computedOf || maxTimesOthers ? 1 : 0) != 0);
                float sum = 0.0f;
                float product = 1.0f;
                float max = 0.0f;
                for (int i = 0; i < detail.length; ++i) {
                    float dval = detail[i].getValue();
                    CheckHits.verifyExplanation(q, doc, dval, deep, detail[i]);
                    product *= dval;
                    sum += dval;
                    max = Math.max(max, dval);
                }
                float combined = 0.0f;
                if (productOf) {
                    combined = product;
                } else if (sumOf) {
                    combined = sum;
                } else if (maxOf) {
                    combined = max;
                } else if (maxTimesOthers) {
                    combined = max + x * (sum - max);
                } else {
                    junit.framework.Assert.assertTrue((String)"should never get here!", (boolean)computedOf);
                    combined = value;
                }
                junit.framework.Assert.assertEquals((String)(q + ": actual subDetails combined==" + combined + " != value=" + value + " Explanation: " + expl), (float)combined, (float)value, (float)CheckHits.explainToleranceDelta(combined, value));
            }
        }
    }

    public static class MatchesAsserter
    extends SimpleCollector {
        private final Weight weight;
        private LeafReaderContext context;
        int lastCheckedDoc = -1;

        public MatchesAsserter(Query query, IndexSearcher searcher) throws IOException {
            this.weight = searcher.createWeight(searcher.rewrite(query), false, 1.0f);
        }

        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.context = context;
            this.lastCheckedDoc = -1;
        }

        public void collect(int doc) throws IOException {
            Matches matches = this.weight.matches(this.context, doc);
            junit.framework.Assert.assertNotNull((String)("Unexpected null Matches object in doc" + doc + " for query " + this.weight.getQuery()), (Object)matches);
            if (this.lastCheckedDoc != doc - 1) {
                Assert.assertNull((String)("Unexpected non-null Matches object in non-matching doc" + doc + " for query " + this.weight.getQuery()), (Object)this.weight.matches(this.context, doc - 1));
            }
            this.lastCheckedDoc = doc;
        }

        public boolean needsScores() {
            return false;
        }
    }

    public static class ExplanationAsserter
    extends SimpleCollector {
        Query q;
        IndexSearcher s;
        String d;
        boolean deep;
        Scorer scorer;
        private int base = 0;

        public ExplanationAsserter(Query q, String defaultFieldName, IndexSearcher s) {
            this(q, defaultFieldName, s, false);
        }

        public ExplanationAsserter(Query q, String defaultFieldName, IndexSearcher s, boolean deep) {
            this.q = q;
            this.s = s;
            this.d = q.toString(defaultFieldName);
            this.deep = deep;
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        public void collect(int doc) throws IOException {
            Explanation exp = null;
            doc += this.base;
            try {
                exp = this.s.explain(this.q, doc);
            }
            catch (IOException e) {
                throw new RuntimeException("exception in hitcollector of [[" + this.d + "]] for #" + doc, e);
            }
            junit.framework.Assert.assertNotNull((String)("Explanation of [[" + this.d + "]] for #" + doc + " is null"), (Object)exp);
            CheckHits.verifyExplanation(this.d, doc, this.scorer.score(), this.deep, exp);
            junit.framework.Assert.assertTrue((String)("Explanation of [[" + this.d + "]] for #" + doc + " does not indicate match: " + exp.toString()), (boolean)exp.isMatch());
        }

        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.base = context.docBase;
        }

        public boolean needsScores() {
            return true;
        }
    }

    public static class ExplanationAssertingSearcher
    extends IndexSearcher {
        public ExplanationAssertingSearcher(IndexReader r) {
            super(r);
        }

        protected void checkExplanations(Query q) throws IOException {
            super.search(q, (Collector)new ExplanationAsserter(q, null, this));
        }

        public TopFieldDocs search(Query query, int n, Sort sort) throws IOException {
            this.checkExplanations(query);
            return super.search(query, n, sort);
        }

        public void search(Query query, Collector results) throws IOException {
            this.checkExplanations(query);
            super.search(query, results);
        }

        public TopDocs search(Query query, int n) throws IOException {
            this.checkExplanations(query);
            return super.search(query, n);
        }
    }

    public static class SetCollector
    extends SimpleCollector {
        final Set<Integer> bag;
        private int base = 0;

        public SetCollector(Set<Integer> bag) {
            this.bag = bag;
        }

        public void setScorer(Scorer scorer) throws IOException {
        }

        public void collect(int doc) {
            this.bag.add(doc + this.base);
        }

        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.base = context.docBase;
        }

        public boolean needsScores() {
            return false;
        }
    }
}

