/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.mahout.math.matrix.impl;

import org.carrot2.mahout.math.function.DoubleDoubleFunction;
import org.carrot2.mahout.math.function.DoubleFunction;
import org.carrot2.mahout.math.function.Functions;
import org.carrot2.mahout.math.function.IntDoubleProcedure;
import org.carrot2.mahout.math.function.IntIntDoubleFunction;
import org.carrot2.mahout.math.function.Mult;
import org.carrot2.mahout.math.function.PlusMult;
import org.carrot2.mahout.math.map.AbstractIntDoubleMap;
import org.carrot2.mahout.math.map.OpenIntDoubleHashMap;
import org.carrot2.mahout.math.matrix.DoubleMatrix1D;
import org.carrot2.mahout.math.matrix.DoubleMatrix2D;
import org.carrot2.mahout.math.matrix.impl.DenseDoubleMatrix1D;
import org.carrot2.mahout.math.matrix.impl.DenseDoubleMatrix2D;
import org.carrot2.mahout.math.matrix.impl.SelectedSparseDoubleMatrix2D;
import org.carrot2.mahout.math.matrix.impl.SparseDoubleMatrix1D;

public final class SparseDoubleMatrix2D
extends DoubleMatrix2D {
    final AbstractIntDoubleMap elements;

    public SparseDoubleMatrix2D(double[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public SparseDoubleMatrix2D(int rows, int columns) {
        this(rows, columns, rows * (columns / 1000), 0.2, 0.5);
    }

    public SparseDoubleMatrix2D(int rows, int columns, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(rows, columns);
        this.elements = new OpenIntDoubleHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    @Override
    public DoubleMatrix2D assign(double value) {
        if (this.isNoView && value == 0.0) {
            this.elements.clear();
        } else {
            super.assign(value);
        }
        return this;
    }

    @Override
    public void assign(DoubleFunction function) {
        if (this.isNoView && function instanceof Mult) {
            this.elements.assign(function);
        } else {
            super.assign(function);
        }
    }

    @Override
    public DoubleMatrix2D assign(DoubleMatrix2D source) {
        if (!(source instanceof SparseDoubleMatrix2D)) {
            return super.assign(source);
        }
        SparseDoubleMatrix2D other = (SparseDoubleMatrix2D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.isNoView && other.isNoView) {
            this.elements.assign(other.elements);
            return this;
        }
        return super.assign(source);
    }

    @Override
    public DoubleMatrix2D assign(final DoubleMatrix2D y, DoubleDoubleFunction function) {
        if (!this.isNoView) {
            return super.assign(y, function);
        }
        this.checkShape(y);
        if (function instanceof PlusMult) {
            final double alpha = ((PlusMult)function).getMultiplicator();
            if (alpha == 0.0) {
                return this;
            }
            y.forEachNonZero(new IntIntDoubleFunction(){

                @Override
                public double apply(int i, int j, double value) {
                    SparseDoubleMatrix2D.this.setQuick(i, j, SparseDoubleMatrix2D.this.getQuick(i, j) + alpha * value);
                    return value;
                }
            });
            return this;
        }
        if (function == Functions.MULT) {
            this.elements.forEachPair(new IntDoubleProcedure(){

                @Override
                public boolean apply(int key, double value) {
                    int i = key / SparseDoubleMatrix2D.this.columns;
                    int j = key % SparseDoubleMatrix2D.this.columns;
                    double r = value * y.getQuick(i, j);
                    if (r != value) {
                        SparseDoubleMatrix2D.this.elements.put(key, r);
                    }
                    return true;
                }
            });
        }
        if (function == Functions.DIV) {
            this.elements.forEachPair(new IntDoubleProcedure(){

                @Override
                public boolean apply(int key, double value) {
                    int i = key / SparseDoubleMatrix2D.this.columns;
                    int j = key % SparseDoubleMatrix2D.this.columns;
                    double r = value / y.getQuick(i, j);
                    if (r != value) {
                        SparseDoubleMatrix2D.this.elements.put(key, r);
                    }
                    return true;
                }
            });
        }
        return super.assign(y, function);
    }

    @Override
    public int cardinality() {
        return this.isNoView ? this.elements.size() : super.cardinality();
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    @Override
    public void forEachNonZero(final IntIntDoubleFunction function) {
        if (this.isNoView) {
            this.elements.forEachPair(new IntDoubleProcedure(){

                @Override
                public boolean apply(int key, double value) {
                    int i = key / SparseDoubleMatrix2D.this.columns;
                    int j = key % SparseDoubleMatrix2D.this.columns;
                    double r = function.apply(i, j, value);
                    if (r != value) {
                        SparseDoubleMatrix2D.this.elements.put(key, r);
                    }
                    return true;
                }
            });
        } else {
            super.forEachNonZero(function);
        }
    }

    @Override
    public double getQuick(int row, int column) {
        return this.elements.get(this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride);
    }

    @Override
    protected boolean haveSharedCellsRaw(DoubleMatrix2D other) {
        if (other instanceof SelectedSparseDoubleMatrix2D) {
            SelectedSparseDoubleMatrix2D otherMatrix = (SelectedSparseDoubleMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseDoubleMatrix2D) {
            SparseDoubleMatrix2D otherMatrix = (SparseDoubleMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected int index(int row, int column) {
        return this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    public DoubleMatrix2D like(int rows, int columns) {
        return new SparseDoubleMatrix2D(rows, columns);
    }

    @Override
    public DoubleMatrix1D like1D(int size) {
        return new SparseDoubleMatrix1D(size);
    }

    @Override
    protected DoubleMatrix1D like1D(int size, int offset, int stride) {
        return new SparseDoubleMatrix1D(size, this.elements, offset, stride);
    }

    @Override
    public void setQuick(int row, int column, double value) {
        int index = this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        if (value == 0.0) {
            this.elements.removeKey(index);
        } else {
            this.elements.put(index, value);
        }
    }

    @Override
    protected DoubleMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseDoubleMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }

    @Override
    public DoubleMatrix1D zMult(DoubleMatrix1D y, DoubleMatrix1D z, double alpha, double beta, final boolean transposeA) {
        boolean ignore;
        int m = this.rows;
        int n = this.columns;
        if (transposeA) {
            m = this.columns;
            n = this.rows;
        }
        boolean bl = ignore = z == null;
        if (ignore) {
            z = new DenseDoubleMatrix1D(m);
        }
        if (!(this.isNoView && y instanceof DenseDoubleMatrix1D && z instanceof DenseDoubleMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if (n != y.size() || m > z.size()) {
            throw new IllegalArgumentException("Incompatible args");
        }
        if (!ignore) {
            z.assign(Functions.mult(beta / alpha));
        }
        DenseDoubleMatrix1D zz = (DenseDoubleMatrix1D)z;
        final double[] zElements = zz.elements;
        final int zStride = zz.stride;
        final int zi = z.index(0);
        DenseDoubleMatrix1D yy = (DenseDoubleMatrix1D)y;
        final double[] yElements = yy.elements;
        final int yStride = yy.stride;
        final int yi = y.index(0);
        if (yElements == null || zElements == null) {
            throw new IllegalStateException();
        }
        this.elements.forEachPair(new IntDoubleProcedure(){

            @Override
            public boolean apply(int key, double value) {
                int i = key / SparseDoubleMatrix2D.this.columns;
                int j = key % SparseDoubleMatrix2D.this.columns;
                if (transposeA) {
                    int tmp = i;
                    i = j;
                    j = tmp;
                }
                int n = zi + zStride * i;
                zElements[n] = zElements[n] + value * yElements[yi + yStride * j];
                return true;
            }
        });
        if (alpha != 1.0) {
            z.assign(Functions.mult(alpha));
        }
        return z;
    }

    @Override
    public DoubleMatrix2D zMult(DoubleMatrix2D B, DoubleMatrix2D C, final double alpha, double beta, final boolean transposeA, boolean transposeB) {
        boolean ignore;
        if (!this.isNoView) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        if (transposeB) {
            B = B.viewDice();
        }
        int m = this.rows;
        int n = this.columns;
        if (transposeA) {
            m = this.columns;
            n = this.rows;
        }
        int p = B.columns;
        boolean bl = ignore = C == null;
        if (C == null) {
            C = new DenseDoubleMatrix2D(m, p);
        }
        if (B.rows != n) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree");
        }
        if (C.rows != m || C.columns != p) {
            throw new IllegalArgumentException("Incompatible result matrix");
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!ignore) {
            C.assign(Functions.mult(beta));
        }
        final DoubleMatrix1D[] Brows = new DoubleMatrix1D[n];
        int i = n;
        while (--i >= 0) {
            Brows[i] = B.viewRow(i);
        }
        final DoubleMatrix1D[] Crows = new DoubleMatrix1D[m];
        int i2 = m;
        while (--i2 >= 0) {
            Crows[i2] = C.viewRow(i2);
        }
        final PlusMult fun = PlusMult.plusMult(0.0);
        this.elements.forEachPair(new IntDoubleProcedure(){

            @Override
            public boolean apply(int key, double value) {
                int i = key / SparseDoubleMatrix2D.this.columns;
                int j = key % SparseDoubleMatrix2D.this.columns;
                fun.setMultiplicator(value * alpha);
                if (transposeA) {
                    Crows[j].assign(Brows[i], fun);
                } else {
                    Crows[i].assign(Brows[j], fun);
                }
                return true;
            }
        });
        return C;
    }
}

