/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.processor.DocBasedVersionConstraintsProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocBasedVersionConstraintsProcessorFactory
extends UpdateRequestProcessorFactory
implements SolrCoreAware,
UpdateRequestProcessorFactory.RunAlways {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean ignoreOldUpdates = false;
    private List<String> versionFields = null;
    private List<String> deleteVersionParamNames = Collections.emptyList();
    private boolean useFieldCache;
    private boolean supportMissingVersionOnOldDocs = false;

    @Override
    public void init(NamedList args) {
        Object tmp = args.remove("versionField");
        if (null == tmp) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'versionField' must be configured");
        }
        if (!(tmp instanceof String)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'versionField' must be configured as a <str>");
        }
        this.versionFields = StrUtils.splitSmart((String)((String)tmp), (char)',');
        tmp = args.remove("deleteVersionParam");
        if (null != tmp) {
            if (!(tmp instanceof String)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'deleteVersionParam' must be configured as a <str>");
            }
            this.deleteVersionParamNames = StrUtils.splitSmart((String)((String)tmp), (char)',');
        }
        if (this.deleteVersionParamNames.size() > 0 && this.deleteVersionParamNames.size() != this.versionFields.size()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The number of 'deleteVersionParam' params must either be 0 or equal to the number of 'versionField' fields");
        }
        tmp = args.remove("ignoreOldUpdates");
        if (null != tmp) {
            if (!(tmp instanceof Boolean)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'ignoreOldUpdates' must be configured as a <bool>");
            }
            this.ignoreOldUpdates = (Boolean)tmp;
        }
        if (null != (tmp = args.remove("supportMissingVersionOnOldDocs"))) {
            if (!(tmp instanceof Boolean)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'supportMissingVersionOnOldDocs' must be configured as a <bool>");
            }
            this.supportMissingVersionOnOldDocs = (Boolean)tmp;
        }
        super.init(args);
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new DocBasedVersionConstraintsProcessor(this.versionFields, this.ignoreOldUpdates, this.deleteVersionParamNames, this.supportMissingVersionOnOldDocs, this.useFieldCache, req, next);
    }

    @Override
    public void inform(SolrCore core) {
        if (core.getUpdateHandler().getUpdateLog() == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "updateLog must be enabled.");
        }
        if (core.getLatestSchema().getUniqueKeyField() == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "schema must have uniqueKey defined.");
        }
        this.useFieldCache = true;
        for (String versionField : this.versionFields) {
            SchemaField userVersionField = core.getLatestSchema().getField(versionField);
            if (userVersionField == null || !userVersionField.stored() || userVersionField.multiValued()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "field " + versionField + " must be defined in schema, be stored, and be single valued.");
            }
            if (!this.useFieldCache) continue;
            try {
                userVersionField.getType().getValueSource(userVersionField, null);
            }
            catch (Exception e) {
                this.useFieldCache = false;
                log.warn("Can't use fieldcache/valuesource: " + e.getMessage());
            }
        }
    }
}

