/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.handler.SolrConfigHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.QParser;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.util.SimplePostTool;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobHandler
extends RequestHandlerBase
implements PluginInfoInitialized,
PermissionNameProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long DEFAULT_MAX_SIZE = 0x500000L;
    private long maxSize = 0x500000L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleRequestBody(final SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        String httpMethod = req.getHttpMethod();
        String path = (String)req.getContext().get("path");
        RequestHandlerUtils.setWt(req, "json");
        List pieces = StrUtils.splitSmart((String)path, (char)'/');
        String blobName = null;
        if (pieces.size() >= 3) {
            blobName = (String)pieces.get(2);
        }
        if ("POST".equals(httpMethod)) {
            ByteBuffer payload;
            if (blobName == null || blobName.isEmpty()) {
                rsp.add("error", "Name not found");
                return;
            }
            String err = SolrConfigHandler.validateName(blobName);
            if (err != null) {
                log.warn("no blob name");
                rsp.add("error", err);
                return;
            }
            if (req.getContentStreams() == null) {
                log.warn("no content stream");
                rsp.add("error", "No stream");
                return;
            }
            Iterator<ContentStream> iterator = req.getContentStreams().iterator();
            if (!iterator.hasNext()) return;
            ContentStream stream = iterator.next();
            try (InputStream is = stream.getStream();){
                payload = SimplePostTool.inputStreamToByteArray(is, this.maxSize);
            }
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(payload.array(), payload.position(), payload.limit());
            String md5 = new BigInteger(1, m.digest()).toString(16);
            TopDocs duplicate = req.getSearcher().search((Query)new TermQuery(new Term("md5", md5)), 1);
            if (duplicate.totalHits > 0L) {
                rsp.add("error", "duplicate entry");
                BlobHandler.forward(req, null, (SolrParams)new MapSolrParams(Utils.makeMap((Object[])new Object[]{"q", "md5:" + md5, "fl", "id,size,version,timestamp,blobName"})), rsp);
                log.warn("duplicate entry for blob :" + blobName);
                return;
            }
            TopFieldDocs docs = req.getSearcher().search((Query)new TermQuery(new Term("blobName", blobName)), 1, new Sort(new SortField("version", SortField.Type.LONG, true)));
            long version = 0L;
            if (docs.totalHits > 0L) {
                Document doc = req.getSearcher().doc(docs.scoreDocs[0].doc);
                Number n = doc.getField("version").numericValue();
                version = n.longValue();
            }
            String id = blobName + "/" + ++version;
            Map doc = Utils.makeMap((Object[])new Object[]{"id", id, "type", "blob", "md5", md5, "blobName", blobName, "version", version, "timestamp", new Date(), "size", payload.limit(), "blob", payload});
            this.verifyWithRealtimeGet(blobName, version, req, doc);
            log.info(StrUtils.formatString((String)"inserting new blob {0} ,size {1}, md5 {2}", (Object[])new Object[]{doc.get("id"), String.valueOf(payload.limit()), md5}));
            BlobHandler.indexMap(req, rsp, doc);
            log.info(" Successfully Added and committed a blob with id {} and size {} ", (Object)id, (Object)payload.limit());
            return;
        }
        int version = -1;
        if (pieces.size() > 3) {
            try {
                version = Integer.parseInt((String)pieces.get(3));
            }
            catch (NumberFormatException e) {
                rsp.add("error", "Invalid version" + (String)pieces.get(3));
                return;
            }
        }
        if ("filestream".equals(req.getParams().get("wt"))) {
            if (blobName == null) {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Please send the request in the format /blob/<blobName>/<version>");
            }
            String q = "blobName:{0}";
            if (version != -1) {
                q = "id:{0}/{1}";
            }
            QParser qparser = QParser.getParser(StrUtils.formatString((String)q, (Object[])new Object[]{blobName, version}), req);
            TopFieldDocs docs = req.getSearcher().search(qparser.parse(), 1, new Sort(new SortField("version", SortField.Type.LONG, true)));
            if (docs.totalHits <= 0L) throw new SolrException(SolrException.ErrorCode.NOT_FOUND, StrUtils.formatString((String)"Invalid combination of blobName {0} and version {1}", (Object[])new Object[]{blobName, version}));
            rsp.add("filestream", new SolrCore.RawWriter((TopDocs)docs){
                final /* synthetic */ TopDocs val$docs;
                {
                    this.val$docs = topDocs;
                }

                @Override
                public void write(OutputStream os) throws IOException {
                    Document doc = req.getSearcher().doc(this.val$docs.scoreDocs[0].doc);
                    IndexableField sf = doc.getField("blob");
                    FieldType fieldType = req.getSchema().getField("blob").getType();
                    ByteBuffer buf = (ByteBuffer)fieldType.toObject(sf);
                    if (buf == null) {
                        throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Invalid document . No field called blob");
                    }
                    os.write(buf.array(), 0, buf.limit());
                }
            });
            return;
        } else {
            String q = "*:*";
            if (blobName != null) {
                q = "blobName:{0}";
                if (version != -1) {
                    q = "id:{0}/{1}";
                }
            }
            BlobHandler.forward(req, null, (SolrParams)new MapSolrParams(Utils.makeMap((Object[])new Object[]{"q", StrUtils.formatString((String)q, (Object[])new Object[]{blobName, version}), "fl", "id,size,version,timestamp,blobName,md5", "sort", "version desc"})), rsp);
        }
    }

    private void verifyWithRealtimeGet(String blobName, long version, SolrQueryRequest req, Map<String, Object> doc) {
        while (true) {
            SolrQueryResponse response = new SolrQueryResponse();
            String id = blobName + "/" + version;
            BlobHandler.forward(req, "/get", (SolrParams)new MapSolrParams(Collections.singletonMap("id", id)), response);
            if (response.getValues().get("doc") == null) {
                return;
            }
            log.info("id {} already exists trying next ", (Object)id);
            doc.put("version", ++version);
            id = blobName + "/" + version;
            doc.put("id", id);
        }
    }

    public static void indexMap(SolrQueryRequest req, SolrQueryResponse rsp, Map<String, Object> doc) throws IOException {
        SolrInputDocument solrDoc = new SolrInputDocument(new String[0]);
        for (Map.Entry<String, Object> e : doc.entrySet()) {
            solrDoc.addField(e.getKey(), e.getValue());
        }
        UpdateRequestProcessorChain processorChain = req.getCore().getUpdateProcessorChain(req.getParams());
        try (UpdateRequestProcessor processor = processorChain.createProcessor(req, rsp);){
            AddUpdateCommand cmd = new AddUpdateCommand(req);
            cmd.solrDoc = solrDoc;
            log.info("Adding doc: " + doc);
            processor.processAdd(cmd);
            log.info("committing doc: " + doc);
            processor.processCommit(new CommitUpdateCommand(req, false));
            processor.finish();
        }
    }

    @Override
    public SolrRequestHandler getSubHandler(String subPath) {
        if (StrUtils.splitSmart((String)subPath, (char)'/').size() > 4) {
            return null;
        }
        return this;
    }

    @Override
    public String getDescription() {
        return "Load Jars into a system index";
    }

    @Override
    public void init(PluginInfo info) {
        Object o;
        NamedList invariants;
        super.init(info.initArgs);
        if (info.initArgs != null && (invariants = (NamedList)info.initArgs.get("invariants")) != null && (o = invariants.get("maxSize")) != null) {
            this.maxSize = Long.parseLong(String.valueOf(o));
            this.maxSize = this.maxSize * 1024L * 1024L;
        }
    }

    private static void forward(SolrQueryRequest req, String handler, SolrParams params, SolrQueryResponse rsp) {
        LocalSolrQueryRequest r = new LocalSolrQueryRequest(req.getCore(), params);
        SolrRequestInfo.getRequestInfo().addCloseHook(r);
        req.getCore().getRequestHandler(handler).handleRequest(r, rsp);
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    @Override
    public Collection<Api> getApis() {
        return ApiBag.wrapRequestHandlers(this, "core.system.blob", "core.system.blob.upload");
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
        switch (ctx.getHttpMethod()) {
            case "GET": {
                return PermissionNameProvider.Name.READ_PERM;
            }
            case "POST": {
                return PermissionNameProvider.Name.UPDATE_PERM;
            }
        }
        return null;
    }
}

