/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkShardTerms;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.util.TestInjection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrepRecoveryOp
implements CoreAdminHandler.CoreAdminOp {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    PrepRecoveryOp() {
    }

    @Override
    public void execute(CoreAdminHandler.CallInfo it) throws Exception {
        assert (TestInjection.injectPrepRecoveryOpPauseForever());
        SolrParams params = it.req.getParams();
        String cname = params.get("core");
        if (cname == null) {
            cname = "";
        }
        String nodeName = params.get("nodeName");
        String coreNodeName = params.get("coreNodeName");
        Replica.State waitForState = Replica.State.getState((String)params.get("state"));
        Boolean checkLive = params.getBool("checkLive");
        Boolean onlyIfLeader = params.getBool("onlyIfLeader");
        Boolean onlyIfLeaderActive = params.getBool("onlyIfLeaderActive");
        CoreContainer coreContainer = it.handler.coreContainer;
        int conflictWaitMs = coreContainer.getZkController().getLeaderConflictResolveWait();
        int maxTries = Math.round(conflictWaitMs / 1000) + 3;
        log.info("Going to wait for coreNodeName: {}, state: {}, checkLive: {}, onlyIfLeader: {}, onlyIfLeaderActive: {}, maxTime: {} s", new Object[]{coreNodeName, waitForState, checkLive, onlyIfLeader, onlyIfLeaderActive, maxTries});
        Replica.State state = null;
        boolean live = false;
        int retry = 0;
        while (true) {
            try (SolrCore core = coreContainer.getCore(cname);){
                if (core == null && retry == Math.min(30, maxTries)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "core not found:" + cname);
                }
                if (core != null) {
                    Replica replica;
                    ClusterState clusterState;
                    DocCollection collection;
                    Slice slice;
                    if (onlyIfLeader != null && onlyIfLeader.booleanValue() && !core.getCoreDescriptor().getCloudDescriptor().isLeader()) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "We are not the leader");
                    }
                    CloudDescriptor cloudDescriptor = core.getCoreDescriptor().getCloudDescriptor();
                    String collectionName = cloudDescriptor.getCollectionName();
                    if (retry % 15 == 0) {
                        if (retry > 0 && log.isInfoEnabled()) {
                            log.info("After " + retry + " seconds, core " + cname + " (" + cloudDescriptor.getShardId() + " of " + cloudDescriptor.getCollectionName() + ") still does not have state: " + waitForState + "; forcing ClusterState update from ZooKeeper");
                        }
                        coreContainer.getZkController().getZkStateReader().forceUpdateCollection(collectionName);
                    }
                    if ((slice = (collection = (clusterState = coreContainer.getZkController().getClusterState()).getCollection(collectionName)).getSlice(cloudDescriptor.getShardId())) != null && (replica = (Replica)slice.getReplicasMap().get(coreNodeName)) != null) {
                        boolean leaderDoesNotNeedRecovery;
                        state = replica.getState();
                        live = clusterState.liveNodesContain(nodeName);
                        Replica.State localState = cloudDescriptor.getLastPublished();
                        boolean bl = leaderDoesNotNeedRecovery = onlyIfLeader != null && onlyIfLeader != false && core.getName().equals(replica.getStr("core")) && waitForState == Replica.State.RECOVERING && localState == Replica.State.ACTIVE && state == Replica.State.ACTIVE;
                        if (leaderDoesNotNeedRecovery) {
                            log.warn("Leader " + core.getName() + " ignoring request to be in the recovering state because it is live and active.");
                        }
                        ZkShardTerms shardTerms = coreContainer.getZkController().getShardTerms(collectionName, slice.getName());
                        if (waitForState == Replica.State.RECOVERING && shardTerms.registered(coreNodeName) && shardTerms.skipSendingUpdatesTo(coreNodeName)) {
                            shardTerms.refreshTerms();
                        }
                        boolean onlyIfActiveCheckResult = onlyIfLeaderActive != null && onlyIfLeaderActive != false && localState != Replica.State.ACTIVE;
                        log.info("In WaitForState(" + waitForState + "): collection=" + collectionName + ", shard=" + slice.getName() + ", thisCore=" + core.getName() + ", leaderDoesNotNeedRecovery=" + leaderDoesNotNeedRecovery + ", isLeader? " + core.getCoreDescriptor().getCloudDescriptor().isLeader() + ", live=" + live + ", checkLive=" + checkLive + ", currentState=" + state.toString() + ", localState=" + localState + ", nodeName=" + nodeName + ", coreNodeName=" + coreNodeName + ", onlyIfActiveCheckResult=" + onlyIfActiveCheckResult + ", nodeProps: " + replica);
                        if (!onlyIfActiveCheckResult && replica != null && (state == waitForState || leaderDoesNotNeedRecovery) && (checkLive == null || checkLive.booleanValue() && live || !checkLive.booleanValue() && !live)) break;
                    }
                }
                if (retry++ == maxTries) {
                    String collection = null;
                    String leaderInfo = null;
                    String shardId = null;
                    try {
                        CloudDescriptor cloudDescriptor = core.getCoreDescriptor().getCloudDescriptor();
                        collection = cloudDescriptor.getCollectionName();
                        shardId = cloudDescriptor.getShardId();
                        leaderInfo = coreContainer.getZkController().getZkStateReader().getLeaderUrl(collection, shardId, 5000);
                    }
                    catch (Exception exc) {
                        leaderInfo = "Not available due to: " + exc;
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "I was asked to wait on state " + waitForState + " for " + shardId + " in " + collection + " on " + nodeName + " but I still do not see the requested state. I see state: " + Objects.toString(state) + " live:" + live + " leader from ZK: " + leaderInfo);
                }
                if (coreContainer.isShutDown()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Solr is shutting down");
                }
            }
            Thread.sleep(1000L);
        }
        log.info("Waited coreNodeName: " + coreNodeName + ", state: " + waitForState + ", checkLive: " + checkLive + ", onlyIfLeader: " + onlyIfLeader + " for: " + retry + " seconds.");
    }
}

