/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlAvgAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlSumAggFunction;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.CompositeList;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;

public class AggregateReduceFunctionsRule
extends RelOptRule {
    public static final AggregateReduceFunctionsRule INSTANCE = new AggregateReduceFunctionsRule(AggregateReduceFunctionsRule.operand(LogicalAggregate.class, AggregateReduceFunctionsRule.any()), RelFactories.LOGICAL_BUILDER);

    protected AggregateReduceFunctionsRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory) {
        super(operand, relBuilderFactory, null);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        if (!super.matches(call)) {
            return false;
        }
        Aggregate oldAggRel = (Aggregate)call.rels[0];
        return this.containsAvgStddevVarCall(oldAggRel.getAggCallList());
    }

    @Override
    public void onMatch(RelOptRuleCall ruleCall) {
        Aggregate oldAggRel = (Aggregate)ruleCall.rels[0];
        this.reduceAggs(ruleCall, oldAggRel);
    }

    private boolean containsAvgStddevVarCall(List<AggregateCall> aggCallList) {
        for (AggregateCall call : aggCallList) {
            if (!(call.getAggregation() instanceof SqlAvgAggFunction) && !(call.getAggregation() instanceof SqlSumAggFunction)) continue;
            return true;
        }
        return false;
    }

    private void reduceAggs(RelOptRuleCall ruleCall, Aggregate oldAggRel) {
        RexBuilder rexBuilder = oldAggRel.getCluster().getRexBuilder();
        List<AggregateCall> oldCalls = oldAggRel.getAggCallList();
        int groupCount = oldAggRel.getGroupCount();
        int indicatorCount = oldAggRel.getIndicatorCount();
        ArrayList newCalls = Lists.newArrayList();
        HashMap aggCallMapping = Maps.newHashMap();
        ArrayList projList = Lists.newArrayList();
        for (int i = 0; i < groupCount + indicatorCount; ++i) {
            projList.add(rexBuilder.makeInputRef(this.getFieldType(oldAggRel, i), i));
        }
        RelBuilder relBuilder = ruleCall.builder();
        relBuilder.push(oldAggRel.getInput());
        ArrayList<RexNode> inputExprs = new ArrayList<RexNode>((Collection<RexNode>)relBuilder.fields());
        for (AggregateCall oldCall : oldCalls) {
            projList.add(this.reduceAgg(oldAggRel, oldCall, newCalls, aggCallMapping, inputExprs));
        }
        int extraArgCount = inputExprs.size() - relBuilder.peek().getRowType().getFieldCount();
        if (extraArgCount > 0) {
            relBuilder.project(inputExprs, CompositeList.of(relBuilder.peek().getRowType().getFieldNames(), Collections.nCopies(extraArgCount, null)));
        }
        this.newAggregateRel(relBuilder, oldAggRel, newCalls);
        relBuilder.project(projList, oldAggRel.getRowType().getFieldNames());
        ruleCall.transformTo(relBuilder.build());
    }

    private RexNode reduceAgg(Aggregate oldAggRel, AggregateCall oldCall, List<AggregateCall> newCalls, Map<AggregateCall, RexNode> aggCallMapping, List<RexNode> inputExprs) {
        if (oldCall.getAggregation() instanceof SqlSumAggFunction) {
            return this.reduceSum(oldAggRel, oldCall, newCalls, aggCallMapping);
        }
        if (oldCall.getAggregation() instanceof SqlAvgAggFunction) {
            SqlKind kind = oldCall.getAggregation().getKind();
            switch (kind) {
                case AVG: {
                    return this.reduceAvg(oldAggRel, oldCall, newCalls, aggCallMapping);
                }
                case STDDEV_POP: {
                    return this.reduceStddev(oldAggRel, oldCall, true, true, newCalls, aggCallMapping, inputExprs);
                }
                case STDDEV_SAMP: {
                    return this.reduceStddev(oldAggRel, oldCall, false, true, newCalls, aggCallMapping, inputExprs);
                }
                case VAR_POP: {
                    return this.reduceStddev(oldAggRel, oldCall, true, false, newCalls, aggCallMapping, inputExprs);
                }
                case VAR_SAMP: {
                    return this.reduceStddev(oldAggRel, oldCall, false, false, newCalls, aggCallMapping, inputExprs);
                }
            }
            throw Util.unexpected(kind);
        }
        RexBuilder rexBuilder = oldAggRel.getCluster().getRexBuilder();
        int nGroups = oldAggRel.getGroupCount();
        List<RelDataType> oldArgTypes = SqlTypeUtil.projectTypes(oldAggRel.getInput().getRowType(), oldCall.getArgList());
        return rexBuilder.addAggCall(oldCall, nGroups, oldAggRel.indicator, newCalls, aggCallMapping, oldArgTypes);
    }

    private RexNode reduceAvg(Aggregate oldAggRel, AggregateCall oldCall, List<AggregateCall> newCalls, Map<AggregateCall, RexNode> aggCallMapping) {
        int nGroups = oldAggRel.getGroupCount();
        RexBuilder rexBuilder = oldAggRel.getCluster().getRexBuilder();
        int iAvgInput = oldCall.getArgList().get(0);
        RelDataType avgInputType = this.getFieldType(oldAggRel.getInput(), iAvgInput);
        AggregateCall sumCall = AggregateCall.create(SqlStdOperatorTable.SUM, oldCall.isDistinct(), oldCall.getArgList(), oldCall.filterArg, oldAggRel.getGroupCount(), oldAggRel.getInput(), null, null);
        AggregateCall countCall = AggregateCall.create(SqlStdOperatorTable.COUNT, oldCall.isDistinct(), oldCall.getArgList(), oldCall.filterArg, oldAggRel.getGroupCount(), oldAggRel.getInput(), null, null);
        RexNode numeratorRef = rexBuilder.addAggCall(sumCall, nGroups, oldAggRel.indicator, newCalls, aggCallMapping, (List<RelDataType>)ImmutableList.of((Object)avgInputType));
        RexNode denominatorRef = rexBuilder.addAggCall(countCall, nGroups, oldAggRel.indicator, newCalls, aggCallMapping, (List<RelDataType>)ImmutableList.of((Object)avgInputType));
        RexNode divideRef = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE, numeratorRef, denominatorRef);
        return rexBuilder.makeCast(oldCall.getType(), divideRef);
    }

    private RexNode reduceSum(Aggregate oldAggRel, AggregateCall oldCall, List<AggregateCall> newCalls, Map<AggregateCall, RexNode> aggCallMapping) {
        int nGroups = oldAggRel.getGroupCount();
        RexBuilder rexBuilder = oldAggRel.getCluster().getRexBuilder();
        int arg = oldCall.getArgList().get(0);
        RelDataType argType = this.getFieldType(oldAggRel.getInput(), arg);
        AggregateCall sumZeroCall = AggregateCall.create(SqlStdOperatorTable.SUM0, oldCall.isDistinct(), oldCall.getArgList(), oldCall.filterArg, oldAggRel.getGroupCount(), oldAggRel.getInput(), null, oldCall.name);
        AggregateCall countCall = AggregateCall.create(SqlStdOperatorTable.COUNT, oldCall.isDistinct(), oldCall.getArgList(), oldCall.filterArg, oldAggRel.getGroupCount(), oldAggRel, null, null);
        RexNode sumZeroRef = rexBuilder.addAggCall(sumZeroCall, nGroups, oldAggRel.indicator, newCalls, aggCallMapping, (List<RelDataType>)ImmutableList.of((Object)argType));
        if (!oldCall.getType().isNullable()) {
            return sumZeroRef;
        }
        RexNode countRef = rexBuilder.addAggCall(countCall, nGroups, oldAggRel.indicator, newCalls, aggCallMapping, (List<RelDataType>)ImmutableList.of((Object)argType));
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, countRef, rexBuilder.makeExactLiteral(BigDecimal.ZERO)), rexBuilder.makeCast(sumZeroRef.getType(), rexBuilder.constantNull()), sumZeroRef);
    }

    private RexNode reduceStddev(Aggregate oldAggRel, AggregateCall oldCall, boolean biased, boolean sqrt, List<AggregateCall> newCalls, Map<AggregateCall, RexNode> aggCallMapping, List<RexNode> inputExprs) {
        RexNode div;
        RexNode denominator;
        int nGroups = oldAggRel.getGroupCount();
        RelOptCluster cluster = oldAggRel.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RelDataTypeFactory typeFactory = cluster.getTypeFactory();
        assert (oldCall.getArgList().size() == 1) : oldCall.getArgList();
        int argOrdinal = oldCall.getArgList().get(0);
        RelDataType argType = this.getFieldType(oldAggRel.getInput(), argOrdinal);
        RexNode argRef = inputExprs.get(argOrdinal);
        RexNode argSquared = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, argRef, argRef);
        int argSquaredOrdinal = AggregateReduceFunctionsRule.lookupOrAdd(inputExprs, argSquared);
        Aggregate.AggCallBinding binding = new Aggregate.AggCallBinding(typeFactory, SqlStdOperatorTable.SUM, (List<RelDataType>)ImmutableList.of((Object)argRef.getType()), oldAggRel.getGroupCount(), oldCall.filterArg >= 0);
        AggregateCall sumArgSquaredAggCall = AggregateCall.create(SqlStdOperatorTable.SUM, oldCall.isDistinct(), ImmutableIntList.of(argSquaredOrdinal), oldCall.filterArg, SqlStdOperatorTable.SUM.inferReturnType(binding), null);
        RexNode sumArgSquared = rexBuilder.addAggCall(sumArgSquaredAggCall, nGroups, oldAggRel.indicator, newCalls, aggCallMapping, (List<RelDataType>)ImmutableList.of((Object)argType));
        AggregateCall sumArgAggCall = AggregateCall.create(SqlStdOperatorTable.SUM, oldCall.isDistinct(), ImmutableIntList.of(argOrdinal), oldCall.filterArg, oldAggRel.getGroupCount(), oldAggRel.getInput(), null, null);
        RexNode sumArg = rexBuilder.addAggCall(sumArgAggCall, nGroups, oldAggRel.indicator, newCalls, aggCallMapping, (List<RelDataType>)ImmutableList.of((Object)argType));
        RexNode sumSquaredArg = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, sumArg, sumArg);
        AggregateCall countArgAggCall = AggregateCall.create(SqlStdOperatorTable.COUNT, oldCall.isDistinct(), oldCall.getArgList(), oldCall.filterArg, oldAggRel.getGroupCount(), oldAggRel.getInput(), null, null);
        RexNode countArg = rexBuilder.addAggCall(countArgAggCall, nGroups, oldAggRel.indicator, newCalls, aggCallMapping, (List<RelDataType>)ImmutableList.of((Object)argType));
        RexNode avgSumSquaredArg = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE, sumSquaredArg, countArg);
        RexNode diff = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MINUS, sumArgSquared, avgSumSquaredArg);
        if (biased) {
            denominator = countArg;
        } else {
            RexLiteral one = rexBuilder.makeExactLiteral(BigDecimal.ONE);
            RexNode nul = rexBuilder.makeCast(countArg.getType(), rexBuilder.constantNull());
            RexNode countMinusOne = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MINUS, countArg, one);
            RexNode countEqOne = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, countArg, one);
            denominator = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, countEqOne, nul, countMinusOne);
        }
        RexNode result = div = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE, diff, denominator);
        if (sqrt) {
            RexLiteral half = rexBuilder.makeExactLiteral(new BigDecimal("0.5"));
            result = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.POWER, div, half);
        }
        return rexBuilder.makeCast(oldCall.getType(), result);
    }

    private static <T> int lookupOrAdd(List<T> list, T element) {
        int ordinal = list.indexOf(element);
        if (ordinal == -1) {
            ordinal = list.size();
            list.add(element);
        }
        return ordinal;
    }

    protected void newAggregateRel(RelBuilder relBuilder, Aggregate oldAggregate, List<AggregateCall> newCalls) {
        relBuilder.aggregate(relBuilder.groupKey(oldAggregate.getGroupSet(), oldAggregate.indicator, oldAggregate.getGroupSets()), newCalls);
    }

    private RelDataType getFieldType(RelNode relNode, int i) {
        RelDataTypeField inputField = relNode.getRowType().getFieldList().get(i);
        return inputField.getType();
    }
}

