/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.carrot2.core.DocumentSourceDescriptor;
import org.carrot2.core.ProcessingComponentConfiguration;
import org.carrot2.core.ProcessingComponentDescriptor;
import org.carrot2.core.ProcessingComponentSuiteInclude;
import org.carrot2.shaded.guava.common.collect.Iterables;
import org.carrot2.shaded.guava.common.collect.Iterators;
import org.carrot2.shaded.guava.common.collect.Lists;
import org.carrot2.util.CloseableUtils;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.ResourceLookup;
import org.carrot2.util.simplexml.PersisterHelpers;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.TreeStrategy;

@Root(name="component-suite")
public class ProcessingComponentSuite {
    @ElementList(inline=true, required=false, entry="include")
    ArrayList<ProcessingComponentSuiteInclude> includes;
    @ElementList(name="sources", entry="source", required=false)
    private ArrayList<DocumentSourceDescriptor> sources;
    @ElementList(name="algorithms", entry="algorithm", required=false)
    private ArrayList<ProcessingComponentDescriptor> algorithms;
    @ElementList(name="components", entry="component", required=false)
    private ArrayList<ProcessingComponentDescriptor> otherComponents;

    public ProcessingComponentSuite() {
    }

    public ProcessingComponentSuite(ArrayList<DocumentSourceDescriptor> sources, ArrayList<ProcessingComponentDescriptor> algorithms) {
        this.algorithms = algorithms;
        this.sources = sources;
        this.otherComponents = Lists.newArrayList();
    }

    public List<DocumentSourceDescriptor> getSources() {
        return this.sources;
    }

    public List<ProcessingComponentDescriptor> getAlgorithms() {
        return this.algorithms;
    }

    public List<ProcessingComponentDescriptor> getOtherComponents() {
        return this.otherComponents;
    }

    public List<ProcessingComponentDescriptor> getComponents() {
        return Lists.newArrayList((Iterable)Iterables.concat(this.sources, this.algorithms, this.otherComponents));
    }

    @Commit
    private void postDeserialize(Map<Object, Object> session) throws Exception {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        if (this.algorithms == null) {
            this.algorithms = new ArrayList();
        }
        if (this.includes == null) {
            this.includes = new ArrayList();
        }
        if (this.otherComponents == null) {
            this.otherComponents = new ArrayList();
        }
        ResourceLookup resourceLookup = PersisterHelpers.getResourceLookup(session);
        ArrayList suites = Lists.newArrayList();
        for (ProcessingComponentSuiteInclude include : this.includes) {
            IResource resource = resourceLookup.getFirst(include.suite);
            if (resource == null) {
                throw new Exception("Could not locate resource: " + include.suite);
            }
            suites.add(ProcessingComponentSuite.deserialize(resource, resourceLookup));
        }
        for (ProcessingComponentSuite suite : suites) {
            this.sources.addAll(suite.getSources());
            this.algorithms.addAll(suite.getAlgorithms());
            this.otherComponents.addAll(suite.getOtherComponents());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessingComponentSuite deserialize(IResource resource, ResourceLookup resourceLookup) throws Exception {
        if (resource == null) {
            throw new IOException("Resource must not be null.");
        }
        InputStream inputStream = resource.open();
        try {
            if (inputStream == null) {
                throw new IOException("Input stream must not be null.");
            }
            Persister persister = PersisterHelpers.createPersister(resourceLookup, (Strategy)new TreeStrategy());
            ProcessingComponentSuite suite = (ProcessingComponentSuite)persister.read(ProcessingComponentSuite.class, inputStream);
            suite.includes = null;
            ProcessingComponentSuite processingComponentSuite = suite;
            return processingComponentSuite;
        }
        finally {
            CloseableUtils.close((Closeable)inputStream);
        }
    }

    public void serialize(OutputStream stream) throws Exception {
        new Persister().write((Object)this, stream);
    }

    public List<ProcessingComponentDescriptor> removeUnavailableComponents() {
        ArrayList failed = Lists.newArrayList();
        Iterator i = Iterators.concat(this.sources.iterator(), this.algorithms.iterator());
        while (i.hasNext()) {
            ProcessingComponentDescriptor p = (ProcessingComponentDescriptor)i.next();
            if (p.isComponentAvailable()) continue;
            failed.add(p);
            i.remove();
        }
        return failed;
    }

    public ProcessingComponentConfiguration[] getComponentConfigurations() {
        List<ProcessingComponentDescriptor> components = this.getComponents();
        ProcessingComponentConfiguration[] result = new ProcessingComponentConfiguration[components.size()];
        int i = 0;
        for (ProcessingComponentDescriptor processingComponentDescriptor : components) {
            result[i++] = processingComponentDescriptor.getComponentConfiguration();
        }
        return result;
    }
}

