/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrjNamedThreadFactory;

public class SignificantTermsStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    protected String zkHost;
    protected String collection;
    protected Map<String, String> params;
    protected Iterator<Tuple> tupleIterator;
    protected String field;
    protected int numTerms;
    protected float minDocFreq;
    protected float maxDocFreq;
    protected int minTermLength;
    protected transient SolrClientCache cache;
    protected transient boolean isCloseCache;
    protected transient StreamContext streamContext;
    protected ExecutorService executorService;

    public SignificantTermsStream(String zkHost, String collectionName, Map params, String field, float minDocFreq, float maxDocFreq, int minTermLength, int numTerms) throws IOException {
        this.init(collectionName, zkHost, params, field, minDocFreq, maxDocFreq, minTermLength, numTerms);
    }

    public SignificantTermsStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (expression.getParameters().size() != 1 + namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - unknown operands found", expression));
        }
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        if (0 == namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one named parameter expected. eg. 'q=*:*'", expression));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost")) continue;
            params.put(namedParam.getName(), namedParam.getParameter().toString().trim());
        }
        String fieldParam = (String)params.get("field");
        if (fieldParam == null) {
            throw new IOException("field param cannot be null for SignificantTermsStream");
        }
        params.remove("field");
        String numTermsParam = (String)params.get("limit");
        int numTerms = 20;
        if (numTermsParam != null) {
            numTerms = Integer.parseInt(numTermsParam);
            params.remove("limit");
        }
        String minTermLengthParam = (String)params.get("minTermLength");
        int minTermLength = 4;
        if (minTermLengthParam != null) {
            minTermLength = Integer.parseInt(minTermLengthParam);
            params.remove("minTermLength");
        }
        String minDocFreqParam = (String)params.get("minDocFreq");
        float minDocFreq = 5.0f;
        if (minDocFreqParam != null) {
            minDocFreq = Float.parseFloat(minDocFreqParam);
            params.remove("minDocFreq");
        }
        String maxDocFreqParam = (String)params.get("maxDocFreq");
        float maxDocFreq = 0.3f;
        if (maxDocFreqParam != null) {
            maxDocFreq = Float.parseFloat(maxDocFreqParam);
            params.remove("maxDocFreq");
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (zkHost == null) {
            zkHost = factory.getDefaultZkHost();
        }
        this.init(collectionName, zkHost, params, fieldParam, minDocFreq, maxDocFreq, minTermLength, numTerms);
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.collection);
        for (Map.Entry<String, String> param : this.params.entrySet()) {
            expression.addParameter(new StreamExpressionNamedParameter(param.getKey(), param.getValue()));
        }
        expression.addParameter(new StreamExpressionNamedParameter("field", this.field));
        expression.addParameter(new StreamExpressionNamedParameter("minDocFreq", Float.toString(this.minDocFreq)));
        expression.addParameter(new StreamExpressionNamedParameter("maxDocFreq", Float.toString(this.maxDocFreq)));
        expression.addParameter(new StreamExpressionNamedParameter("numTerms", String.valueOf(this.numTerms)));
        expression.addParameter(new StreamExpressionNamedParameter("minTermLength", String.valueOf(this.minTermLength)));
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        return expression;
    }

    private void init(String collectionName, String zkHost, Map params, String field, float minDocFreq, float maxDocFreq, int minTermLength, int numTerms) throws IOException {
        this.zkHost = zkHost;
        this.collection = collectionName;
        this.params = params;
        this.field = field;
        this.minDocFreq = minDocFreq;
        this.maxDocFreq = maxDocFreq;
        this.numTerms = numTerms;
        this.minTermLength = minTermLength;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.cache = context.getSolrClientCache();
        this.streamContext = context;
    }

    @Override
    public void open() throws IOException {
        if (this.cache == null) {
            this.isCloseCache = true;
            this.cache = new SolrClientCache();
        } else {
            this.isCloseCache = false;
        }
        this.executorService = ExecutorUtil.newMDCAwareCachedThreadPool(new SolrjNamedThreadFactory("SignificantTermsStream"));
    }

    @Override
    public List<TupleStream> children() {
        return null;
    }

    private List<Future<NamedList>> callShards(List<String> baseUrls) throws IOException {
        ArrayList<Future<NamedList>> futures = new ArrayList<Future<NamedList>>();
        for (String baseUrl : baseUrls) {
            SignificantTermsCall lc = new SignificantTermsCall(baseUrl, this.params, this.field, this.minDocFreq, this.maxDocFreq, this.minTermLength, this.numTerms);
            Future<NamedList> future = this.executorService.submit(lc);
            futures.add(future);
        }
        return futures;
    }

    @Override
    public void close() throws IOException {
        if (this.isCloseCache) {
            this.cache.close();
        }
        this.executorService.shutdown();
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory).toString());
    }

    @Override
    public Tuple read() throws IOException {
        try {
            if (this.tupleIterator == null) {
                HashMap<String, int[]> mergeFreqs = new HashMap<String, int[]>();
                long numDocs = 0L;
                long resultCount = 0L;
                for (Future<NamedList> future : this.callShards(SignificantTermsStream.getShards(this.zkHost, this.collection, this.streamContext))) {
                    NamedList fullResp = future.get();
                    Map map = (Map)fullResp.get("significantTerms");
                    List terms = (List)map.get("sterms");
                    List docFreqs = (List)map.get("docFreq");
                    List queryDocFreqs = (List)map.get("queryDocFreq");
                    numDocs += (long)((Integer)map.get("numDocs")).intValue();
                    SolrDocumentList searchResp = (SolrDocumentList)fullResp.get("response");
                    resultCount += searchResp.getNumFound();
                    for (int i = 0; i < terms.size(); ++i) {
                        String term = (String)terms.get(i);
                        int docFreq = (Integer)docFreqs.get(i);
                        int queryDocFreq = (Integer)queryDocFreqs.get(i);
                        if (!mergeFreqs.containsKey(term)) {
                            mergeFreqs.put(term, new int[2]);
                        }
                        int[] freqs = (int[])mergeFreqs.get(term);
                        freqs[0] = freqs[0] + docFreq;
                        freqs[1] = freqs[1] + queryDocFreq;
                    }
                }
                ArrayList maps = new ArrayList();
                for (Object term : mergeFreqs.keySet()) {
                    int[] nArray = (int[])mergeFreqs.get(term);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("term", term);
                    map.put("background", nArray[0]);
                    map.put("foreground", nArray[1]);
                    float score = (float)(Math.log(nArray[1]) + 1.0) * (float)(Math.log((float)(numDocs + 1L) / (float)(nArray[0] + 1)) + 1.0);
                    map.put("score", Float.valueOf(score));
                    maps.add(map);
                }
                Collections.sort(maps, new ScoreComp());
                ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
                for (Map map : maps) {
                    if (arrayList.size() == this.numTerms) break;
                    arrayList.add(new Tuple(map));
                }
                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                map.put("EOF", true);
                arrayList.add(new Tuple(map));
                this.tupleIterator = arrayList.iterator();
            }
            return this.tupleIterator.next();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected class SignificantTermsCall
    implements Callable<NamedList> {
        private String baseUrl;
        private String field;
        private float minDocFreq;
        private float maxDocFreq;
        private int numTerms;
        private int minTermLength;
        private Map<String, String> paramsMap;

        public SignificantTermsCall(String baseUrl, Map<String, String> paramsMap, String field, float minDocFreq, float maxDocFreq, int minTermLength, int numTerms) {
            this.baseUrl = baseUrl;
            this.field = field;
            this.minDocFreq = minDocFreq;
            this.maxDocFreq = maxDocFreq;
            this.paramsMap = paramsMap;
            this.numTerms = numTerms;
            this.minTermLength = minTermLength;
        }

        @Override
        public NamedList<Double> call() throws Exception {
            ModifiableSolrParams params = new ModifiableSolrParams();
            HttpSolrClient solrClient = SignificantTermsStream.this.cache.getHttpSolrClient(this.baseUrl);
            params.add("distrib", "false");
            params.add("fq", "{!significantTerms}");
            for (String key : this.paramsMap.keySet()) {
                params.add(key, this.paramsMap.get(key));
            }
            params.add("minDocFreq", Float.toString(this.minDocFreq));
            params.add("maxDocFreq", Float.toString(this.maxDocFreq));
            params.add("minTermLength", Integer.toString(this.minTermLength));
            params.add("field", this.field);
            params.add("numTerms", String.valueOf(this.numTerms * 5));
            QueryRequest request = new QueryRequest(params);
            QueryResponse response = (QueryResponse)request.process(solrClient);
            NamedList<Object> res = response.getResponse();
            return res;
        }
    }

    private static class ScoreComp
    implements Comparator<Map> {
        private ScoreComp() {
        }

        @Override
        public int compare(Map a, Map b) {
            Float scorea = (Float)a.get("score");
            Float scoreb = (Float)b.get("score");
            return scoreb.compareTo(scorea);
        }
    }
}

