/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.io.IOException;
import java.util.Set;
import java.util.function.BiPredicate;
import org.apache.solr.common.MapWriter;

public class ConditionalMapWriter
implements MapWriter {
    private final MapWriter delegate;
    private final BiPredicate<String, Object> predicate;
    public static final BiPredicate<String, Object> NON_NULL_VAL = (s, o) -> o != null;

    public ConditionalMapWriter(MapWriter delegate, BiPredicate<String, Object> predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        this.delegate.writeMap(new EntryWriterWrapper(ew));
    }

    public static BiPredicate<String, Object> dedupeKeyPredicate(Set<String> keys) {
        return (k, v) -> keys.add((String)k);
    }

    private class EntryWriterWrapper
    implements MapWriter.EntryWriter {
        private final MapWriter.EntryWriter delegate;

        EntryWriterWrapper(MapWriter.EntryWriter delegate) {
            this.delegate = delegate;
        }

        @Override
        public MapWriter.EntryWriter put(String k, Object v) throws IOException {
            if (ConditionalMapWriter.this.predicate.test(k, v)) {
                this.delegate.put(k, v);
            }
            return this;
        }

        @Override
        public MapWriter.EntryWriter put(String k, int v) throws IOException {
            return this.put(k, (Object)v);
        }

        @Override
        public MapWriter.EntryWriter put(String k, long v) throws IOException {
            return this.put(k, (Object)v);
        }

        @Override
        public MapWriter.EntryWriter put(String k, float v) throws IOException {
            return this.put(k, Float.valueOf(v));
        }

        @Override
        public MapWriter.EntryWriter put(String k, double v) throws IOException {
            return this.put(k, (Object)v);
        }

        @Override
        public MapWriter.EntryWriter put(String k, boolean v) throws IOException {
            return this.put(k, (Object)v);
        }
    }
}

