/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.google.common.base.Predicate;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.ui.UIUtil;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.ui.TerminalSession;
import com.jediterm.terminal.ui.TerminalWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.JBTabbedTerminalWidget;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;
import org.jetbrains.plugins.terminal.TerminalView;

public abstract class AbstractTerminalRunner<T extends Process> {
    private static final Logger LOG = Logger.getInstance((String)AbstractTerminalRunner.class.getName());
    @NotNull
    protected final Project myProject;

    public AbstractTerminalRunner(@NotNull Project project) {
        if (project == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public void run() {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Running the terminal", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setText("Running the terminal...");
                try {
                    AbstractTerminalRunner.this.doRun();
                }
                catch (Exception e) {
                    LOG.warn("Error running terminal", (Throwable)e);
                    UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)AbstractTerminalRunner.this.getProject(), (String)e.getMessage(), (String)this.getTitle()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/terminal/AbstractTerminalRunner$1", "run"));
            }
        });
    }

    private void doRun() {
        try {
            T process = this.createProcess(null);
            UIUtil.invokeLaterIfNeeded(() -> this.initConsoleUI(process));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected abstract T createProcess(@Nullable String var1) throws ExecutionException;

    protected abstract ProcessHandler createProcessHandler(T var1);

    @NotNull
    public JBTabbedTerminalWidget createTerminalWidget(@NotNull Disposable parent) {
        if (parent == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(1);
        }
        JBTerminalSystemSettingsProvider provider = new JBTerminalSystemSettingsProvider();
        JBTabbedTerminalWidget terminalWidget = new JBTabbedTerminalWidget(this.myProject, provider, (Predicate<Pair<TerminalWidget, String>>)((Predicate)widget -> {
            this.openSessionInDirectory((TerminalWidget)widget.getFirst(), (String)widget.getSecond());
            return true;
        }), parent);
        this.openSessionForFile((TerminalWidget)terminalWidget, TerminalView.getInstance(this.myProject).getFileToOpen());
        JBTabbedTerminalWidget jBTabbedTerminalWidget = terminalWidget;
        if (jBTabbedTerminalWidget == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(2);
        }
        return jBTabbedTerminalWidget;
    }

    private void initConsoleUI(T process) {
        Executor defaultExecutor = DefaultRunExecutor.getRunExecutorInstance();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("TerminalRunner", (ActionGroup)toolbarActions, false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)actionToolbar.getComponent(), "West");
        actionToolbar.setTargetComponent((JComponent)panel);
        ProcessHandler processHandler = this.createProcessHandler(process);
        RunContentDescriptor contentDescriptor = new RunContentDescriptor(null, processHandler, (JComponent)panel, this.getTerminalConnectionName(process));
        contentDescriptor.setAutoFocusContent(true);
        toolbarActions.add(this.createCloseAction(defaultExecutor, contentDescriptor));
        JBTerminalSystemSettingsProvider provider = new JBTerminalSystemSettingsProvider();
        JBTabbedTerminalWidget widget = new JBTabbedTerminalWidget(this.myProject, provider, (Predicate<Pair<TerminalWidget, String>>)((Predicate)widget1 -> {
            this.openSessionInDirectory((TerminalWidget)widget1.getFirst(), (String)widget1.getSecond());
            return true;
        }), (Disposable)contentDescriptor);
        AbstractTerminalRunner.createAndStartSession((TerminalWidget)widget, this.createTtyConnector(process));
        panel.add((Component)widget.getComponent(), "Center");
        this.showConsole(defaultExecutor, contentDescriptor, widget.getComponent());
        processHandler.startNotify();
    }

    public void openSession(@NotNull TerminalWidget terminal) {
        if (terminal == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(3);
        }
        this.openSessionInDirectory(terminal, null);
    }

    public static void createAndStartSession(@NotNull TerminalWidget terminal, @NotNull TtyConnector ttyConnector) {
        if (terminal == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(4);
        }
        if (ttyConnector == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(5);
        }
        TerminalSession session = terminal.createTerminalSession(ttyConnector);
        TerminalView.recordUsage(ttyConnector);
        session.start();
    }

    protected abstract String getTerminalConnectionName(T var1);

    protected abstract TtyConnector createTtyConnector(T var1);

    protected AnAction createCloseAction(Executor defaultExecutor, RunContentDescriptor myDescriptor) {
        return new CloseAction(defaultExecutor, myDescriptor, this.myProject);
    }

    protected void showConsole(Executor defaultExecutor, @NotNull RunContentDescriptor myDescriptor, Component toFocus) {
        if (myDescriptor == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(6);
        }
        ExecutionManager.getInstance((Project)this.myProject).getContentManager().showRunContent(defaultExecutor, myDescriptor);
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(defaultExecutor.getId());
        if (toolWindow != null) {
            toolWindow.activate(() -> IdeFocusManager.getInstance((Project)this.myProject).requestFocus(toFocus, true));
        }
    }

    @NotNull
    protected Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(7);
        }
        return project;
    }

    public abstract String runningTargetName();

    public void openSessionForFile(@NotNull TerminalWidget terminalWidget, @Nullable VirtualFile file) {
        if (terminalWidget == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(8);
        }
        this.openSessionInDirectory(terminalWidget, AbstractTerminalRunner.getParentDirectoryPath(file));
    }

    @Nullable
    private static String getParentDirectoryPath(@Nullable VirtualFile file) {
        VirtualFile dir = file != null && !file.isDirectory() ? file.getParent() : file;
        return dir != null ? dir.getPath() : null;
    }

    public void openSessionInDirectory(@NotNull TerminalWidget terminalWidget, @Nullable String directory) {
        if (terminalWidget == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(9);
        }
        ModalityState modalityState = ModalityState.stateForComponent((Component)terminalWidget.getComponent());
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (terminalWidget == null) {
                AbstractTerminalRunner.$$$reportNull$$$0(11);
            }
            try {
                T process = this.createProcess(directory);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (terminalWidget == null) {
                        AbstractTerminalRunner.$$$reportNull$$$0(12);
                    }
                    try {
                        AbstractTerminalRunner.createAndStartSession(terminalWidget, this.createTtyConnector(process));
                        terminalWidget.getComponent().revalidate();
                    }
                    catch (RuntimeException e) {
                        this.showCannotOpenTerminalDialog(e);
                    }
                }, modalityState);
            }
            catch (Exception e) {
                ApplicationManager.getApplication().invokeLater(() -> this.showCannotOpenTerminalDialog(e), modalityState);
            }
        });
    }

    private void showCannotOpenTerminalDialog(@NotNull Throwable e) {
        if (e == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(10);
        }
        Messages.showErrorDialog((String)e.getMessage(), (String)("Can't Open " + this.runningTargetName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/AbstractTerminalRunner";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminal";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ttyConnector";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myDescriptor";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalWidget";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/AbstractTerminalRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTerminalWidget";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTerminalWidget";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openSession";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAndStartSession";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showConsole";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "openSessionForFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "openSessionInDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showCannotOpenTerminalDialog";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openSessionInDirectory$6";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

