/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.navigation;

import com.intellij.ide.actions.searcheverywhere.ContributorSearchResult;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.navigation.YAMLKeyNavigationItem;
import org.jetbrains.yaml.navigation.YAMLKeysIndex;

public class YAMLKeysSearchEverywhereContributor
implements SearchEverywhereContributor<Language> {
    @Nullable
    final Project myProject;

    YAMLKeysSearchEverywhereContributor(@Nullable Project project) {
        this.myProject = project;
    }

    @NotNull
    public String getSearchProviderId() {
        String string = this.getClass().getSimpleName();
        if (string == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupName() {
        String string = YAMLBundle.message("YAMLKeysSearchEverywhereContributor.group.name");
        if (string == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String includeNonProjectItemsText() {
        return null;
    }

    public int getSortWeight() {
        return 1000;
    }

    public boolean showInFindResults() {
        return true;
    }

    public ContributorSearchResult<Object> search(String pattern, boolean everywhere, SearchEverywhereContributorFilter<Language> filter, ProgressIndicator progressIndicator, int elementsLimit) {
        if (pattern.isEmpty()) {
            return ContributorSearchResult.empty();
        }
        ArrayList result = new ArrayList();
        ApplicationManager.getApplication().runReadAction(() -> this.findKeys(result, pattern, everywhere, progressIndicator, elementsLimit));
        return new ContributorSearchResult(result);
    }

    public boolean processSelectedItem(Object selected, int modifiers, String searchText) {
        if (selected instanceof Navigatable) {
            ((Navigatable)selected).navigate(true);
        }
        return true;
    }

    public ListCellRenderer getElementsRenderer(JList<?> list) {
        return new NavigationItemListCellRenderer();
    }

    public Object getDataForItem(Object element, String dataId) {
        return null;
    }

    private void findKeys(@NotNull List<Object> result, @NotNull String pattern, boolean everywhere, ProgressIndicator progressIndicator, int elementsLimit) {
        if (result == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(2);
        }
        if (pattern == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(3);
        }
        if (this.myProject == null) {
            return;
        }
        Collection allKeys = FileBasedIndex.getInstance().getAllKeys(YAMLKeysIndex.KEY, this.myProject);
        List<String> sorted = YAMLKeysSearchEverywhereContributor.applyPattern(allKeys, pattern, progressIndicator);
        for (String name : sorted) {
            progressIndicator.checkCanceled();
            CommonProcessors.CollectProcessor files = new CommonProcessors.CollectProcessor();
            GlobalSearchScope filter = everywhere ? ProjectScope.getAllScope((Project)this.myProject) : ProjectScope.getProjectScope((Project)this.myProject);
            FileBasedIndex.getInstance().getFilesWithKey(YAMLKeysIndex.KEY, Collections.singleton(name), (Processor)files, filter);
            for (VirtualFile file : files.getResults()) {
                PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
                if (psiFile == null) continue;
                ArrayList positions = FileBasedIndex.getInstance().getValues(YAMLKeysIndex.KEY, (Object)name, GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)file));
                if (positions.size() > 1) {
                    positions = new ArrayList(positions);
                    Collections.sort(positions);
                }
                Iterator iterator = positions.iterator();
                while (iterator.hasNext()) {
                    int pos = (Integer)iterator.next();
                    Navigatable navigatable = PsiNavigationSupport.getInstance().createNavigatable(this.myProject, file, pos);
                    result.add(new YAMLKeyNavigationItem(navigatable, name, file));
                    if (result.size() < elementsLimit) continue;
                    return;
                }
            }
        }
    }

    @Contract(pure=true)
    @NotNull
    private static List<String> applyPattern(@NotNull Collection<String> keys, @NotNull String pattern, ProgressIndicator progressIndicator) {
        if (keys == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(5);
        }
        MultiMap priority = MultiMap.create();
        for (String key : keys) {
            progressIndicator.checkCanceled();
            int start = key.indexOf(pattern);
            if (start == -1 || start > 0 && key.charAt(start - 1) != '.' || start + pattern.length() < key.length() && key.indexOf(".", start + pattern.length()) != -1) continue;
            int dots = YAMLKeysSearchEverywhereContributor.countDots(key, start);
            priority.putValue((Object)dots, (Object)key);
        }
        progressIndicator.checkCanceled();
        List<String> list = priority.keySet().stream().sorted().map(idx -> priority.get(idx)).map(found -> found.stream().sorted()).flatMap(s -> s).collect(Collectors.toList());
        if (list == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Contract(pure=true)
    private static int countDots(@NotNull String path, int end) {
        if (path == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(7);
        }
        int count = 0;
        for (int i = 0; i < end; ++i) {
            if (path.charAt(i) != '.') continue;
            ++count;
        }
        return count;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/navigation/YAMLKeysSearchEverywhereContributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchProviderId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/navigation/YAMLKeysSearchEverywhereContributor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "applyPattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findKeys";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyPattern";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "countDots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<Language> {
        @NotNull
        public SearchEverywhereContributor<Language> createContributor(AnActionEvent initEvent) {
            YAMLKeysSearchEverywhereContributor yAMLKeysSearchEverywhereContributor = new YAMLKeysSearchEverywhereContributor(initEvent.getProject());
            if (yAMLKeysSearchEverywhereContributor == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return yAMLKeysSearchEverywhereContributor;
        }

        @Nullable
        public SearchEverywhereContributorFilter<Language> createFilter(AnActionEvent initEvent) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/navigation/YAMLKeysSearchEverywhereContributor$Factory", "createContributor"));
        }
    }
}

