/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.labels;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalLabelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DropDownLink<T>
extends LinkLabel<Object> {
    private T chosenItem;

    public DropDownLink(@NotNull T value, @NotNull Runnable clickAction) {
        if (value == null) {
            DropDownLink.$$$reportNull$$$0(0);
        }
        if (clickAction == null) {
            DropDownLink.$$$reportNull$$$0(1);
        }
        super(value.toString(), AllIcons.General.LinkDropTriangle, (s, d) -> {
            if (clickAction == null) {
                DropDownLink.$$$reportNull$$$0(4);
            }
            clickAction.run();
        });
        this.chosenItem = value;
        this.init();
    }

    public DropDownLink(@NotNull T initialItem, @NotNull List<T> items, @Nullable Consumer<T> itemChosenAction, boolean updateLabel) {
        if (initialItem == null) {
            DropDownLink.$$$reportNull$$$0(2);
        }
        if (items == null) {
            DropDownLink.$$$reportNull$$$0(3);
        }
        super(initialItem.toString(), AllIcons.General.LinkDropTriangle);
        this.chosenItem = initialItem;
        IPopupChooserBuilder<T> popupBuilder = JBPopupFactory.getInstance().createPopupChooserBuilder(items).setRenderer(new LinkCellRenderer(this)).setItemChosenCallback(t -> {
            this.chosenItem = t;
            if (updateLabel) {
                this.setText(t.toString());
            }
            if (itemChosenAction != null) {
                itemChosenAction.consume(t);
            }
        });
        this.setListener((s, d) -> {
            Point showPoint = new Point(0, this.getHeight() + JBUI.scale((int)4));
            popupBuilder.createPopup().show(new RelativePoint((Component)this, showPoint));
        }, null);
        this.init();
    }

    private void init() {
        this.setIconTextGap(JBUI.scale((int)1));
        this.setHorizontalAlignment(10);
        this.setHorizontalTextPosition(10);
        this.setUI(new MetalLabelUI(){

            @Override
            protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
                String result2 = super.layoutCL(label, fontMetrics, text, icon, viewR, iconR, textR);
                iconR.y += JBUI.scale((int)1);
                return result2;
            }
        });
    }

    public T getChosenItem() {
        return this.chosenItem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clickAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialItem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/components/labels/DropDownLink";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LinkCellRenderer<T>
    extends JLabel
    implements ListCellRenderer<T> {
        private final JComponent owner;

        private LinkCellRenderer(JComponent owner) {
            this.owner = owner;
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)0, (int)10));
        }

        @Override
        public Dimension getPreferredSize() {
            return this.recomputeSize(super.getPreferredSize());
        }

        @Override
        public Dimension getMinimumSize() {
            return this.recomputeSize(super.getMinimumSize());
        }

        private Dimension recomputeSize(@NotNull Dimension size) {
            if (size == null) {
                LinkCellRenderer.$$$reportNull$$$0(0);
            }
            size.height = Math.max(size.height, JBUI.scale((int)22));
            size.width = Math.max(size.width, this.owner.getPreferredSize().width);
            return size;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            this.setEnabled(list.isEnabled());
            this.setOpaque(true);
            this.setBackground(isSelected ? list.getSelectionBackground() : UIManager.getColor("Label.background"));
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "size", "com/intellij/ui/components/labels/DropDownLink$LinkCellRenderer", "recomputeSize"));
        }
    }
}

