/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.util.Function;
import com.intellij.util.execution.ParametersListUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.jetbrains.annotations.Nullable;

public class RawCommandLineEditor
extends JPanel
implements TextAccessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.RawCommandLineEditor");
    private final JTextField myEditor;
    private final TextFieldWithBrowseButton myTextField;
    private String myDialogCaption = "";

    public RawCommandLineEditor() {
        this((Function<String, List<String>>)ParametersListUtil.DEFAULT_LINE_PARSER, (Function<List<String>, String>)ParametersListUtil.DEFAULT_LINE_JOINER);
    }

    public RawCommandLineEditor(final Function<String, List<String>> lineParser, final Function<List<String>, String> lineJoiner) {
        super(new BorderLayout());
        if (Registry.is((String)"raw.command.line.editor.dialog")) {
            this.myTextField = new TextFieldWithBrowseButton(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (RawCommandLineEditor.this.myDialogCaption == null) {
                        Container parent = RawCommandLineEditor.this.getParent();
                        if (parent instanceof LabeledComponent) {
                            parent = parent.getParent();
                        }
                        LOG.error("Did not call RawCommandLineEditor.setDialogCaption() in " + parent);
                        RawCommandLineEditor.this.myDialogCaption = "Parameters";
                    }
                    Messages.showTextAreaDialog(RawCommandLineEditor.this.myTextField.getTextField(), RawCommandLineEditor.this.myDialogCaption, "EditParametersPopupWindow", (Function<String, List<String>>)lineParser, (Function<List<String>, String>)lineJoiner);
                }
            });
            this.myEditor = this.myTextField.getTextField();
            this.myTextField.setButtonIcon(AllIcons.Actions.ShowViewer);
            this.add((Component)this.myTextField, "Center");
        } else {
            this.myTextField = null;
            this.myEditor = new ExpandableTextField(lineParser, lineJoiner);
            this.add((Component)this.myEditor, "Center");
        }
        this.setDescriptor(null);
    }

    public void setDescriptor(FileChooserDescriptor descriptor) {
        this.setDescriptor(descriptor, true);
    }

    public void setDescriptor(FileChooserDescriptor descriptor, boolean insertSystemDependentPaths) {
        InsertPathAction.addTo(this.myEditor, descriptor, insertSystemDependentPaths);
    }

    public String getDialogCaption() {
        return this.myDialogCaption;
    }

    public void setDialogCaption(String dialogCaption) {
        this.myDialogCaption = dialogCaption != null ? dialogCaption : "";
    }

    @Override
    public void setText(@Nullable String text) {
        this.myEditor.setText(text);
    }

    @Override
    public String getText() {
        return StringUtil.notNullize((String)this.myEditor.getText());
    }

    public JTextField getTextField() {
        return this.myEditor;
    }

    public Document getDocument() {
        return this.myEditor.getDocument();
    }

    public void attachLabel(JLabel label) {
        label.setLabelFor(this.myEditor);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        (this.myTextField != null ? this.myTextField : this.myEditor).setEnabled(enabled);
    }
}

