/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.AuthData;
import git4idea.remote.GitHttpAuthDataProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiTaskExecutor;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountInformationProvider;
import org.jetbrains.plugins.github.extensions.GithubAccountGitAuthenticationFailureManager;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/github/extensions/GithubHttpAuthDataProvider;", "Lgit4idea/remote/GitHttpAuthDataProvider;", "authenticationManager", "Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "apiTaskExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiTaskExecutor;", "accountInformationProvider", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountInformationProvider;", "authenticationFailureManager", "Lorg/jetbrains/plugins/github/extensions/GithubAccountGitAuthenticationFailureManager;", "(Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;Lorg/jetbrains/plugins/github/api/GithubApiTaskExecutor;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountInformationProvider;Lorg/jetbrains/plugins/github/extensions/GithubAccountGitAuthenticationFailureManager;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "forgetPassword", "", "url", "", "authData", "Lcom/intellij/util/AuthData;", "getAuthData", "Lorg/jetbrains/plugins/github/extensions/GithubHttpAuthDataProvider$GithubAccountAuthData;", "project", "Lcom/intellij/openapi/project/Project;", "login", "getSuitableAccounts", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "GithubAccountAuthData", "intellij.vcs.github"})
public final class GithubHttpAuthDataProvider
implements GitHttpAuthDataProvider {
    private final Logger LOG;
    private final GithubAuthenticationManager authenticationManager;
    private final GithubApiTaskExecutor apiTaskExecutor;
    private final GithubAccountInformationProvider accountInformationProvider;
    private final GithubAccountGitAuthenticationFailureManager authenticationFailureManager;

    @Nullable
    public GithubAccountAuthData getAuthData(@NotNull Project project, @NotNull String url) {
        GithubAccountAuthData githubAccountAuthData;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        GithubAccount githubAccount = (GithubAccount)CollectionsKt.singleOrNull((Iterable)this.getSuitableAccounts(project, url, null));
        if (githubAccount != null) {
            GithubAccountAuthData githubAccountAuthData2;
            GithubAccount githubAccount2;
            GithubAccount account = githubAccount2 = githubAccount;
            try {
                String string = this.authenticationManager.getTokenForAccount$intellij_vcs_github(account);
                if (string == null) {
                    return null;
                }
                String token2 = string;
                String username = this.apiTaskExecutor.execute((ProgressIndicator)new DumbProgressIndicator(), account, this.accountInformationProvider.getUsernameTask(), true);
                githubAccountAuthData2 = new GithubAccountAuthData(account, username, token2);
            }
            catch (IOException e) {
                this.LOG.info("Cannot load username for " + account, (Throwable)e);
                githubAccountAuthData2 = null;
            }
            githubAccountAuthData = githubAccountAuthData2;
        } else {
            githubAccountAuthData = null;
        }
        return githubAccountAuthData;
    }

    @Nullable
    public GithubAccountAuthData getAuthData(@NotNull Project project, @NotNull String url, @NotNull String login2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)login2, (String)"login");
        GithubAccount githubAccount = (GithubAccount)CollectionsKt.singleOrNull((Iterable)this.getSuitableAccounts(project, url, login2));
        if (githubAccount != null) {
            GithubAccountAuthData githubAccountAuthData;
            GithubAccount githubAccount2;
            GithubAccount account = githubAccount2 = githubAccount;
            String string = this.authenticationManager.getTokenForAccount$intellij_vcs_github(account);
            if (string != null) {
                String string2;
                String it = string2 = string;
                githubAccountAuthData = new GithubAccountAuthData(account, login2, it);
            } else {
                githubAccountAuthData = null;
            }
            return githubAccountAuthData;
        }
        return null;
    }

    public void forgetPassword(@NotNull String url, @NotNull AuthData authData) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)authData, (String)"authData");
        if (authData instanceof GithubAccountAuthData) {
            this.authenticationFailureManager.ignoreAccount(url, ((GithubAccountAuthData)authData).getAccount());
        }
    }

    @NotNull
    public final Set<GithubAccount> getSuitableAccounts(@NotNull Project project, @NotNull String url, @Nullable String login2) {
        GithubAccount defaultAccount;
        GithubAccount it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Iterable iterable = this.authenticationManager.getAccounts();
        void var6_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (GithubAccount)element$iv$iv;
            if (!it.getServer().matches(url)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (GithubAccount)element$iv$iv;
            if (!(!this.authenticationFailureManager.isAccountIgnored(url, it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List potentialAccounts = (List)destination$iv$iv;
        if (login2 != null) {
            $receiver$iv$iv = $receiver$iv = (Iterable)potentialAccounts;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                boolean bl;
                it = (GithubAccount)element$iv$iv;
                try {
                    bl = Intrinsics.areEqual((Object)this.apiTaskExecutor.execute((ProgressIndicator)new DumbProgressIndicator(), it, this.accountInformationProvider.getUsernameTask(), true), (Object)login2);
                }
                catch (IOException e) {
                    this.LOG.info("Cannot load username for " + it, (Throwable)e);
                    bl = false;
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            potentialAccounts = (List)destination$iv$iv;
        }
        if ((defaultAccount = this.authenticationManager.getDefaultAccount(project)) != null && potentialAccounts.contains(defaultAccount)) {
            return SetsKt.setOf((Object)defaultAccount);
        }
        return CollectionsKt.toSet((Iterable)potentialAccounts);
    }

    public GithubHttpAuthDataProvider(@NotNull GithubAuthenticationManager authenticationManager, @NotNull GithubApiTaskExecutor apiTaskExecutor, @NotNull GithubAccountInformationProvider accountInformationProvider, @NotNull GithubAccountGitAuthenticationFailureManager authenticationFailureManager) {
        Logger logger;
        Intrinsics.checkParameterIsNotNull((Object)authenticationManager, (String)"authenticationManager");
        Intrinsics.checkParameterIsNotNull((Object)apiTaskExecutor, (String)"apiTaskExecutor");
        Intrinsics.checkParameterIsNotNull((Object)accountInformationProvider, (String)"accountInformationProvider");
        Intrinsics.checkParameterIsNotNull((Object)authenticationFailureManager, (String)"authenticationFailureManager");
        this.authenticationManager = authenticationManager;
        this.apiTaskExecutor = apiTaskExecutor;
        this.accountInformationProvider = accountInformationProvider;
        this.authenticationFailureManager = authenticationFailureManager;
        GithubHttpAuthDataProvider githubHttpAuthDataProvider = this;
        Logger logger2 = Logger.getInstance(GithubHttpAuthDataProvider.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        githubHttpAuthDataProvider.LOG = logger = logger2;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/extensions/GithubHttpAuthDataProvider$GithubAccountAuthData;", "Lcom/intellij/util/AuthData;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "login", "", "password", "(Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;Ljava/lang/String;Ljava/lang/String;)V", "getAccount", "()Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "intellij.vcs.github"})
    public static final class GithubAccountAuthData
    extends AuthData {
        @NotNull
        private final GithubAccount account;

        @NotNull
        public final GithubAccount getAccount() {
            return this.account;
        }

        public GithubAccountAuthData(@NotNull GithubAccount account, @NotNull String login2, @NotNull String password) {
            Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
            Intrinsics.checkParameterIsNotNull((Object)login2, (String)"login");
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            super(login2, password);
            this.account = account;
        }
    }
}

