/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.google.gson.Gson;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.ThreeState;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.extensions.TargetWithVariantExtKt;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.run.CompositeRefactoringElementListener;
import com.jetbrains.python.run.PyWorkingDirectoryRenamer;
import com.jetbrains.python.run.UndoRefactoringCompletionListener;
import com.jetbrains.python.run.targetBasedConfiguration.PyRunTargetVariant;
import com.jetbrains.python.run.targetBasedConfiguration.PyTargetTypeRefactoringKt;
import com.jetbrains.python.testing.AbstractPythonTestRunConfiguration;
import com.jetbrains.python.testing.ConfigField;
import com.jetbrains.python.testing.ConfigurationTarget;
import com.jetbrains.python.testing.PyAbstractTestConfiguration$WhenMappings;
import com.jetbrains.python.testing.PyRerunAwareConfiguration;
import com.jetbrains.python.testing.PyTargetBasedPsiLocation;
import com.jetbrains.python.testing.PyTestLegacyConfigurationAdapter;
import com.jetbrains.python.testing.PyTestsSharedKt;
import com.jetbrains.reflection.DelegationProperty;
import com.jetbrains.reflection.Properties;
import com.jetbrains.reflection.Property;
import com.jetbrains.reflection.ReflectionUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\"J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u0018\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0*2\b\b\u0002\u0010+\u001a\u00020&H\u0002J\b\u0010,\u001a\u00020\"H\u0002J\u0012\u0010-\u001a\u00020\t2\b\b\u0002\u0010+\u001a\u00020&H\u0014J\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0*2\n\u0010/\u001a\u0006\u0012\u0002\b\u000300H\u0002J\u0014\u00101\u001a\u0004\u0018\u0001022\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\f\u00103\u001a\b\u0012\u0004\u0012\u00020\t0*J\u001e\u00103\u001a\u0004\u0018\u00010\t2\n\u0010/\u001a\u0006\u0012\u0002\b\u0003002\u0006\u00104\u001a\u000205H\u0016J4\u00106\u001a\b\u0012\u0004\u0012\u00020\t0*2\u0006\u00107\u001a\u0002082\u001c\u00109\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u000300\u0012\u0004\u0012\u0002050;0:H\u0016J\u000f\u0010<\u001a\u0004\u0018\u00010=H\u0000\u00a2\u0006\u0002\b>J\b\u0010?\u001a\u00020\tH\u0016J\b\u0010@\u001a\u00020&H&J\b\u0010A\u001a\u00020&H\u0016J\u001a\u0010B\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010C\u001a\u0004\u0018\u00010\tH\u0016J\u0006\u0010D\u001a\u00020EJ\u0010\u0010F\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020GH\u0016J\u0006\u0010H\u001a\u00020\u001fJ\u0010\u0010I\u001a\u00020\u001f2\u0006\u0010J\u001a\u00020\tH\u0016J\r\u0010K\u001a\u00020&H\u0010\u00a2\u0006\u0002\bLJ\b\u0010M\u001a\u00020\tH\u0016J\u0010\u0010N\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020GH\u0016R$\u0010\u000b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\u00138\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\r\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u00020\u00188\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0019\u0010\r\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000f\u00a8\u0006O"}, d2={"Lcom/jetbrains/python/testing/PyAbstractTestConfiguration;", "Lcom/jetbrains/python/testing/AbstractPythonTestRunConfiguration;", "Lcom/jetbrains/python/testing/PyRerunAwareConfiguration;", "Lcom/intellij/execution/configurations/RefactoringListenerProvider;", "project", "Lcom/intellij/openapi/project/Project;", "configurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "runnerName", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;)V", "additionalArguments", "additionalArguments$annotations", "()V", "getAdditionalArguments", "()Ljava/lang/String;", "setAdditionalArguments", "(Ljava/lang/String;)V", "legacyConfigurationAdapter", "Lcom/jetbrains/python/testing/PyTestLegacyConfigurationAdapter;", "legacyConfigurationAdapter$annotations", "getLegacyConfigurationAdapter", "()Lcom/jetbrains/python/testing/PyTestLegacyConfigurationAdapter;", "target", "Lcom/jetbrains/python/testing/ConfigurationTarget;", "target$annotations", "getTarget", "()Lcom/jetbrains/python/testing/ConfigurationTarget;", "testFrameworkName", "getTestFrameworkName", "checkConfiguration", "", "copyFrom", "src", "Lcom/jetbrains/reflection/Properties;", "copyTo", "dst", "couldBeTestTarget", "", "element", "Lcom/intellij/psi/PsiElement;", "generateRawArguments", "", "forRerun", "getConfigFields", "getCustomRawArgumentsString", "getPythonTestSpecByLocation", "location", "Lcom/intellij/execution/Location;", "getRefactoringElementListener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "getTestSpec", "failedTest", "Lcom/intellij/execution/testframework/AbstractTestProxy;", "getTestSpecsForRerun", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "locations", "", "Lcom/intellij/openapi/util/Pair;", "getWorkingDirectoryAsVirtual", "Lcom/intellij/openapi/vfs/VirtualFile;", "getWorkingDirectoryAsVirtual$intellij_python_community_impl", "getWorkingDirectorySafe", "isFrameworkInstalled", "isIdTestBased", "isSameAsLocation", "metainfo", "isTestClassRequired", "Lcom/intellij/util/ThreeState;", "readExternal", "Lorg/jdom/Element;", "reset", "setMetaInfo", "metaInfo", "shouldSeparateTargetPath", "shouldSeparateTargetPath$intellij_python_community_impl", "suggestedName", "writeExternal", "intellij.python.community.impl"})
public abstract class PyAbstractTestConfiguration
extends AbstractPythonTestRunConfiguration<PyAbstractTestConfiguration>
implements PyRerunAwareConfiguration,
RefactoringListenerProvider {
    @NotNull
    private final ConfigurationTarget target;
    @NotNull
    private String additionalArguments;
    @NotNull
    private final String testFrameworkName;
    @NotNull
    private final PyTestLegacyConfigurationAdapter<PyAbstractTestConfiguration> legacyConfigurationAdapter;
    private final String runnerName;

    @DelegationProperty
    public static /* synthetic */ void target$annotations() {
    }

    @NotNull
    public final ConfigurationTarget getTarget() {
        return this.target;
    }

    @ConfigField
    public static /* synthetic */ void additionalArguments$annotations() {
    }

    @NotNull
    public final String getAdditionalArguments() {
        return this.additionalArguments;
    }

    public final void setAdditionalArguments(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.additionalArguments = string;
    }

    @NotNull
    public final String getTestFrameworkName() {
        return this.testFrameworkName;
    }

    @NotNull
    public final ThreeState isTestClassRequired() {
        return PyTestsSharedKt.getRunnersThatRequireTestCaseClass().contains(this.runnerName) ? ThreeState.YES : ThreeState.NO;
    }

    @DelegationProperty
    public static /* synthetic */ void legacyConfigurationAdapter$annotations() {
    }

    @NotNull
    public final PyTestLegacyConfigurationAdapter<PyAbstractTestConfiguration> getLegacyConfigurationAdapter() {
        return this.legacyConfigurationAdapter;
    }

    @Nullable
    public final VirtualFile getWorkingDirectoryAsVirtual$intellij_python_community_impl() {
        CharSequence charSequence = this.getWorkingDirectory();
        if (!(charSequence == null || charSequence.length() == 0)) {
            return LocalFileSystem.getInstance().findFileByPath(this.getWorkingDirectory());
        }
        return null;
    }

    @Override
    @NotNull
    public String getWorkingDirectorySafe() {
        String dirProvidedByUser = super.getWorkingDirectory();
        CharSequence charSequence = dirProvidedByUser;
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string = dirProvidedByUser;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dirProvidedByUser");
            return string;
        }
        Object object = this.target.getElementDirectory(this);
        if (object == null || (object = object.getPath()) == null) {
            String string = super.getWorkingDirectorySafe();
            object = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"super.getWorkingDirectorySafe()");
        }
        return object;
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(@Nullable PsiElement element) {
        CompositeRefactoringElementListener renamer;
        block1: {
            UndoRefactoringCompletionListener undoRefactoringCompletionListener;
            if (element == null) {
                return null;
            }
            renamer = new CompositeRefactoringElementListener(new PyWorkingDirectoryRenamer(this.getWorkingDirectoryAsVirtual$intellij_python_community_impl(), this));
            UndoRefactoringCompletionListener undoRefactoringCompletionListener2 = PyTargetTypeRefactoringKt.createRefactoringListenerIfPossible(element, this.target.asPsiElement(this), TargetWithVariantExtKt.asVirtualFile(this.target), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
                final /* synthetic */ PyAbstractTestConfiguration this$0;

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    this.this$0.getTarget().setTarget(it);
                }
                {
                    this.this$0 = pyAbstractTestConfiguration;
                    super(1);
                }
            }));
            if (undoRefactoringCompletionListener2 == null) break block1;
            UndoRefactoringCompletionListener it = undoRefactoringCompletionListener = undoRefactoringCompletionListener2;
            renamer = renamer.plus(it);
        }
        return (RefactoringElementListener)renamer;
    }

    @Override
    public void checkConfiguration() {
        super.checkConfiguration();
        if (!this.isFrameworkInstalled()) {
            throw (Throwable)new RuntimeConfigurationWarning(PyBundle.message("runcfg.testing.no.test.framework", this.testFrameworkName));
        }
        this.target.checkValid();
    }

    public abstract boolean isFrameworkInstalled();

    @Override
    public boolean isIdTestBased() {
        return true;
    }

    private final List<String> getPythonTestSpecByLocation(Location<?> location) {
        if (location instanceof PyTargetBasedPsiLocation) {
            return ((PyTargetBasedPsiLocation)location).getTarget().generateArgumentsLine(this);
        }
        if (!(location instanceof PsiLocation)) {
            return CollectionsKt.emptyList();
        }
        if (!(((PsiLocation)location).getPsiElement() instanceof PyQualifiedNameOwner)) {
            return CollectionsKt.emptyList();
        }
        PsiElement psiElement = ((PsiLocation)location).getPsiElement();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.python.psi.PyQualifiedNameOwner");
        }
        String string = ((PyQualifiedNameOwner)psiElement).getQualifiedName();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(location.psiElement as \u2026ame ?: return emptyList()");
        String qualifiedName = string;
        return new ConfigurationTarget(qualifiedName, PyRunTargetVariant.PYTHON).generateArgumentsLine(this);
    }

    @Override
    @Nullable
    public String getTestSpec(@NotNull Location<?> location, @NotNull AbstractTestProxy failedTest) {
        Intrinsics.checkParameterIsNotNull(location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)failedTest, (String)"failedTest");
        List<String> list2 = this.getPythonTestSpecByLocation(location);
        if (list2.isEmpty()) {
            return null;
        }
        return CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getTestSpecsForRerun(@NotNull GlobalSearchScope scope, @NotNull List<Pair<Location<?>, AbstractTestProxy>> locations) {
        PsiElement key$iv;
        Object object;
        Location it;
        Collection collection;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull(locations, (String)"locations");
        ArrayList result2 = new ArrayList();
        Iterable $receiver$iv = locations;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            object = (Location)it.first;
            collection.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterable<PsiElement> set$iv = new HashSet();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $receiver$iv) {
            Location location = it = (Location)e$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)location, (String)"it");
            key$iv = location.getPsiElement();
            if (!((HashSet)set$iv).add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        $receiver$iv = list$iv;
        set$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            key$iv = (Location)item$iv$iv;
            collection = destination$iv$iv;
            Location location = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)location, (String)"it");
            object = this.getPythonTestSpecByLocation(location);
            collection.add(object);
        }
        $receiver$iv = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        for (Object element$iv : $receiver$iv) {
            List it2 = (List)element$iv;
            result2.addAll(it2);
        }
        return CollectionsKt.plus((Collection)result2, (Iterable)this.generateRawArguments(true));
    }

    @NotNull
    public final List<String> getTestSpec() {
        return CollectionsKt.plus((Collection)this.target.generateArgumentsLine(this), (Iterable)PyAbstractTestConfiguration.generateRawArguments$default(this, false, 1, null));
    }

    private final List<String> generateRawArguments(boolean forRerun) {
        String rawArguments = this.additionalArguments + " " + this.getCustomRawArgumentsString(forRerun);
        CharSequence charSequence = rawArguments;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            Collection collection = CollectionsKt.listOf((Object)"--");
            List list2 = ParametersListUtil.parse((String)rawArguments, (boolean)false, (boolean)true);
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"com.intellij.util.execut\u2026awArguments, false, true)");
            return CollectionsKt.plus((Collection)collection, (Iterable)list2);
        }
        return CollectionsKt.emptyList();
    }

    static /* bridge */ /* synthetic */ List generateRawArguments$default(PyAbstractTestConfiguration pyAbstractTestConfiguration, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateRawArguments");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return pyAbstractTestConfiguration.generateRawArguments(bl);
    }

    @NotNull
    public String suggestedName() {
        String string;
        switch (PyAbstractTestConfiguration$WhenMappings.$EnumSwitchMapping$0[this.target.getTargetType().ordinal()]) {
            case 1: {
                VirtualFile virtualFile = TargetWithVariantExtKt.asVirtualFile(this.target);
                String name = virtualFile != null ? virtualFile.getName() : null;
                StringBuilder stringBuilder = new StringBuilder().append(this.testFrameworkName).append(" in ");
                String string2 = name;
                if (string2 == null) {
                    string2 = this.target.getTarget();
                }
                string = stringBuilder.append((Object)string2).toString();
                break;
            }
            case 2: {
                string = this.testFrameworkName + " for " + this.target.getTarget();
                break;
            }
            default: {
                string = this.testFrameworkName;
            }
        }
        return string;
    }

    @NotNull
    protected String getCustomRawArgumentsString(boolean forRerun) {
        return "";
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String getCustomRawArgumentsString$default(PyAbstractTestConfiguration pyAbstractTestConfiguration, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCustomRawArgumentsString");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return pyAbstractTestConfiguration.getCustomRawArgumentsString(bl);
    }

    public final void reset() {
        this.target.setTarget(PyTestsSharedKt.access$getDEFAULT_PATH$p());
        this.target.setTargetType(PyRunTargetVariant.PATH);
        this.additionalArguments = "";
    }

    public final void copyFrom(@NotNull Properties src) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        src.copyTo(this.getConfigFields());
    }

    public final void copyTo(@NotNull Properties dst) {
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        this.getConfigFields().copyTo(dst);
    }

    @Override
    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.legacyConfigurationAdapter.writeExternal(element);
        super.writeExternal(element);
        Gson gson2 = new Gson();
        Iterable $receiver$iv = this.getConfigFields().getProperties();
        for (Object element$iv : $receiver$iv) {
            Property it = (Property)element$iv;
            Object value = it.get();
            if (value == null) continue;
            JDOMExternalizerUtil.writeField((Element)element, (String)PyTestsSharedKt.access$getPrefixedName$p(it), (String)gson2.toJson(value));
        }
    }

    @Override
    public void readExternal(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.readExternal(element);
        Gson gson2 = new Gson();
        Iterable $receiver$iv = this.getConfigFields().getProperties();
        for (Object element$iv : $receiver$iv) {
            Property it = (Property)element$iv;
            Object fromJson = gson2.fromJson(JDOMExternalizerUtil.readField((Element)element, (String)PyTestsSharedKt.access$getPrefixedName$p(it)), it.getType());
            if (fromJson == null) continue;
            it.set(fromJson);
        }
        this.legacyConfigurationAdapter.readExternal(element);
    }

    private final Properties getConfigFields() {
        return ReflectionUtilsKt.getProperties$default(this, ConfigField.class, false, 4, null);
    }

    public final boolean couldBeTestTarget(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        TypeEvalContext context = TypeEvalContext.userInitiated(element.getProject(), element.getContainingFile());
        ThreeState threeState = this.isTestClassRequired();
        TypeEvalContext typeEvalContext = context;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"context");
        return PyTestsSharedKt.isTestElement(element, threeState, typeEvalContext);
    }

    public boolean shouldSeparateTargetPath$intellij_python_community_impl() {
        return true;
    }

    public void setMetaInfo(@NotNull String metaInfo) {
        Intrinsics.checkParameterIsNotNull((Object)metaInfo, (String)"metaInfo");
    }

    public boolean isSameAsLocation(@NotNull ConfigurationTarget target2, @Nullable String metainfo) {
        Intrinsics.checkParameterIsNotNull((Object)target2, (String)"target");
        return Intrinsics.areEqual((Object)target2, (Object)this.target);
    }

    public PyAbstractTestConfiguration(@NotNull Project project, @NotNull ConfigurationFactory configurationFactory, @NotNull String runnerName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)configurationFactory, (String)"configurationFactory");
        Intrinsics.checkParameterIsNotNull((Object)runnerName, (String)"runnerName");
        super(project, configurationFactory);
        this.runnerName = runnerName;
        this.target = new ConfigurationTarget(PyTestsSharedKt.access$getDEFAULT_PATH$p(), PyRunTargetVariant.PATH);
        this.additionalArguments = "";
        String string = configurationFactory.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.testFrameworkName = string;
        this.legacyConfigurationAdapter = new PyTestLegacyConfigurationAdapter<PyAbstractTestConfiguration>(this);
    }
}

