/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ThreeState;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyMoveAttributeToInitQuickFix;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.testing.PythonUnitTestUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyAttributeOutsideInitInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.attribute.outside.init", new Object[0]);
        if (string == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session2);
        if (visitor2 == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    private static boolean isDefinedByProperty(@NotNull PyTargetExpression attribute, @NotNull Collection<Property> properties, @NotNull Map<String, PyTargetExpression> attributesInInit) {
        if (attribute == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(4);
        }
        if (properties == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(5);
        }
        if (attributesInInit == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(6);
        }
        return ((StreamEx)StreamEx.of(properties).filter(it -> {
            if (attribute == null) {
                PyAttributeOutsideInitInspection.$$$reportNull$$$0(14);
            }
            return PyAttributeOutsideInitInspection.isSetBy(attribute, it);
        })).anyMatch(it -> {
            if (attributesInInit == null) {
                PyAttributeOutsideInitInspection.$$$reportNull$$$0(13);
            }
            return attributesInInit.containsKey(it.getName());
        });
    }

    private static boolean isApplicable(@NotNull PyClass containingClass, @NotNull TypeEvalContext context) {
        if (containingClass == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(7);
        }
        if (context == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(8);
        }
        return !PythonUnitTestUtil.isTestClass(containingClass, ThreeState.UNSURE, context) && !containingClass.isSubclass("django.db.models.base.Model", context);
    }

    @Nullable
    private static Collection<PyTargetExpression> getSetterTargetExpressions(@NotNull Property property) {
        if (property == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(9);
        }
        if (!property.getSetter().isDefined() || property.getSetter().value() == null) {
            return null;
        }
        PyFunction setter = property.getSetter().value().asMethod();
        if (setter == null) {
            return null;
        }
        return ControlFlowCache.getScope(setter).getTargetExpressions();
    }

    private static boolean isSetBy(@NotNull PyTargetExpression attribute, @NotNull Property property) {
        Collection<PyTargetExpression> propertyTargetExpressions;
        if (attribute == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(10);
        }
        if (property == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(11);
        }
        return (propertyTargetExpressions = PyAttributeOutsideInitInspection.getSetterTargetExpressions(property)) != null && attribute.getName() != null && StreamEx.of(propertyTargetExpressions).map(targetExpression -> targetExpression.getName()).nonNull().anyMatch(name -> {
            if (attribute == null) {
                PyAttributeOutsideInitInspection.$$$reportNull$$$0(12);
            }
            return name.equals(attribute.getName());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyAttributeOutsideInitInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesInInit";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyAttributeOutsideInitInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDefinedByProperty";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSetterTargetExpressions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSetBy";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isSetBy$3";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isDefinedByProperty$1";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isDefinedByProperty$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session2) {
            if (session2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session2);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            PyClass containingClass = node.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String name = node.getName();
            if (name != null && name.startsWith("_")) {
                return;
            }
            if (!PyAttributeOutsideInitInspection.isApplicable(containingClass, this.myTypeEvalContext)) {
                return;
            }
            if (node.getModifier() != null) {
                return;
            }
            List<PyTargetExpression> classAttributes = containingClass.getClassAttributes();
            Map<String, Property> properties = containingClass.getProperties();
            HashMap<String, PyTargetExpression> attributesInInit = new HashMap<String, PyTargetExpression>();
            ((StreamEx)StreamEx.of(classAttributes).filter(attribute -> !properties.containsKey(attribute.getName()))).forEach(attribute -> attributesInInit.put(attribute.getName(), (PyTargetExpression)attribute));
            PyFunction initMethod = containingClass.findMethodByName("__init__", false, null);
            if (initMethod != null) {
                PyClassImpl.collectInstanceAttributes(initMethod, attributesInInit);
            }
            for (PyClass superClass : containingClass.getAncestorClasses(this.myTypeEvalContext)) {
                PyFunction superInit = superClass.findMethodByName("__init__", false, null);
                if (superInit != null) {
                    PyClassImpl.collectInstanceAttributes(superInit, attributesInInit);
                }
                for (PyTargetExpression classAttr : superClass.getClassAttributes()) {
                    attributesInInit.put(classAttr.getName(), classAttr);
                }
            }
            HashMap<String, PyTargetExpression> attributes = new HashMap<String, PyTargetExpression>();
            PyClassImpl.collectInstanceAttributes(node, attributes);
            for (PyTargetExpression attribute2 : attributes.values()) {
                String attributeName = attribute2.getName();
                if (attributeName == null || attributesInInit.containsKey(attributeName) || PyAttributeOutsideInitInspection.isDefinedByProperty(attribute2, properties.values(), attributesInInit)) continue;
                this.registerProblem((PsiElement)attribute2, PyBundle.message("INSP.attribute.$0.outside.init", attributeName), new PyMoveAttributeToInitQuickFix());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyAttributeOutsideInitInspection$Visitor", "<init>"));
        }
    }
}

