/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.collect.Lists;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.documentation.DocumentationBuilderKit;
import com.jetbrains.python.documentation.PyDocumentationLink;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.PyStructuredDocstringFormatter;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatementWithElse;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.QualifiedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.toolbox.ChainIterable;
import com.jetbrains.python.toolbox.Maybe;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDocumentationBuilder {
    private final PsiElement myElement;
    private final PsiElement myOriginalElement;
    private final ChainIterable<String> myProlog;
    private final ChainIterable<String> myBody;
    private final ChainIterable<String> myContent;
    private final ChainIterable<String> mySections;
    private final Map<String, ChainIterable<String>> mySectionsMap;
    private final TypeEvalContext myContext;
    private static final Pattern ourSpacesPattern = Pattern.compile("^\\s+");

    public PyDocumentationBuilder(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        if (element == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(0);
        }
        this.mySectionsMap = FactoryMap.createMap(item -> new ChainIterable(), LinkedHashMap::new);
        this.myElement = element;
        this.myOriginalElement = originalElement;
        this.myProlog = new ChainIterable();
        this.myBody = new ChainIterable();
        this.myContent = new ChainIterable();
        this.mySections = new ChainIterable();
        this.myContext = TypeEvalContext.userInitiated(this.myElement.getProject(), this.myElement.getContainingFile());
    }

    @Nullable
    public String build() {
        PsiElement outerElement = this.myOriginalElement != null ? this.myOriginalElement.getParent() : null;
        PsiElement elementDefinition = this.resolveToDocStringOwner();
        PsiElement propertyDefinition = this.buildFromProperty(elementDefinition, outerElement);
        boolean isProperty = false;
        if (propertyDefinition != null) {
            isProperty = true;
            elementDefinition = propertyDefinition;
        }
        if (elementDefinition instanceof PyDocStringOwner) {
            this.buildFromDocstring((PyDocStringOwner)elementDefinition, isProperty);
        } else if (elementDefinition instanceof PyNamedParameter) {
            this.buildFromParameter((PyNamedParameter)elementDefinition);
        }
        ASTNode node = elementDefinition.getNode();
        if (node != null && PythonDialectsTokenSetProvider.INSTANCE.getKeywordTokens().contains(node.getElementType())) {
            PyStatementWithElse statement;
            String documentationName = elementDefinition.getText();
            if (node.getElementType() == PyTokenTypes.AS_KEYWORD || node.getElementType() == PyTokenTypes.ELSE_KEYWORD) {
                statement = (PyTryExceptStatement)PsiTreeUtil.getParentOfType((PsiElement)elementDefinition, PyTryExceptStatement.class);
                if (statement != null) {
                    documentationName = "try";
                }
            } else if (node.getElementType() == PyTokenTypes.IN_KEYWORD && (statement = (PyForStatement)PsiTreeUtil.getParentOfType((PsiElement)elementDefinition, PyForStatement.class)) != null) {
                documentationName = "for";
            }
            this.buildForKeyword(documentationName);
        }
        if (!this.mySectionsMap.isEmpty()) {
            this.mySections.addItem("<table class='sections'>");
            ArrayList firstSections = Lists.newArrayList((Object[])new String[]{CodeInsightBundle.message((String)"javadoc.parameters", (Object[])new Object[0]), PyBundle.message("QDOC.keyword.args", new Object[0]), CodeInsightBundle.message((String)"javadoc.returns", (Object[])new Object[0]), PyBundle.message("QDOC.raises", new Object[0])});
            firstSections.retainAll(this.mySectionsMap.keySet());
            ArrayList<String> remainingSections = new ArrayList<String>(this.mySectionsMap.keySet());
            remainingSections.removeAll(firstSections);
            for (String header : ContainerUtil.concat((List)firstSections, remainingSections)) {
                this.mySections.addItem("<tr><td valign='top' class='section'><p>");
                this.mySections.addItem(header);
                this.mySections.addItem("</td><td valign='top'>");
                this.mySections.add((Iterable<String>)this.mySectionsMap.get(header));
                this.mySections.addItem("</td>");
            }
            this.mySections.addItem("</table>");
        }
        if (this.myBody.isEmpty() && this.myContent.isEmpty()) {
            return null;
        }
        ChainIterable<String> result2 = new ChainIterable<String>();
        if (!this.myProlog.isEmpty() || !this.myBody.isEmpty()) {
            result2.addItem("<div class='definition'><pre>").add(this.myProlog);
            if (!this.myBody.isEmpty() && !this.myProlog.isEmpty()) {
                result2.addItem("<br>");
            }
            result2.add(this.myBody).addItem("</pre></div>");
        }
        if (!this.myContent.isEmpty()) {
            result2.addItem("<div class='content'>").add(this.myContent).addItem("</div>");
        }
        result2.add(this.mySections);
        return DocumentationBuilderKit.wrapInTag("html", DocumentationBuilderKit.wrapInTag("body", result2)).toString();
    }

    private void buildForKeyword(@NotNull String name) {
        if (name == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(1);
        }
        try (FileReader reader = new FileReader(PythonHelpersLocator.getHelperPath("/tools/python_keywords/" + name));){
            String text2 = FileUtil.loadTextAndClose((Reader)reader);
            this.myContent.addItem(StringUtil.convertLineSeparators((String)text2, (String)"\n"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void buildFromParameter(@NotNull PyNamedParameter parameter) {
        StructuredDocString structuredDocString;
        String description;
        PyStringLiteralExpression docString;
        PyFunction func;
        String link;
        if (parameter == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(2);
        }
        String string = link = (func = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)parameter, PyFunction.class, (boolean)true, (Class[])new Class[]{PyLambdaExpression.class})) != null ? PyDocumentationBuilder.getLinkToFunction(func, true) : StringUtil.escapeXml((String)"<unnamed>");
        if (link != null) {
            this.myProlog.addItem("Parameter ").addWith(DocumentationBuilderKit.TagBold, DocumentationBuilderKit.$(parameter.getName())).addItem(" of ").addItem(link);
        }
        if (func != null && (docString = PyDocumentationBuilder.getEffectiveDocStringExpression(func)) != null && StringUtil.isNotEmpty((String)(description = (structuredDocString = DocStringUtil.parse(docString.getStringValue())).getParamDescription(parameter.getName())))) {
            this.myContent.add(DocumentationBuilderKit.$(description));
        }
        this.myBody.add(PythonDocumentationProvider.describeParameter(parameter, this.myContext));
    }

    @Nullable
    private PsiElement buildFromProperty(@NotNull PsiElement elementDefinition, @Nullable PsiElement outerElement) {
        PyStringLiteralExpression getterDocstring;
        PyFunction getter;
        PyStringLiteralExpression accessorDocstring;
        PyFunction accessorFunc;
        if (elementDefinition == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(3);
        }
        if (this.myOriginalElement == null) {
            return null;
        }
        String elementName = this.myOriginalElement.getText();
        if (!PyNames.isIdentifier(elementName)) {
            return null;
        }
        if (!(outerElement instanceof PyQualifiedExpression)) {
            return null;
        }
        PyExpression qualifier = ((PyQualifiedExpression)outerElement).getQualifier();
        if (qualifier == null) {
            return null;
        }
        PyType type = this.myContext.getType(qualifier);
        if (!(type instanceof PyClassType)) {
            return null;
        }
        PyClass cls = ((PyClassType)type).getPyClass();
        Property property = cls.findProperty(elementName, true, null);
        if (property == null) {
            return null;
        }
        AccessDirection direction = AccessDirection.of((PyElement)outerElement);
        Maybe<PyCallable> accessor = property.getByDirection(direction);
        String link = this.getLinkToClass(cls, true);
        if (link != null) {
            this.myProlog.addItem("Property ").addWith(DocumentationBuilderKit.TagBold, DocumentationBuilderKit.$(elementName)).addItem(" of ").addItem(link);
        }
        String docstring = null;
        if (property.getDoc() != null) {
            docstring = property.getDoc();
        }
        if (docstring == null && (accessorFunc = PyUtil.as(accessor.valueOrNull(), PyFunction.class)) != null && (accessorDocstring = PyDocumentationBuilder.getEffectiveDocStringExpression(accessorFunc)) != null) {
            docstring = accessorDocstring.getStringValue();
        }
        if (docstring == null && direction != AccessDirection.READ && (getter = PyUtil.as(property.getGetter().valueOrNull(), PyFunction.class)) != null && (getterDocstring = PyDocumentationBuilder.getEffectiveDocStringExpression(getter)) != null) {
            this.mySectionsMap.get(PyBundle.message("QDOC.documentation.is.copied.from", new Object[0])).addItem("property getter");
            docstring = getterDocstring.getStringValue();
        }
        if (docstring != null) {
            this.myContent.add(PyDocumentationBuilder.formatDocString(elementDefinition, docstring));
        }
        String accessorKind = PyDocumentationBuilder.getAccessorKind(direction);
        this.mySectionsMap.get(PyBundle.message("QDOC.accessor.kind", new Object[0])).addItem(accessorKind).addItem(accessor.valueOrNull() == null ? " (not defined)" : "");
        if (accessor.valueOrNull() != null) {
            return (PsiElement)accessor.value();
        }
        if (property.getGetter().valueOrNull() != null) {
            return (PsiElement)property.getGetter().value();
        }
        return property.getDefinitionSite();
    }

    @NotNull
    private static String getAccessorKind(@NotNull AccessDirection dir) {
        if (dir == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(4);
        }
        String accessorKind = dir == AccessDirection.READ ? "Getter" : (dir == AccessDirection.WRITE ? "Setter" : "Deleter");
        String string = accessorKind;
        if (string == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(5);
        }
        return string;
    }

    private void buildFromDocstring(@NotNull PyDocStringOwner elementDefinition, boolean isProperty) {
        String link;
        PsiFile containing;
        if (elementDefinition == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(6);
        }
        PyStringLiteralExpression docStringExpression = PyDocumentationBuilder.getEffectiveDocStringExpression(elementDefinition);
        if (PyUtil.isTopLevel((PsiElement)elementDefinition) && (containing = elementDefinition.getContainingFile()) instanceof PyFile && (link = PyDocumentationBuilder.getLinkToModule((PyFile)containing)) != null) {
            this.myProlog.addItem(link);
        }
        if (elementDefinition instanceof PyClass) {
            PyFunction constructor;
            PyClass pyClass = (PyClass)elementDefinition;
            this.myBody.add(PythonDocumentationProvider.describeDecorators(pyClass, DocumentationBuilderKit.WRAP_IN_ITALIC, DocumentationBuilderKit.ESCAPE_AND_SAVE_NEW_LINES_AND_SPACES, "<br>", "<br>"));
            this.myBody.add(PythonDocumentationProvider.describeClass(pyClass, DocumentationBuilderKit.WRAP_IN_BOLD, DocumentationBuilderKit.ESCAPE_AND_SAVE_NEW_LINES_AND_SPACES, false, true, this.myContext));
            if (docStringExpression == null && (constructor = pyClass.findMethodByName("__init__", false, this.myContext)) != null) {
                docStringExpression = constructor.getDocStringExpression();
            }
        } else if (elementDefinition instanceof PyFunction) {
            String link2;
            PyFunction pyFunction = (PyFunction)elementDefinition;
            PyClass pyClass = pyFunction.getContainingClass();
            if (!isProperty && pyClass != null && (link2 = this.getLinkToClass(pyClass, true)) != null) {
                this.myProlog.addItem(link2);
            }
            this.myBody.add(PythonDocumentationProvider.describeDecorators(pyFunction, DocumentationBuilderKit.WRAP_IN_ITALIC, DocumentationBuilderKit.ESCAPE_AND_SAVE_NEW_LINES_AND_SPACES, "<br>", "<br>"));
            this.myBody.add(PythonDocumentationProvider.describeFunction(pyFunction, this.myOriginalElement, this.myContext, false));
            if (docStringExpression == null && pyClass != null && !isProperty) {
                docStringExpression = this.addInheritedDocString(pyFunction, pyClass);
            }
            if (docStringExpression != null) {
                this.addFunctionSpecificSections(docStringExpression, pyFunction);
            }
        } else if (elementDefinition instanceof PyFile) {
            this.addModulePath((PyFile)elementDefinition);
        } else if (elementDefinition instanceof PyTargetExpression) {
            PyTargetExpression target2 = (PyTargetExpression)elementDefinition;
            if (this.isAttribute() && !isProperty && (link = this.getLinkToClass(target2.getContainingClass(), true)) != null) {
                this.myProlog.addItem(PyUtil.isInstanceAttribute(target2) ? "Instance attribute " : "Class attribute ").addWith(DocumentationBuilderKit.TagBold, DocumentationBuilderKit.$(elementDefinition.getName())).addItem(" of ").addItem(link);
            }
            this.myBody.add(PythonDocumentationProvider.describeTarget(target2, this.myContext));
        }
        if (docStringExpression != null && !isProperty) {
            this.myContent.add(PyDocumentationBuilder.formatDocString(this.myElement, docStringExpression.getStringValue()));
        }
    }

    private void addFunctionSpecificSections(@NotNull PyStringLiteralExpression docstring, @NotNull PyFunction function) {
        String exceptionList;
        String returnDescription;
        String keywordArgsList;
        if (docstring == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(7);
        }
        if (function == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(8);
        }
        StructuredDocString structured = DocStringUtil.parseDocString(docstring);
        List parameters2 = function.getParameters(this.myContext);
        List actualNames = ContainerUtil.mapNotNull((Collection)parameters2, PyCallableParameter::getName);
        String paramList = ((StreamEx)StreamEx.of((Collection)actualNames).filter(name -> structured.getParamDescription((String)name) != null)).map(name -> {
            String description = structured.getParamDescription((String)name);
            return "<p><code>" + name + "</code> &ndash; " + description + "</p>";
        }).joining();
        if (!paramList.isEmpty()) {
            this.mySectionsMap.get(CodeInsightBundle.message((String)"javadoc.parameters", (Object[])new Object[0])).addItem(paramList);
        }
        List<String> allKeywordArgs = structured.getKeywordArguments();
        if (!ContainerUtil.exists((Iterable)parameters2, PyCallableParameter::isKeywordContainer)) {
            allKeywordArgs.retainAll(new HashSet(actualNames));
        }
        if (!(keywordArgsList = StreamEx.of(allKeywordArgs).map(name -> {
            String description = structured.getKeywordArgumentDescription((String)name);
            return "<p><code>" + name + "</code> &ndash; " + StringUtil.notNullize((String)description) + "</p>";
        }).joining()).isEmpty()) {
            this.mySectionsMap.get(PyBundle.message("QDOC.keyword.args", new Object[0])).addItem(keywordArgsList);
        }
        if ((returnDescription = structured.getReturnDescription()) != null) {
            this.mySectionsMap.get(CodeInsightBundle.message((String)"javadoc.returns", (Object[])new Object[0])).addItem(returnDescription);
        }
        if (!(exceptionList = StreamEx.of(structured.getRaisedExceptions()).map(name -> {
            String description = structured.getRaisedExceptionDescription((String)name);
            return "<p><code>" + name + "</code>" + (StringUtil.isNotEmpty((String)description) ? " &ndash; " + description : "") + "</p>";
        }).joining()).isEmpty()) {
            this.mySectionsMap.get(PyBundle.message("QDOC.raises", new Object[0])).addItem(exceptionList);
        }
    }

    private boolean isAttribute() {
        return this.myElement instanceof PyTargetExpression && PyUtil.isAttribute((PyTargetExpression)this.myElement);
    }

    @NotNull
    private PsiElement resolveToDocStringOwner() {
        PsiElement resolved;
        PsiElement resolved2;
        PyExpression assignedValue;
        if (this.myElement instanceof PyTargetExpression && ((PyTargetExpression)this.myElement).getDocStringValue() == null && (assignedValue = ((PyTargetExpression)this.myElement).findAssignedValue()) instanceof PyReferenceExpression && (resolved2 = this.resolveWithoutImplicits((PyReferenceExpression)assignedValue)) instanceof PyDocStringOwner) {
            this.mySectionsMap.get(PyBundle.message("QDOC.assigned.to", new Object[0])).addWith(DocumentationBuilderKit.TagCode, DocumentationBuilderKit.$(((PyTargetExpression)this.myElement).getName()));
            PsiElement psiElement = resolved2;
            if (psiElement == null) {
                PyDocumentationBuilder.$$$reportNull$$$0(9);
            }
            return psiElement;
        }
        if (this.myElement instanceof PyReferenceExpression && (resolved = this.resolveWithoutImplicits((PyReferenceExpression)this.myElement)) != null) {
            PsiElement psiElement = resolved;
            if (psiElement == null) {
                PyDocumentationBuilder.$$$reportNull$$$0(10);
            }
            return psiElement;
        }
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(11);
        }
        return psiElement;
    }

    @Nullable
    private PsiElement resolveWithoutImplicits(@NotNull PyReferenceExpression element) {
        PyResolveContext resolveContext;
        QualifiedResolveResult resolveResult;
        if (element == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(12);
        }
        return (resolveResult = element.followAssignmentsChain(resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(this.myContext))).isImplicit() ? null : resolveResult.getElement();
    }

    @Nullable
    private PyStringLiteralExpression addInheritedDocString(@NotNull PyFunction pyFunction, @NotNull PyClass pyClass) {
        String methodName;
        if (pyFunction == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(13);
        }
        if (pyClass == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(14);
        }
        if ((methodName = pyFunction.getName()) == null) {
            return null;
        }
        boolean isConstructor = "__init__".equals(methodName);
        Iterable<PyClass> classes = pyClass.getAncestorClasses(this.myContext);
        if (isConstructor) {
            classes = new ChainIterable<PyClass>(pyClass).add(classes);
        }
        for (PyClass ancestor : classes) {
            String ancestorLink;
            PyStringLiteralExpression docstringElement = null;
            PyFunction inherited = null;
            boolean isFromClass = false;
            if (isConstructor) {
                docstringElement = PyDocumentationBuilder.getEffectiveDocStringExpression(ancestor);
                boolean bl = isFromClass = docstringElement != null;
            }
            if (!isFromClass && (inherited = ancestor.findMethodByName(methodName, false, null)) != null) {
                docstringElement = PyDocumentationBuilder.getEffectiveDocStringExpression(inherited);
            }
            if (docstringElement == null || docstringElement.getStringValue().length() <= 1) continue;
            String string = ancestorLink = isFromClass ? this.getLinkToClass(ancestor, false) : PyDocumentationBuilder.getLinkToFunction(inherited, false);
            if (ancestorLink != null) {
                this.mySectionsMap.get(PyBundle.message("QDOC.documentation.is.copied.from", new Object[0])).addWith(DocumentationBuilderKit.TagCode, DocumentationBuilderKit.$(ancestorLink));
            }
            return docstringElement;
        }
        if (PyNames.UNDERSCORED_ATTRIBUTES.contains((Object)methodName)) {
            return this.addPredefinedMethodDoc(pyFunction, methodName);
        }
        return null;
    }

    @Nullable
    private PyStringLiteralExpression addPredefinedMethodDoc(@NotNull PyFunction fun, @NotNull String methodName) {
        PyClass objectClass;
        PyFunction predefinedMethod;
        PyClassType objectType;
        if (fun == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(15);
        }
        if (methodName == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(16);
        }
        if ((objectType = PyBuiltinCache.getInstance(fun).getObjectType()) != null && (predefinedMethod = (objectClass = objectType.getPyClass()).findMethodByName(methodName, false, null)) != null) {
            String predefinedDoc;
            PyStringLiteralExpression predefinedDocstring = PyDocumentationBuilder.getEffectiveDocStringExpression(predefinedMethod);
            String string = predefinedDoc = predefinedDocstring != null ? predefinedDocstring.getStringValue() : null;
            if (predefinedDoc != null && predefinedDoc.length() > 1) {
                this.mySectionsMap.get(PyBundle.message("QDOC.documentation.is.copied.from", new Object[0])).addItem("built-in description");
                this.myContent.add(PyDocumentationBuilder.formatDocString(fun, predefinedDoc));
            }
            return predefinedDocstring;
        }
        return null;
    }

    @NotNull
    private static ChainIterable<String> formatDocString(@NotNull PsiElement element, @NotNull String docstring) {
        List<String> formatted;
        if (element == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(17);
        }
        if (docstring == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(18);
        }
        if ((formatted = PyStructuredDocstringFormatter.formatDocstring(element, docstring)) != null) {
            ChainIterable<List<String>> chainIterable = new ChainIterable<List<String>>(formatted);
            if (chainIterable == null) {
                PyDocumentationBuilder.$$$reportNull$$$0(19);
            }
            return chainIterable;
        }
        List origLines = LineTokenizer.tokenizeIntoList((CharSequence)docstring.trim(), (boolean)false, (boolean)false);
        List updatedLines = ((StreamEx)StreamEx.of(PyIndentUtil.removeCommonIndent(origLines, true)).takeWhile(line -> !line.startsWith(">>>"))).toList();
        ChainIterable<String> result2 = new ChainIterable<String>();
        boolean isFirstLine = true;
        int tabSize = CodeStyle.getIndentOptions((PsiFile)element.getContainingFile()).TAB_SIZE;
        for (String line2 : updatedLines) {
            int leadingTabs;
            if (isFirstLine && ourSpacesPattern.matcher(line2).matches()) continue;
            if (isFirstLine) {
                isFirstLine = false;
            } else {
                result2.addItem("<br>");
            }
            for (leadingTabs = 0; leadingTabs < line2.length() && line2.charAt(leadingTabs) == '\t'; ++leadingTabs) {
            }
            if (leadingTabs > 0) {
                line2 = StringUtil.repeatSymbol((char)' ', (int)(tabSize * leadingTabs)) + line2.substring(leadingTabs);
            }
            result2.addItem(DocumentationBuilderKit.combUp(line2));
        }
        ChainIterable<String> chainIterable = result2;
        if (chainIterable == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(20);
        }
        return chainIterable;
    }

    private void addModulePath(@NotNull PyFile followed) {
        VirtualFile file2;
        if (followed == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(21);
        }
        if ((file2 = followed.getVirtualFile()) == null) {
            this.myProlog.addWith(DocumentationBuilderKit.TagSmall, DocumentationBuilderKit.$(PyBundle.message("QDOC.module.path.unknown", new Object[0])));
        } else {
            QualifiedName name = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)followed);
            if (name != null) {
                this.myProlog.add(DocumentationBuilderKit.$(PyUtil.isPackage(followed) ? "Package " : "Module ")).addWith(DocumentationBuilderKit.TagBold, DocumentationBuilderKit.$(((QualifiedName)ObjectUtils.chooseNotNull((Object)QualifiedNameFinder.canonizeQualifiedName(name, null), (Object)name)).toString()));
            } else {
                String path = file2.getPath();
                this.myProlog.addWith(DocumentationBuilderKit.TagSpan.withAttribute("path", path), DocumentationBuilderKit.$(path));
            }
        }
    }

    @Nullable
    private static String getLinkToModule(@NotNull PyFile module2) {
        QualifiedName name;
        if (module2 == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(22);
        }
        if ((name = QualifiedNameFinder.findCanonicalImportPath((PsiElement)module2, null)) != null) {
            return PyDocumentationLink.toModule(name.toString(), name.toString());
        }
        VirtualFile vFile = module2.getVirtualFile();
        return vFile != null ? vFile.getPath() : null;
    }

    @Nullable
    private String getLinkToClass(@NotNull PyClass pyClass, boolean preferQualifiedName) {
        String linkText;
        if (pyClass == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(23);
        }
        String qualifiedName = pyClass.getQualifiedName();
        String shortName = pyClass.getName();
        String string = linkText = preferQualifiedName && qualifiedName != null ? qualifiedName : shortName;
        if (linkText == null) {
            return null;
        }
        if (qualifiedName != null) {
            return PyDocumentationLink.toPossibleClass(linkText, qualifiedName, (PsiElement)pyClass, this.myContext);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyClass.class, (boolean)false) == pyClass) {
            return PyDocumentationLink.toContainingClass(linkText);
        }
        return linkText;
    }

    @Nullable
    private static String getLinkToFunction(@NotNull PyFunction function, boolean preferQualifiedName) {
        String linkText;
        if (function == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(24);
        }
        String qualifiedName = function.getQualifiedName();
        PyClass pyClass = function.getContainingClass();
        String shortName = pyClass == null ? function.getName() : pyClass.getName() + "." + function.getName();
        String string = linkText = preferQualifiedName && qualifiedName != null ? qualifiedName : shortName;
        if (linkText == null || function.getName() == null || pyClass != null && pyClass.getName() == null) {
            return null;
        }
        if (qualifiedName != null) {
            return PyDocumentationLink.toFunction(linkText, function);
        }
        return linkText;
    }

    @Nullable
    static PyStringLiteralExpression getEffectiveDocStringExpression(@NotNull PyDocStringOwner owner) {
        PyStringLiteralExpression expression;
        if (owner == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(25);
        }
        if ((expression = owner.getDocStringExpression()) != null && StringUtil.isNotEmpty((String)PyPsiUtils.strValue(expression))) {
            return expression;
        }
        PsiElement original = PyiUtil.getOriginalElement(owner);
        PyDocStringOwner originalOwner = PyUtil.as(original, PyDocStringOwner.class);
        return originalOwner != null ? originalOwner.getDocStringExpression() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementDefinition";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/PyDocumentationBuilder";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docstring";
                break;
            }
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFunction";
                break;
            }
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "followed";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/PyDocumentationBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessorKind";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToDocStringOwner";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDocString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildForKeyword";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildFromParameter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildFromProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAccessorKind";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildFromDocstring";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addFunctionSpecificSections";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveWithoutImplicits";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addInheritedDocString";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addPredefinedMethodDoc";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "formatDocString";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addModulePath";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLinkToModule";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLinkToClass";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLinkToFunction";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveDocStringExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

