/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class ProgressStripeIcon
implements Icon {
    private static final int TRANSLATE = 1;
    private static final int HEIGHT = 3;
    @NotNull
    private final JComponent myReferenceComponent;
    private final int myShift;

    private ProgressStripeIcon(@NotNull JComponent component, int shift) {
        if (component == null) {
            ProgressStripeIcon.$$$reportNull$$$0(0);
        }
        this.myReferenceComponent = component;
        this.myShift = shift;
    }

    public abstract int getChunkWidth();

    protected abstract void paint(@NotNull Graphics2D var1, int var2, int var3, int var4);

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        Graphics2D g2 = (Graphics2D)g;
        for (int shift = this.myShift - this.getChunkWidth(); shift < this.getIconWidth(); shift += this.getChunkWidth()) {
            this.paint(g2, x, y, shift);
        }
        config.restore();
    }

    @Override
    public int getIconWidth() {
        return this.myReferenceComponent.getWidth();
    }

    @Override
    public int getIconHeight() {
        return ProgressStripeIcon.getHeight();
    }

    public static int getHeight() {
        return JBUI.scale((int)3);
    }

    @NotNull
    public static AsyncProcessIcon generateIcon(final @NotNull JComponent component) {
        int i;
        if (component == null) {
            ProgressStripeIcon.$$$reportNull$$$0(1);
        }
        List<GradientIcon> result2 = ContainerUtil.newArrayList();
        if (UIUtil.isUnderAquaBasedLookAndFeel() && !UIUtil.isUnderDarcula()) {
            for (i = 0; i < 2 * JBUI.scale((int)128); i += JBUI.scale((int)1)) {
                result2.add(new GradientIcon(component, i));
            }
        } else {
            for (i = 0; i < JBUI.scale((int)16); i += JBUI.scale((int)1)) {
                result2.add((GradientIcon)((Object)new StripeIcon(component, i)));
            }
            result2 = ContainerUtil.reverse((List)result2);
        }
        final Icon passive = (Icon)result2.get(0);
        final AsyncProcessIcon icon = new AsyncProcessIcon("ProgressWithStripes", result2.toArray(new Icon[0]), passive){

            public Dimension getPreferredSize() {
                return new Dimension(component.getWidth(), passive.getIconHeight());
            }
        };
        component.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                icon.revalidate();
            }
        });
        AsyncProcessIcon asyncProcessIcon = icon;
        if (asyncProcessIcon == null) {
            ProgressStripeIcon.$$$reportNull$$$0(2);
        }
        return asyncProcessIcon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/ProgressStripeIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/ProgressStripeIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "generateIcon";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GradientIcon
    extends ProgressStripeIcon {
        private static final double ALPHA = 0.5;
        private static final Color DARK_BLUE = new Color(5087224);
        private static final Color DARK_GRAY = Gray._165;
        private static final Color LIGHT_BLUE = ColorUtil.withAlpha((Color)new Color(9487096), (double)0.5);
        private static final Color LIGHT_GRAY = ColorUtil.withAlpha((Color)new Color(0xDBDBDB), (double)0.5);
        private static final int GRADIENT = 128;
        private static final int GRADIENT_HEIGHT = 2;

        private GradientIcon(@NotNull JComponent component, int shift) {
            if (component == null) {
                GradientIcon.$$$reportNull$$$0(0);
            }
            super(component, shift);
        }

        @Override
        public int getChunkWidth() {
            return 2 * JBUI.scale((int)128);
        }

        @Override
        public void paint(@NotNull Graphics2D g2, int x, int y, int shift) {
            Color light;
            Color dark;
            if (g2 == null) {
                GradientIcon.$$$reportNull$$$0(1);
            }
            if (UIUtil.isGraphite()) {
                dark = DARK_GRAY;
                light = LIGHT_GRAY;
            } else {
                dark = DARK_BLUE;
                light = LIGHT_BLUE;
            }
            g2.setPaint(new GradientPaint(x + shift, y, dark, x + shift + JBUI.scale((int)128), y, light));
            g2.fill(new Rectangle(x + shift, y, JBUI.scale((int)128), this.getIconHeight()));
            g2.setPaint(new GradientPaint(x + shift + JBUI.scale((int)128), y, light, x + shift + 2 * JBUI.scale((int)128), y, dark));
            g2.fill(new Rectangle(x + shift + JBUI.scale((int)128), y, JBUI.scale((int)128), this.getIconHeight()));
        }

        @Override
        public int getIconHeight() {
            return JBUI.scale((int)2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g2";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/frame/ProgressStripeIcon$GradientIcon";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StripeIcon
    extends ProgressStripeIcon {
        private static final double ALPHA = 0.8;
        private static final JBColor BG_COLOR = new JBColor(ColorUtil.withAlpha((Color)Gray._165, (double)0.8), ColorUtil.withAlpha((Color)Gray._110, (double)0.8));
        private static final int WIDTH = 16;

        private StripeIcon(@NotNull JComponent component, int shift) {
            if (component == null) {
                StripeIcon.$$$reportNull$$$0(0);
            }
            super(component, shift);
        }

        @Override
        public int getChunkWidth() {
            return JBUI.scale((int)16);
        }

        @Override
        protected void paint(@NotNull Graphics2D g2, int x, int y, int shift) {
            if (g2 == null) {
                StripeIcon.$$$reportNull$$$0(1);
            }
            g2.setColor((Color)BG_COLOR);
            Path2D.Double path = new Path2D.Double();
            int height = JBUI.scale((int)3);
            float incline = (float)height / 2.0f;
            float length = (float)JBUI.scale((int)16) / 2.0f;
            float start = length / 2.0f;
            path.moveTo((float)(x + shift) + start, y + height);
            path.lineTo((float)(x + shift) + start + incline, y);
            path.lineTo((float)(x + shift) + start + incline + length, y);
            path.lineTo((float)(x + shift) + start + length, y + height);
            path.lineTo((float)(x + shift) + start, y + height);
            path.closePath();
            g2.fill(new Area(path));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g2";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/frame/ProgressStripeIcon$StripeIcon";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

