/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.PlusMinus;
import com.intellij.openapi.vcs.changes.ui.VirtualFileListCellRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.treeWithCheckedNodes.SelectionManager;
import com.intellij.util.treeWithCheckedNodes.TreeNodeState;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsStructureChooser
extends DialogWrapper {
    private static final int MAX_FOLDERS = 100;
    public static final Border BORDER = IdeBorderFactory.createBorder((int)3);
    public static final String CAN_NOT_ADD_TEXT = "<html>Selected: <font color=red>(You have added 100 elements. No more is allowed.)</font></html>";
    private static final String VCS_STRUCTURE_CHOOSER_KEY = "git4idea.history.wholeTree.VcsStructureChooser";
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<VirtualFile> myRoots;
    @NotNull
    private final Map<VirtualFile, String> myModulesSet;
    @NotNull
    private final Set<VirtualFile> mySelectedFiles;
    @NotNull
    private final SelectionManager mySelectionManager;
    private Tree myTree;

    public VcsStructureChooser(@NotNull Project project, @NotNull String title, @NotNull Collection<VirtualFile> initialSelection, @NotNull List<VirtualFile> roots) {
        if (project == null) {
            VcsStructureChooser.$$$reportNull$$$0(0);
        }
        if (title == null) {
            VcsStructureChooser.$$$reportNull$$$0(1);
        }
        if (initialSelection == null) {
            VcsStructureChooser.$$$reportNull$$$0(2);
        }
        if (roots == null) {
            VcsStructureChooser.$$$reportNull$$$0(3);
        }
        super(project, true);
        this.mySelectedFiles = ContainerUtil.newHashSet();
        this.setTitle(title);
        this.myProject = project;
        this.myRoots = roots;
        this.mySelectionManager = new SelectionManager(100, 500, MyNodeConverter.getInstance());
        this.myModulesSet = this.calculateModules(roots);
        this.init();
        this.mySelectionManager.setSelection(initialSelection);
        this.checkEmpty();
    }

    @NotNull
    private Map<VirtualFile, String> calculateModules(@NotNull List<VirtualFile> roots) {
        if (roots == null) {
            VcsStructureChooser.$$$reportNull$$$0(4);
        }
        HashMap result2 = ContainerUtil.newHashMap();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Module[] modules = (Module[])ReadAction.compute(() -> moduleManager.getModules());
        TreeSet<VirtualFile> checkSet = new TreeSet<VirtualFile>((Comparator<VirtualFile>)FilePathComparator.getInstance());
        checkSet.addAll(roots);
        for (Module module2 : modules) {
            VirtualFile[] files2;
            for (VirtualFile file2 : files2 = ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
                VirtualFile floor = checkSet.floor(file2);
                if (floor == null) continue;
                result2.put(file2, module2.getName());
            }
        }
        HashMap hashMap = result2;
        if (hashMap == null) {
            VcsStructureChooser.$$$reportNull$$$0(5);
        }
        return hashMap;
    }

    @NotNull
    public Collection<VirtualFile> getSelectedFiles() {
        Set<VirtualFile> set2 = this.mySelectedFiles;
        if (set2 == null) {
            VcsStructureChooser.$$$reportNull$$$0(6);
        }
        return set2;
    }

    private void checkEmpty() {
        this.setOKActionEnabled(!this.mySelectedFiles.isEmpty());
    }

    @NotNull
    protected String getDimensionServiceKey() {
        if (VCS_STRUCTURE_CHOOSER_KEY == null) {
            VcsStructureChooser.$$$reportNull$$$0(7);
        }
        return VCS_STRUCTURE_CHOOSER_KEY;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        Tree tree = this.myTree;
        if (tree == null) {
            VcsStructureChooser.$$$reportNull$$$0(8);
        }
        return tree;
    }

    protected JComponent createCenterPanel() {
        this.myTree = new Tree();
        this.myTree.setBorder(BORDER);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(false);
        this.myTree.setExpandableItemsEnabled(false);
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, true, true, true, false, true){

            public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                if (!super.isFileVisible(file2, showHiddenFiles)) {
                    return false;
                }
                if (VcsStructureChooser.this.myRoots.contains(file2)) {
                    return false;
                }
                ChangeListManager changeListManager = ChangeListManager.getInstance((Project)VcsStructureChooser.this.myProject);
                return !changeListManager.isIgnoredFile(file2) && !changeListManager.isUnversioned(file2);
            }
        };
        descriptor2.withRoots(new ArrayList<VirtualFile>(this.myRoots)).withShowHiddenFiles(true).withHideIgnored(true);
        final MyCheckboxTreeCellRenderer cellRenderer = new MyCheckboxTreeCellRenderer(this.mySelectionManager, this.myModulesSet, this.myProject, (JTree)this.myTree, this.myRoots);
        FileSystemTreeImpl fileSystemTree = new FileSystemTreeImpl(this.myProject, descriptor2, this.myTree, cellRenderer, null, (Convertor<TreePath, String>)((Convertor)o -> {
            DefaultMutableTreeNode lastPathComponent = (DefaultMutableTreeNode)o.getLastPathComponent();
            Object uo = lastPathComponent.getUserObject();
            if (uo instanceof FileNodeDescriptor) {
                VirtualFile file2 = ((FileNodeDescriptor)((Object)((Object)uo))).getElement().getFile();
                String module2 = this.myModulesSet.get(file2);
                if (module2 != null) {
                    return module2;
                }
                return file2 == null ? "" : file2.getName();
            }
            return o.toString();
        }));
        fileSystemTree.getTreeBuilder().getUi().setNodeDescriptorComparator((o1, o2) -> {
            if (o1 instanceof FileNodeDescriptor && o2 instanceof FileNodeDescriptor) {
                boolean isDir2;
                VirtualFile f1 = ((FileNodeDescriptor)((Object)o1)).getElement().getFile();
                VirtualFile f2 = ((FileNodeDescriptor)((Object)o2)).getElement().getFile();
                boolean isDir1 = f1.isDirectory();
                if (isDir1 != (isDir2 = f2.isDirectory())) {
                    return isDir1 ? -1 : 1;
                }
                return f1.getPath().compareToIgnoreCase(f2.getPath());
            }
            return o1.getIndex() - o2.getIndex();
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                int row;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((row = VcsStructureChooser.this.myTree.getRowForLocation(e.getX(), e.getY())) < 0) {
                    return false;
                }
                Object o = VcsStructureChooser.this.myTree.getPathForRow(row).getLastPathComponent();
                if (VcsStructureChooser.this.getTreeRoot() == o || VcsStructureChooser.getFile(o) == null) {
                    return false;
                }
                Rectangle rowBounds = VcsStructureChooser.this.myTree.getRowBounds(row);
                cellRenderer.setBounds(rowBounds);
                Rectangle checkBounds = cellRenderer.myCheckbox.getBounds();
                checkBounds.setLocation(rowBounds.getLocation());
                if (checkBounds.height == 0) {
                    checkBounds.height = rowBounds.height;
                }
                if (checkBounds.contains(e.getPoint())) {
                    VcsStructureChooser.this.mySelectionManager.toggleSelection((DefaultMutableTreeNode)o);
                    VcsStructureChooser.this.myTree.revalidate();
                    VcsStructureChooser.this.myTree.repaint();
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$2", "onClick"));
            }
        }.installOn((Component)this.myTree);
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    TreePath[] paths = VcsStructureChooser.this.myTree.getSelectionPaths();
                    if (paths == null) {
                        return;
                    }
                    for (TreePath path : paths) {
                        if (path == null) continue;
                        Object o = path.getLastPathComponent();
                        if (VcsStructureChooser.this.getTreeRoot() == o || VcsStructureChooser.getFile(o) == null) {
                            return;
                        }
                        VcsStructureChooser.this.mySelectionManager.toggleSelection((DefaultMutableTreeNode)o);
                    }
                    VcsStructureChooser.this.myTree.revalidate();
                    VcsStructureChooser.this.myTree.repaint();
                    e.consume();
                }
            }
        });
        JBPanel panel2 = new JBPanel((LayoutManager)new BorderLayout());
        panel2.add((Component)new JBScrollPane((Component)fileSystemTree.getTree()), (Object)"Center");
        final JLabel selectedLabel = new JLabel("");
        selectedLabel.setBorder((Border)JBUI.Borders.empty((int)2, (int)0));
        panel2.add((Component)selectedLabel, (Object)"South");
        this.mySelectionManager.setSelectionChangeListener(new PlusMinus<VirtualFile>(){

            @Override
            public void plus(VirtualFile virtualFile) {
                VcsStructureChooser.this.mySelectedFiles.add(virtualFile);
                this.recalculateErrorText();
            }

            private void recalculateErrorText() {
                VcsStructureChooser.this.checkEmpty();
                if (VcsStructureChooser.this.mySelectionManager.canAddSelection()) {
                    selectedLabel.setText("");
                } else {
                    selectedLabel.setText(VcsStructureChooser.CAN_NOT_ADD_TEXT);
                }
                selectedLabel.revalidate();
            }

            @Override
            public void minus(VirtualFile virtualFile) {
                VcsStructureChooser.this.mySelectedFiles.remove(virtualFile);
                this.recalculateErrorText();
            }
        });
        panel2.setPreferredSize((Dimension)JBUI.size((int)400, (int)300));
        return panel2;
    }

    @NotNull
    private DefaultMutableTreeNode getTreeRoot() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
        if (defaultMutableTreeNode == null) {
            VcsStructureChooser.$$$reportNull$$$0(9);
        }
        return defaultMutableTreeNode;
    }

    @Nullable
    private static VirtualFile getFile(@NotNull Object node) {
        if (node == null) {
            VcsStructureChooser.$$$reportNull$$$0(10);
        }
        if (!(((DefaultMutableTreeNode)node).getUserObject() instanceof FileNodeDescriptor)) {
            return null;
        }
        FileNodeDescriptor descriptor2 = (FileNodeDescriptor)((Object)((DefaultMutableTreeNode)node).getUserObject());
        if (descriptor2.getElement().getFile() == null) {
            return null;
        }
        return descriptor2.getElement().getFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSelection";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/VcsStructureChooser";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsStructureChooser";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateModules";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calculateModules";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WithModulesListCellRenderer
    extends VirtualFileListCellRenderer {
        @NotNull
        private final Map<VirtualFile, String> myModules;

        private WithModulesListCellRenderer(@NotNull Project project, @NotNull Map<VirtualFile, String> modules) {
            if (project == null) {
                WithModulesListCellRenderer.$$$reportNull$$$0(0);
            }
            if (modules == null) {
                WithModulesListCellRenderer.$$$reportNull$$$0(1);
            }
            super(project, true);
            this.myModules = modules;
        }

        @Override
        protected String getName(@NotNull FilePath path) {
            String module2;
            if (path == null) {
                WithModulesListCellRenderer.$$$reportNull$$$0(2);
            }
            if ((module2 = this.myModules.get(path.getVirtualFile())) != null) {
                return module2;
            }
            return super.getName(path);
        }

        @Override
        protected void renderIcon(@NotNull FilePath path) {
            String module2;
            if (path == null) {
                WithModulesListCellRenderer.$$$reportNull$$$0(3);
            }
            if ((module2 = this.myModules.get(path.getVirtualFile())) != null) {
                this.setIcon(PlatformIcons.CONTENT_ROOT_ICON_CLOSED);
            } else if (path.isDirectory()) {
                this.setIcon(PlatformIcons.FOLDER_ICON);
            } else {
                this.setIcon(path.getFileType().getIcon());
            }
        }

        @Override
        protected void putParentPathImpl(@NotNull Object value, @NotNull String parentPath, @NotNull FilePath self) {
            if (value == null) {
                WithModulesListCellRenderer.$$$reportNull$$$0(4);
            }
            if (parentPath == null) {
                WithModulesListCellRenderer.$$$reportNull$$$0(5);
            }
            if (self == null) {
                WithModulesListCellRenderer.$$$reportNull$$$0(6);
            }
            this.append(self.getPath(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modules";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentPath";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "self";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/ui/filter/VcsStructureChooser$WithModulesListCellRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderIcon";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putParentPathImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyNodeConverter
    implements Convertor<DefaultMutableTreeNode, VirtualFile> {
        @NotNull
        private static final MyNodeConverter ourInstance = new MyNodeConverter();

        private MyNodeConverter() {
        }

        @NotNull
        public static MyNodeConverter getInstance() {
            MyNodeConverter myNodeConverter = ourInstance;
            if (myNodeConverter == null) {
                MyNodeConverter.$$$reportNull$$$0(0);
            }
            return myNodeConverter;
        }

        public VirtualFile convert(DefaultMutableTreeNode o) {
            return ((FileNodeDescriptor)((Object)o.getUserObject())).getElement().getFile();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$MyNodeConverter", "getInstance"));
        }
    }

    private static class MyCheckboxTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        @NotNull
        private final WithModulesListCellRenderer myTextRenderer;
        @NotNull
        public final JCheckBox myCheckbox;
        @NotNull
        private final SelectionManager mySelectionManager;
        @NotNull
        private final Map<VirtualFile, String> myModulesSet;
        @NotNull
        private final Collection<VirtualFile> myRoots;
        @NotNull
        private final ColoredTreeCellRenderer myColoredRenderer;
        @NotNull
        private final JLabel myEmpty;
        @NotNull
        private final JList myFictive;

        private MyCheckboxTreeCellRenderer(@NotNull SelectionManager selectionManager, @NotNull Map<VirtualFile, String> modulesSet, @NotNull Project project, @NotNull JTree tree, @NotNull Collection<VirtualFile> roots) {
            if (selectionManager == null) {
                MyCheckboxTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if (modulesSet == null) {
                MyCheckboxTreeCellRenderer.$$$reportNull$$$0(1);
            }
            if (project == null) {
                MyCheckboxTreeCellRenderer.$$$reportNull$$$0(2);
            }
            if (tree == null) {
                MyCheckboxTreeCellRenderer.$$$reportNull$$$0(3);
            }
            if (roots == null) {
                MyCheckboxTreeCellRenderer.$$$reportNull$$$0(4);
            }
            super(new BorderLayout());
            this.mySelectionManager = selectionManager;
            this.myModulesSet = modulesSet;
            this.myRoots = roots;
            this.setBackground(tree.getBackground());
            this.myColoredRenderer = new ColoredTreeCellRenderer(){

                public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    if (tree == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.append(value.toString());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$MyCheckboxTreeCellRenderer$1", "customizeCellRenderer"));
                }
            };
            this.myFictive = new JBList();
            this.myFictive.setBackground(tree.getBackground());
            this.myFictive.setSelectionBackground(UIUtil.getListSelectionBackground());
            this.myFictive.setSelectionForeground(UIUtil.getListSelectionForeground());
            this.myTextRenderer = new WithModulesListCellRenderer(project, this.myModulesSet){

                @Override
                protected void putParentPath(Object value, FilePath path, FilePath self) {
                    if (myRoots.contains(self.getVirtualFile())) {
                        super.putParentPath(value, path, self);
                    }
                }
            };
            this.myTextRenderer.setBackground(tree.getBackground());
            this.myCheckbox = new JCheckBox();
            this.myCheckbox.setBackground(tree.getBackground());
            this.myEmpty = new JLabel("");
            this.add((Component)this.myCheckbox, "West");
            this.add((Component)((Object)this.myTextRenderer), "Center");
            this.myCheckbox.setVisible(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.invalidate();
            if (value == null) {
                return this.myEmpty;
            }
            VirtualFile file2 = VcsStructureChooser.getFile(value);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (file2 == null) {
                Object uo = node.getUserObject();
                if (uo instanceof String) {
                    this.myColoredRenderer.getTreeCellRendererComponent(tree, (Object)node, selected, expanded, leaf, row, hasFocus);
                    return this.myColoredRenderer;
                }
                return this.myEmpty;
            }
            this.myCheckbox.setVisible(true);
            TreeNodeState state2 = this.mySelectionManager.getState(node);
            this.myCheckbox.setEnabled(TreeNodeState.CLEAR.equals((Object)state2) || TreeNodeState.SELECTED.equals((Object)state2));
            this.myCheckbox.setSelected(!TreeNodeState.CLEAR.equals((Object)state2));
            this.myCheckbox.setOpaque(false);
            this.myCheckbox.setBackground(null);
            this.setBackground(null);
            this.myTextRenderer.getListCellRendererComponent(this.myFictive, file2, 0, selected, hasFocus);
            this.revalidate();
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selectionManager";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modulesSet";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/ui/filter/VcsStructureChooser$MyCheckboxTreeCellRenderer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

