/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.graph.utils.BfsUtil;
import com.intellij.vcs.log.graph.utils.DfsUtil;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import com.intellij.vcs.log.history.FileNamesData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0004H\u0016J(\u0010 \u001a\u0004\u0018\u00010\r2\u0006\u0010!\u001a\u00020\u00042\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\r0#H\u0002J\u0016\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\rR\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00040\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u000e\u001a\u001e\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \n*\u0004\u0018\u00010\r0\r0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryRefiner;", "Lcom/intellij/vcs/log/graph/utils/DfsUtil$NodeVisitor;", "visibleGraph", "Lcom/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl;", "", "namesData", "Lcom/intellij/vcs/log/history/FileNamesData;", "(Lcom/intellij/vcs/log/graph/impl/facade/VisibleGraphImpl;Lcom/intellij/vcs/log/history/FileNamesData;)V", "excluded", "Ljava/util/HashSet;", "kotlin.jvm.PlatformType", "paths", "Lcom/intellij/util/containers/Stack;", "Lcom/intellij/openapi/vcs/FilePath;", "pathsForCommits", "Ljava/util/HashMap;", "getPathsForCommits", "()Ljava/util/HashMap;", "permanentCommitsInfo", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentCommitsInfo;", "permanentLinearGraph", "Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;", "visibilityBuffer", "Lcom/intellij/vcs/log/graph/utils/impl/BitSetFlags;", "enterNode", "", "currentNode", "previousNode", "down", "", "exitNode", "node", "findPathWithoutConflict", "nodeId", "pathGetter", "Lkotlin/Function1;", "refine", "row", "startPath", "intellij.platform.vcs.log.impl"})
public final class FileHistoryRefiner
implements DfsUtil.NodeVisitor {
    private final PermanentCommitsInfo<Integer> permanentCommitsInfo;
    private final LiteLinearGraph permanentLinearGraph;
    private final Stack<FilePath> paths;
    private final BitSetFlags visibilityBuffer;
    @NotNull
    private final HashMap<Integer, FilePath> pathsForCommits;
    private final HashSet<Integer> excluded;
    private final VisibleGraphImpl<Integer> visibleGraph;
    private final FileNamesData namesData;

    @NotNull
    public final HashMap<Integer, FilePath> getPathsForCommits() {
        return this.pathsForCommits;
    }

    public final boolean refine(int row, @NotNull FilePath startPath) {
        Intrinsics.checkParameterIsNotNull((Object)startPath, (String)"startPath");
        if (this.namesData.getHasRenames()) {
            this.paths.push((Object)startPath);
            DfsUtil.walk(LinearGraphUtils.asLiteLinearGraph(this.visibleGraph.getLinearGraph()), row, this);
        } else {
            this.pathsForCommits.putAll(this.namesData.buildPathsMap());
        }
        for (Integer commit : this.pathsForCommits.keySet()) {
            FilePath path = this.pathsForCommits.get(commit);
            if (path == null) continue;
            Integer n = commit;
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"commit");
            if (!this.namesData.affects(n, path)) {
                this.excluded.add(commit);
            }
            if (!this.namesData.isTrivialMerge(commit, path)) continue;
            this.excluded.add(commit);
        }
        Iterable $receiver$iv = this.excluded;
        Iterator<Integer> iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Integer element$iv;
            Integer it = element$iv = iterator.next();
            this.pathsForCommits.remove(it);
        }
        return !this.excluded.isEmpty();
    }

    @Override
    public void enterNode(int currentNode, int previousNode, boolean down) {
        FilePath previousPath;
        Object v1;
        Object object;
        Object object2;
        Object object3;
        int currentCommit;
        int currentNodeId;
        block7: {
            currentNodeId = this.visibleGraph.getNodeId(currentNode);
            Integer n = this.permanentCommitsInfo.getCommitId(currentNodeId);
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"permanentCommitsInfo.getCommitId(currentNodeId)");
            currentCommit = ((Number)n).intValue();
            List list2 = (List)this.paths;
            object3 = list2;
            object2 = object3.listIterator(object3.size());
            while (object2.hasPrevious()) {
                object = object2.previous();
                FilePath it = (FilePath)object;
                if (!(it != null)) continue;
                v1 = object;
                break block7;
            }
            v1 = null;
        }
        if (v1 == null) {
            Intrinsics.throwNpe();
        }
        FilePath currentPath = previousPath = (FilePath)v1;
        if (previousNode != -1) {
            Function1 pathGetter2;
            int previousNodeId = this.visibleGraph.getNodeId(previousNode);
            Integer n = this.permanentCommitsInfo.getCommitId(previousNodeId);
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"permanentCommitsInfo.getCommitId(previousNodeId)");
            int previousCommit = ((Number)n).intValue();
            if (down) {
                pathGetter2 = (Function1)new Function1<Integer, FilePath>(this, previousCommit, previousPath){
                    final /* synthetic */ FileHistoryRefiner this$0;
                    final /* synthetic */ int $previousCommit;
                    final /* synthetic */ FilePath $previousPath;

                    @Nullable
                    public final FilePath invoke(int parentIndex) {
                        FileNamesData fileNamesData = FileHistoryRefiner.access$getNamesData$p(this.this$0);
                        CommitId CommitId2 = FileHistoryRefiner.access$getPermanentCommitsInfo$p(this.this$0).getCommitId(parentIndex);
                        Intrinsics.checkExpressionValueIsNotNull(CommitId2, (String)"permanentCommitsInfo.getCommitId(parentIndex)");
                        return fileNamesData.getPathInParentRevision(this.$previousCommit, ((Number)CommitId2).intValue(), this.$previousPath);
                    }
                    {
                        this.this$0 = fileHistoryRefiner;
                        this.$previousCommit = n;
                        this.$previousPath = filePath;
                        super(1);
                    }
                };
                currentPath = this.findPathWithoutConflict(previousNodeId, (Function1<? super Integer, ? extends FilePath>)pathGetter2);
                if (currentPath == null) {
                    int parentIndex = BfsUtil.getCorrespondingParent(this.permanentLinearGraph, previousNodeId, currentNodeId, this.visibilityBuffer);
                    currentPath = (FilePath)pathGetter2.invoke((Object)parentIndex);
                }
            } else {
                pathGetter2 = (Function1)new Function1<Integer, FilePath>(this, currentCommit, previousPath){
                    final /* synthetic */ FileHistoryRefiner this$0;
                    final /* synthetic */ int $currentCommit;
                    final /* synthetic */ FilePath $previousPath;

                    @Nullable
                    public final FilePath invoke(int parentIndex) {
                        FileNamesData fileNamesData = FileHistoryRefiner.access$getNamesData$p(this.this$0);
                        CommitId CommitId2 = FileHistoryRefiner.access$getPermanentCommitsInfo$p(this.this$0).getCommitId(parentIndex);
                        Intrinsics.checkExpressionValueIsNotNull(CommitId2, (String)"permanentCommitsInfo.getCommitId(parentIndex)");
                        return fileNamesData.getPathInChildRevision(this.$currentCommit, ((Number)CommitId2).intValue(), this.$previousPath);
                    }
                    {
                        this.this$0 = fileHistoryRefiner;
                        this.$currentCommit = n;
                        this.$previousPath = filePath;
                        super(1);
                    }
                };
                currentPath = this.findPathWithoutConflict(currentNodeId, (Function1<? super Integer, ? extends FilePath>)pathGetter2);
                if (currentPath == null) {
                    int parentIndex = BfsUtil.getCorrespondingParent(this.permanentLinearGraph, currentNodeId, previousNodeId, this.visibilityBuffer);
                    currentPath = (FilePath)pathGetter2.invoke((Object)parentIndex);
                }
            }
        }
        object3 = this.pathsForCommits;
        object2 = currentCommit;
        object = currentPath;
        object3.put(object2, object);
        this.paths.push((Object)currentPath);
    }

    private final FilePath findPathWithoutConflict(int nodeId, Function1<? super Integer, ? extends FilePath> pathGetter2) {
        Object v3;
        FilePath path;
        block3: {
            Iterable iterable;
            List<Integer> list2 = this.permanentLinearGraph.getNodes(nodeId, LiteLinearGraph.NodeFilter.DOWN);
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"permanentLinearGraph.get\u2026earGraph.NodeFilter.DOWN)");
            List<Integer> parents = list2;
            Object object = CollectionsKt.first(parents);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parents.first()");
            path = (FilePath)pathGetter2.invoke(object);
            if (parents.size() == 1) {
                return path;
            }
            Iterable iterable2 = iterable = (Iterable)parents.subList(1, parents.size());
            for (Object t : iterable2) {
                Integer it;
                Integer n = it = (Integer)t;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"it");
                if (!(Intrinsics.areEqual((Object)((FilePath)pathGetter2.invoke((Object)n)), (Object)path) ^ true)) continue;
                v3 = t;
                break block3;
            }
            v3 = null;
        }
        if (v3 != null) {
            return null;
        }
        return path;
    }

    @Override
    public void exitNode(int node) {
        this.paths.pop();
    }

    public FileHistoryRefiner(@NotNull VisibleGraphImpl<Integer> visibleGraph, @NotNull FileNamesData namesData) {
        Intrinsics.checkParameterIsNotNull(visibleGraph, (String)"visibleGraph");
        Intrinsics.checkParameterIsNotNull((Object)namesData, (String)"namesData");
        this.visibleGraph = visibleGraph;
        this.namesData = namesData;
        PermanentGraphInfo<Integer> permanentGraphInfo = this.visibleGraph.getPermanentGraph();
        Intrinsics.checkExpressionValueIsNotNull(permanentGraphInfo, (String)"visibleGraph.permanentGraph");
        PermanentCommitsInfo<Integer> permanentCommitsInfo = permanentGraphInfo.getPermanentCommitsInfo();
        Intrinsics.checkExpressionValueIsNotNull(permanentCommitsInfo, (String)"visibleGraph.permanentGraph.permanentCommitsInfo");
        this.permanentCommitsInfo = permanentCommitsInfo;
        PermanentGraphInfo<Integer> permanentGraphInfo2 = this.visibleGraph.getPermanentGraph();
        Intrinsics.checkExpressionValueIsNotNull(permanentGraphInfo2, (String)"visibleGraph.permanentGraph");
        LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph(permanentGraphInfo2.getLinearGraph());
        Intrinsics.checkExpressionValueIsNotNull((Object)liteLinearGraph, (String)"LinearGraphUtils.asLiteL\u2026rmanentGraph.linearGraph)");
        this.permanentLinearGraph = liteLinearGraph;
        this.paths = new Stack();
        this.visibilityBuffer = new BitSetFlags(this.permanentLinearGraph.nodesCount());
        HashMap hashMap = ContainerUtil.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"ContainerUtil.newHashMap<Int, FilePath>()");
        this.pathsForCommits = hashMap;
        HashSet hashSet = ContainerUtil.newHashSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashSet, (String)"ContainerUtil.newHashSet<Int>()");
        this.excluded = hashSet;
    }

    @NotNull
    public static final /* synthetic */ FileNamesData access$getNamesData$p(FileHistoryRefiner $this) {
        return $this.namesData;
    }

    @NotNull
    public static final /* synthetic */ PermanentCommitsInfo access$getPermanentCommitsInfo$p(FileHistoryRefiner $this) {
        return $this.permanentCommitsInfo;
    }
}

